/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public class StatementTestSetup
extends BaseJDBCTestSetup {
    public StatementTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        try {
            stmt.execute("select count(*) from stmtTable");
            stmt.execute("drop table stmtTable");
        }
        catch (SQLException sqle) {
            StatementTestSetup.assertEquals((String)"Unexpected error when accessing non-existing table.", (String)"42X05", (String)sqle.getSQLState());
        }
        stmt.execute("create table stmtTable (id int, val varchar(10))");
        stmt.execute("insert into stmtTable values (1, 'one'),(2,'two')");
        ResultSet rs = stmt.executeQuery("select count(*) from stmtTable");
        rs.next();
        StatementTestSetup.assertEquals((String)"Number of rows are not as expected", (int)2, (int)rs.getInt(1));
        rs.close();
        stmt.close();
        con.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("drop table stmtTable");
        stmt.close();
        con.commit();
        super.tearDown();
    }
}

