/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ResultSetTest
extends BaseJDBCTestCase {
    private static final byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final byte[] BYTES2 = new byte[]{105, 104, 103, 102, 101, 101, 102, 103, 104, 105};
    private static final String str1 = "I am the main Input string and I will be Updated";
    private static final String str2 = "I am the string used to update";
    private static int insertKey = 0;
    private Statement stmt = null;
    private ResultSet rs = null;
    private int key = -1;

    public ResultSetTest(String name) {
        super(name);
    }

    protected void setUp() throws SQLException {
        this.key = ResultSetTest.requestKey();
        this.stmt = this.createStatement(1003, 1008);
        this.rs = this.stmt.executeQuery("SELECT * FROM SYS.SYSTABLES");
        this.rs.next();
    }

    @Override
    protected void tearDown() throws Exception {
        this.rs.close();
        this.stmt.close();
        this.rs = null;
        this.stmt = null;
        super.tearDown();
    }

    public void testGetNCharacterStreamIntNotImplemented() throws SQLException {
        try {
            this.rs.getNCharacterStream(1);
            ResultSetTest.fail((String)"ResultSet.getNCharacterStream(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNCharaterStreamStringNotImplemented() throws SQLException {
        try {
            this.rs.getNCharacterStream("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getNCharacterStream(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNClobNotIntImplemented() throws SQLException {
        try {
            this.rs.getNClob(1);
            ResultSetTest.fail((String)"ResultSet.getNClob(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNClobStringNotImplemented() throws SQLException {
        try {
            this.rs.getNClob("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getNClob(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringIntNotImplemented() throws SQLException {
        try {
            this.rs.getNString(1);
            ResultSetTest.fail((String)"ResultSet.getNString(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetNStringStringNotImplemented() throws SQLException {
        try {
            this.rs.getNString("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getNString(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLIntNotImplemented() throws SQLException {
        try {
            this.rs.getSQLXML(1);
            ResultSetTest.fail((String)"ResultSet.getSQLXML(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testGetSQLXMLStringNotImplemented() throws SQLException {
        try {
            this.rs.getSQLXML("some-column-name");
            ResultSetTest.fail((String)"ResultSet.getSQLXML(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamIntNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream(1, null, 0L);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(int, Reader, int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamIntLengthLessNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream(1, null);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(int, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamStringNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream("some-column-name", null, 0L);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(String, Reader, 0) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNCharacterStreamStringLengthlessNotImplemented() throws SQLException {
        try {
            this.rs.updateNCharacterStream("some-column-name", null);
            ResultSetTest.fail((String)"ResultSet.updateNCharacterStream(String, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobIntNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob(1, (NClob)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(int, NClob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobIntLengthlessNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob(1, (Reader)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(int, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobStringNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob("some-column-name", (NClob)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(String, NClob) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNClobStringLengthlessNotImplemented() throws SQLException {
        try {
            this.rs.updateNClob("some-column-name", (Reader)null);
            ResultSetTest.fail((String)"ResultSet.updateNClob(String, Reader) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNStringIntNotImplemented() throws SQLException {
        try {
            this.rs.updateNString(1, null);
            ResultSetTest.fail((String)"ResultSet.updateNString(int, String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateNStringStringNotImplemented() throws SQLException {
        try {
            this.rs.updateNString("some-column-name", null);
            ResultSetTest.fail((String)"ResultSet.updateNString(String, String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateSQLXMLIntNotImplemented() throws SQLException {
        try {
            this.rs.updateSQLXML(1, null);
            ResultSetTest.fail((String)"ResultSet.updateSQLXML(int, SQLXML) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateSQLXMLStringNotImplemented() throws SQLException {
        try {
            this.rs.updateSQLXML("some-column-name", null);
            ResultSetTest.fail((String)"ResultSet.updateSQLXML(String, SQLXML) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testUpdateBinaryStream() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is_for_update = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongBit");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongBit", this.key);
        rs1.next();
        rs1.updateBinaryStream(1, (InputStream)is_for_update, BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongBit", this.key);
        rs1.next();
        InputStream is_ret = rs1.getBinaryStream(1);
        is_ret.read(bytes_ret);
        is_ret.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateBinaryStream", (byte)BYTES2[i], (byte)bytes_ret[i]);
        }
        rs1.close();
    }

    public void testUpdateAsciiStream() throws Exception {
        this.stmt.execute("create table UpdateTestTable_ResultSet (sno int, datacol LONG VARCHAR)");
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is_for_update = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prepareStatement("insert into UpdateTestTable_ResultSet values(?,?)");
        ps_sb.setInt(1, 1);
        ps_sb.setAsciiStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.stmt.executeQuery("select * from UpdateTestTable_ResultSet for update");
        rs1.next();
        rs1.updateAsciiStream(2, (InputStream)is_for_update, BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.stmt.executeQuery("select * from UpdateTestTable_ResultSet");
        rs1.next();
        InputStream is_ret = rs1.getAsciiStream(2);
        is_ret.read(bytes_ret);
        is_ret.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)bytes_ret[i]);
        }
        rs1.close();
        this.stmt.execute("drop table UpdateTestTable_ResultSet");
    }

    public void testUpdateCharacterStream() throws Exception {
        String str = "Test data";
        String str_for_update = "Test data used for update";
        StringReader r = new StringReader(str);
        StringReader r_for_update = new StringReader(str_for_update);
        PreparedStatement ps_sb = this.prep("dLongVarchar");
        ps_sb.setInt(1, this.key);
        ps_sb.setCharacterStream(2, (Reader)r, str.length());
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongVarchar", this.key);
        rs1.next();
        rs1.updateCharacterStream(1, (Reader)r_for_update, str_for_update.length());
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongVarchar", this.key);
        rs1.next();
        StringReader r_ret = (StringReader)rs1.getCharacterStream(1);
        char[] c_ret = new char[str_for_update.length()];
        r_ret.read(c_ret);
        String str_ret = new String(c_ret);
        ResultSetTest.assertEquals((String)("Error in updateCharacterStream" + str_ret), (String)str_for_update, (String)str_ret);
        rs1.close();
    }

    public void testUpdateBinaryStreamStringParameterName() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is_for_update = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongBit");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongBit", this.key);
        rs1.next();
        rs1.updateBinaryStream("dLongBit", (InputStream)is_for_update, BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongBit", this.key);
        rs1.next();
        InputStream is_ret = rs1.getBinaryStream(1);
        is_ret.read(bytes_ret);
        is_ret.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateBinaryStream", (byte)BYTES2[i], (byte)bytes_ret[i]);
        }
        rs1.close();
    }

    public void testUpdateBinaryStreamLengthless() throws IOException, SQLException {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongBit");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongBit", this.key);
        rs1.next();
        rs1.updateBinaryStream(1, (InputStream)is2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongBit", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testUpdateBinaryStreamLengthlessBlob() throws IOException, SQLException {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dBlob", this.key);
        rs1.next();
        rs1.updateBinaryStream(1, (InputStream)is2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testUpdateBinaryStreamLengthlessParameterName() throws IOException, SQLException {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongBit");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongBit", this.key);
        rs1.next();
        rs1.updateBinaryStream("dLongBit", (InputStream)is2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongBit", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testUpdateAsciiStreamStringParameterName() throws Exception {
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is_for_update = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongVarchar");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongVarchar", this.key);
        rs1.next();
        rs1.updateAsciiStream("dLongVarchar", (InputStream)is_for_update, BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongVarchar", this.key);
        rs1.next();
        InputStream is_ret = rs1.getAsciiStream(1);
        is_ret.read(bytes_ret);
        is_ret.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)bytes_ret[i]);
        }
        rs1.close();
    }

    public void testUpdateAsciiStreamLengthless() throws IOException, SQLException {
        byte[] bytesRet = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream isForUpdate = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongVarchar");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongVarchar", this.key);
        rs1.next();
        rs1.updateAsciiStream(1, (InputStream)isForUpdate);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongVarchar", this.key);
        rs1.next();
        InputStream isRet = rs1.getAsciiStream(1);
        isRet.read(bytesRet);
        isRet.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)bytesRet[i]);
        }
        rs1.close();
    }

    public void testUpdateAsciiStreamLengthlessParameterName() throws IOException, SQLException {
        byte[] bytesRet = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream isForUpdate = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongVarchar");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongVarchar", this.key);
        rs1.next();
        rs1.updateAsciiStream("dLongVarchar", (InputStream)isForUpdate);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongVarchar", this.key);
        rs1.next();
        InputStream isRet = rs1.getAsciiStream(1);
        isRet.read(bytesRet);
        isRet.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            ResultSetTest.assertEquals((String)"Error in updateAsciiStream", (byte)BYTES2[i], (byte)bytesRet[i]);
        }
        rs1.close();
    }

    public void testUpdateCharacterStreamStringParameterName() throws Exception {
        String str = "Test data";
        String str_for_update = "Test data used for update";
        StringReader r = new StringReader(str);
        StringReader r_for_update = new StringReader(str_for_update);
        PreparedStatement ps_sb = this.prep("dLongVarchar");
        ps_sb.setInt(1, this.key);
        ps_sb.setCharacterStream(2, (Reader)r, str.length());
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongVarchar", this.key);
        rs1.next();
        rs1.updateCharacterStream("dLongVarchar", (Reader)r_for_update, str_for_update.length());
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongVarchar", this.key);
        rs1.next();
        StringReader r_ret = (StringReader)rs1.getCharacterStream(1);
        char[] c_ret = new char[str_for_update.length()];
        r_ret.read(c_ret);
        String str_ret = new String(c_ret);
        ResultSetTest.assertEquals((String)("Error in updateCharacterStream" + str_ret), (String)str_for_update, (String)str_ret);
        rs1.close();
    }

    public void testUpdateCharacterStreamLengthless() throws IOException, SQLException {
        String str = "This is the (\u0fff\u1234) test string";
        String strUpdated = "An updated (\u0fef\u9876) test string";
        PreparedStatement psChar = this.prep("dLongVarchar");
        psChar.setInt(1, this.key);
        psChar.setCharacterStream(2, new StringReader(str));
        psChar.execute();
        psChar.close();
        ResultSet rs = this.fetchUpd("dLongVarchar", this.key);
        rs.next();
        rs.updateCharacterStream(1, (Reader)new StringReader(strUpdated));
        rs.updateRow();
        rs.close();
        rs = this.fetch("dLongVarchar", this.key);
        rs.next();
        Reader updatedStr = rs.getCharacterStream(1);
        for (int i = 0; i < strUpdated.length(); ++i) {
            ResultSetTest.assertEquals((String)("Strings differ at index " + i), (int)strUpdated.charAt(i), (int)updatedStr.read());
        }
        ResultSetTest.assertEquals((String)"Too much data in stream", (int)-1, (int)updatedStr.read());
        updatedStr.close();
    }

    public void testUpdateCharacterStreamLengthlessParameterName() throws IOException, SQLException {
        String str = "This is the (\u0fff\u1234) test string";
        String strUpdated = "An updated (\u0fef\u9876) test string";
        PreparedStatement psChar = this.prep("dLongVarchar");
        psChar.setInt(1, this.key);
        psChar.setCharacterStream(2, new StringReader(str));
        psChar.execute();
        psChar.close();
        ResultSet rs = this.fetchUpd("dLongVarchar", this.key);
        rs.next();
        rs.updateCharacterStream("dLongVarchar", (Reader)new StringReader(strUpdated));
        rs.updateRow();
        rs.close();
        rs = this.fetch("dLongVarchar", this.key);
        rs.next();
        Reader updatedStr = rs.getCharacterStream(1);
        for (int i = 0; i < strUpdated.length(); ++i) {
            ResultSetTest.assertEquals((String)("Strings differ at index " + i), (int)strUpdated.charAt(i), (int)updatedStr.read());
        }
        ResultSetTest.assertEquals((String)"Too much data in stream", (int)-1, (int)updatedStr.read());
        updatedStr.close();
    }

    public void testUpdateClob() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = ResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setAsciiStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dClob", this.key);
        rs1.next();
        Clob clob = rs1.getClob(1);
        rs1.close();
        rs1 = this.fetchUpd("dClob", key2);
        rs1.next();
        rs1.updateClob(1, clob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", key2);
        rs1.next();
        ResultSetTest.assertEquals(clob, rs1.getClob(1));
        rs1.close();
    }

    public void testUpdateClobLengthless() throws Exception {
        this.getConnection().setAutoCommit(false);
        StringReader r1 = new StringReader(new String(BYTES1));
        StringReader r2 = new StringReader(new String(BYTES2));
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setCharacterStream(2, r1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dClob", this.key);
        rs1.next();
        rs1.updateClob(1, (Reader)r2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new StringReader(new String(BYTES2)), rs1.getCharacterStream(1));
        rs1.close();
    }

    public void testUpdateClobwithLengthofIS() throws Exception {
        StringReader r1 = new StringReader(str1);
        StringReader r2 = new StringReader(str2);
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setCharacterStream(2, r1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dClob", this.key);
        rs1.next();
        rs1.updateClob(1, (Reader)r2, (long)str2.length());
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new StringReader(str2), rs1.getCharacterStream(1));
        rs1.close();
    }

    public void testUpdateBlob() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = ResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setBinaryStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        Blob blob = rs1.getBlob(1);
        rs1.close();
        rs1 = this.fetchUpd("dBlob", key2);
        rs1.next();
        rs1.updateBlob(1, blob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", key2);
        rs1.next();
        ResultSetTest.assertEquals(blob, rs1.getBlob(1));
        rs1.close();
    }

    public void testUpdateBlobLengthless() throws Exception {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dBlob", this.key);
        rs1.next();
        rs1.updateBlob(1, (InputStream)is2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testUpdateBlobWithLengthofIS() throws Exception {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dBlob", this.key);
        rs1.next();
        rs1.updateBlob(1, (InputStream)is2, (long)BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testUpdateBlobStringParameterNameWithLengthofIS() throws Exception {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dBlob", this.key);
        rs1.next();
        rs1.updateBlob("dBlob", (InputStream)is2, (long)BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testUpdateClobStringParameterName() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setAsciiStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = ResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setAsciiStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetch("dClob", this.key);
        rs1.next();
        Clob clob = rs1.getClob(1);
        rs1.close();
        rs1 = this.fetchUpd("dClob", key2);
        rs1.next();
        rs1.updateClob("dClob", clob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", key2);
        rs1.next();
        ResultSetTest.assertEquals(clob, rs1.getClob(1));
        rs1.close();
    }

    public void testUpdateClobLengthlessParameterName() throws Exception {
        StringReader r1 = new StringReader(new String(BYTES1));
        StringReader r2 = new StringReader(new String(BYTES2));
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setCharacterStream(2, r1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dClob", this.key);
        rs1.next();
        rs1.updateClob("dClob", (Reader)r2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new StringReader(new String(BYTES2)), rs1.getCharacterStream(1));
        rs1.close();
    }

    public void testUpdateClobStringParameterNameWithLengthofIS() throws Exception {
        StringReader r1 = new StringReader(str1);
        StringReader r2 = new StringReader(str2);
        PreparedStatement ps_sb = this.prep("dClob");
        ps_sb.setInt(1, this.key);
        ps_sb.setCharacterStream(2, r1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dClob", this.key);
        rs1.next();
        rs1.updateClob("dClob", (Reader)r2, (long)str2.length());
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dClob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new StringReader(str2), rs1.getCharacterStream(1));
        rs1.close();
    }

    public void testUpdateBlobStringParameterName() throws Exception {
        this.getConnection().setAutoCommit(false);
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, (InputStream)is1, BYTES1.length);
        ps_sb.executeUpdate();
        int key2 = ResultSetTest.requestKey();
        ps_sb.setInt(1, key2);
        ps_sb.setBinaryStream(2, (InputStream)is2, BYTES2.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        Blob blob = rs1.getBlob(1);
        rs1.close();
        rs1 = this.fetchUpd("dBlob", key2);
        rs1.next();
        rs1.updateBlob("dBlob", blob);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", key2);
        rs1.next();
        ResultSetTest.assertEquals(blob, rs1.getBlob(1));
        rs1.close();
    }

    public void testUpdateBlobWithStreamLengthlessParameterName() throws Exception {
        ByteArrayInputStream is1 = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is2 = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dBlob");
        ps_sb.setInt(1, this.key);
        ps_sb.setBinaryStream(2, is1);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dBlob", this.key);
        rs1.next();
        rs1.updateBlob("dBlob", (InputStream)is2);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dBlob", this.key);
        rs1.next();
        ResultSetTest.assertEquals(new ByteArrayInputStream(BYTES2), rs1.getBinaryStream(1));
        rs1.close();
    }

    public void testGetHoldability() throws SQLException, Exception {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values(1)");
        ResultSetTest.assertEquals((String)"default holdability is HOLD_CURSORS_OVER_COMMIT", (int)1, (int)rs.getHoldability());
        rs.close();
        try {
            rs.getHoldability();
            ResultSetTest.fail((String)"getHoldability() should fail when closed");
        }
        catch (SQLException sqle) {
            ResultSetTest.assertSQLState("XCL16", sqle);
        }
        int[] holdabilities = new int[]{1, 2};
        for (int h = 0; h < holdabilities.length; ++h) {
            Statement s = this.createStatement(1003, 1007, holdabilities[h]);
            rs = s.executeQuery("values(1)");
            ResultSetTest.assertEquals((String)("holdability " + ResultSetTest.holdabilityString(holdabilities[h])), (int)holdabilities[h], (int)rs.getHoldability());
            rs.close();
            s.close();
        }
        stmt.execute("create procedure getresultsetwithhold(in hold int) parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.ResultSetTest.getResultSetWithHoldability' dynamic result sets 1 reads sql data");
        for (int statementHoldability = 0; statementHoldability < holdabilities.length; ++statementHoldability) {
            for (int procHoldability = 0; procHoldability < holdabilities.length; ++procHoldability) {
                CallableStatement cs = this.prepareCall("call getresultsetwithhold(?)", 1003, 1007, holdabilities[statementHoldability]);
                cs.setInt(1, holdabilities[procHoldability]);
                cs.execute();
                rs = cs.getResultSet();
                ResultSetTest.assertSame((Object)cs, (Object)rs.getStatement());
                int holdability = rs.getHoldability();
                ResultSetTest.assertEquals((String)("holdability of ResultSet from stored proc: " + ResultSetTest.holdabilityString(holdability)), (int)holdabilities[procHoldability], (int)holdability);
                this.commit();
                try {
                    rs.next();
                    ResultSetTest.assertEquals((String)"non-holdable result set not closed on commit", (int)1, (int)holdability);
                }
                catch (SQLException sqle) {
                    ResultSetTest.assertSQLState("XCL16", sqle);
                    ResultSetTest.assertEquals((String)"holdable result set closed on commit", (int)2, (int)holdability);
                }
                rs.close();
                cs.close();
            }
        }
        stmt.execute("drop procedure getresultsetwithhold");
        stmt.close();
        this.commit();
    }

    public void testIsClosed() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values(1)");
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)rs.isClosed());
        while (rs.next()) {
        }
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)rs.isClosed());
        rs.close();
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)rs.isClosed());
        rs = stmt.executeQuery("values(1)");
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)rs.isClosed());
        ResultSet rs2 = stmt.executeQuery("values(1)");
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)rs.isClosed());
        ResultSetTest.assertFalse((String)"rs2 should be open", (boolean)rs2.isClosed());
        Statement stmt2 = this.createStatement();
        rs = stmt2.executeQuery("values(1)");
        ResultSetTest.assertFalse((String)"rs2 should be open", (boolean)rs2.isClosed());
        ResultSetTest.assertFalse((String)"rs should be open", (boolean)rs.isClosed());
        stmt.execute("create procedure retrieve_result_sets() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.jdbc4.ResultSetTest.threeResultSets' dynamic result sets 3 reads sql data");
        stmt.execute("call retrieve_result_sets()");
        ResultSet[] rss = new ResultSet[3];
        int count = 0;
        do {
            rss[count] = stmt.getResultSet();
            ResultSetTest.assertFalse((String)("rss[" + count + "] should be open"), (boolean)rss[count].isClosed());
            if (count > 0) {
                ResultSetTest.assertTrue((String)("rss[" + (count - 1) + "] should be closed"), (boolean)rss[count - 1].isClosed());
            }
            ++count;
        } while (stmt.getMoreResults());
        ResultSetTest.assertEquals((String)"expected three result sets", (int)3, (int)count);
        stmt.execute("drop procedure retrieve_result_sets");
        rs = stmt2.executeQuery("values(1)");
        stmt2.close();
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)rs.isClosed());
        Connection conn2 = this.openDefaultConnection();
        stmt2 = conn2.createStatement();
        rs = stmt2.executeQuery("values(1)");
        conn2.close();
        ResultSetTest.assertTrue((String)"rs should be closed", (boolean)rs.isClosed());
        stmt.close();
        stmt2.close();
    }

    public void testIsClosedOnNonHoldableResultSet() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.getConnection().setHoldability(2);
        ResultSet rs = this.createStatement().executeQuery("SELECT TABLENAME FROM SYS.SYSTABLES");
        ResultSetTest.assertEquals((String)"ResultSet shouldn't be holdable", (int)2, (int)rs.getHoldability());
        this.commit();
        ResultSetTest.assertTrue((String)"Commit should have closed the ResultSet", (boolean)rs.isClosed());
    }

    public void testExceptionWhenClosed() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, SQLException {
        String[] zeroArgMethods;
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("values(1)");
        rs.close();
        HashMap<String, Class[]> params = new HashMap<String, Class[]>();
        HashMap<String, Integer[]> args = new HashMap<String, Integer[]>();
        for (String name : zeroArgMethods = new String[]{"getWarnings", "clearWarnings", "getStatement", "getMetaData", "getConcurrency", "getHoldability", "getRow", "getType", "rowDeleted", "rowInserted", "rowUpdated", "getFetchDirection", "getFetchSize"}) {
            params.put(name, null);
            args.put(name, null);
        }
        for (String name : new String[]{"setFetchDirection", "setFetchSize"}) {
            params.put(name, new Class[]{Integer.TYPE});
            args.put(name, new Integer[]{0});
        }
        for (String name : params.keySet()) {
            Method method = rs.getClass().getMethod(name, (Class[])params.get(name));
            try {
                method.invoke((Object)rs, (Object[])args.get(name));
                ResultSetTest.fail((String)("Unexpected Failure: method.invoke(rs, " + args.get(name) + ") should have failed."));
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause instanceof SQLException) {
                    SQLException sqle = (SQLException)cause;
                    String state = sqle.getSQLState();
                    ResultSetTest.assertSQLState("XCL16", sqle);
                    continue;
                }
                throw ite;
            }
            ResultSetTest.fail((String)("no exception thrown for " + name + "() when ResultSet is closed"));
        }
        stmt.close();
    }

    public void testWrapper() throws SQLException {
        Class<ResultSet> wrap_class;
        PreparedStatement ps = this.prepareStatement("select count(*) from sys.systables");
        ResultSet rs = ps.executeQuery();
        if (rs.isWrapperFor(wrap_class = ResultSet.class)) {
            ResultSet resultSet = rs.unwrap(wrap_class);
        } else {
            ResultSetTest.assertFalse((String)"isWrapperFor wrongly returns false", (boolean)rs.isWrapperFor(wrap_class));
        }
        Class<PreparedStatement> wrap_class1 = PreparedStatement.class;
        try {
            if (rs.isWrapperFor(wrap_class1)) {
                ResultSetTest.assertTrue((String)"isWrapperFor wrongly returns true", (boolean)rs.isWrapperFor(wrap_class1));
            } else {
                PreparedStatement ps1 = rs.unwrap(wrap_class1);
                ResultSetTest.fail((String)"unwrap does not throw the expected exception");
            }
        }
        catch (SQLException sqle) {
            ResultSetTest.assertSQLState("XJ128", sqle);
        }
    }

    public static Test suite() {
        TestSuite rsSuite = new TestSuite("ResultSetTest suite");
        rsSuite.addTest(ResultSetTest.decorateTestSuite(TestConfiguration.defaultSuite(ResultSetTest.class, false)));
        return rsSuite;
    }

    private static Test decorateTestSuite(Test rsSuite) {
        return new BaseJDBCTestSetup(rsSuite){

            protected void setUp() throws SQLException {
                Connection con = this.getConnection();
                Statement stmt = con.createStatement();
                stmt.execute("create table UpdateTestTableResultSet (sno int not null unique,dBlob BLOB,dClob CLOB,dLongVarchar LONG VARCHAR,dLongBit LONG VARCHAR FOR BIT DATA)");
                stmt.close();
            }

            @Override
            protected void tearDown() throws Exception {
                Connection con = this.getConnection();
                Statement stmt = con.createStatement();
                stmt.execute("drop table UpdateTestTableResultSet");
                stmt.close();
                super.tearDown();
            }
        };
    }

    private static final int requestKey() {
        return ++insertKey;
    }

    private PreparedStatement prep(String colName) throws SQLException {
        return this.prepareStatement("insert into UpdateTestTableResultSet (sno, " + colName + ") values (?,?)");
    }

    private ResultSet fetchUpd(String colName, int key) throws SQLException {
        Statement stmt = this.createStatement(1003, 1008);
        return stmt.executeQuery("select " + colName + " from UpdateTestTableResultSet where sno = " + key + " for update");
    }

    private ResultSet fetch(String colName, int key) throws SQLException {
        Statement stmt = this.createStatement();
        return stmt.executeQuery("select " + colName + " from UpdateTestTableResultSet where sno = " + key);
    }

    private static String holdabilityString(int holdability) {
        switch (holdability) {
            case 1: {
                return "HOLD_CURSORS_OVER_COMMIT";
            }
            case 2: {
                return "CLOSE_CURSORS_AT_COMMIT";
            }
        }
        return "UNKNOWN HOLDABILITY";
    }

    public static void threeResultSets(ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt1 = c.createStatement();
        rs1[0] = stmt1.executeQuery("values(1)");
        Statement stmt2 = c.createStatement();
        rs2[0] = stmt2.executeQuery("values(1)");
        Statement stmt3 = c.createStatement();
        rs3[0] = stmt3.executeQuery("values(1)");
        c.close();
    }

    public static void getResultSetWithHoldability(int holdability, ResultSet[] rs) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement s = c.createStatement(1003, 1007, holdability);
        rs[0] = s.executeQuery("values (1), (2), (3)");
        c.close();
    }

    public void testDerby1368() throws SQLException, IOException {
        this.testDerby1368(true);
        this.testDerby1368(false);
    }

    public void testDerby1368(boolean lengthless) throws SQLException, IOException {
        Statement stmt = this.createStatement();
        stmt.execute("create table T1368 (ID char(32) PRIMARY KEY, DATA blob(2G) not null)");
        int length = 0x100000;
        byte[] data = new byte[length];
        data[0] = 1;
        data[1] = 2;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        PreparedStatement ps = this.prepareStatement("insert into T1368 (ID, DATA) values (?, ?)");
        ps.setString(1, "id");
        if (lengthless) {
            ps.setBinaryStream(2, bais);
        } else {
            ps.setBinaryStream(2, (InputStream)bais, length);
        }
        ps.execute();
        ps.close();
        ps = this.prepareStatement("select DATA from T1368 where ID = ?");
        ps.setString(1, "id");
        ResultSet rs = ps.executeQuery();
        rs.next();
        Blob b = rs.getBlob(1);
        ResultSetTest.assertEquals((long)length, (long)b.length());
        InputStream in = b.getBinaryStream();
        ResultSetTest.assertEquals((int)1, (int)in.read());
        while (in.read() != -1) {
        }
        in.close();
        in = b.getBinaryStream();
        ResultSetTest.assertEquals((long)length, (long)b.length());
        ResultSetTest.assertEquals((int)1, (int)in.read());
        in.close();
        rs.close();
        stmt.executeUpdate("DROP TABLE T1368");
    }
}

