/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AssertEventCatcher;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceTest
extends BaseJDBCTestCase {
    private DataSource ds = null;

    public DataSourceTest(String name) {
        super(name);
    }

    public void setUp() {
        this.ds = JDBCDataSource.getDataSource();
    }

    @Override
    public void tearDown() throws Exception {
        this.ds = null;
        super.tearDown();
    }

    public void testIsWrapperForDataSource() throws SQLException {
        DataSourceTest.assertTrue((boolean)this.ds.isWrapperFor(DataSource.class));
    }

    public void testIsNotWrapperForPoolDataSource() throws SQLException {
        DataSourceTest.assertFalse((boolean)this.ds.isWrapperFor(ConnectionPoolDataSource.class));
    }

    public void testIsNotWrapperForXADataSource() throws SQLException {
        DataSourceTest.assertFalse((boolean)this.ds.isWrapperFor(XADataSource.class));
    }

    public void testIsNotWrapperForResultSet() throws SQLException {
        DataSourceTest.assertFalse((boolean)this.ds.isWrapperFor(ResultSet.class));
    }

    public void testUnwrapDataSource() throws SQLException {
        DataSource ds2 = this.ds.unwrap(DataSource.class);
        DataSourceTest.assertSame((String)"Unwrap returned wrong object.", (Object)this.ds, (Object)ds2);
    }

    public void testUnwrapConnectionPoolDataSource() {
        try {
            ConnectionPoolDataSource cpds = this.ds.unwrap(ConnectionPoolDataSource.class);
            DataSourceTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapXADataSource() {
        try {
            XADataSource xads = this.ds.unwrap(XADataSource.class);
            DataSourceTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("XJ128", e);
        }
    }

    public void testUnwrapResultSet() {
        try {
            ResultSet rs = this.ds.unwrap(ResultSet.class);
            DataSourceTest.fail((String)"Unwrap didn't fail.");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("XJ128", e);
        }
    }

    public void testConnectionErrorEvent() throws SQLException, Exception {
        AssertEventCatcher aes12 = new AssertEventCatcher(12);
        ConnectionPoolDataSource ds = J2EEDataSource.getConnectionPoolDataSource();
        PooledConnection pc = ds.getPooledConnection();
        pc.addConnectionEventListener(aes12);
        Connection conn = pc.getConnection();
        DataSourceTest.dropTable(conn, "TAB1");
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertFalse((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        if (DataSourceTest.usingEmbedded()) {
            this.getTestConfiguration().shutdownDatabase();
        } else {
            this.getTestConfiguration().stopNetworkServer();
        }
        try {
            conn.createArrayOf("junk", null);
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("0A000", e);
        }
        try {
            conn.createNClob();
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("0A000", e);
        }
        try {
            conn.createSQLXML();
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("0A000", e);
        }
        try {
            conn.createStruct("junk", null);
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("0A000", e);
        }
        try {
            conn.createBlob();
        }
        catch (SQLException e) {
            if (DataSourceTest.usingEmbedded()) {
                DataSourceTest.assertSQLState("08003", e);
            }
            DataSourceTest.assertSQLState("08006", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.createClob();
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getClientInfo();
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.getClientInfo("junk");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setClientInfo(null);
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.setClientInfo("junk1", "junk2");
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        try {
            conn.isWrapperFor(((Object)((Object)this)).getClass());
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        } else {
            DataSourceTest.assertFalse((boolean)aes12.didConnectionErrorEventHappen());
        }
        aes12.resetState();
        try {
            conn.unwrap(((Object)((Object)this)).getClass());
        }
        catch (SQLException e) {
            if (DataSourceTest.usingEmbedded()) {
                DataSourceTest.assertSQLState("08003", e);
            }
            DataSourceTest.assertSQLState("XJ128", e);
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertTrue((boolean)aes12.didConnectionErrorEventHappen());
        } else {
            DataSourceTest.assertFalse((boolean)aes12.didConnectionErrorEventHappen());
        }
        aes12.resetState();
        try {
            conn.isValid(5);
        }
        catch (SQLException e) {
            DataSourceTest.assertSQLState("08003", e);
        }
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertTrue((boolean)aes12.didConnectionClosedEventHappen());
        } else {
            DataSourceTest.assertFalse((boolean)aes12.didConnectionClosedEventHappen());
        }
        DataSourceTest.assertFalse((boolean)aes12.didConnectionErrorEventHappen());
        aes12.resetState();
        if (DataSourceTest.usingEmbedded()) {
            Class.forName("com.pivotal.gemfirexd.jdbc.EmbeddedDriver").newInstance();
        } else {
            this.getTestConfiguration().startNetworkServer();
        }
        conn = this.getConnection();
        conn.close();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(DataSourceTest.class);
    }
}

