/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionMethodsTest
extends BaseJDBCTestCase {
    FileInputStream is;

    public ConnectionMethodsTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ConnectionMethodsTest");
        suite.addTest(ConnectionMethodsTest.baseSuite("ConnectionMethodsTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ConnectionMethodsTest.baseSuite("ConnectionMethodsTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(ConnectionMethodsTest.class, name);
        SupportFilesSetup test = new SupportFilesSetup((Test)suite, new String[]{"functionTests/testData/ConnectionMethods/short.txt"});
        return new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table clobtable2(n int,clobcol CLOB)");
                s.execute("create table blobtable2(n int,blobcol BLOB)");
            }
        };
    }

    public void testCreateClob() throws SQLException, FileNotFoundException, IOException, Exception {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into clobtable2 (n, clobcol) values(?,?)");
        ps.setInt(1, 1000);
        Clob clob = conn.createClob();
        try {
            this.is = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream("extin/short.txt");
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        OutputStream os = clob.setAsciiStream(1L);
        ArrayList<Integer> beforeUpdateList = new ArrayList<Integer>();
        int c = this.is.read();
        while (c > 0) {
            os.write(c);
            beforeUpdateList.add(c);
            c = this.is.read();
        }
        ps.setClob(2, clob);
        ps.executeUpdate();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select clobcol from clobtable2 where n = 1000");
        ConnectionMethodsTest.assertTrue((boolean)rs.next());
        clob = rs.getClob(1);
        ConnectionMethodsTest.assertEquals((long)beforeUpdateList.size(), (long)clob.length());
        InputStream in = clob.getAsciiStream();
        ArrayList<Integer> afterUpdateList = new ArrayList<Integer>();
        int b = in.read();
        while (b > -1) {
            afterUpdateList.add(b);
            b = in.read();
        }
        ConnectionMethodsTest.assertEquals((int)beforeUpdateList.size(), (int)afterUpdateList.size());
        int i = 0;
        while ((long)i < clob.length()) {
            ConnectionMethodsTest.assertEquals(beforeUpdateList.get(i), afterUpdateList.get(i));
            ++i;
        }
        os.close();
        this.is.close();
    }

    public void testCreateBlob() throws SQLException, FileNotFoundException, IOException, Exception {
        Connection conn = this.getConnection();
        Statement s = this.createStatement();
        PreparedStatement ps = this.prepareStatement("insert into blobtable2 (n, blobcol) values(?,?)");
        ps.setInt(1, 1000);
        Blob blob = conn.createBlob();
        try {
            this.is = (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream("extin/short.txt");
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
        OutputStream os = blob.setBinaryStream(1L);
        ArrayList<Integer> beforeUpdateList = new ArrayList<Integer>();
        int actualLength = 0;
        int c = this.is.read();
        while (c > 0) {
            os.write(c);
            beforeUpdateList.add(c);
            c = this.is.read();
            ++actualLength;
        }
        ps.setBlob(2, blob);
        ps.executeUpdate();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select blobcol from blobtable2 where n = 1000");
        ConnectionMethodsTest.assertTrue((boolean)rs.next());
        blob = rs.getBlob(1);
        ConnectionMethodsTest.assertEquals((long)beforeUpdateList.size(), (long)blob.length());
        InputStream in = blob.getBinaryStream();
        ArrayList<Integer> afterUpdateList = new ArrayList<Integer>();
        int b = in.read();
        while (b > -1) {
            afterUpdateList.add(b);
            b = in.read();
        }
        ConnectionMethodsTest.assertEquals((int)beforeUpdateList.size(), (int)afterUpdateList.size());
        int i = 0;
        while ((long)i < blob.length()) {
            ConnectionMethodsTest.assertEquals(beforeUpdateList.get(i), afterUpdateList.get(i));
            ++i;
        }
        os.close();
        this.is.close();
    }

    public void testConnectionIsValid() throws SQLException, Exception {
        Connection conn = this.getConnection();
        try {
            conn.isValid(-1);
            ConnectionMethodsTest.fail((String)"FAIL: isValid(-1): Invalid argument execption not thrown");
        }
        catch (SQLException e) {
            ConnectionMethodsTest.assertSQLState("XJ081", e);
        }
        if (!conn.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0): returned false");
        }
        if (!conn.isValid(1)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(1): returned false");
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            ConnectionMethodsTest.assertSQLState("08003", e);
        }
        if (conn.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on closed connection: returned true");
        }
        if (!(conn = this.getConnection()).isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on open connection: returned false");
        }
        TestConfiguration.getCurrent().shutdownDatabase();
        if (conn.isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on stopped database: returned true");
        }
        if (!(conn = this.getConnection()).isValid(0)) {
            ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on new connection: returned false");
        }
        if (!ConnectionMethodsTest.usingEmbedded()) {
            TestConfiguration.getCurrent().stopNetworkServer();
            if (conn.isValid(0)) {
                ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on stopped database: returned true");
            }
            TestConfiguration.getCurrent().startNetworkServer();
            conn = this.getConnection();
            if (!conn.isValid(0)) {
                ConnectionMethodsTest.fail((String)"FAIL: isValid(0) on new connection: returned false");
            }
        }
    }
}

