/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.BlobClobTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ExemptBlobMD;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobTest
extends BaseJDBCTestCase {
    private Blob blob = null;
    private static final ExemptBlobMD[] emd = new ExemptBlobMD[]{new ExemptBlobMD("getBinaryStream", new Class[]{Long.TYPE, Long.TYPE}, true, true), new ExemptBlobMD("setBinaryStream", new Class[]{Long.TYPE}, false, true), new ExemptBlobMD("setBytes", new Class[]{Long.TYPE, byte[].class}, false, true), new ExemptBlobMD("setBytes", new Class[]{Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE}, false, true), new ExemptBlobMD("truncate", new Class[]{Long.TYPE}, false, true), new ExemptBlobMD("free", null, true, true)};
    private HashMap<Method, ExemptBlobMD> excludedMethodSet = new HashMap();
    private static final String LOCK_TIMEOUT = "40XL1";

    public BlobTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
        this.getConnection().setTransactionIsolation(2);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.blob != null) {
            this.blob.free();
            this.blob = null;
        }
        this.excludedMethodSet = null;
        super.tearDown();
    }

    void buildHashSet() {
        Class<Blob> iface = Blob.class;
        for (int i = 0; i < emd.length; ++i) {
            try {
                Method m = iface.getMethod(emd[i].getMethodName(), emd[i].getParams());
                this.excludedMethodSet.put(m, emd[i]);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                BlobTest.fail((String)"The method could not be found in the interface");
            }
        }
    }

    public void testFreeandMethodsAfterCallingFree() throws SQLException {
        this.blob = BlobClobTestSetup.getSampleBlob(this.getConnection());
        this.buildHashSet();
        this.blob.free();
        this.blob.free();
        this.buildMethodList(this.blob);
    }

    void buildMethodList(Object LOB) {
        boolean valid = true;
        Vector<Method> methodList = new Vector<Method>();
        Class<Blob> clazz = Blob.class;
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (this.checkIfExempted(methods[i])) continue;
            valid = this.checkIfMethodThrowsSQLException(LOB, methods[i]);
            if (!valid) {
                methodList.add(methods[i]);
            }
            valid = true;
        }
        if (!methodList.isEmpty()) {
            int c = 0;
            String failureMessage = "The Following methods don't throw required exception - ";
            for (Method m : methodList) {
                if (++c == methodList.size() && c != 1) {
                    failureMessage = failureMessage + " & ";
                } else if (c != 1) {
                    failureMessage = failureMessage + " , ";
                }
                failureMessage = failureMessage + m.getName();
            }
            BlobTest.fail((String)failureMessage);
        }
    }

    boolean checkIfExempted(Method m) {
        ExemptBlobMD md = this.excludedMethodSet.get(m);
        if (md != null && BlobTest.usingDerbyNetClient()) {
            return md.getIfClientFramework();
        }
        if (md != null && BlobTest.usingEmbedded()) {
            return md.getIfEmbeddedFramework();
        }
        return false;
    }

    boolean checkIfMethodThrowsSQLException(Object LOB, Method method) {
        block3: {
            try {
                method.invoke(LOB, this.getNullValues(method.getParameterTypes()));
            }
            catch (Throwable e) {
                if (!(e instanceof InvocationTargetException)) break block3;
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    SQLException sqle = (SQLException)cause;
                    return sqle.getSQLState().equals("XJ215");
                }
                return false;
            }
        }
        return false;
    }

    Object[] getNullValues(Class<?>[] params) {
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = this.getNullValueForType(params[i]);
        }
        return args;
    }

    Object getNullValueForType(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Character.TYPE) {
            return new Character('\u0000');
        }
        if (type == Byte.TYPE) {
            return new Byte(0);
        }
        if (type == Short.TYPE) {
            return new Short(0);
        }
        if (type == Integer.TYPE) {
            return new Integer(0);
        }
        if (type == Long.TYPE) {
            return new Long(0L);
        }
        if (type == Float.TYPE) {
            return new Float(0.0f);
        }
        if (type == Double.TYPE) {
            return new Double(0.0);
        }
        BlobTest.fail((String)("Don't know how to handle type " + type));
        return null;
    }

    public void testGetBinaryStreamLong() throws Exception {
        byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setBinaryStream(2, is);
        ps.execute();
        ps.close();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + id);
        rs.next();
        Blob blob = rs.getBlob(1);
        InputStream is_1 = blob.getBinaryStream(2L, 5L);
        ByteArrayInputStream is_2 = new ByteArrayInputStream(BYTES1, 1, 5);
        BlobTest.assertEquals(is_2, is_1);
        rs.close();
        st.close();
    }

    public void testGetBinaryStreamLongExceptionConditions() throws SQLException {
        byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setBinaryStream(2, is);
        ps.execute();
        ps.close();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + id);
        rs.next();
        Blob blob = rs.getBlob(1);
        try {
            blob.getBinaryStream(-2L, 5L);
            BlobTest.fail((String)"FAIL: Expected SQLException for pos being negative not thrown");
        }
        catch (SQLException sqle) {
            BlobTest.assertSQLState("XJ070", sqle);
        }
        try {
            blob.getBinaryStream(blob.length() + 1L, 5L);
            BlobTest.fail((String)"FAIL: Expected SQLException for position being greater than length of LOB not thrown");
        }
        catch (SQLException sqle) {
            BlobTest.assertSQLState("XJ087", sqle);
        }
        try {
            blob.getBinaryStream(2L, -5L);
            BlobTest.fail((String)"Fail: expected exception for the length being negative not thrown");
        }
        catch (SQLException sqle) {
            BlobTest.assertSQLState("XJ071", sqle);
        }
        try {
            blob.getBinaryStream(blob.length() - 4L, 10L);
            BlobTest.fail((String)"Fail: expected exception for the sum of position and length being greater than the LOB size not thrown");
        }
        catch (SQLException sqle) {
            BlobTest.assertSQLState("XJ087", sqle);
        }
    }

    public void testGetBinaryStreamCreateBlob() throws Exception {
        byte[] bytes1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream is_bytes1 = new ByteArrayInputStream(bytes1);
        Blob blob = this.getConnection().createBlob();
        InputStream is = blob.getBinaryStream();
        blob.setBytes(1L, bytes1);
        BlobTest.assertEquals(is_bytes1, is);
    }

    public void testGetBinaryStreamBlobUpdates() throws Exception {
        byte[] bytes1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        byte[] bytes2 = new byte[]{101, 102, 103, 104, 105, 101, 102, 103, 104, 105};
        Blob blob = this.getConnection().createBlob();
        InputStream is_BeforeWrite = blob.getBinaryStream();
        OutputStream os = blob.setBinaryStream(1L);
        os.write(bytes1);
        blob.setBytes(bytes1.length + 1, bytes2);
        InputStream is_AfterWrite = blob.getBinaryStream();
        BlobTest.assertEquals(is_BeforeWrite, is_AfterWrite);
    }

    public void testLockingAfterFree() throws SQLException {
        int id = this.initializeLongBlob();
        this.executeParallelUpdate(id, false);
        this.blob.free();
        this.executeParallelUpdate(id, false);
        this.commit();
    }

    public void testLockingAfterFreeWithRR() throws SQLException {
        this.getConnection().setTransactionIsolation(4);
        int id = this.initializeLongBlob();
        this.executeParallelUpdate(id, false);
        this.blob.free();
        this.executeParallelUpdate(id, false);
        this.commit();
        this.executeParallelUpdate(id, false);
    }

    public void testLockingAfterFreeWithDirtyReads() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        int id = this.initializeLongBlob();
        this.executeParallelUpdate(id, false);
        this.blob.free();
        this.executeParallelUpdate(id, false);
        this.commit();
    }

    private int initializeLongBlob() throws SQLException {
        int lobLength = 40000;
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setBinaryStream(2, (InputStream)new LoopingAlphabetStream(40000L), 40000);
        ps.execute();
        ps.close();
        this.commit();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + id);
        rs.next();
        this.blob = rs.getBlob(1);
        rs.close();
        st.close();
        return id;
    }

    private void executeParallelUpdate(int id, boolean timeoutExpected) throws SQLException {
        Connection conn2 = this.openDefaultConnection();
        Statement stmt2 = conn2.createStatement();
        try {
            stmt2.executeUpdate("update BLOBCLOB set CLOBDATA = 'New' where id=" + id);
            stmt2.close();
            conn2.commit();
            conn2.close();
            if (timeoutExpected) {
                BlobTest.fail((String)"FAIL - should have gotten lock timeout");
            }
        }
        catch (SQLException se) {
            stmt2.close();
            conn2.rollback();
            conn2.close();
            if (timeoutExpected) {
                BlobTest.assertSQLState(LOCK_TIMEOUT, se);
            }
            throw se;
        }
    }

    public static Test suite() {
        return new BlobClobTestSetup(TestConfiguration.defaultSuite(BlobTest.class, false));
    }
}

