/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import com.pivotal.gemfirexd.internal.shared.common.reference.MessageId;
import com.pivotal.gemfirexd.internal.shared.common.reference.SQLState;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.derbyTesting.junit.BaseTestCase;

public class MessageBundleTest
extends BaseTestCase {
    static HashSet sqlStateIds = new HashSet();
    static HashSet messageIdIds = new HashSet();
    static HashSet messageBundleIds = new HashSet();

    public MessageBundleTest(String name) {
        super(name);
    }

    static void loadClassIds(Class idclass, HashSet set) throws Exception {
        Field[] fields = idclass.getFields();
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String id = (String)fields[i].get(null);
            if (id.length() == 2 || id.equals("close.C.1") || id.equals("rwupd") || id.equals("02502") || id.equals("XSAX0") || set.add(id)) continue;
            System.err.println("ERROR: The id " + id + " was found twice in " + idclass.getName());
        }
    }

    static void loadMessageBundleIds() throws Exception {
        int numBundles = 50;
        for (int i = 0; i < numBundles; ++i) {
            MessageBundleTest.loadMessageBundle(i);
        }
    }

    static void loadMessageBundle(int index) {
        String bundleName = "com.pivotal.gemfirexd.internal.loc.m" + index;
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.ENGLISH);
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (messageBundleIds.add(key)) continue;
            System.err.println("ERROR: the key " + key + " exists twice in messages_en.properties");
        }
    }

    public void testSQLStateOrphanedIds() throws Exception {
        for (String sqlStateId : sqlStateIds) {
            if (messageBundleIds.contains(sqlStateId)) continue;
            System.err.println("ERROR: Message id " + sqlStateId + " in SQLState.java was not found in" + " messages_en.properties");
        }
    }

    public void testMessageIdOrphanedIds() throws Exception {
        for (String sqlStateId : messageIdIds) {
            if (messageBundleIds.contains(sqlStateId)) continue;
            System.err.println("ERROR: Message id " + sqlStateId + " in MessageId.java was not found in" + " messages_en.properties");
        }
    }

    public void testMessageBundleOrphanedMessages() throws Exception {
        for (String msgid : messageBundleIds) {
            if (sqlStateIds.contains(msgid) || messageIdIds.contains(msgid)) continue;
            System.err.println("WARNING: Message id " + msgid + " in messages_en.properties is not " + "referenced in either SQLState.java or MessageId.java");
        }
    }

    static {
        try {
            MessageBundleTest.loadClassIds(SQLState.class, sqlStateIds);
            MessageBundleTest.loadClassIds(MessageId.class, messageIdIds);
            MessageBundleTest.loadMessageBundleIds();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }
}

