/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import com.pivotal.gemfirexd.internal.client.am.ClientMessageId;
import com.pivotal.gemfirexd.internal.client.am.SqlException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class SqlExceptionTest
extends BaseJDBCTestCase {
    public SqlExceptionTest(String name) {
        super(name);
    }

    public void testChainedException() {
        IOException ioe = new IOException("Test exception");
        SqlException sqle = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)ioe);
        SQLException javae = sqle.getSQLException(null);
        SqlExceptionTest.assertEquals((Object)sqle, (Object)javae.getCause());
        SqlExceptionTest.assertEquals((Object)ioe, (Object)javae.getCause().getCause());
        SqlExceptionTest.assertNull((Object)sqle.getNextException());
    }

    public void testNextException() {
        SQLException nexte = new SQLException("test");
        SqlException sqle = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)nexte);
        SQLException javae = sqle.getSQLException(null);
        SqlExceptionTest.assertEquals((Object)sqle, (Object)javae.getCause());
        SqlExceptionTest.assertEquals((Object)nexte, (Object)javae.getCause().getCause());
        SqlExceptionTest.assertEquals((Object)nexte, (Object)javae.getNextException());
        SqlException internalException = new SqlException(null, new ClientMessageId("08000"));
        javae = new SqlException(null, new ClientMessageId("08003.C.1"), (Throwable)internalException).getSQLException(null);
        SqlExceptionTest.assertNotNull((Object)javae.getNextException());
        SqlExceptionTest.assertEquals((String)javae.getNextException().getSQLState(), (String)"08000");
        SqlExceptionTest.assertEquals((Object)internalException, (Object)javae.getCause().getCause());
    }

    public void testSerializedException() throws Exception {
        try {
            Connection conn = this.getConnection();
            Statement stmt = conn.createStatement();
            String insertData = "INSERT INTO tableWithPK values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)";
            stmt.addBatch(insertData);
            stmt.addBatch(insertData);
            stmt.addBatch(insertData);
            stmt.executeBatch();
            SqlExceptionTest.fail((String)"Unexpected: SQL statement should have failed");
        }
        catch (SQLException se) {
            SQLException se_ser = SqlExceptionTest.recreateSQLException(se);
            SqlExceptionTest.assertSQLState("Unexpected SQL State", se.getSQLState(), se_ser);
            SqlExceptionTest.assertSQLExceptionEquals(se, se_ser);
        }
    }

    public void setUp() throws Exception {
        Connection conn = this.getConnection();
        String createTableWithPK = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        Statement stmt = conn.createStatement();
        stmt.execute(createTableWithPK);
        stmt.close();
        conn.close();
    }

    @Override
    public void tearDown() throws Exception {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("DROP TABLE tableWithPK");
        stmt.close();
        conn.close();
        super.tearDown();
    }

    public static SQLException recreateSQLException(SQLException se) throws Exception {
        SQLException recreatedDS = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(se);
        oos.flush();
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        recreatedDS = (SQLException)ois.readObject();
        ois.close();
        SqlExceptionTest.assertNotNull((Object)recreatedDS);
        return recreatedDS;
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty SqlExceptionTest - client not supported on JSR169");
        }
        return new TestSuite(SqlExceptionTest.class, "SqlExceptionTest");
    }
}

