/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.derbynet.SwitchablePrintStream;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OutBufferedStream {
    private static NetworkServerControl networkServer = null;
    private static boolean dbNotCreated = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            ij.getPropertyArg((String[])args);
            SwitchablePrintStream testExecutionOutput = new SwitchablePrintStream(System.out);
            SwitchablePrintStream testExecutionErrOutput = new SwitchablePrintStream(System.out);
            PrintStream originalOut = System.out;
            PrintStream originalErr = System.err;
            System.setOut(testExecutionOutput);
            System.setErr(testExecutionErrOutput);
            OutBufferedStream.startServer();
            System.out.println("start test.");
            OutBufferedStream.createTestTable();
            OutBufferedStream.testReadOfLob();
            System.out.println("test done.");
            OutputStream shutdownLogFileStream = null;
            OutputStream shutdownErrLogFileStream = null;
            try {
                shutdownLogFileStream = OutBufferedStream.getShutdownLogFileStream();
                shutdownErrLogFileStream = OutBufferedStream.getShutdownErrLogFileStream();
                testExecutionOutput.switchOutput(shutdownLogFileStream);
                testExecutionErrOutput.switchOutput(shutdownErrLogFileStream);
                OutBufferedStream.shutdownServer();
                testExecutionOutput.switchOutput(originalOut);
                testExecutionErrOutput.switchOutput(originalErr);
            }
            finally {
                if (shutdownLogFileStream != null) {
                    shutdownLogFileStream.flush();
                    shutdownLogFileStream.close();
                }
                if (shutdownErrLogFileStream != null) {
                    shutdownErrLogFileStream.flush();
                    shutdownErrLogFileStream.close();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void createTestTable() throws SQLException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        Connection conn = OutBufferedStream.getConnection();
        Statement createTableSt = conn.createStatement();
        createTableSt.execute("create table TEST_TABLE( TEST_COL blob( 65536 ))");
        createTableSt.close();
        conn.commit();
        conn.close();
    }

    private static void testReadOfLob() throws SQLException, IOException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        int c;
        Connection conn = OutBufferedStream.getConnection();
        conn.setAutoCommit(false);
        PreparedStatement insertLobSt = conn.prepareStatement("insert into TEST_TABLE( TEST_COL ) values(?)");
        insertLobSt.setBinaryStream(1, (InputStream)OutBufferedStream.createOriginalDataInputStream(65536), 65536);
        insertLobSt.executeUpdate();
        insertLobSt.close();
        conn.commit();
        PreparedStatement st = conn.prepareStatement("select TEST_COL from TEST_TABLE");
        ResultSet rs = st.executeQuery();
        rs.next();
        InputStream is = rs.getBinaryStream(1);
        while ((c = is.read()) > -1) {
            System.out.print(c);
            System.out.print(",");
            if ((c + 1) % 256 != 0) continue;
            System.out.println();
        }
        is.close();
        rs.close();
        st.close();
        conn.commit();
        conn.close();
        System.out.println();
    }

    private static ByteArrayInputStream createOriginalDataInputStream(int length) {
        byte[] originalValue = new byte[length];
        for (int i = 0; i < originalValue.length; ++i) {
            originalValue[i] = (byte)(i % 256);
        }
        return new ByteArrayInputStream(originalValue);
    }

    protected static boolean isServerStarted(NetworkServerControl server, int ntries) {
        for (int i = 1; i <= ntries; ++i) {
            try {
                Thread.sleep(500L);
                server.ping();
                return true;
            }
            catch (Exception e) {
                if (i != ntries) continue;
                return false;
            }
        }
        return false;
    }

    private static void startServer() throws Exception {
        try {
            TestUtil.loadDriver();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        networkServer = new NetworkServerControl(InetAddress.getByName("localhost"), 1527);
        networkServer.start(null);
        if (!OutBufferedStream.isServerStarted(networkServer, 60)) {
            System.exit(-1);
        }
    }

    private static void shutdownServer() throws Exception {
        networkServer.shutdown();
    }

    private static Connection getConnection() throws SQLException {
        String dbName = "wombat";
        if (dbNotCreated) {
            dbName = dbName + ";create=true";
            dbNotCreated = false;
        }
        return DriverManager.getConnection(TestUtil.getJdbcUrlPrefix("localhost", 1527) + dbName, "testuser", "testpassword");
    }

    private static OutputStream getShutdownLogFileStream() throws FileNotFoundException {
        return new FileOutputStream("outBufferedStream." + System.getProperty("framework", "") + "." + "shutdown.std.log");
    }

    private static OutputStream getShutdownErrLogFileStream() throws FileNotFoundException {
        return new FileOutputStream("outBufferedStream." + System.getProperty("framework", "") + "." + "shutdown.err.log");
    }
}

