/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.IOException;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerControlClientCommandTest
extends BaseJDBCTestCase {
    public NetworkServerControlClientCommandTest(String name) {
        super(name);
    }

    public void testPing() throws Exception {
        String currentHost = TestConfiguration.getCurrent().getHostName();
        String currentPort = Integer.toString(TestConfiguration.getCurrent().getPort());
        String[] pingCmd1 = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "ping"};
        this.assertSuccessfulPing(pingCmd1);
        String[] pingCmd2 = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "ping", "-h", currentHost, "-p", currentPort};
        this.assertSuccessfulPing(pingCmd2);
        String[] pingCmd3 = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "ping", "-h", currentHost};
        this.assertSuccessfulPing(pingCmd3);
        String[] pingCmd4 = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "ping", "-h", "nothere"};
        this.assertFailedPing(pingCmd4, "Unable to find host");
        String[] pingCmd5 = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "ping", "-h", currentHost, "-p", "9393"};
        this.assertFailedPing(pingCmd5, "Could not connect to GemFireXD Network Server");
    }

    private void assertSuccessfulPing(String[] pingCmd) throws InterruptedException, IOException {
        this.assertExecJavaCmdAsExpected(new String[]{"Connection obtained"}, pingCmd, 0);
    }

    private void assertFailedPing(String[] pingCmd, String expectedMessage) throws InterruptedException, IOException {
        this.assertExecJavaCmdAsExpected(new String[]{expectedMessage}, pingCmd, 1);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("NetworkServerControlClientCommandTest");
        if (!Derby.hasServer() || !Locale.getDefault().getLanguage().equals("en") || JDBC.vmSupportsJSR169()) {
            return suite;
        }
        Test test = TestConfiguration.clientServerSuite(NetworkServerControlClientCommandTest.class);
        test = SecurityManagerSetup.noSecurityManager(test);
        suite.addTest(test);
        return suite;
    }
}

