/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NetworkServerControlApiTest
extends BaseJDBCTestCase {
    private static String POLICY_FILE_NAME = "functionTests/tests/derbynet/NetworkServerControlApiTest.policy";
    private static String TARGET_POLICY_FILE_NAME = "server.policy";

    public NetworkServerControlApiTest(String name) {
        super(name);
    }

    public void testWrongUsage() throws Exception {
        String nsc = "com.pivotal.gemfirexd.internal.drda.NetworkServerControl";
        String usage = "Usage: ";
        String[] cmd = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl"};
        this.assertExecJavaCmdAsExpected(new String[]{"No command given.", "Usage: "}, cmd, 1);
        cmd = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "-h", "localhost"};
        this.assertExecJavaCmdAsExpected(new String[]{"No command given.", "Usage: "}, cmd, 1);
        cmd = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "unknowncmd"};
        this.assertExecJavaCmdAsExpected(new String[]{"Command unknowncmd is unknown.", "Usage: "}, cmd, 1);
        cmd = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "-unknownarg"};
        this.assertExecJavaCmdAsExpected(new String[]{"Argument -unknownarg is unknown.", "Usage: "}, cmd, 1);
        cmd = new String[]{"com.pivotal.gemfirexd.internal.drda.NetworkServerControl", "ping", "arg1"};
        this.assertExecJavaCmdAsExpected(new String[]{"Invalid number of arguments for command ping.", "Usage: "}, cmd, 1);
    }

    public void testTraceCommands() throws Exception {
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        String derbySystemHome = NetworkServerControlApiTest.getSystemProperty("gemfirexd.system.home");
        nsctrl.setTraceDirectory(derbySystemHome);
        nsctrl.trace(true);
        nsctrl.ping();
        NetworkServerControlApiTest.assertTrue((boolean)this.fileExists(derbySystemHome + "/Server4.trace"));
        nsctrl.trace(false);
        nsctrl.setTraceDirectory("/");
        try {
            nsctrl.trace(true);
            NetworkServerControlApiTest.fail((String)"Should have gotten an exception turning on tracing");
        }
        catch (Exception exception) {
            // empty catch block
        }
        nsctrl.ping();
    }

    public void xtestTraceSystemPropertiesNoPermission() throws SQLException {
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("gemfirexd.drda.traceAll"), (String)"true");
        NetworkServerControlApiTest.assertEquals((String)NetworkServerControlApiTest.getSystemProperty("gemfirexd.drda.traceDirectory"), (String)"/");
        Connection conn = this.getConnection();
        NetworkServerControlApiTest.assertFalse((boolean)conn.getMetaData().isReadOnly());
    }

    public void testPing() throws Exception {
        String currentHost = TestConfiguration.getCurrent().getHostName();
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        nsctrl.ping();
        nsctrl = new NetworkServerControl(this.privInetAddressGetByName(currentHost), 9393);
        try {
            nsctrl.ping();
            NetworkServerControlApiTest.fail((String)"Should not have been able to ping on port 9393");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InetAddress privInetAddressGetByName(final String host) throws UnknownHostException {
        InetAddress inetAddr = null;
        try {
            inetAddr = (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UnknownHostException {
                    return InetAddress.getByName(host);
                }
            });
        }
        catch (PrivilegedActionException pe) {
            Exception e = pe.getException();
            if (e instanceof UnknownHostException) {
                throw (UnknownHostException)e;
            }
            throw (SecurityException)e;
        }
        return inetAddr;
    }

    private boolean fileExists(String filename) {
        final File file = new File(filename);
        try {
            return (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException {
                    return new Boolean(file.exists());
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (SecurityException)pae.getException();
        }
    }

    private String makeServerPolicyName() {
        try {
            String userDir = NetworkServerControlApiTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            System.out.println("Unexpected exception caught by makeServerPolicyName(): " + e);
            return null;
        }
    }

    private static Test decorateTest() {
        String serverPolicyName = new NetworkServerControlApiTest("test").makeServerPolicyName();
        Test test = TestConfiguration.clientServerSuite(NetworkServerControlApiTest.class);
        return test;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("NetworkServerControlApiTest");
        if (!Derby.hasServer()) {
            return suite;
        }
        suite.addTest(NetworkServerControlApiTest.decorateTest());
        suite = NetworkServerControlApiTest.decorateSystemPropertyTests(suite);
        return suite;
    }

    private static TestSuite decorateSystemPropertyTests(TestSuite suite) {
        Properties traceProps = new Properties();
        traceProps.put("gemfirexd.drda.traceDirectory", "/");
        traceProps.put("gemfirexd.drda.traceAll", "true");
        suite.addTest((Test)new SystemPropertyTestSetup(TestConfiguration.clientServerDecorator((Test)new NetworkServerControlApiTest("xtestTraceSystemPropertiesNoPermission")), traceProps));
        return suite;
    }
}

