/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LOBLocatorReleaseTest
extends BaseJDBCTestCase {
    public LOBLocatorReleaseTest(String name) {
        super(name);
    }

    public void testNoLOBs() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from sys.systables");
        while (rs.next()) {
        }
        rs.close();
        stmt = this.createStatement(1004, 1007);
        this.getConnection().setAutoCommit(false);
        rs = stmt.executeQuery("select * from sys.systables");
        rs.absolute(3);
        while (rs.next()) {
        }
        rs.previous();
        rs.absolute(2);
        rs.relative(2);
        rs.afterLast();
        rs.first();
        rs.next();
        rs.last();
        rs.beforeFirst();
        stmt.close();
        rs.close();
        this.rollback();
    }

    public void testForwardOnlyWithNoNulls() throws SQLException {
        this.forwardOnlyTest("LOBLOC_NO_NULLS");
    }

    public void testForwardOnlyWithNulls() throws SQLException {
        this.forwardOnlyTest("LOBLOC_WITH_NULLS");
    }

    private void forwardOnlyTest(String table) throws SQLException {
        String sql = "select dBlob, dClob from " + table;
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
        }
        rs.close();
        rs = stmt.executeQuery(sql);
        int index = 0;
        while (rs.next()) {
            if (index % 2 == 0) {
                Blob b = rs.getBlob(1);
                if (!rs.wasNull()) {
                    b.length();
                }
            }
            if (index % 3 == 0) {
                Clob c = rs.getClob(2);
                if (!rs.wasNull()) {
                    c.length();
                }
            }
            if (index == 9) {
                this.commit();
            }
            ++index;
        }
        rs.close();
        stmt.close();
        stmt = this.createStatement();
        rs = stmt.executeQuery(sql);
        rs.next();
        rs.next();
        stmt.close();
        this.commit();
        stmt = this.createStatement();
        rs = stmt.executeQuery(sql);
        rs.next();
        rs.next();
        this.rollback();
        rs.close();
    }

    public void testBlobClobStateForwardOnlyWithNoNulls() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        rs.next();
        Blob b = rs.getBlob(1);
        long blobLength = b.length();
        rs.next();
        Clob c = rs.getClob(2);
        long clobLength = c.length();
        rs.next();
        rs.close();
        LOBLocatorReleaseTest.assertEquals((long)blobLength, (long)b.length());
        LOBLocatorReleaseTest.assertEquals((long)clobLength, (long)c.length());
        this.commit();
        try {
            c.getSubString(1L, 9);
            LOBLocatorReleaseTest.fail((String)"Locator should have been released, causing the call to fail");
        }
        catch (SQLException sqle) {
            LOBLocatorReleaseTest.assertSQLState("XJ215", sqle);
        }
    }

    public void testBlobClobStateAfterCloseOnScrollable() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement(1004, 1007);
        ResultSet rs = stmt.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        rs.next();
        rs.relative(5);
        Blob b = rs.getBlob(1);
        long blobLength = b.length();
        rs.next();
        Clob c = rs.getClob(2);
        long clobLength = c.length();
        rs.first();
        rs.close();
        LOBLocatorReleaseTest.assertEquals((long)blobLength, (long)b.length());
        LOBLocatorReleaseTest.assertEquals((long)clobLength, (long)c.length());
        this.commit();
        try {
            c.getSubString(1L, 9);
            LOBLocatorReleaseTest.fail((String)"Locator should have been released, causing the call to fail");
        }
        catch (SQLException sqle) {
            LOBLocatorReleaseTest.assertSQLState("XJ215", sqle);
        }
    }

    public void DISABLED_testScrollableWithNoNulls() throws SQLException {
        this.scrollableTest("LOBLOC_NO_NULLS", 1007);
        this.scrollableTest("LOBLOC_NO_NULLS", 1008);
    }

    public void DISABLED_testScrollableWithNulls() throws SQLException {
        this.scrollableTest("LOBLOC_WITH_NULLS", 1007);
        this.scrollableTest("LOBLOC_WITH_NULLS", 1008);
    }

    private void scrollableTest(String table, int rsConcurrency) throws SQLException {
        String sql = "select dBlob, dClob from " + table;
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement(1004, rsConcurrency);
        ResultSet rs = stmt.executeQuery(sql);
        while (rs.next()) {
        }
        rs.close();
        rs = stmt.executeQuery(sql);
        rs.next();
        rs.beforeFirst();
        rs.first();
        rs.relative(3);
        rs.previous();
        rs.last();
        rs.absolute(5);
        rs.afterLast();
        rs.next();
    }

    public void DISABLED_testScrollableMoveToCurrentRow() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        rs.next();
        rs.moveToCurrentRow();
        rs.moveToCurrentRow();
    }

    public void DISABLED_testScrollableAbsoluteRow() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        rs.next();
        rs.absolute(4);
        rs.absolute(4);
        rs.absolute(4);
    }

    public void DISABLED_testScrollableUpdateWithLocators() throws SQLException {
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("select dBlob, dClob from LOBLOC_NO_NULLS");
        rs.absolute(3);
        Clob c1 = rs.getClob(2);
        int origLength = (int)c1.length();
        String origContent = c1.getSubString(1L, origLength);
        c1.setString(origLength, "FIRSTPASS");
        rs.absolute(7);
        rs.next();
        rs.absolute(3);
        Clob c2 = rs.getClob(2);
        LOBLocatorReleaseTest.assertEquals((String)origContent, (String)c2.getSubString(1L, (int)c2.length()));
        rs.updateRow();
        rs.absolute(3);
        Clob c3 = rs.getClob(2);
        LOBLocatorReleaseTest.assertEquals((String)origContent, (String)c3.getSubString(1L, (int)c3.length()));
        rs.previous();
        rs.next();
        Clob c4 = rs.getClob(2);
        String newContent = "THIS IS THE NEW VALUE!";
        c4.setString(1L, "THIS IS THE NEW VALUE!");
        rs.updateClob(2, c4);
        rs.updateRow();
        c4.setString(1L, "THIS IS NOT NOT NOT THE NEW VALUE!");
        rs.updateRow();
        rs.next();
        rs.absolute(3);
        Clob c5 = rs.getClob(2);
        LOBLocatorReleaseTest.assertEquals((String)"THIS IS THE NEW VALUE!", (String)c5.getSubString(1L, (int)c5.length()));
        this.rollback();
        this.assertInvalid(c1);
        this.assertInvalid(c2);
        this.assertInvalid(c3);
        this.assertInvalid(c4);
        this.assertInvalid(c5);
    }

    private void assertInvalid(Clob clob) {
        try {
            clob.getSubString(1L, (int)clob.length());
            LOBLocatorReleaseTest.fail((String)"Clob should have been invalidated");
        }
        catch (SQLException sqle) {
            LOBLocatorReleaseTest.assertSQLState("XJ215", sqle);
        }
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.clientServerSuite(LOBLocatorReleaseTest.class)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                int i;
                byte[] bContent;
                s.executeUpdate("create table LOBLOC_NO_NULLS (dBlob BLOB not null, dClob CLOB not null)");
                Connection con = s.getConnection();
                PreparedStatement ps = con.prepareStatement("insert into LOBLOC_NO_NULLS values (?,?)");
                String cContent = "A little test Clob";
                try {
                    bContent = cContent.getBytes("US-ASCII");
                }
                catch (UnsupportedEncodingException uee) {
                    SQLException sqle = new SQLException();
                    sqle.initCause(uee);
                    throw sqle;
                }
                for (i = 0; i < 25; ++i) {
                    ps.setBytes(1, bContent);
                    ps.setString(2, cContent);
                    ps.executeUpdate();
                }
                ps.close();
                s.executeUpdate("create table LOBLOC_WITH_NULLS (dBlob BLOB, dClob CLOB)");
                ps = con.prepareStatement("insert into LOBLOC_WITH_NULLS values (?,?)");
                for (i = 0; i < 25; ++i) {
                    if (i % 3 == 0) {
                        ps.setNull(1, 2004);
                    } else {
                        ps.setBytes(1, bContent);
                    }
                    if (i % 4 == 0) {
                        ps.setNull(2, 2005);
                    } else {
                        ps.setString(2, cContent);
                    }
                    ps.executeUpdate();
                }
                ps.close();
                con.commit();
            }
        };
    }
}

