/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DerbyNetNewServer {
    private static final String DATABASE_NAME = "gemfirexd";
    private static boolean passed = true;
    private static final Properties authenticationProperties = new Properties();

    public static void main(String[] args) {
        try {
            TestUtil.loadDriver();
            Class.forName("com.pivotal.gemfirexd.jdbc.EmbeddedDriver").newInstance();
            ij.getPropertyArg((String[])args);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            NetworkServerControl server = new NetworkServerControl(InetAddress.getByName("localhost"), TestConfiguration.getCurrent().getPort());
            DerbyNetNewServer.testServer(server, bos, "non-null PrintWriter");
            server = new NetworkServerControl(InetAddress.getByName("localhost"), TestConfiguration.getCurrent().getPort());
            DerbyNetNewServer.testServer(server, null, "null PrintWriter");
        }
        catch (Exception e) {
            e.printStackTrace();
            passed = false;
        }
        if (passed) {
            System.out.println("PASSED.");
        } else {
            System.out.println("FAILED.");
        }
    }

    private static void testServer(NetworkServerControl server, ByteArrayOutputStream bos, String label) throws Exception {
        PrintWriter writer = null;
        System.out.println("Testing " + label);
        if (bos != null) {
            bos.reset();
            writer = new PrintWriter(bos);
        }
        server.start(writer);
        Connection conn = null;
        int ntries = 1;
        while (true) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                conn = DriverManager.getConnection(TestUtil.getJdbcUrlPrefix() + DATABASE_NAME + ";create=true", authenticationProperties);
            }
            catch (SQLException sqle) {
                if (ntries > 10) {
                    System.out.println("Server start failed: " + sqle.getMessage());
                    if (bos != null) {
                        System.out.println("Server log:");
                        System.out.println(bos.toString());
                    }
                    passed = false;
                    break;
                }
                ++ntries;
                continue;
            }
            break;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sqle) {
                passed = false;
                System.out.println("SQLException thrown in close: " + sqle.getMessage());
            }
        }
        try {
            server.shutdown();
        }
        catch (Exception e) {
            passed = false;
            System.out.println("Server shutdown failed: " + e.getMessage());
        }
        if (bos != null && bos.size() == 0) {
            passed = false;
            System.out.println("Nothing written to the server log.");
        }
    }

    static {
        authenticationProperties.put("user", "admin");
        authenticationProperties.put("password", "admin");
    }
}

