/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import com.pivotal.gemfirexd.internal.drda.NetworkServerControl;
import com.pivotal.gemfirexd.internal.tools.ij;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class DerbyNetAutoStart {
    protected static boolean passed = true;
    private static final String JUST_START_SERVER_ARG = "justStartServer=";
    private static Connection drdaConn;
    private static Connection embeddedConn;
    private static int testNumber;
    private static int portNumber;
    private static String hostName;
    private static String homeDir;
    private static String databaseName;
    private static Properties baseProperties;
    private static StringBuilder basePropertiesSB;
    private static File derbyPropertiesFile;
    private static final Properties authenticationProperties;
    private static PrintStream realSystemOut;
    private static ByteArrayOutputStream serverOutputBOS;
    private static PrintStream serverOutputOut;
    private static final String logFileProperty = "gemfirexd.stream.error.file";

    public static void main(String[] args) {
        DerbyNetAutoStart.setup(args);
        DerbyNetAutoStart.runAllTests();
        if (passed) {
            System.out.println("PASSED.");
            System.exit(0);
        } else {
            System.out.println("FAILED.");
            System.exit(1);
        }
    }

    protected static void setup(String[] args) {
        realSystemOut = System.out;
        try {
            TestUtil.loadDriver();
            ij.getPropertyArg((String[])args);
            homeDir = System.getProperty("gemfirexd.system.home", ".");
            hostName = TestUtil.getHostName();
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].startsWith(JUST_START_SERVER_ARG)) continue;
                PrintStream out = DerbyNetAutoStart.getPrintStream(homeDir + File.separatorChar + "serverOutput.txt");
                System.setOut(out);
                System.setErr(out);
                Class.forName("com.pivotal.gemfirexd.jdbc.EmbeddedDriver").newInstance();
                try {
                    portNumber = Integer.parseInt(args[i].substring(JUST_START_SERVER_ARG.length()));
                }
                catch (Exception e) {
                    portNumber = -1;
                }
                if (portNumber <= 0) {
                    portNumber = 1527;
                }
                NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(hostName), portNumber);
                server.start(null);
                for (int j = 0; j < 60; ++j) {
                    Thread.sleep(1000L);
                    if (DerbyNetAutoStart.isServerStarted(server)) break;
                }
                while (DerbyNetAutoStart.isServerStarted(server)) {
                    Thread.sleep(500L);
                }
                System.exit(0);
            }
            derbyPropertiesFile = new File(homeDir + File.separatorChar + "gemfirexd.properties");
            try {
                int c;
                FileReader propertiesReader = new FileReader(derbyPropertiesFile);
                while ((c = propertiesReader.read()) != -1) {
                    basePropertiesSB.append((char)c);
                }
                baseProperties.load(new FileInputStream(derbyPropertiesFile));
            }
            catch (IOException propertiesReader) {}
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " thrown: " + e.getMessage());
            e.printStackTrace();
            passed = false;
        }
        if (!passed) {
            System.exit(1);
        }
    }

    protected static void runAllTests() {
        testNumber = 0;
        try {
            portNumber = 1527;
            if (DerbyNetAutoStart.startTest(new String[]{"gemfirexd.drda.startNetworkServer", "true"})) {
                DerbyNetAutoStart.endTest(true);
            }
            portNumber = 31415;
            if (DerbyNetAutoStart.startTest(new String[]{"gemfirexd.drda.startNetworkServer", "true", "gemfirexd.drda.portNumber", String.valueOf(portNumber)})) {
                DerbyNetAutoStart.endTest(true);
            }
            portNumber = -1;
            if (DerbyNetAutoStart.startTest(new String[]{"gemfirexd.drda.startNetworkServer", "false"})) {
                DerbyNetAutoStart.deleteDir(homeDir + File.separatorChar + databaseName);
                try {
                    drdaConn = DriverManager.getConnection(TestUtil.getJdbcUrlPrefix() + databaseName, authenticationProperties);
                    passed = false;
                    System.out.println("  The network server was started though gemfirexd.drda.startNetworkServer=false.");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DerbyNetAutoStart.endTest(false);
            }
            if (DerbyNetAutoStart.startTest(new String[0])) {
                try {
                    drdaConn = DriverManager.getConnection(TestUtil.getJdbcUrlPrefix() + "database" + testNumber, authenticationProperties);
                    passed = false;
                    System.out.println("  The network server was started though gemfirexd.drda.startNetworkServer was not set.");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DerbyNetAutoStart.endTest(false);
            }
            DerbyNetAutoStart.testExtantNetServer();
        }
        catch (Exception e) {
            System.out.println(e.getClass().getName() + " thrown: " + e.getMessage());
            e.printStackTrace();
            passed = false;
        }
    }

    private static PrintStream getPrintStream(String fileName) {
        try {
            return new PrintStream(new FileOutputStream(fileName));
        }
        catch (Exception e) {
            System.out.println("Could not create " + fileName);
            System.out.println(e.getMessage());
            System.exit(1);
            return null;
        }
    }

    private static void testExtantNetServer() throws Exception {
        Process serverProcess;
        block24: {
            String portStr;
            boolean appendingToLog;
            String logFileName = homeDir + File.separator + "gemfirexd.log";
            DerbyNetAutoStart.announceTest();
            long startLogFileLength = DerbyNetAutoStart.getLogFileLength(logFileName);
            String logAppendProp = System.getProperty("gemfirexd.infolog.append");
            if (logAppendProp == null) {
                logAppendProp = baseProperties.getProperty("gemfirexd.infolog.append");
            }
            boolean bl = appendingToLog = logAppendProp != null && new Boolean(logAppendProp) != false;
            if (!DerbyNetAutoStart.writeDerbyProperties(new String[0])) {
                return;
            }
            jvm jvm2 = null;
            try {
                jvm2 = jvm2.getCurrentJvm();
            }
            catch (Exception e) {
                passed = false;
                System.out.println(" Could not get the current JVM:");
                System.out.println("   " + e.getMessage());
                return;
            }
            portNumber = -1;
            Vector vCmd = jvm2.getCommandLine();
            Properties systemProperties = System.getProperties();
            String[] cmd = new String[vCmd.size() + systemProperties.size() + 3];
            for (int i = 0; i < vCmd.size(); ++i) {
                cmd[i] = (String)vCmd.elementAt(i);
            }
            Enumeration<Object> e = systemProperties.keys();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                if (propName.equals(logFileProperty)) continue;
                cmd[i++] = "-D" + propName + "=" + (String)systemProperties.get(propName);
            }
            cmd[i++] = "-Dgemfirexd.stream.error.file=derbynet.log";
            cmd[i++] = "org.apache.derbyTesting.functionTests.tests.derbynet.DerbyNetAutoStart";
            if (portNumber > 0) {
                portStr = String.valueOf(portNumber);
                cmd[i++] = JUST_START_SERVER_ARG + (portNumber > 0 ? String.valueOf(portNumber) : "");
                portStr = ":" + portStr;
            } else {
                portStr = "1527";
                cmd[i++] = JUST_START_SERVER_ARG;
            }
            serverProcess = Runtime.getRuntime().exec(cmd);
            String dbUrl = TestUtil.getJdbcUrlPrefix(hostName, Integer.parseInt(portStr)) + "database1";
            Connection drdaConn = null;
            int ntries = 1;
            while (true) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    drdaConn = DriverManager.getConnection(dbUrl, authenticationProperties);
                }
                catch (SQLException sqle) {
                    if (ntries > 20) {
                        System.out.println("Server start failed: " + sqle.getMessage());
                        sqle.printStackTrace();
                        passed = false;
                        return;
                    }
                    ++ntries;
                    continue;
                }
                break;
            }
            try {
                String[] properties = portNumber <= 0 ? new String[]{"gemfirexd.drda.startNetworkServer", "true"} : new String[]{"gemfirexd.drda.startNetworkServer", "true", "gemfirexd.drda.portNumber", String.valueOf(portNumber)};
                portNumber = -1;
                if (!DerbyNetAutoStart.runTest(properties)) break block24;
                DerbyNetAutoStart.checkConn(drdaConn, "network");
                DerbyNetAutoStart.checkConn(embeddedConn, "embedded");
                drdaConn.close();
                DerbyNetAutoStart.endTest(false);
                try {
                    Thread.sleep(1000L);
                    RandomAccessFile logFile = new RandomAccessFile(logFileName, "r");
                    if (appendingToLog) {
                        logFile.seek(startLogFileLength);
                    }
                }
                catch (Exception e2) {
                    System.out.println("Cannot open gemfirexd.log: " + e2.getMessage());
                    passed = false;
                    drdaConn.close();
                    DerbyNetAutoStart.stopServer(serverProcess);
                    return;
                }
                if (!DerbyNetAutoStart.checkLog(logFileName, new String[]{"An exception was thrown during network server startup"})) {
                    System.out.println("Active threads:");
                    ThreadGroup tg = Thread.currentThread().getThreadGroup();
                    while (tg.getParent() != null) {
                        tg = tg.getParent();
                    }
                    Thread[] activeThreads = new Thread[16 * Thread.activeCount()];
                    int threadCount = tg.enumerate(activeThreads, true);
                    for (int idx = 0; idx < threadCount; ++idx) {
                        System.out.println("  " + activeThreads[idx].getName());
                    }
                    try {
                        int ev = serverProcess.exitValue();
                        System.out.println("The separate server process exited prematurely with code " + ev);
                    }
                    catch (IllegalThreadStateException itse) {
                        System.out.println("The server process seems to be running.");
                    }
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                passed = false;
            }
        }
        DerbyNetAutoStart.stopServer(serverProcess);
    }

    private static long getLogFileLength(String logFileName) {
        try {
            RandomAccessFile logFile = new RandomAccessFile(logFileName, "r");
            long length = logFile.length();
            logFile.close();
            return length;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private static void checkConn(Connection conn, String label) {
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            ResultSet rs = dbmd.getSchemas();
            while (rs.next()) {
            }
            rs.close();
        }
        catch (SQLException sqle) {
            passed = false;
            System.out.println("Could not use the " + label + " connection:");
            System.out.println("  " + sqle.getMessage());
        }
    }

    private static void stopServer(Process serverProcess) {
        try {
            NetworkServerControl server = new NetworkServerControl(InetAddress.getByName(hostName), portNumber);
            server.shutdown();
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            System.out.println("  Exception thrown while trying to shutdown the remote server.");
            System.out.println("    " + e.getMessage());
            passed = false;
        }
        serverProcess.destroy();
    }

    private static boolean checkLog(String logFileName, String[] expected) throws IOException {
        int i;
        String logLine;
        boolean allFound = true;
        boolean[] found = new boolean[expected.length];
        FileInputStream is = new FileInputStream(logFileName);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((logLine = br.readLine()) != null) {
            for (i = 0; i < expected.length; ++i) {
                if (found[i] || logLine.indexOf(expected[i]) < 0) continue;
                found[i] = true;
            }
        }
        for (i = 0; i < expected.length; ++i) {
            if (found[i]) continue;
            passed = false;
            System.out.println("Derby.log does not contain\n  '" + expected[i] + "'.");
            allFound = false;
        }
        return allFound;
    }

    private static boolean startTest(String[] properties) {
        DerbyNetAutoStart.announceTest();
        return DerbyNetAutoStart.runTest(properties);
    }

    private static boolean runTest(String[] properties) {
        drdaConn = null;
        embeddedConn = null;
        if (!DerbyNetAutoStart.writeDerbyProperties(properties)) {
            return false;
        }
        DerbyNetAutoStart.deleteDir(homeDir + File.separatorChar + databaseName);
        try {
            System.setOut(serverOutputOut);
            Class.forName("com.pivotal.gemfirexd.jdbc.EmbeddedDriver").newInstance();
            embeddedConn = DriverManager.getConnection("jdbc:derby:" + databaseName + ";create=true");
            System.setOut(realSystemOut);
        }
        catch (SQLException sqle) {
            System.setOut(realSystemOut);
            passed = false;
            System.out.println("  Could not create an embedded database.");
            System.out.println("    " + sqle.getMessage());
            return false;
        }
        catch (Exception e) {
            System.setOut(realSystemOut);
            passed = false;
            System.out.println("  Could not start the Derby client driver.");
            System.out.println("    " + e.getMessage());
            return false;
        }
        if (portNumber > 0) {
            int ntries = 1;
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    drdaConn = DriverManager.getConnection(TestUtil.getJdbcUrlPrefix(hostName, portNumber) + databaseName, authenticationProperties);
                }
                catch (SQLException sqle) {
                    if (ntries > 5) {
                        passed = false;
                        System.out.println("  Could not access database through the network server.");
                        System.out.println("    " + sqle.getMessage());
                        return false;
                    }
                    ++ntries;
                    continue;
                }
                break;
            }
        }
        return true;
    }

    private static boolean writeDerbyProperties(String[] properties) {
        derbyPropertiesFile.delete();
        try {
            derbyPropertiesFile.createNewFile();
            PrintStream propertyWriter = new PrintStream(new FileOutputStream(derbyPropertiesFile));
            propertyWriter.print(basePropertiesSB.toString());
            for (int i = 0; i < properties.length - 1; i += 2) {
                propertyWriter.println(properties[i] + "=" + properties[i + 1]);
            }
            propertyWriter.close();
            return true;
        }
        catch (IOException ioe) {
            passed = false;
            System.out.println("  Could not create gemfirexd.properties: " + ioe.getMessage());
            return false;
        }
    }

    private static void deleteDir(String dirName) {
        DerbyNetAutoStart.deleteDir(new File(dirName));
    }

    private static void deleteDir(File parent) {
        if (!parent.exists()) {
            return;
        }
        if (parent.isDirectory()) {
            String[] child = parent.list();
            for (int i = 0; i < child.length; ++i) {
                DerbyNetAutoStart.deleteDir(new File(parent, child[i]));
            }
        }
        parent.delete();
    }

    private static void announceTest() {
        System.out.println("Starting test case " + ++testNumber + ".");
        databaseName = "database" + testNumber;
    }

    private static void endTest(boolean autoStarted) {
        block14: {
            try {
                if (drdaConn != null) {
                    drdaConn.close();
                    drdaConn = null;
                }
                if (embeddedConn != null) {
                    embeddedConn.close();
                    embeddedConn = null;
                }
            }
            catch (SQLException sqle) {
                passed = false;
                System.out.println("  Connection close failed:");
                System.out.println("    " + sqle.getMessage());
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException sqle) {
                // empty catch block
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("XJ015")) break block14;
                passed = false;
                System.out.println("  System shutdown failed:");
                System.out.println("    " + sqle.getMessage());
            }
        }
        serverOutputOut.flush();
        if (serverOutputBOS.size() > 0) {
            passed = false;
            System.out.println("The auto-started server wrote to System.out.");
        }
        serverOutputBOS.reset();
        if (autoStarted && databaseName != null) {
            try {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                drdaConn = DriverManager.getConnection(TestUtil.getJdbcUrlPrefix(hostName, portNumber) + databaseName, authenticationProperties);
                passed = false;
                System.out.println("Was able to connect to the network server after Derby shut down.");
                drdaConn.close();
                drdaConn = null;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static boolean isServerStarted(NetworkServerControl server) {
        try {
            server.ping();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static {
        testNumber = 0;
        baseProperties = new Properties();
        basePropertiesSB = new StringBuilder();
        authenticationProperties = new Properties();
        authenticationProperties.put("user", "admin");
        authenticationProperties.put("password", "admin");
        serverOutputBOS = new ByteArrayOutputStream();
        serverOutputOut = new PrintStream(serverOutputBOS);
    }
}

