/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClientSideSystemPropertiesTest
extends BaseJDBCTestCase {
    public void testConnection() throws Exception {
        this.getConnection().setAutoCommit(false);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                int fileCounter;
                File dir = new File(ClientSideSystemPropertiesTest.getSystemProperty("gemfirexd.client.traceDirectory"));
                File[] list = dir.listFiles();
                for (fileCounter = 0; fileCounter < list.length; ++fileCounter) {
                    File tempFile = list[fileCounter];
                }
                Assert.assertTrue((fileCounter > 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    protected void setUp() throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File dir = new File(ClientSideSystemPropertiesTest.getSystemProperty("gemfirexd.client.traceDirectory"));
                if (!dir.exists()) {
                    Assert.assertTrue((dir.mkdir() || dir.mkdirs() ? 1 : 0) != 0);
                } else {
                    File[] list = dir.listFiles();
                    for (int fileCounter = 0; fileCounter < list.length; ++fileCounter) {
                        File tempFile = list[fileCounter];
                        tempFile.delete();
                    }
                }
                return null;
            }
        });
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        ClientSideSystemPropertiesTest.removeDirectory(ClientSideSystemPropertiesTest.getSystemProperty("gemfirexd.client.traceDirectory"));
    }

    public ClientSideSystemPropertiesTest(String name) {
        super(name);
    }

    public static Test suite() {
        Properties traceRelatedProperties = new Properties();
        traceRelatedProperties.setProperty("gemfirexd.client.traceLevel", "64");
        traceRelatedProperties.setProperty("gemfirexd.client.traceDirectory", "TraceDir");
        Test suite = TestConfiguration.clientServerSuite(ClientSideSystemPropertiesTest.class);
        return new SystemPropertyTestSetup(suite, traceRelatedProperties);
    }
}

