/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import com.pivotal.gemfirexd.internal.client.am.ByteArrayCombinerStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseTestCase;

public class ByteArrayCombinerStreamTest
extends BaseTestCase {
    private static final byte[] defaultArray = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88};
    private ByteArrayCombinerStream combiner;

    public ByteArrayCombinerStreamTest(String name) {
        super(name);
    }

    public void testCombineNullRead() throws IOException {
        this.combiner = new ByteArrayCombinerStream(null, 0L);
        ByteArrayCombinerStreamTest.assertEquals((int)-1, (int)this.combiner.read());
    }

    public void testCombineNullReadArray() throws IOException {
        this.combiner = new ByteArrayCombinerStream(null, 0L);
        ByteArrayCombinerStreamTest.assertEquals((int)-1, (int)this.combiner.read(new byte[10], 0, 10));
    }

    public void testCombineAvailableNull() throws IOException {
        this.combiner = new ByteArrayCombinerStream(null, 0L);
        ByteArrayCombinerStreamTest.assertEquals((int)0, (int)this.combiner.available());
    }

    public void testCombineAvailable4bytes() throws IOException {
        byte[] array = new byte[]{65, 66, 77, 79};
        ArrayList<byte[]> list = new ArrayList<byte[]>(1);
        list.add(array);
        this.combiner = new ByteArrayCombinerStream(list, 4L);
        ByteArrayCombinerStreamTest.assertEquals((int)4, (int)this.combiner.available());
    }

    public void testCombineWithExtraEmptyByteArray() throws IOException {
        byte[] array = new byte[]{65, 66, 77, 79};
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        list.add(array);
        list.add(new byte[4]);
        this.combiner = new ByteArrayCombinerStream(list, (long)array.length);
        byte[] resArray = new byte[array.length];
        ByteArrayCombinerStreamTest.assertEquals((int)array.length, (int)this.combiner.read(resArray, 0, resArray.length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
    }

    public void testCombineOneArray() throws IOException {
        ArrayList<byte[]> list = new ArrayList<byte[]>(1);
        list.add(defaultArray);
        this.combiner = new ByteArrayCombinerStream(list, (long)defaultArray.length);
        byte[] resArray = new byte[defaultArray.length];
        ByteArrayCombinerStreamTest.assertEquals((int)defaultArray.length, (int)this.combiner.read(resArray, 0, resArray.length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(defaultArray, resArray));
    }

    public void testCominbe100SmallArrays() throws IOException {
        int arrays = 100;
        byte[] array = new byte[]{65, 66, 77, 79};
        ArrayList<byte[]> list = new ArrayList<byte[]>(arrays);
        long length = 0L;
        for (int i = 0; i < arrays; ++i) {
            list.add(array);
            length += (long)array.length;
        }
        byte[] targetArray = new byte[(int)length];
        int offset = 0;
        for (int i = 0; i < arrays; ++i) {
            System.arraycopy(array, 0, targetArray, offset, array.length);
            offset += array.length;
        }
        this.combiner = new ByteArrayCombinerStream(list, length);
        byte[] resArray = new byte[(int)length];
        ByteArrayCombinerStreamTest.assertEquals((long)length, (long)this.combiner.read(resArray, 0, resArray.length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(targetArray, resArray));
    }

    public void testTruncateDataFromOneArray() throws IOException {
        int length = defaultArray.length - 5;
        ArrayList<byte[]> list = new ArrayList<byte[]>(1);
        list.add(defaultArray);
        byte[] targetArray = new byte[length];
        System.arraycopy(defaultArray, 0, targetArray, 0, length);
        byte[] resArray = new byte[length];
        this.combiner = new ByteArrayCombinerStream(list, (long)length);
        ByteArrayCombinerStreamTest.assertEquals((int)length, (int)this.combiner.read(resArray, 0, length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(targetArray, resArray));
    }

    public void testTruncateDataFromTwoArrays() throws IOException {
        int length = defaultArray.length * 2 - 7;
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        list.add(defaultArray);
        list.add(defaultArray);
        byte[] targetArray = new byte[length];
        System.arraycopy(defaultArray, 0, targetArray, 0, defaultArray.length);
        System.arraycopy(defaultArray, 0, targetArray, defaultArray.length, length - defaultArray.length);
        byte[] resArray = new byte[length];
        this.combiner = new ByteArrayCombinerStream(list, (long)length);
        ByteArrayCombinerStreamTest.assertEquals((int)length, (int)this.combiner.read(resArray, 0, length));
        ByteArrayCombinerStreamTest.assertTrue((this.combiner.read() == -1 ? 1 : 0) != 0);
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(targetArray, resArray));
    }

    public void testTooLittleDataNoCombine() {
        ArrayList<byte[]> list = new ArrayList<byte[]>(1);
        list.add(new byte[5]);
        try {
            this.combiner = new ByteArrayCombinerStream(list, 10L);
            ByteArrayCombinerStreamTest.fail((String)"An IllegalArgumentException singalling too little data should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTooLittleDataWithCombine() {
        ArrayList<byte[]> list = new ArrayList<byte[]>(3);
        byte[] data = new byte[]{65, 66, 67, 68, 69};
        list.add(data);
        list.add(data);
        list.add(data);
        try {
            this.combiner = new ByteArrayCombinerStream(list, (long)(data.length * 3 + 1));
            ByteArrayCombinerStreamTest.fail((String)"An IllegalArgumentException singalling too little data should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNegativeLengthArgument() {
        ArrayList<byte[]> list = new ArrayList<byte[]>(1);
        list.add(new byte[1234]);
        try {
            this.combiner = new ByteArrayCombinerStream(list, -54L);
            ByteArrayCombinerStreamTest.fail((String)"An IllegalArgumentException singalling negative length should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNegativeValueInDataCausesEndOfStream() throws IOException {
        byte b;
        byte[] data = new byte[]{66, 67, -123, 68, 69};
        byte[] targetData = new byte[]{66, 67, 0, 0, 0};
        byte[] resData = new byte[5];
        ArrayList<byte[]> list = new ArrayList<byte[]>(1);
        list.add(data);
        this.combiner = new ByteArrayCombinerStream(list, (long)data.length);
        int index = 0;
        while ((b = (byte)this.combiner.read()) > 0) {
            resData[index++] = b;
        }
        ByteArrayCombinerStreamTest.assertTrue((boolean)Arrays.equals(targetData, resData));
        ByteArrayCombinerStreamTest.assertEquals((byte)data[3], (byte)((byte)this.combiner.read()));
        ByteArrayCombinerStreamTest.assertEquals((byte)data[4], (byte)((byte)this.combiner.read()));
        ByteArrayCombinerStreamTest.assertEquals((int)-1, (int)((byte)this.combiner.read()));
    }

    public static Test suite() {
        return new TestSuite(ByteArrayCombinerStreamTest.class, "ByteArrayCombinerStreamTest");
    }
}

