/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BadConnectionTest
extends BaseJDBCTestCase {
    public void setUp() throws SQLException {
        this.getConnection().close();
    }

    public void testNoUserOrPassword() {
        try {
            Connection connection = DriverManager.getConnection("jdbc:gemfirexd://" + this.getTestConfiguration().getHostName() + ":" + this.getTestConfiguration().getPort() + "/gemfirexd");
        }
        catch (SQLException e) {
            BadConnectionTest.assertSQLState("08004", e);
            BadConnectionTest.assertEquals((int)40000, (int)e.getErrorCode());
        }
    }

    public void DISABLED_testDatabaseNotFound() {
        try {
            Properties p = new Properties();
            p.put("user", "admin");
            p.put("password", "admin");
            Connection c = DriverManager.getConnection("jdbc:gemfirexd://" + this.getTestConfiguration().getHostName() + ":" + this.getTestConfiguration().getPort() + "/testbase", p);
            BadConnectionTest.fail((String)"Connection with no database succeeded");
        }
        catch (SQLException e) {
            BadConnectionTest.assertSQLState("08004", e);
            BadConnectionTest.assertEquals((int)40000, (int)e.getErrorCode());
        }
    }

    public void testBadConnectionAttribute() {
        try {
            Connection c = DriverManager.getConnection("jdbc:gemfirexd://" + this.getTestConfiguration().getHostName() + ":" + this.getTestConfiguration().getPort() + "/badAttribute;upgrade=notValidValue");
            BadConnectionTest.fail((String)"Connection with bad atttributes succeeded");
        }
        catch (SQLException e) {
            BadConnectionTest.assertSQLState("XJ028", e);
            BadConnectionTest.assertEquals((int)40000, (int)e.getErrorCode());
        }
    }

    public BadConnectionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return TestConfiguration.clientServerSuite(BadConnectionTest.class);
    }
}

