/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.testData.serializedDataSources;

import com.pivotal.gemfirexd.internal.tools.sysinfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

public class SerializeDataSources {
    private static final String[] KNOWN_EMBEDDED_DATA_SOURCES = new String[]{"com.pivotal.gemfirexd.internal.jdbc.EmbeddedDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedConnectionPoolDataSource", "com.pivotal.gemfirexd.internal.jdbc.EmbeddedXADataSource"};
    private static final String[] KNOWN_CLIENT_DATA_SOURCES = new String[]{"com.pivotal.gemfirexd.internal.jdbc.ClientDataSource", "com.pivotal.gemfirexd.internal.jdbc.ClientConnectionPoolDataSource", "com.pivotal.gemfirexd.internal.jdbc.ClientXADataSource"};

    private static int serializeDataSources(String versionString, String buildNumber, String[] dataSourceClasses) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, NamingException {
        String modifiedVersionString = versionString.replaceAll("\\.", "_");
        int dsCount = 0;
        for (String dsClassName : dataSourceClasses) {
            Class<?> dsClass;
            try {
                dsClass = Class.forName(dsClassName);
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("\tcouldn't load " + dsClassName);
                continue;
            }
            DataSource ds = (DataSource)dsClass.newInstance();
            File serialized = new File(dsClass.getSimpleName() + "-" + modifiedVersionString + ".ser");
            System.out.println("\twriting " + serialized.getName());
            FileOutputStream os = new FileOutputStream(serialized);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeUTF(versionString);
            oos.writeUTF(buildNumber);
            oos.writeObject(ds);
            Reference dsRef = ((Referenceable)((Object)ds)).getReference();
            oos.writeObject(dsRef);
            oos.flush();
            oos.close();
            ++dsCount;
        }
        return dsCount;
    }

    private static boolean printInfoFromSerializedFile(String fileName) {
        System.out.println(">>> File: " + fileName);
        File file = new File(fileName);
        if (!file.exists()) {
            System.out.println("\tFile does not exist.");
            return false;
        }
        if (!file.canRead()) {
            System.out.println("\tCannot read file.");
            return false;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(is);
            String version = ois.readUTF();
            System.out.println("\tversion: " + version);
            String buildNr = ois.readUTF();
            System.out.println("\tbuild  : " + buildNr);
            Object obj = ois.readObject();
            System.out.println("\tobject : " + obj);
            obj = ois.readObject();
            System.out.println("\tobject : " + obj);
        }
        catch (Exception e) {
            System.out.println("\t!! De-serialization failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        int majorVersionEmbedded = sysinfo.getMajorVersion((String)"DBMS");
        int minorVersionEmbedded = sysinfo.getMinorVersion((String)"DBMS");
        String buildNumberEmbedded = sysinfo.getBuildNumber((String)"DBMS");
        String versionEmbedded = sysinfo.getVersionString((String)"DBMS");
        int majorVersionClient = sysinfo.getMajorVersion((String)"dnc");
        int minorVersionClient = sysinfo.getMinorVersion((String)"dnc");
        String buildNumberClient = sysinfo.getBuildNumber((String)"dnc");
        String versionClient = sysinfo.getVersionString((String)"dnc");
        if (args.length > 0) {
            System.out.println("Reading files with the Derby version(s):");
            System.out.println("\tembedded: " + versionEmbedded);
            System.out.println("\tclient  : " + versionClient);
            System.out.println();
            for (int i = 0; i < args.length; ++i) {
                boolean status = SerializeDataSources.printInfoFromSerializedFile(args[i]);
                System.out.println("File read successfully: " + status);
                System.out.println();
            }
            System.exit(0);
        }
        int knownDsCount = KNOWN_EMBEDDED_DATA_SOURCES.length + KNOWN_CLIENT_DATA_SOURCES.length;
        int dsWritten = 0;
        if (majorVersionEmbedded != -1 && minorVersionEmbedded != -1) {
            System.out.println("Serializing embedded data sources for Derby version " + versionEmbedded);
            dsWritten += SerializeDataSources.serializeDataSources(versionEmbedded, buildNumberEmbedded, KNOWN_EMBEDDED_DATA_SOURCES);
        } else {
            System.err.println("No embedded data sources will be generated because Derby version can't be determined.");
        }
        if (majorVersionClient != -1 && minorVersionClient != -1) {
            System.out.println("Serializing client data sources for Derby version " + versionClient);
            dsWritten += SerializeDataSources.serializeDataSources(versionClient, buildNumberClient, KNOWN_CLIENT_DATA_SOURCES);
        } else {
            System.err.println("No client data sources will be generated because Derby version can't be determined.");
        }
        System.out.println();
        System.out.println("Known data sources:   " + knownDsCount);
        System.out.println("Data sources written: " + dsWritten);
    }
}

