/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import com.pivotal.gemfirexd.internal.tools.JDBCDisplayUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class dbcleanup {
    static String dbURL = "jdbc:derby:wombat";
    static String driver = "com.pivotal.gemfirexd.jdbc.EmbeddedDriver";
    static boolean dbIsDirty = false;
    int thread_id;
    int ind = 0;

    public static void main(String[] args) throws SQLException, IOException, InterruptedException, Exception {
        dbcleanup.doit(true);
    }

    public static void doit(boolean dbIsNew) throws SQLException, IOException, InterruptedException, Exception {
        Connection conn = null;
        Statement s = null;
        ResultSet rs = null;
        boolean finished = false;
        Date d = new Date();
        Properties dbclProps = System.getProperties();
        String systemHome = dbclProps.getProperty("user.dir") + File.separatorChar + "testCSHome";
        dbclProps.put("gemfirexd.system.home", systemHome);
        System.setProperties(dbclProps);
        boolean useprocess = true;
        String up = dbclProps.getProperty("useprocess");
        if (up != null && up.equals("false")) {
            useprocess = false;
        }
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        Class.forName(driver).newInstance();
        if (dbIsNew) {
            try {
                conn = DriverManager.getConnection(dbURL + ";create=true");
                conn.setAutoCommit(false);
                System.out.println("created " + dbURL + " " + d);
            }
            catch (SQLException se) {
                System.out.println("connect failed for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                System.exit(1);
            }
        } else {
            try {
                conn = DriverManager.getConnection(dbURL);
                conn.setAutoCommit(false);
                System.out.println("connected to " + dbURL + " " + d);
            }
            catch (SQLException se) {
                System.out.println("connect failed for " + dbURL);
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                System.exit(1);
            }
        }
        d = new Date();
        System.out.println("dbcleanup starting: " + d);
        Enumeration schemalist = null;
        Enumeration list = null;
        Vector<String> schemavec = new Vector<String>();
        Vector tablevec = null;
        try {
            s = conn.createStatement();
            rs = s.executeQuery(" select schemaname from sys.sysschemas  where schemaname <> 'SYS'");
            while (rs.next()) {
                schemavec.addElement(new String(rs.getString(1)));
            }
            rs.close();
            if (schemavec.size() > 1) {
                dbIsDirty = true;
            }
        }
        catch (SQLException se) {
            System.out.println("select schemas: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            System.exit(1);
        }
        String schema = null;
        String n = null;
        boolean viewdependencyFound = false;
        boolean tabledependencyFound = false;
        Vector viewvec = null;
        int count = 0;
        schemalist = schemavec.elements();
        while (schemalist.hasMoreElements()) {
            schema = (String)schemalist.nextElement();
            viewdependencyFound = true;
            while (viewdependencyFound) {
                viewdependencyFound = false;
                viewvec = dbcleanup.findTables(conn, s, 'V', schema);
                if (viewvec.size() <= 0) continue;
                System.out.println("schema " + schema);
                viewdependencyFound = dbcleanup.dropTables(conn, s, viewvec, "view");
            }
            tabledependencyFound = true;
            while (tabledependencyFound) {
                tabledependencyFound = false;
                tablevec = dbcleanup.findTables(conn, s, 'T', schema);
                if (tablevec.size() <= 0) continue;
                System.out.println("schema " + schema);
                tabledependencyFound = dbcleanup.dropTables(conn, s, tablevec, "table");
            }
            Vector<String> stmtvec = new Vector<String>();
            try {
                rs = s.executeQuery(" select stmtname  from sys.sysstatements t, sys.sysschemas  s  where t.schemaid = s.schemaid  and s.schemaname = '" + schema + "'");
                count = 0;
                while (rs.next()) {
                    dbIsDirty = true;
                    stmtvec.addElement(new String(rs.getString(1)));
                    ++count;
                }
                rs.close();
            }
            catch (SQLException se) {
                System.out.println("select statements: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                System.exit(1);
            }
            if (count <= true) continue;
            try {
                System.out.println("schema " + schema);
                System.out.println("dropping leftover statements: ");
                list = stmtvec.elements();
                while (list.hasMoreElements()) {
                    n = (String)list.nextElement();
                    s.execute("drop statement " + n);
                    conn.commit();
                    System.out.println("\t" + n);
                }
            }
            catch (SQLException se) {
                System.out.println("drop statement: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                System.exit(1);
            }
        }
        if (schemavec.size() > 1) {
            System.out.println("dropping extra user schemas: ");
            schemalist = null;
            schemalist = schemavec.elements();
            while (schemalist.hasMoreElements()) {
                schema = (String)schemalist.nextElement();
                if (schema.equals("APP")) continue;
                if (schema == null) {
                    System.out.println("null schema in schemalist");
                    continue;
                }
                try {
                    System.out.println("\t" + schema);
                    s.execute("drop schema \"" + schema + "\"");
                }
                catch (SQLException se) {
                    System.out.println("drop schema: FAIL -- unexpected exception:");
                    JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                    System.exit(1);
                }
            }
        }
        dbcleanup.dropAliases(conn, 'M');
        dbcleanup.dropAliases(conn, 'C');
        try {
            int i;
            rs = s.executeQuery("select count (*) from sys.sysdepends");
            if (rs.next() && (i = rs.getInt(1)) > 0) {
                System.out.println("found " + i + " leftover dependencies");
            }
        }
        catch (SQLException se) {
            System.out.println("drop schema: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            System.exit(1);
        }
        if (useprocess) {
            dbcleanup.doshutdown();
        }
        d = new Date();
        System.out.println("dbcleanup finished: " + d);
    }

    static void doshutdown() {
        Connection conn = null;
        try {
            conn = DriverManager.getConnection(dbURL + ";shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("08006")) {
                System.out.println("shutting down " + dbURL);
            }
            System.out.println("shutdown failed for " + dbURL);
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            System.exit(1);
        }
    }

    static boolean dropTables(Connection conn, Statement s, Vector tablevec, String tabletype) throws Exception {
        boolean dependencyFound = false;
        String n = null;
        Object objtype = null;
        System.out.println("dropping " + tabletype + "(s)");
        Enumeration list = tablevec.elements();
        while (list.hasMoreElements()) {
            n = (String)list.nextElement();
            try {
                s.execute("drop " + tabletype + " " + n);
                conn.commit();
                System.out.println("\t" + n);
            }
            catch (SQLException se) {
                if (se.getSQLState().equals("X0Y25")) {
                    dependencyFound = true;
                    System.out.println(n + " not droped due to dependency, will retry a bit later");
                    continue;
                }
                if (se.getSQLState().equals("X0Y23")) {
                    dependencyFound = true;
                    System.out.println(n + " not droped due to dependency, will retry a bit later");
                    continue;
                }
                System.out.println("drop table: FAIL -- unexpected exception:");
                JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                System.exit(1);
            }
        }
        return dependencyFound;
    }

    static Vector findTables(Connection conn, Statement s, char c, String schema) throws Exception {
        ResultSet rs = null;
        Vector<String> tableviewvec = new Vector<String>();
        try {
            rs = s.executeQuery(" select t.tablename  from sys.systables t, sys.sysschemas  s  where t.schemaid = s.schemaid  and t.tabletype = '" + c + "'" + " and s.schemaname = '" + schema + "'");
            while (rs.next()) {
                dbIsDirty = true;
                tableviewvec.addElement(new String(rs.getString(1)));
            }
            rs.close();
        }
        catch (SQLException se) {
            System.out.println("select tables: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            System.exit(1);
        }
        return tableviewvec;
    }

    static void dropAliases(Connection conn, char aliastype) throws Exception {
        ResultSet rs = null;
        Statement s = null;
        String typestring = null;
        Vector<String> aliasvec = new Vector<String>();
        String n = null;
        int count = 0;
        if (aliastype == 'M') {
            typestring = "method";
        } else if (aliastype == 'C') {
            typestring = "class";
        }
        try {
            s = conn.createStatement();
            rs = s.executeQuery("select alias, aliastype from sys.sysaliases  where systemalias = false  and aliastype = '" + aliastype + "'");
            count = 0;
            while (rs.next()) {
                dbIsDirty = true;
                aliasvec.addElement(new String(rs.getString(1)));
                ++count;
            }
            rs.close();
            conn.commit();
        }
        catch (SQLException se) {
            System.out.println("drop alias: FAIL -- unexpected exception:");
            JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
            System.exit(1);
        }
        if (count > 1) {
            System.out.println("dropping user aliases, type " + typestring + ": ");
            Enumeration list = aliasvec.elements();
            while (list.hasMoreElements()) {
                n = (String)list.nextElement();
                try {
                    s.execute("drop " + typestring + " alias " + n);
                }
                catch (SQLException se) {
                    System.out.println("drop alias: FAIL -- unexpected exception:");
                    JDBCDisplayUtil.ShowException((PrintStream)System.out, (Throwable)se);
                    System.exit(1);
                }
                conn.commit();
                System.out.println("\t" + n);
            }
        }
    }
}

