/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derbyTesting.functionTests.util.TestUtil;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.StringSubstitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class Sed {
    private static final String SQL_EXCEPTION_FILTERED_SUBSTITUTION = "java.sql.SQLException:";

    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 2) {
            System.err.println("Usage: Sed sourcefile targetfile");
            System.exit(1);
        }
        File src = new File(args[0]);
        File tgt = new File(args[1]);
        new Sed().exec(src, tgt, null, false, false, false);
    }

    public void exec(File srcFile, File dstFile, InputStream isSed, boolean isJCC, boolean isI18N, boolean isJDBC4) throws IOException {
        String hostName = TestUtil.getHostName();
        Vector<String> deleteLines = new Vector<String>();
        deleteLines.addElement("^gfxd version.*$");
        deleteLines.addElement("^\\*\\*\\*\\* Test Run Started .* \\*\\*\\*\\*$");
        deleteLines.addElement("^\\*\\*\\*\\* Test Run Completed .* \\*\\*\\*\\*$");
        deleteLines.addElement("^ELAPSED TIME = [0-9]* milliseconds$");
        deleteLines.addElement("^\\^\\?$");
        deleteLines.addElement("^S.*gfxd> $");
        deleteLines.addElement("^ *$");
        deleteLines.addElement("^Server StackTrace:$");
        deleteLines.addElement("^\\[ *$");
        deleteLines.addElement("^\\] *$");
        deleteLines.addElement("^\\[$");
        deleteLines.addElement("^\\]$");
        deleteLines.addElement("^<not available>\\]$");
        deleteLines.addElement("^(.*at .*)\\(.*:[0-9].*\\)$");
        deleteLines.addElement("^(.*at .*)\\(*.java\\)$");
        deleteLines.addElement("^(.*at .*)\\(Compiled Code\\)$");
        deleteLines.addElement("^(.*at .*)\\(Interpreted Code\\)$");
        deleteLines.addElement("^(.*at .*)\\(Unknown Source\\)$");
        deleteLines.addElement("^(.*at .*)\\(Native Method\\)$");
        deleteLines.addElement("^\\tat $");
        deleteLines.addElement("optimizer estimated cost");
        deleteLines.addElement("optimizer estimated row count");
        deleteLines.addElement("Using executables built for native_threads");
        deleteLines.addElement("Estimate of memory used");
        deleteLines.addElement("Size of merge runs");
        deleteLines.addElement("Number of merge runs");
        deleteLines.addElement("Sort type");
        deleteLines.addElement("Optimization started at .*$");
        deleteLines.addElement("WARNING 02000: No row was found for FETCH, UPDATE or DELETE");
        deleteLines.addElement("Stack trace:");
        deleteLines.addElement("^.*java/.*\\<init\\>\\(.*\\)V");
        deleteLines.addElement("^.*com/pivotal/gemfirexd/internal/.*\\(.*\\).*$");
        deleteLines.addElement("^.*java/.*\\(.*\\).*$");
        deleteLines.addElement("^\\[.*db2jcc.jar\\] [0-9].[1-9] - .*$");
        deleteLines.addElement("^\\[.*db2jcc_license_c.jar\\] [1-9].[0-9] - .*$");
        deleteLines.addElement("^XSDB.*$");
        deleteLines.addElement("^\\.*$");
        deleteLines.addElement("^Time: [0-9].*$");
        deleteLines.addElement("^OK \\(.*$");
        Vector<String> searchStrings = new Vector<String>();
        searchStrings.addElement("^Transaction:\\(.*\\) *\\|");
        searchStrings.addElement("^Read [0-9]* of [0-9]* bytes$");
        searchStrings.addElement("Directory .*connect.wombat.seg0");
        StringBuilder constraintNameFilter = new StringBuilder();
        constraintNameFilter.append("SQL[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]");
        searchStrings.addElement(constraintNameFilter.toString());
        StringBuilder uuidFilter = new StringBuilder();
        uuidFilter.append("[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]-");
        uuidFilter.append("[0-9a-f][0-9a-f][0-9a-f][0-9a-f]-");
        uuidFilter.append("[0-9a-f][0-9a-f][0-9a-f][0-9a-f]-");
        uuidFilter.append("[0-9a-f][0-9a-f][0-9a-f][0-9a-f]-");
        uuidFilter.append("[0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f][0-9a-f]");
        searchStrings.addElement(uuidFilter.toString());
        StringBuilder timestampFilter = new StringBuilder();
        timestampFilter.append("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] ");
        timestampFilter.append("[0-9][0-9]:[0-9][0-9]:[0-9][0-9].[0-9]* *");
        searchStrings.addElement(timestampFilter.toString());
        timestampFilter = new StringBuilder();
        timestampFilter.append("[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] ");
        timestampFilter.append("[0-9][0-9]:[0-9][0-9]:[0-9][0-9].[0-9]* *");
        searchStrings.addElement(timestampFilter.toString());
        timestampFilter = new StringBuilder();
        timestampFilter.append("[0-9]-[0-9][0-9]-[0-9][0-9] ");
        timestampFilter.append("[0-9][0-9]:[0-9][0-9]:[0-9][0-9].[0-9]* *");
        searchStrings.addElement(timestampFilter.toString());
        searchStrings.addElement("^  Waiting XID : {.*}");
        searchStrings.addElement("^  Granted XID : .*$");
        searchStrings.addElement("^The selected victim is XID : .*");
        searchStrings.addElement("(beta - )\\(([0-9]*)\\)");
        searchStrings.addElement("Level2CostEstimateImpl: .*");
        searchStrings.addElement("^Transaction ([0-9])* : \\(([0-9]*)\\,([0-9a-f]*)\\,([0-9a-f]*)\\)");
        searchStrings.addElement("^Modifying access paths using optimizer .[0-9]*");
        searchStrings.addElement("CDWS[0-9]*");
        searchStrings.addElement("IXWS[0-9]*");
        searchStrings.addElement("FAILED STACK MAP");
        if (isJCC) {
            searchStrings.addElement("[ ]*\\|");
            searchStrings.addElement("^--*");
        }
        searchStrings.addElement("Directory.*.wombat.already.exists");
        searchStrings.addElement("Directory.*.extinout/crwombatlog/log.*.exists");
        searchStrings.addElement("  DB2ConnectionCorrelator: [0-9A-Z.]*");
        searchStrings.addElement("org.xml.sax.SAX.*$");
        searchStrings.addElement(hostName);
        if (isJDBC4) {
            searchStrings.addElement("java.sql.SQLDataException:");
            searchStrings.addElement("java.sql.SQLDataSetSyncException:");
            searchStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            searchStrings.addElement("java.sql.SQLFeatureNotSupportedException:");
            searchStrings.addElement("java.sql.SQLIntegrityConstraintViolationException:");
            searchStrings.addElement("java.sql.SQLInvalidAuthorizationSpecException:");
            searchStrings.addElement("java.sql.SQLNonTransientConnectionException:");
            searchStrings.addElement("java.sql.SQLNonTransientException:");
            searchStrings.addElement("java.sql.SQLRuntimeException:");
            searchStrings.addElement("java.sql.SQLSyntaxErrorException:");
            searchStrings.addElement("java.sql.SQLTimeoutException:");
            searchStrings.addElement("java.sql.SQLTransactionRollbackException:");
            searchStrings.addElement("java.sql.SQLTransientConnectionException:");
            searchStrings.addElement("java.sql.SQLTransientException:");
            searchStrings.addElement("No suitable driver found for [0-9A-Za-z:]*");
            searchStrings.addElement("No suitable driver;[0-9A-Za-z:=]*");
            searchStrings.addElement("SQL Exception: No suitable driver");
            searchStrings.addElement("\\[\\.fffffffff\\]");
        }
        Vector<String> subStrings = new Vector<String>();
        subStrings.addElement("Transaction:(XXX)|");
        subStrings.addElement("Read ... bytes");
        subStrings.addElement("Directory DBLOCATION/seg0");
        subStrings.addElement("xxxxGENERATED-IDxxxx");
        subStrings.addElement("xxxxFILTERED-UUIDxxxx");
        subStrings.addElement("xxxxxxFILTERED-TIMESTAMPxxxxx");
        subStrings.addElement("xxxxxxFILTERED-TIMESTAMPxxxxx");
        subStrings.addElement("xxxxxxFILTERED-TIMESTAMPxxxxx");
        subStrings.addElement("  Waiting XID : {WWW,QQQ}");
        subStrings.addElement("  Granted XID : {GGG.QQQ}...");
        subStrings.addElement("The selected victim is XID : VVV");
        subStrings.addElement("$1(xxXXxxFILTERED-BUILD-NUMBERxxXXxx)");
        subStrings.addElement("Level2CostEstimateImpl: xxXXxxFILTERED-INFORMATIONxxXXxx");
        subStrings.addElement("Transaction $1 : ($2,FILTERED,FILTERED)");
        subStrings.addElement("Modifying access paths using optimizer FILTERED_NUMBER");
        subStrings.addElement("CDWSno");
        subStrings.addElement("IXWSno");
        subStrings.addElement("");
        if (isJCC) {
            subStrings.addElement(" |");
            subStrings.addElement("-----");
        }
        subStrings.addElement("Directory DBLOCATION/wombat already exists");
        subStrings.addElement("Directory 'extinout<sp>crwombatlog<sp>log' exists");
        subStrings.addElement("");
        subStrings.addElement("xxxFILTERED-SAX-EXCEPTIONxxx'.");
        subStrings.addElement("xxxFILTERED_HOSTNAMExxx");
        if (isJDBC4) {
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement(SQL_EXCEPTION_FILTERED_SUBSTITUTION);
            subStrings.addElement("No suitable driver");
            subStrings.addElement("No suitable driver");
            subStrings.addElement("java.sql.SQLException: No suitable driver");
            subStrings.addElement(".fffffffff");
        }
        this.doWork(srcFile, dstFile, null, deleteLines, searchStrings, subStrings, isSed, isI18N);
    }

    public void execJCC(InputStream is, File dstFile) throws IOException {
        Vector deleteLines = new Vector();
        Vector<String> searchStrings = new Vector<String>();
        searchStrings.addElement("[ ]*\\|");
        searchStrings.addElement("^--*");
        Vector<String> subStrings = new Vector<String>();
        subStrings.addElement(" |");
        subStrings.addElement("-----");
        this.doWork(null, dstFile, is, deleteLines, searchStrings, subStrings, null);
    }

    private void doWork(File srcFile, File dstFile, InputStream is, Vector deleteLines, Vector searchStrings, Vector subStrings, InputStream isSed) throws IOException {
        this.doWork(srcFile, dstFile, is, deleteLines, searchStrings, subStrings, isSed, false);
    }

    private void doWork(File srcFile, File dstFile, InputStream is, Vector deleteLines, Vector searchStrings, Vector subStrings, InputStream isSed, boolean isI18N) throws IOException {
        String str;
        Pattern pattern;
        String regex;
        int i;
        BufferedReader inFile;
        boolean lineDeleted = false;
        String result = "";
        Vector<Pattern> delPatternVector = new Vector<Pattern>();
        Vector<Pattern> subPatternVector = new Vector<Pattern>();
        if (isSed != null) {
            Properties sedp = new Properties();
            sedp.load(isSed);
            Enumeration<?> e = sedp.propertyNames();
            while (e.hasMoreElements()) {
                String patternName;
                StringTokenizer st;
                String value;
                String key = (String)e.nextElement();
                if (key.equals("substitute")) {
                    value = sedp.getProperty(key);
                    st = new StringTokenizer(value, ",");
                    patternName = "";
                    String patName = "";
                    String subName = "";
                    while (st.hasMoreTokens()) {
                        patternName = st.nextToken();
                        StringTokenizer st2 = new StringTokenizer(patternName, ";");
                        patName = st2.nextToken();
                        subName = st2.nextToken();
                        if (patName.equals("") || subName.equals("")) continue;
                        searchStrings.addElement(patName);
                        subStrings.addElement(subName);
                    }
                    continue;
                }
                if (!key.equals("delete")) continue;
                value = sedp.getProperty(key);
                st = new StringTokenizer(value, ",");
                patternName = "";
                while (st.hasMoreTokens()) {
                    patternName = st.nextToken();
                    deleteLines.addElement(patternName);
                }
            }
        }
        Perl5Compiler pcompiler = new Perl5Compiler();
        Perl5Matcher matcher = new Perl5Matcher();
        if (is == null && isI18N) {
            FileInputStream fs = new FileInputStream(srcFile);
            inFile = new BufferedReader(new InputStreamReader((InputStream)fs, "UTF-8"));
        } else {
            inFile = is == null ? new BufferedReader(new FileReader(srcFile)) : new BufferedReader(new InputStreamReader(is, "UTF-8"));
        }
        PrintWriter outFile = new PrintWriter((Writer)new BufferedWriter(new FileWriter(dstFile), 10000), true);
        for (i = 0; i < deleteLines.size(); ++i) {
            try {
                regex = (String)deleteLines.elementAt(i);
                pattern = pcompiler.compile(regex);
                if (pattern == null) {
                    System.out.println("pattern is null");
                }
                delPatternVector.addElement(pattern);
                continue;
            }
            catch (MalformedPatternException e) {
                System.out.println("Bad pattern.");
                System.out.println(e.getMessage());
            }
        }
        for (i = 0; i < searchStrings.size(); ++i) {
            try {
                regex = (String)searchStrings.elementAt(i);
                pattern = pcompiler.compile(regex);
                if (pattern == null) {
                    System.out.println("pattern is null");
                }
                subPatternVector.addElement(pattern);
                continue;
            }
            catch (MalformedPatternException e) {
                System.out.println("Bad pattern.");
                System.out.println(e.getMessage());
            }
        }
        int lineCount = 0;
        while ((str = inFile.readLine()) != null) {
            ++lineCount;
            lineDeleted = false;
            if (str.length() == 1 && str.charAt(0) == '\u0000') {
                lineDeleted = true;
            }
            if (isI18N) {
                boolean hasNonAscii = false;
                for (int si = 0; si < str.length(); ++si) {
                    char c = str.charAt(si);
                    if (c >= ' ' && c < '\u007f') continue;
                    hasNonAscii = true;
                    break;
                }
                if (hasNonAscii) {
                    StringBuilder sb = new StringBuilder();
                    for (int si = 0; si < str.length(); ++si) {
                        char c = str.charAt(si);
                        if (c < ' ' || c >= '\u007f') {
                            sb.append(' ');
                            sb.append("EnC:>");
                            sb.append((int)str.charAt(si));
                            sb.append("< ");
                            continue;
                        }
                        sb.append(c);
                    }
                    str = sb.toString();
                }
            }
            if (!lineDeleted) {
                for (int j = 0; j < delPatternVector.size(); ++j) {
                    if (!matcher.contains(str, (Pattern)delPatternVector.elementAt(j))) continue;
                    String tmpp = ((Pattern)delPatternVector.elementAt(j)).getPattern();
                    lineDeleted = true;
                    break;
                }
            }
            if (lineDeleted) continue;
            StringSubstitution strsub = new StringSubstitution("");
            Perl5Substitution perlsub = new Perl5Substitution("");
            boolean subDone = false;
            for (int j = 0; j < subPatternVector.size(); ++j) {
                Perl5Substitution substitution;
                PatternMatcherInput input = new PatternMatcherInput(str);
                Pattern patt = (Pattern)subPatternVector.elementAt(j);
                String pstr = patt.getPattern();
                String sub = (String)subStrings.elementAt(j);
                if (sub.indexOf("$") > 0) {
                    perlsub.setSubstitution(sub);
                    substitution = perlsub;
                } else {
                    strsub.setSubstitution(sub);
                    substitution = strsub;
                }
                if (!matcher.contains(input, patt)) continue;
                MatchResult mr = matcher.getMatch();
                str = result = Util.substitute((PatternMatcher)matcher, (Pattern)patt, (Substitution)substitution, (String)str, (int)-1);
                subDone = true;
            }
            if (subDone) {
                outFile.println(result);
                continue;
            }
            outFile.println(str);
            outFile.flush();
        }
        inFile.close();
        outFile.flush();
        outFile.close();
    }
}

