/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.harness.CopySuppFiles;
import org.apache.derbyTesting.functionTests.harness.CurrentTime;
import org.apache.derbyTesting.functionTests.harness.FileCompare;
import org.apache.derbyTesting.functionTests.harness.JavaVersionHolder;
import org.apache.derbyTesting.functionTests.harness.MultiTest;
import org.apache.derbyTesting.functionTests.harness.NetServer;
import org.apache.derbyTesting.functionTests.harness.ProcessStreamResult;
import org.apache.derbyTesting.functionTests.harness.RunClass;
import org.apache.derbyTesting.functionTests.harness.RunIJ;
import org.apache.derbyTesting.functionTests.harness.RunList;
import org.apache.derbyTesting.functionTests.harness.Sed;
import org.apache.derbyTesting.functionTests.harness.SkipTest;
import org.apache.derbyTesting.functionTests.harness.SpecialFlags;
import org.apache.derbyTesting.functionTests.harness.SysInfoLog;
import org.apache.derbyTesting.functionTests.harness.TimedProcess;
import org.apache.derbyTesting.functionTests.harness.UnJar;
import org.apache.derbyTesting.functionTests.harness.dbcleanup;
import org.apache.derbyTesting.functionTests.harness.jvm;
import org.apache.derbyTesting.functionTests.harness.shutdown;

public class RunTest {
    static boolean verbose = false;
    static boolean skiptest = false;
    static StringBuilder skiptestReason = new StringBuilder();
    static final String testResourceHome = "/org/apache/derbyTesting/functionTests/";
    static String[] validFrameworks = new String[]{"embedded", "", "DerbyNet", "DerbyNetClient", "DB2jcc", "DB2app"};
    static NetServer ns;
    static boolean serverNeedsStopping;
    static boolean jvmnet;
    static String jvmnetjvm;
    static String driverName;
    static String dbName;
    static String jvmName;
    static String javaCmd;
    static String javaVersion;
    static String majorVersion;
    static String minorVersion;
    static int jccMajor;
    static int jccMinor;
    static int imajor;
    static int iminor;
    static boolean isjdk12test;
    static String classpath;
    static String classpathServer;
    public static String framework;
    public static String J9_STATEMENTCACHESIZE;
    static String usesystem;
    static String searchCP;
    static boolean useCommonDB;
    static boolean keepfiles;
    static boolean useprocess;
    static boolean systemdiff;
    static boolean upgradetest;
    static boolean encryption;
    static boolean jdk12exttest;
    static boolean generateUTF8Out;
    static String runningdir;
    static String outputdir;
    static String canondir;
    static String bootcp;
    static String canonpath;
    static String mtestdir;
    static String testSpecialProps;
    static String testJavaFlags;
    static String jvmflags;
    static boolean reportstderr;
    static int timeout;
    public static String timeoutStr;
    static String jarfile;
    static boolean skipsed;
    static String commonDBHome;
    static boolean dbIsNew;
    static String runwithjvm;
    static boolean startServer;
    static String hostName;
    static String testEncoding;
    static String upgradejarpath;
    static boolean replacePolicyFile;
    static String scriptName;
    static String scriptFileName;
    static String testDirName;
    static String defaultPackageName;
    static String javaPath;
    static String testType;
    static String testBase;
    static String testOutName;
    static String passFileName;
    static String failFileName;
    static String UTF8OutName;
    static String tempMasterName;
    static File passFile;
    static File failFile;
    static String shutdownurl;
    static boolean useOutput;
    static boolean outcopy;
    static String userdir;
    static char fileSep;
    static PrintWriter printWriter;
    static PrintWriter pwDiff;
    static File script;
    static File baseDir;
    static boolean deleteBaseDir;
    static File outDir;
    static File runDir;
    static File canonDir;
    static File tmpOutFile;
    static File tempMasterFile;
    static File stdOutFile;
    static File finalOutFile;
    static File UTF8OutFile;
    static File appPropFile;
    static File clPropFile;
    static File diffFile;
    static File tsuiteDir;
    static File rsuiteDir;
    static File extInDir;
    static File extOutDir;
    static File extInOutDir;
    static String topsuitedir;
    static String topsuiteName;
    static String topreportdir;
    static String suiteName;
    static boolean isSuiteRun;
    static boolean lastTestFailed;
    static boolean isI18N;
    static String codeset;
    static boolean junitXASingle;
    static boolean runWithoutSecurityManager;
    static InputStream isSed;

    public static void main(String[] args) throws Exception {
        boolean status;
        String outName;
        block38: {
            System.setProperty(GfxdConstants.GFXD_LOG_FILE, "gemfirexd.log");
            System.setProperty("jline.terminal", "scala.tools.jline.UnsupportedTerminal");
            Locale.setDefault(Locale.US);
            skiptestReason.setLength(0);
            if (args.length == 0) {
                System.out.println("no test name provided");
                System.exit(1);
            }
            scriptName = args[0];
            if (Boolean.getBoolean("listOnly")) {
                System.out.println("LISTONLY :" + scriptName);
                return;
            }
            if (scriptName == null || scriptName.equals("")) {
                System.out.println("Null or blank test script name.");
                System.exit(1);
            }
            if (args.length == 7) {
                defaultPackageName = args[1];
                usesystem = args[2];
                useprocess = false;
                shutdownurl = args[4];
                isSuiteRun = true;
                suiteName = args[5];
                framework = args[6];
                startServer = true;
            }
            testType = scriptName.substring(scriptName.lastIndexOf(".") + 1);
            RunTest.verifyTestType();
            Properties sp = System.getProperties();
            if (!useprocess) {
                sp.put("useprocess", "false");
                if (sp.getProperty("maximumDisplayWidth") == null) {
                    sp.put("maximumDisplayWidth", "128");
                }
                if (sp.getProperty("ij.defaultResourcePackage") != null) {
                    sp.put("ij.defaultResourcePackage", defaultPackageName);
                }
                System.setProperties(sp);
            }
            JavaVersionHolder jvhs = RunTest.getProperties(sp);
            boolean isJDBC4 = jvhs.atLeast(1, 6);
            RunTest.setDirectories(scriptName, sp);
            if (testDirName.startsWith("i18n")) {
                isI18N = true;
            }
            String propString = RunTest.createPropString();
            if (!isSuiteRun && useprocess) {
                SysInfoLog sysLog = new SysInfoLog();
                sysLog.exec(jvmName, javaCmd, classpath, framework, pwDiff, useprocess);
            }
            String startTime = CurrentTime.getTime();
            StringBuilder sb = new StringBuilder();
            sb.append("*** Start: " + testBase + " jdk" + javaVersion + " ");
            if (framework.length() > 0 && !framework.startsWith("embedded")) {
                sb.append(framework + " ");
            }
            if (suiteName != null && suiteName.length() > 0) {
                sb.append(suiteName + " ");
            }
            sb.append(startTime + " ***");
            System.out.println(sb.toString());
            pwDiff.println(sb.toString());
            if (driverName != null && !skiptest) {
                RunTest.composePolicyFile();
                String spacedJvmFlags = jvmflags;
                if (jvmflags != null && jvmflags.indexOf("^") > 0) {
                    spacedJvmFlags = RunTest.spaceJvmFlags(jvmflags);
                }
                System.out.println("Initialize for framework: " + framework);
                if (jvmnet && framework.startsWith("DerbyNet")) {
                    String jvmnetjvm = System.getProperty("serverJvmName");
                    if (jvmnetjvm == null) {
                        jvmnetjvm = "j9_22";
                    }
                    ns = new NetServer(baseDir, jvmnetjvm, classpathServer, null, spacedJvmFlags, framework, startServer);
                } else {
                    ns = new NetServer(baseDir, jvmName, classpathServer, javaCmd, spacedJvmFlags, framework, startServer);
                }
                if (!useprocess && isSuiteRun) {
                    boolean started = false;
                    try {
                        started = ns.testNetworkServerConnection();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!started && startServer) {
                        ns.start();
                    }
                    if (started && !startServer) {
                        ns.stop();
                    }
                } else {
                    ns.start();
                    serverNeedsStopping = true;
                }
            }
            if (jarfile != null) {
                UnJar uj = new UnJar();
                UnJar.unjar(jarfile, outDir.getCanonicalPath(), true);
            }
            if (skiptest) {
                if (skiptestReason.length() == 0) {
                    RunTest.addSkiptestReason("Test skipped: skiptest set without setting skiptestReason, please fix RunTest.java...");
                }
                pwDiff.println(skiptestReason);
                System.out.println(skiptestReason);
                RunTest.doCleanup(javaVersion);
                return;
            }
            RunTest.testRun(propString, sp);
            if (serverNeedsStopping) {
                ns.stop();
            }
            outName = finalOutFile.getPath();
            if (skipsed) {
                tmpOutFile.renameTo(finalOutFile);
            } else {
                try {
                    Sed sed = new Sed();
                    sed.exec(tmpOutFile, finalOutFile, isSed, NetServer.isClientConnection(framework), isI18N, isJDBC4);
                }
                catch (ClassFormatError cfe) {
                    if (!verbose) break block38;
                    System.out.println("SED Error: " + cfe.getMessage());
                }
            }
        }
        String frameworkMaster = framework;
        if (framework.startsWith("embedded")) {
            frameworkMaster = "";
        }
        FileCompare diff = new FileCompare();
        if (verbose) {
            System.out.println("About to execute: diff.exec( outName = " + outName + ",outDir = " + outDir + ",pwDiff = " + pwDiff + ",testOutName = " + testOutName + ",frameworkMaster = " + frameworkMaster + ",jvmName = " + jvmName + ",iminor = " + iminor + ",useprocess = " + useprocess + ",systemdiff = " + systemdiff + ",canondir = " + canondir + ",canonpath = " + canonpath + ")\n");
        }
        if (jvmnet) {
            if (jvmnetjvm == null) {
                jvmnetjvm = "j9_22";
            }
            status = diff.exec(outName, outDir, pwDiff, testOutName, frameworkMaster, jvmName, iminor, useprocess, systemdiff, canondir, canonpath, jvmnetjvm);
        } else {
            status = diff.exec(outName, outDir, pwDiff, testOutName, frameworkMaster, jvmName, iminor, useprocess, systemdiff, canondir, canonpath, null);
        }
        if (status) {
            lastTestFailed = true;
            pwDiff.println("Test Failed.");
            System.out.println("Test Failed.");
            keepfiles = true;
            RunTest.addToFailures(scriptName);
            if (useCommonDB) {
                status = baseDir.delete();
            }
        } else {
            RunTest.addToSuccesses(scriptName);
            pwDiff.flush();
        }
        RunTest.generateUTF8OutFile(finalOutFile);
        RunTest.doCleanup(javaVersion);
    }

    private static void testRun(String propString, Properties sysProp) throws FileNotFoundException, IOException, Exception {
        String systemHome = baseDir.getPath();
        String scriptPath = null;
        if (testType.startsWith("sql")) {
            scriptPath = script.getPath();
        }
        if (useCommonDB && (usesystem == null || usesystem == "") && (testType.equals("sql") || testType.equals("java") || testType.equals("sql2"))) {
            dbcleanup.doit(dbIsNew);
        }
        if (useprocess) {
            String[] testCmd = RunTest.buildTestCommand(propString, systemHome, scriptPath);
            RunTest.execTestProcess(testCmd);
        } else {
            RunTest.execTestNoProcess(sysProp, systemHome, propString, scriptPath);
        }
    }

    private static void setDirectories(String scriptName, Properties sp) throws ClassNotFoundException, FileNotFoundException, IOException {
        File tmpoutDir;
        userdir = sp.getProperty("user.dir");
        if (!useprocess) {
            defaultPackageName = "/org/apache/derbyTesting/";
        }
        if (useCommonDB) {
            defaultPackageName = "/org/apache/derbyTesting/";
        }
        String resourceName = defaultPackageName + "functionTests/tests/";
        int index = scriptName.lastIndexOf(47);
        if (index == -1) {
            if (!(testType.equals("sql") || testType.equals("java") || testType.equals("junit"))) {
                System.out.println("Test argument should be of the form: <dir>/<test>.<ext>");
                System.exit(1);
            } else {
                scriptFileName = scriptName;
                resourceName = resourceName + scriptName;
            }
        } else {
            testDirName = index == 0 ? "" : scriptName.substring(0, index);
            scriptFileName = scriptName.substring(index + 1, scriptName.length());
            defaultPackageName = testType.equals("multi") ? defaultPackageName + "functionTests/multi/" + testDirName + "/" : defaultPackageName + "functionTests/tests/" + testDirName + "/";
            resourceName = defaultPackageName + scriptFileName;
        }
        testBase = scriptFileName.substring(0, scriptFileName.lastIndexOf("." + testType));
        if (testType.equals("java") || testType.equals("junit")) {
            String tmp = defaultPackageName.replace('/', '.');
            int tl = tmp.length() - 1;
            String string = javaPath = tl == 0 ? "" : tmp.substring(1, tl);
        }
        if (runningdir != null && runningdir.length() > 0) {
            if (File.separatorChar == '\\') {
                String runningdirWin = RunTest.convertPathForWin(runningdir);
                runDir = new File(new File(runningdirWin).getCanonicalPath());
            } else {
                runDir = new File(new File(runningdir).getCanonicalPath());
            }
        }
        String userdirWin = null;
        if (outputdir == null || outputdir.length() == 0) {
            if (File.separatorChar == '\\') {
                userdirWin = RunTest.convertPathForWin(userdir);
                tmpoutDir = new File(new File(userdirWin).getCanonicalPath());
            } else {
                tmpoutDir = new File(new File(userdir).getCanonicalPath());
            }
        } else if (File.separatorChar == '\\') {
            String outputdirWin = RunTest.convertPathForWin(outputdir);
            tmpoutDir = new File(new File(outputdirWin).getCanonicalPath());
        } else {
            tmpoutDir = new File(new File(outputdir).getCanonicalPath());
        }
        if (!isSuiteRun && !framework.startsWith("embedded")) {
            runDir = tmpoutDir;
            outDir = new File(tmpoutDir, framework);
            outDir.mkdir();
        } else {
            outDir = tmpoutDir;
            outDir.mkdir();
            if (topsuitedir != null && topsuitedir.length() > 0) {
                if (File.separatorChar == '\\') {
                    String topsuitedirWin = RunTest.convertPathForWin(topsuitedir);
                    tsuiteDir = new File(new File(topsuitedirWin).getCanonicalPath());
                } else {
                    tsuiteDir = new File(new File(topsuitedir).getCanonicalPath());
                }
            } else {
                tsuiteDir = outDir;
            }
            tsuiteDir.mkdir();
            if (topreportdir != null && topreportdir.length() > 0) {
                if (File.separatorChar == '\\') {
                    String topreportdirWin = RunTest.convertPathForWin(topreportdir);
                    rsuiteDir = new File(new File(topreportdirWin).getCanonicalPath());
                } else {
                    rsuiteDir = new File(new File(topreportdir).getCanonicalPath());
                }
            } else {
                rsuiteDir = outDir;
            }
            rsuiteDir.mkdir();
        }
        fileSep = File.separatorChar;
        if (testType.equals("multi") && (mtestdir == null || mtestdir.length() == 0)) {
            mtestdir = outDir.getPath();
        }
        if (!(testType.equals("java") || testType.equals("junit") || testType.equals("unit") || testType.equals("multi"))) {
            FileWriter fw;
            File f;
            InputStream is = RunTest.loadTestResource("tests/" + testDirName + "/" + scriptFileName);
            if (is == null) {
                System.out.println("Could not locate " + scriptName);
                RunTest.addToFailures(scriptName);
                throw new FileNotFoundException(resourceName);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            if (upgradetest) {
                try {
                    script = new File(new File(userdir, scriptFileName).getCanonicalPath());
                }
                catch (IOException e) {
                    f = new File(userdir, scriptFileName);
                    fw = new FileWriter(f);
                    fw.close();
                    script = new File(f.getCanonicalPath());
                }
            } else {
                try {
                    script = new File(new File(outDir, scriptFileName).getCanonicalPath());
                }
                catch (IOException e) {
                    f = new File(outDir, scriptFileName);
                    fw = new FileWriter(f);
                    fw.close();
                    script = new File(f.getCanonicalPath());
                }
            }
            PrintWriter pw = null;
            pw = new PrintWriter((Writer)new BufferedWriter(new FileWriter(script.getPath()), 10000), true);
            String str = "";
            while ((str = in.readLine()) != null) {
                pw.println(str);
            }
            pw.close();
            pw = null;
            in = null;
        }
        baseDir = null;
        if (useCommonDB) {
            if (File.separatorChar == '\\') {
                String commonDBHomeWin = RunTest.convertPathForWin(commonDBHome);
                baseDir = new File(userdirWin, commonDBHomeWin);
            } else {
                baseDir = new File(userdir, commonDBHome);
            }
        } else if (!useprocess && isSuiteRun && (usesystem == null || usesystem.length() <= 0)) {
            String suite = suiteName.substring(0, suiteName.indexOf(58));
            if (File.separatorChar == '\\') {
                String useprWin = RunTest.convertPathForWin(suite);
                baseDir = new File(outDir, useprWin);
            } else {
                baseDir = new File(outDir, suite);
            }
        } else if (usesystem != null && usesystem.length() > 0) {
            if (File.separatorChar == '\\') {
                String usesystemWin = RunTest.convertPathForWin(usesystem);
                baseDir = upgradetest ? new File(userdirWin, usesystemWin) : new File(outDir, usesystemWin);
            } else {
                baseDir = upgradetest ? new File(userdir, usesystem) : new File(outDir, usesystem);
            }
        } else if (File.separatorChar == '\\') {
            String testBaseWin = RunTest.convertPathForWin(testBase);
            baseDir = new File(outDir, testBaseWin);
        } else {
            baseDir = new File(outDir, testBase);
        }
        if (baseDir.exists()) {
            if (!useCommonDB || lastTestFailed) {
                RunTest.cleanupBaseDir(baseDir);
                lastTestFailed = false;
            } else if (useCommonDB) {
                dbIsNew = false;
            }
        } else {
            boolean created = baseDir.mkdir();
            dbIsNew = true;
        }
        deleteBaseDir = usesystem == null || usesystem.length() <= 0;
        if (testOutName == null) {
            testOutName = testBase;
        }
        tmpOutFile = new File(outDir, testOutName + ".tmp");
        tempMasterName = testOutName + ".tmpmstr";
        UTF8OutName = testOutName + ".utf8out";
        finalOutFile = new File(outDir, testOutName + ".out");
        diffFile = new File(outDir, testOutName + ".diff");
        stdOutFile = new File(outDir, testOutName + ".std");
        if (isSuiteRun) {
            String sname = suiteName.substring(0, suiteName.indexOf(":"));
            passFileName = sname + ".pass";
            passFile = new File(rsuiteDir, passFileName);
            failFileName = sname + ".fail";
            failFile = new File(rsuiteDir, failFileName);
        } else {
            passFileName = testBase + ".pass";
            passFile = new File(outDir, passFileName);
            failFileName = testBase + ".fail";
            failFile = new File(outDir, failFileName);
        }
        boolean status = true;
        if (tmpOutFile.exists()) {
            status = tmpOutFile.delete();
        }
        if ((tempMasterFile = new File(outDir, tempMasterName)).exists()) {
            status = tempMasterFile.delete();
        }
        if (finalOutFile.exists()) {
            status = finalOutFile.delete();
        }
        if (diffFile.exists()) {
            status = diffFile.delete();
        }
        if (stdOutFile.exists()) {
            status = stdOutFile.delete();
        }
        if ((UTF8OutFile = new File(outDir, UTF8OutName)).exists()) {
            status = UTF8OutFile.delete();
        }
        if (!isSuiteRun) {
            if (failFile.exists()) {
                status = failFile.delete();
            }
            if (passFile.exists()) {
                status = passFile.delete();
            }
        }
        if (!status) {
            System.out.println("Unable to delete tmp, out and/or diff files to start");
        }
        pwDiff = new PrintWriter((Writer)new BufferedWriter(new FileWriter(diffFile.getPath()), 4096), true);
    }

    private static JavaVersionHolder getProperties(Properties sp) throws Exception {
        String uscdb;
        String rstderr;
        String dbug;
        String nosed;
        String usepr;
        String jdk12ext;
        String encrypt;
        String keep;
        String sysdiff;
        Object excludeJcc;
        String replace_policy;
        String generateUTF8OutProp;
        if (jvmflags != null && jvmflags.length() > 0) {
            StringTokenizer st = new StringTokenizer(jvmflags, "^");
            while (st.hasMoreTokens()) {
                String tmpstr = st.nextToken();
                if (tmpstr.indexOf("=") <= 0 || !tmpstr.startsWith("-D")) continue;
                String key = tmpstr.substring(2, tmpstr.indexOf("="));
                String value = tmpstr.substring(tmpstr.indexOf("=") + 1, tmpstr.length());
                sp.put(key, value);
            }
        }
        searchCP = sp.getProperty("ij.searchClassPath");
        String frameworkp = sp.getProperty("framework");
        if (frameworkp != null) {
            framework = frameworkp;
        }
        if (framework == null) {
            framework = "embedded";
        }
        if (!RunTest.verifyFramework(framework)) {
            framework = "";
        } else {
            driverName = NetServer.getDriverName(framework);
        }
        String junitXAProp = sp.getProperty("derbyTesting.xa.single");
        if (junitXAProp != null && junitXAProp.equals("true")) {
            junitXASingle = true;
        }
        if ((hostName = sp.getProperty("hostName")) == null) {
            hostName = "localhost";
        }
        if ((generateUTF8OutProp = sp.getProperty("generateUTF8Out")) != null && generateUTF8OutProp.equals("true")) {
            generateUTF8Out = true;
        }
        String skipFile = framework + ".exclude";
        if (!framework.equals("")) {
            skiptest = SkipTest.skipIt(skipFile, scriptName);
            if (!skiptest && !hostName.equals("localhost")) {
                skipFile = framework + "Remote.exclude";
                skiptest = SkipTest.skipIt(skipFile, scriptName);
            }
            if (skiptest) {
                RunTest.addSkiptestReason("Test skipped: listed in " + skipFile + " file, skipping test: " + scriptName);
            }
        }
        javaVersion = (jvmName = sp.getProperty("jvm")) == null || jvmName.length() == 0 || jvmName.equals("jview") ? System.getProperty("java.version") : jvmName;
        String javavmVersion = sp.getProperty("java.vm.name").equals("J9") ? sp.getProperty("java.vm.version") : javaVersion;
        JavaVersionHolder jvh = new JavaVersionHolder(javavmVersion);
        majorVersion = jvh.getMajorVersion();
        minorVersion = jvh.getMinorVersion();
        iminor = jvh.getMinorNumber();
        imajor = jvh.getMajorNumber();
        if (jvmName == null || !jvmName.equals("jview")) {
            if (iminor < 2 && imajor < 2) {
                jvmName = "currentjvm";
            } else if (System.getProperty("java.vm.vendor").startsWith("IBM")) {
                if (System.getProperty("java.vm.name").equals("J9")) {
                    if (System.getProperty("com.ibm.oti.configuration").equals("foun10")) {
                        jvmName = "j9_foundation";
                    } else if (System.getProperty("com.ibm.oti.configuration").equals("foun11")) {
                        jvmName = "j9_foundation11";
                    } else {
                        javaVersion = javaVersion + " - " + majorVersion + "." + minorVersion;
                        if (imajor <= 2 && iminor < 2) {
                            majorVersion = "1";
                            minorVersion = "3";
                            imajor = 1;
                            iminor = 3;
                        }
                        jvmName = "j9_" + majorVersion + minorVersion;
                    }
                } else {
                    jvmName = "ibm" + majorVersion + minorVersion;
                }
            } else {
                jvmName = "jdk" + majorVersion + minorVersion;
            }
        }
        String specversion = sp.getProperty("java.specification.version");
        JavaVersionHolder jvhs = new JavaVersionHolder(specversion);
        testEncoding = sp.getProperty("derbyTesting.encoding");
        upgradejarpath = sp.getProperty("derbyTesting.jar.path");
        if (testEncoding != null && !jvmName.equals("jdk15")) {
            skiptest = true;
            RunTest.addSkiptestReason("derbyTesting.encoding can only be used with jdk15, skipping test");
        }
        replacePolicyFile = (replace_policy = sp.getProperty("derbyTesting.replacePolicyFile")) != null && replace_policy.equals("true");
        javaCmd = sp.getProperty("javaCmd");
        bootcp = sp.getProperty("bootcp");
        jvmflags = sp.getProperty("jvmflags");
        testJavaFlags = sp.getProperty("testJavaFlags");
        classpath = sp.getProperty("classpath");
        classpathServer = sp.getProperty("classpathServer");
        if (classpathServer == null || classpathServer.startsWith("${")) {
            classpathServer = classpath;
        }
        jarfile = sp.getProperty("jarfile");
        String upg = sp.getProperty("upgradetest");
        if (upg != null && (upg = upg.toLowerCase()).equals("true")) {
            upgradetest = true;
        }
        if (framework.equals("DerbyNet") && !jvmName.startsWith("j9_foundation")) {
            Class<?> c = null;
            Method m = null;
            Object o = null;
            Integer i = null;
            try {
                c = Class.forName("com.ibm.db2.jcc.DB2Driver");
                o = c.newInstance();
                m = c.getMethod("getMajorVersion", null);
                i = (Integer)m.invoke(o, null);
                jccMajor = i;
                m = c.getMethod("getMinorVersion", null);
                i = (Integer)m.invoke(o, null);
                jccMinor = i;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            excludeJcc = sp.getProperty("excludeJCC");
            try {
                RunList.checkClientExclusion((String)excludeJcc, "JCC", jccMajor, jccMinor, javaVersion);
            }
            catch (Exception e) {
                skiptest = true;
                RunTest.addSkiptestReason(e.getMessage());
            }
        }
        if ((sysdiff = sp.getProperty("systemdiff")) != null && (sysdiff = sysdiff.toLowerCase()).equals("true")) {
            systemdiff = true;
        }
        if ((keep = sp.getProperty("keepfiles")) != null && (keep = keep.toLowerCase()).equals("true")) {
            keepfiles = true;
        }
        if ((encrypt = sp.getProperty("encryption")) != null && encrypt.equalsIgnoreCase("true")) {
            encryption = true;
        }
        if ((jdk12ext = sp.getProperty("jdk12exttest")) != null && jdk12ext.equalsIgnoreCase("true")) {
            jdk12exttest = true;
        }
        if (encryption || jdk12exttest) {
            if (iminor < 2) {
                skiptest = true;
                RunTest.addSkiptestReason("Test skipped: encryption or jdk12exttest requires jdk12 or higher; this is jdk1" + iminor + ", skipping test: " + scriptFileName);
            } else {
                try {
                    excludeJcc = Class.forName("javax.transaction.xa.Xid");
                }
                catch (ClassNotFoundException cnfe) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test skipped: javax.transaction.xa.Xid not found, skipping test: " + scriptFileName);
                }
                try {
                    Class<?> cnfe = Class.forName("javax.sql.RowSet");
                }
                catch (ClassNotFoundException cnfe2) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test skipped: javax.sql.RowSet not found, skipping test: " + scriptFileName);
                }
            }
        }
        if ((runningdir = sp.getProperty("rundir")) == null) {
            runningdir = "";
        }
        if ((outputdir = sp.getProperty("outputdir")) == null) {
            outputdir = "";
        }
        canondir = sp.getProperty("canondir");
        canonpath = sp.getProperty("canonpath");
        testOutName = sp.getProperty("testoutname");
        useOutput = new Boolean(sp.getProperty("useoutput", "true"));
        outcopy = new Boolean(sp.getProperty("outcopy", "false"));
        mtestdir = sp.getProperty("mtestdir");
        if (mtestdir == null) {
            mtestdir = "";
        }
        useprocess = (usepr = sp.getProperty("useprocess")) != null ? !(usepr = usepr.toLowerCase()).equals("false") : true;
        if (!hostName.equals("localhost")) {
            startServer = false;
        }
        if ((nosed = sp.getProperty("skipsed")) != null && (nosed = nosed.toLowerCase()).equals("true")) {
            skipsed = true;
        }
        if ((dbug = sp.getProperty("verbose")) != null && (dbug = dbug.toLowerCase()).equals("true")) {
            verbose = true;
        }
        if ((rstderr = sp.getProperty("reportstderr")) != null && (rstderr = rstderr.toLowerCase()).equals("false")) {
            reportstderr = false;
        }
        if (timeoutStr == null) {
            timeoutStr = sp.getProperty("timeout", "-1");
        }
        try {
            timeout = Integer.parseInt(timeoutStr);
        }
        catch (NumberFormatException nfe) {
            timeout = -1;
        }
        testSpecialProps = sp.getProperty("testSpecialProps");
        if (useprocess) {
            String defrespckg = sp.getProperty("ij.defaultResourcePackage");
            if (defrespckg != null && !(defaultPackageName = defrespckg).endsWith("/")) {
                defaultPackageName = defaultPackageName + "/";
            }
            usesystem = sp.getProperty("usesystem");
        }
        if (!useprocess && !skiptest) {
            String tsuiteName = null;
            tsuiteName = suiteName != null ? suiteName : sp.getProperty("suitename");
            if (tsuiteName != null && tsuiteName.length() > 0) {
                skipFile = framework + "Useprocess.exclude";
                if (!framework.equals("") && (skiptest = SkipTest.skipIt(skipFile, scriptName))) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test " + scriptName + " skipped, " + "listed in " + framework + "Useprocess.exclude file.");
                }
            }
        }
        if (useprocess || suiteName == null) {
            if (useprocess) {
                suiteName = sp.getProperty("suitename");
            }
            if (suiteName != null && suiteName.length() > 0) {
                isSuiteRun = true;
                if (useprocess) {
                    topsuiteName = sp.getProperty("topsuitename");
                }
                topsuitedir = sp.getProperty("topsuitedir");
                topreportdir = sp.getProperty("topreportdir");
            }
        }
        if ((uscdb = sp.getProperty("useCommonDB")) != null && uscdb.equals("true")) {
            useCommonDB = true;
        }
        return jvhs;
    }

    private static String createPropString() throws ClassNotFoundException, FileNotFoundException, IOException {
        String value;
        String key;
        Enumeration<?> e;
        String propString = "";
        Object in = null;
        BufferedOutputStream bos = null;
        Object bos2 = null;
        String str = "";
        InputStream isCl = null;
        InputStream isClDef = null;
        InputStream isAp = null;
        InputStream isApDef = null;
        String clDefProp = "tests/" + testDirName + "/" + "default_gemfirexd.properties";
        String apDefProp = null;
        apDefProp = useCommonDB ? "tests/" + testDirName + "/" + "commonDB_app.properties" : "tests/" + testDirName + "/" + "default_app.properties";
        Properties clp = new Properties();
        Properties ap = new Properties();
        Properties ijProps = new Properties();
        Properties srvProps = new Properties();
        if (testSpecialProps != null && testSpecialProps.length() > 0) {
            SpecialFlags.parse(testSpecialProps, ijProps, srvProps);
        }
        isClDef = RunTest.loadTestResource(clDefProp);
        isCl = RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + "_gemfirexd.properties");
        if (isCl != null) {
            clp.load(isCl);
            clp.list(System.out);
        } else if (isClDef != null) {
            clp.load(isClDef);
        }
        if (jvmName.startsWith("j9") && clp.getProperty("gemfirexd.language.statementCacheSize") == null) {
            clp.put("gemfirexd.language.statementCacheSize", J9_STATEMENTCACHESIZE);
        }
        if (clp.isEmpty()) {
            if (!srvProps.isEmpty()) {
                clp = srvProps;
            }
        } else if (!srvProps.isEmpty()) {
            Enumeration<?> e2 = srvProps.propertyNames();
            while (e2.hasMoreElements()) {
                String cval;
                String key2 = (String)e2.nextElement();
                String value2 = srvProps.getProperty(key2);
                if (key2.equals("gemfirexd.debug.true") && (cval = clp.getProperty("gemfirexd.debug.true")) != null) {
                    value2 = cval.length() != 0 ? value2 + "," + cval : "";
                }
                clp.put(key2, value2);
            }
        }
        if (!clp.isEmpty()) {
            try {
                clPropFile = new File(new File(baseDir, "gemfirexd.properties").getCanonicalPath());
            }
            catch (IOException e3) {
                File f = new File(baseDir, "gemfirexd.properties");
                FileWriter fw = new FileWriter(f);
                fw.close();
                clPropFile = new File(f.getCanonicalPath());
            }
            bos = new BufferedOutputStream(new FileOutputStream(clPropFile));
            clp.store(bos, "GemFireXD Properties");
            bos.close();
        }
        isSed = testType.equals("multi") ? RunTest.loadTestResource("multi/stress/" + testBase + "_sed.properties") : RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + "_sed.properties");
        Properties dp = new Properties();
        String testPropName = null;
        Object testPropSDName = null;
        testPropName = useCommonDB ? "CDB" + testBase + "_app.properties" : testBase + "_app.properties";
        isApDef = RunTest.loadTestResource(apDefProp);
        isAp = testType.equals("multi") ? RunTest.loadTestResource("multi/" + testDirName + "/" + testBase + "_app.properties") : RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + "_app.properties");
        if (isAp != null) {
            ap.load(isAp);
            e = ap.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = ap.getProperty(key);
                if (!key.equals("usedefaults") || !value.equals("true") || isApDef == null) continue;
                dp.load(isApDef);
                RunTest.mergeProps(ap, dp);
                break;
            }
        } else if (isApDef != null) {
            ap.load(isApDef);
        }
        if (ap.isEmpty()) {
            if (!ijProps.isEmpty()) {
                ap = ijProps;
            }
        } else if (!ijProps.isEmpty()) {
            e = ijProps.propertyNames();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                value = ijProps.getProperty(key);
                ap.put(key, value);
            }
        }
        if (!ap.isEmpty()) {
            try {
                appPropFile = new File(new File(baseDir, testPropName).getCanonicalPath());
            }
            catch (IOException e4) {
                File f = new File(baseDir, testPropName);
                FileWriter fw = new FileWriter(f);
                fw.close();
                appPropFile = new File(f.getCanonicalPath());
            }
            String conEnc = System.getProperty("console.encoding");
            String fileEnc = System.getProperty("file.encoding");
            if (ap.getProperty("gemfirexd.ui.codeset") != null) {
                codeset = ap.getProperty("gemfirexd.ui.codeset");
            } else if (isI18N) {
                ap.put("gemfirexd.ui.codeset", "UTF-8");
            } else if (conEnc != null && fileEnc != null && conEnc.startsWith("Cp850")) {
                ap.put("gemfirexd.ui.codeset", fileEnc);
            }
            if (verbose) {
                System.out.println("console.encoding:" + conEnc + " file.encoding:" + fileEnc + " gemfirexd.ui.codeset: " + ap.getProperty("gemfirexd.ui.codeset"));
            }
            if (System.getProperty("ij.dataSource") != null) {
                ap.remove("ij.database");
                ap.remove("ij.protocol");
            }
            ap.remove("ij.database");
            ap.put("ij.database", "jdbc:gemfirexd:");
            ap.put("gemfire.mcast-port", "0");
            ap.put("gemfire.log-level", "fine");
            ap.put(GfxdConstants.GFXD_LOG_FILE, "gemfirexd.log");
            ap.put("jline.terminal", "scala.tools.jline.UnsupportedTerminal");
            bos = new BufferedOutputStream(new FileOutputStream(appPropFile));
            ap.store(bos, "App Properties");
            bos.close();
            String apppropsjvmflags = ap.getProperty("jvmflags");
            if (apppropsjvmflags != null) {
                jvmflags = jvmflags != null ? apppropsjvmflags + "^" + jvmflags : apppropsjvmflags;
            }
            if (jvmflags != null && jvmflags.length() > 0) {
                StringTokenizer st = new StringTokenizer(jvmflags, "^");
                while (st.hasMoreTokens()) {
                    String tmpstr = st.nextToken();
                    if (tmpstr.indexOf("=") <= 0 || !tmpstr.startsWith("-D")) continue;
                    String key3 = tmpstr.substring(2, tmpstr.indexOf("="));
                    String value3 = tmpstr.substring(tmpstr.indexOf("=") + 1, tmpstr.length());
                    ap.put(key3, value3);
                }
            }
            if (framework.length() > 0 || encryption) {
                try {
                    if (!framework.equals("") && !framework.equals("embedded")) {
                        RunTest.frameworkProtocol(ap);
                    } else if (encryption) {
                        RunTest.encryptionProtocol(ap);
                    }
                }
                catch (Exception e5) {
                    System.out.println("Exception: " + e5.getMessage());
                    e5.printStackTrace();
                }
                appPropFile = new File(baseDir, testBase + "_app.properties");
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(appPropFile));
                    ap.store(bos, "Test Properties");
                    bos.close();
                }
                catch (IOException ioe) {
                    System.out.println("IOException creating prop file: " + ioe.getMessage());
                }
            }
        }
        if (appPropFile != null && appPropFile.exists()) {
            String suppFiles;
            String startServerProp;
            String srvJvm;
            propString = appPropFile.getPath();
            shutdownurl = ap.getProperty("shutdown");
            String jdk12test = ap.getProperty("jdk12test");
            if (jdk12test != null && jdk12test.toLowerCase().equals("true")) {
                isjdk12test = true;
                if (jvmName.equals("currentjvm")) {
                    skiptest = true;
                    RunTest.addSkiptestReason("Test skipped: test needs jdk12, jvm is reporting currentjvm; skipping test: " + scriptFileName);
                }
            }
            if ((srvJvm = System.getProperty("serverJvm")) != null) {
                jvmnet = true;
            }
            String excludeJcc = ap.getProperty("excludeJCC");
            if (framework.equals("DerbyNet")) {
                try {
                    RunList.checkClientExclusion(excludeJcc, "JCC", jccMajor, jccMinor, javaVersion);
                }
                catch (Exception e6) {
                    skiptest = true;
                    RunTest.addSkiptestReason(e6.getMessage());
                }
            }
            String testJVM = jvmName;
            if (jvmName.startsWith("j9")) {
                testJVM = jvmName.equals("j9_foundation") ? "foundation" : (jvmName.equals("j9_foundation11") ? "foundation" : "j9");
            }
            if ((runwithjvm = ap.getProperty("runwith" + testJVM)) != null && runwithjvm.equalsIgnoreCase("false")) {
                skiptest = true;
                RunTest.addSkiptestReason("Test skipped: test cannot run with jvm: " + jvmName + ".  " + scriptFileName);
            }
            if ((startServerProp = ap.getProperty("startServer")) != null && startServerProp.equalsIgnoreCase("false")) {
                startServer = false;
            }
            if (testEncoding == null) {
                testEncoding = ap.getProperty("derbyTesting.encoding");
                if (jvmName.equals("jdk15") && testEncoding != null) {
                    jvmflags = (jvmflags == null ? "" : jvmflags + " ") + "-Dfile.encoding=" + testEncoding;
                    ap.put("file.encoding", testEncoding);
                }
            }
            if (!replacePolicyFile) {
                String replace_policy = ap.getProperty("derbyTesting.replacePolicyFile");
                replacePolicyFile = replace_policy != null && replace_policy.equals("true");
            }
            if (NetServer.isJCCConnection(framework) || "true".equalsIgnoreCase(ap.getProperty("noSecurityManager"))) {
                runWithoutSecurityManager = true;
            }
            boolean copySupportFiles = (suppFiles = ap.getProperty("supportfiles")) != null && suppFiles.length() > 0;
            boolean createExtDirs = new Boolean(ap.getProperty("useextdirs", "false"));
            if (copySupportFiles || createExtDirs) {
                File multiDir;
                File copyOutDir = null;
                copyOutDir = testType.equals("sql2") ? (isSuiteRun || framework.length() > 0 ? outDir : (runDir != null && runDir.exists() ? runDir : outDir)) : (testType.equals("multi") ? (isSuiteRun || mtestdir == null || mtestdir.length() == 0 ? outDir : (multiDir = new File(mtestdir))) : (outcopy ? outDir : (runDir != null && runDir.exists() ? runDir : outDir)));
                if (createExtDirs) {
                    extInDir = copyOutDir;
                    extInDir = new File(copyOutDir, "extin");
                    if (!extInDir.exists()) {
                        extInDir.mkdirs();
                    }
                    if (!(extOutDir = new File(copyOutDir, "extout")).exists()) {
                        extOutDir.mkdirs();
                    }
                    if (!(extInOutDir = new File(copyOutDir, "extinout")).exists()) {
                        extInOutDir.mkdirs();
                    }
                    copyOutDir = extInDir;
                }
                if (copySupportFiles) {
                    CopySuppFiles.copyFiles(copyOutDir, suppFiles);
                }
            } else {
                extInDir = null;
                extOutDir = null;
                extInOutDir = null;
            }
        }
        return propString;
    }

    public static String setTestJavaFlags(String tflags) {
        StringBuilder sb = new StringBuilder();
        if (verbose) {
            System.out.println("testJavaflags: " + tflags);
        }
        String dintro = "-D";
        try {
            dintro = jvm.getJvm(jvmName).getDintro();
        }
        catch (Exception e) {
            System.out.println("Problem getting jvm " + jvmName + " Dintro: ");
            e.printStackTrace(System.out);
            System.exit(1);
        }
        StringTokenizer st = new StringTokenizer(tflags, "^");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.startsWith("-")) {
                sb.append(dintro);
            }
            sb.append(token);
            sb.append(" ");
        }
        if (verbose) {
            System.out.println("setTestJavaFlags returning: " + sb.toString());
        }
        return sb.toString();
    }

    private static void loadProps(Properties p, File f) throws Exception {
        if (f.canRead()) {
            FileInputStream fis = new FileInputStream(f);
            p.load(fis);
            fis.close();
        }
    }

    private static void mergeProps(Properties to, Properties from) {
        Enumeration<?> e = from.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            to.put(key, from.getProperty(key));
        }
    }

    private static void frameworkProtocol(Properties p) throws Exception {
        if (p == null) {
            return;
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            if (key.equals("driver") || key.equals("ij.driver") || key.equals("jdbc.drivers")) {
                p.put(key, driverName);
                continue;
            }
            if (key.startsWith("ij.protocol") || key.equals("protocol")) {
                value = NetServer.alterURL(framework, value);
                p.put(key, value);
                continue;
            }
            if (key.equals("database") || key.equals("ij.database") || key.startsWith("ij.connection") || key.equals("jdbc.url")) {
                dbName = value.substring(value.lastIndexOf(58) + 1, value.length());
                value = NetServer.alterURL(framework, value);
                p.put(key, value);
                continue;
            }
            p.put(key, value);
        }
        if (NetServer.isJCCConnection(framework)) {
            String user = System.getProperty("ij.user");
            if (user == null) {
                user = "APP";
            }
            p.put("ij.user", user);
        }
        if (NetServer.isClientConnection(framework)) {
            String password = System.getProperty("ij.password");
            if (password == null) {
                password = "APP";
            }
            p.put("ij.password", password);
        }
        if (NetServer.isJCCConnection(framework)) {
            p.put("ij.retrieveMessagesFromServerOnGetMessage", "true");
        }
        if (driverName != null) {
            p.put("ij.driver", driverName);
        }
    }

    private static void encryptionProtocol(Properties p) throws Exception {
        String encryptUrl = "dataEncryption=true;bootPassword=Thursday";
        if (p == null) {
            return;
        }
        String v = p.getProperty("testEncryptionAlgorithm");
        if (v != null) {
            encryptUrl = encryptUrl + ";encryptionAlgorithm=" + v;
        }
        if ((v = p.getProperty("testEncryptionProvider")) != null) {
            encryptUrl = encryptUrl + ";encryptionProvider=" + v;
        }
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = p.getProperty(key);
            if (key.equals("database") || key.equals("ij.database") || key.startsWith("ij.connection") || key.equals("jdbc.url")) {
                int index = value.indexOf(encryptUrl);
                if (index == -1) {
                    value = value + ";" + encryptUrl;
                }
                p.put(key, value);
                continue;
            }
            if (key.equals("testEncryptionAlgorithm") || key.equals("testEncryptionProvider")) continue;
            p.put(key, value);
        }
    }

    private static void cleanupBaseDir(File baseDir) {
        boolean okToDelete = false;
        if (usesystem == null || usesystem.length() == 0) {
            okToDelete = true;
        } else if (usesystem.equals("nist")) {
            if (testBase.equals("schema1")) {
                okToDelete = true;
            }
        } else if (usesystem.equals("puzzles") && testBase.equals("puzzleschema")) {
            okToDelete = true;
        }
        if (useCommonDB) {
            okToDelete = false;
        }
        if (okToDelete) {
            RunTest.deleteFile(baseDir);
            if (baseDir.exists()) {
                System.out.println("baseDir did not get deleted which could cause test failures");
            } else {
                baseDir.mkdir();
            }
        }
    }

    private static void doCleanup(String javaVersion) throws IOException {
        boolean status = true;
        if (script != null && script.exists() && !keepfiles) {
            status = script.delete();
        }
        String endTime = CurrentTime.getTime();
        StringBuilder sbend = new StringBuilder();
        sbend.append("*** End:   " + testBase + " jdk" + javaVersion + " ");
        if (framework.length() > 0 && !framework.startsWith("embedded")) {
            sbend.append(framework + " ");
        }
        if (suiteName != null && suiteName.length() > 0) {
            sbend.append(suiteName + " ");
        }
        sbend.append(endTime + " ***");
        System.out.println(sbend.toString());
        pwDiff.println(sbend.toString());
        pwDiff.flush();
        pwDiff.close();
        pwDiff = null;
        if (!keepfiles) {
            status = tmpOutFile.delete();
            if (!status) {
                tmpOutFile = null;
            }
            status = finalOutFile.delete();
            if (!skiptest) {
                status = diffFile.delete();
            }
            tempMasterFile = new File(outDir, tempMasterName);
            status = tempMasterFile.delete();
            UTF8OutFile = new File(outDir, UTF8OutName);
            status = UTF8OutFile.delete();
            File defaultPolicyFile = new File(userdir, "derby_tests.policy");
            if (defaultPolicyFile.exists()) {
                status = defaultPolicyFile.delete();
            }
            if (deleteBaseDir) {
                if (!useCommonDB) {
                    RunTest.deleteFile(baseDir);
                } else {
                    status = appPropFile.delete();
                }
                if (extInDir != null) {
                    RunTest.deleteFile(extInDir);
                }
                if (extOutDir != null) {
                    RunTest.deleteFile(extOutDir);
                }
                if (extInOutDir != null) {
                    RunTest.deleteFile(extInOutDir);
                }
            }
        }
        keepfiles = false;
        RunTest.deleteFile(new File("datadictionary"));
    }

    public static void deleteFile(File f) {
        boolean status = true;
        if (f == null) {
            System.out.println(f.getName() + " is null");
            return;
        }
        if (!f.exists()) {
            System.out.println(f.getName() + " does not exist; harness error");
            return;
        }
        status = f.delete();
        if (status) {
            return;
        }
        if (!f.isDirectory()) {
            System.out.println("Could not delete file " + f.getName() + ", going on");
            return;
        }
        String[] files = f.list();
        for (int i = 0; i < files.length; ++i) {
            File sub = new File(f.getPath(), files[i]);
            if (sub == null || (status = sub.delete()) || !sub.isDirectory()) continue;
            RunTest.deleteFile(sub);
            status = sub.delete();
        }
        status = f.delete();
        if (!status) {
            System.out.println("Warning: Cleanup failed on baseDir: " + f.getPath());
        }
    }

    static void addToFailures(String testName) throws IOException {
        if (failFileName == null) {
            failFileName = isSuiteRun ? suiteName + ".fail" : testBase + ".fail";
        }
        RunTest.addToListFile(failFileName, testName);
    }

    static void addToSuccesses(String testName) throws IOException {
        if (passFileName == null) {
            passFileName = isSuiteRun ? suiteName + ".pass" : testBase + ".pass";
        }
        RunTest.addToListFile(passFileName, testName);
    }

    static void addToListFile(String fileName, String testName) throws IOException {
        File f = isSuiteRun ? new File(rsuiteDir, fileName) : new File(outDir, fileName);
        PrintStream ps = null;
        try {
            ps = new PrintStream(new FileOutputStream(f.getCanonicalPath(), true));
        }
        catch (IOException e) {
            FileWriter fw = new FileWriter(f);
            fw.close();
            ps = new PrintStream(new FileOutputStream(f.getCanonicalPath(), true));
        }
        ps.println(testName);
        ps.flush();
        ps.close();
    }

    static void appendStderr(BufferedOutputStream bos, InputStream is) throws IOException {
        PrintWriter tmpPw = new PrintWriter(bos);
        BufferedReader errReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        String s = null;
        boolean lines = false;
        while ((s = errReader.readLine()) != null) {
            tmpPw.println(s);
        }
        errReader.close();
        tmpPw.flush();
    }

    static void verifyTestType() throws ClassNotFoundException, FileNotFoundException, IOException {
        InputStream is = RunTest.loadTestResource("harness/testtypes.properties");
        Properties p = new Properties();
        p.load(is);
        String testtypes = p.getProperty("testtypes");
        StringTokenizer st = new StringTokenizer(testtypes, ",");
        String ttype = "";
        while (st.hasMoreTokens()) {
            ttype = st.nextToken();
            if (!testType.equals(ttype)) continue;
            return;
        }
        System.out.println("Unknown test type: " + testType);
        System.exit(1);
    }

    public static void addStandardTestJvmProps(Vector testJvmProps, String derbySystemHome, String userDirName, jvm jvm2) {
        if (derbySystemHome == null || derbySystemHome.length() == 0) {
            derbySystemHome = userDirName;
        }
        testJvmProps.addElement("gemfirexd.system.home=" + derbySystemHome);
        testJvmProps.addElement("gemfirexd.infolog.append=true ");
    }

    private static String[] buildTestCommand(String propString, String systemHome, String scriptPath) throws FileNotFoundException, IOException, Exception {
        RunTest.composePolicyFile();
        String ij2 = "";
        if (testType.equals("sql")) {
            ij2 = "ij";
        }
        jvm jvm2 = null;
        jvm2 = jvm.getJvm(jvmName);
        if (javaCmd != null) {
            jvm2.setJavaCmd(javaCmd);
        }
        if (classpath != null && classpath.length() > 0) {
            jvm2.setClasspath(classpath);
        }
        Vector<String> jvmProps = new Vector<String>();
        if (testType.equals("java")) {
            RunTest.addStandardTestJvmProps(jvmProps, systemHome, outDir.getCanonicalPath(), null);
        } else if (runDir != null && runDir.exists()) {
            RunTest.addStandardTestJvmProps(jvmProps, systemHome, runDir.getCanonicalPath(), jvm2);
        } else {
            RunTest.addStandardTestJvmProps(jvmProps, systemHome, outDir.getCanonicalPath(), jvm2);
        }
        if (testJavaFlags != null && testJavaFlags.length() > 0) {
            String parsedFlags = RunTest.setTestJavaFlags(testJavaFlags);
            StringTokenizer st = new StringTokenizer(parsedFlags, " ");
            while (st.hasMoreTokens()) {
                jvmflags = (jvmflags == null ? "" : jvmflags) + " " + st.nextToken();
            }
        }
        if (ij2.startsWith("ij")) {
            jvmProps.addElement("ij.defaultResourcePackage=" + defaultPackageName);
        }
        if (framework != null) {
            jvmProps.addElement("framework=" + framework);
            if (hostName != null && !hostName.equals("localhost")) {
                jvmProps.addElement("hostName=" + hostName);
            }
        }
        if (junitXASingle) {
            jvmProps.addElement("derbyTesting.xa.single=true");
        }
        if (testEncoding != null && jvmName.equals("jdk15")) {
            jvmProps.addElement("derbyTesting.encoding=" + testEncoding);
            jvmProps.addElement("file.encoding=" + testEncoding);
            jvmflags = (jvmflags == null ? "" : jvmflags + " ") + "-Dfile.encoding=" + testEncoding;
        } else if (isI18N) {
            jvmProps.addElement("file.encoding=UTF-8");
            jvmflags = (jvmflags == null ? "" : jvmflags + " ") + "-Dfile.encoding=UTF-8";
        }
        if (upgradejarpath != null) {
            jvmProps.addElement("derbyTesting.jar.path=" + upgradejarpath);
        }
        if (jvmflags != null && jvmflags.length() > 0) {
            if (jvmflags.indexOf("^") > 0) {
                jvmflags = RunTest.spaceJvmFlags(jvmflags);
            }
            jvm2.setFlags(jvmflags);
        }
        if (testType.equals("multi")) {
            if (jvmflags != null && jvmflags.indexOf("mx") == -1 && jvmflags.indexOf("Xmx") == -1) {
                jvm2.setMx(0x4000000L);
            }
            jvmProps.addElement("encryption=" + encryption);
            Properties props = new Properties();
            SpecialFlags.parse(testSpecialProps, props, new Properties());
            String encryptionAlgorithm = props.getProperty("testEncryptionAlgorithm");
            if (encryptionAlgorithm != null) {
                jvmProps.addElement("encryptionAlgorithm=\"encryptionAlgorithm=" + encryptionAlgorithm + "\"");
            }
        }
        jvm2.setD(jvmProps);
        if (!runWithoutSecurityManager) {
            jvm2.setSecurityProps();
        } else {
            System.out.println("-- SecurityManager not installed --");
        }
        Vector v = jvm2.getCommandLine();
        if (ij2.startsWith("ij")) {
            String isNotAscii = System.getProperty("platform.notASCII");
            if (isI18N) {
                v.addElement("-Dconsole.encoding=UTF-8");
            } else if (isNotAscii == null || isNotAscii.equals("false")) {
                v.addElement("-Dconsole.encoding=Cp1252");
            }
            v.addElement("com.pivotal.gemfirexd.internal.tools." + ij2);
            if (ij2.equals("ij")) {
                v.addElement("-f");
                v.addElement(outDir.toString() + File.separatorChar + scriptFileName);
            }
            v.addElement("-p");
            v.addElement(propString);
        } else if (testType.equals("java")) {
            if (javaPath.length() > 0) {
                v.addElement(javaPath + "." + testBase);
            } else {
                v.addElement(testBase);
            }
            if (propString.length() > 0) {
                v.addElement("-p");
                v.addElement(propString);
            }
        } else if (testType.equals("unit")) {
            v.addElement("org.apache.derbyTesting.unitTests.harness.UnitTestMain");
            v.addElement("-p");
            v.addElement(propString);
        } else if (testType.equals("junit")) {
            v.addElement("junit.textui.TestRunner");
            if (javaPath.length() > 0) {
                v.addElement(javaPath + "." + testBase);
            } else {
                v.addElement(testBase);
            }
        } else if (testType.equals("multi")) {
            System.out.println("scriptiflename is: " + scriptFileName);
            v.addElement("org.apache.derbyTesting.functionTests.harness.MultiTest");
            v.addElement(scriptFileName);
            v.addElement("-i");
            v.addElement(mtestdir);
            v.addElement("-o");
            v.addElement(outDir.getPath());
            v.addElement("-p");
            v.addElement(propString);
        }
        String[] sCmd = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            sCmd[i] = (String)v.elementAt(i);
        }
        return sCmd;
    }

    public static String spaceJvmFlags(String caretedJvmFlags) {
        String spacedJvmFlags = "";
        StringTokenizer st = new StringTokenizer(jvmflags, "^");
        while (st.hasMoreTokens()) {
            spacedJvmFlags = spacedJvmFlags + st.nextToken() + " ";
        }
        spacedJvmFlags = spacedJvmFlags.substring(0, spacedJvmFlags.length() - 1);
        return spacedJvmFlags;
    }

    public static void composePolicyFile() throws ClassNotFoundException {
        try {
            InputStream newpolicy;
            String default_policy = "util/derby_tests.policy";
            if (!replacePolicyFile) {
                File userDirHandle = new File(userdir);
                CopySuppFiles.copyFiles(userDirHandle, default_policy);
            }
            if (isSuiteRun && suiteName != null) {
                newpolicy = RunTest.loadTestResource("suites/" + suiteName.substring(0, suiteName.indexOf(58)) + ".policy");
                RunTest.writePolicyFile(newpolicy);
            }
            if (!useprocess) {
                newpolicy = RunTest.loadTestResource("util/useprocessfalse.policy");
                RunTest.writePolicyFile(newpolicy);
            }
            newpolicy = RunTest.loadTestResource("tests/" + testDirName + "/" + testBase + ".policy");
            RunTest.writePolicyFile(newpolicy);
        }
        catch (IOException ie) {
            System.out.println("Exception trying to create policy file: ");
            ie.printStackTrace();
        }
    }

    public static void writePolicyFile(InputStream newpolicy) {
        try {
            if (newpolicy != null) {
                File oldpolicy = new File(runDir, "derby_tests.policy");
                if (verbose && oldpolicy.exists()) {
                    System.out.println("Appending to derby_tests.policy");
                }
                BufferedReader policyadd = new BufferedReader(new InputStreamReader(newpolicy, "UTF-8"));
                FileWriter policyfw = new FileWriter(oldpolicy.getPath(), true);
                PrintWriter policypw = new PrintWriter((Writer)new BufferedWriter(policyfw, 10000), true);
                String str = "";
                while ((str = policyadd.readLine()) != null) {
                    policypw.println(str);
                }
                policypw.close();
                policyadd.close();
                policypw = null;
                newpolicy = null;
            }
        }
        catch (IOException ie) {
            System.out.println("Exception trying to create policy file: ");
            ie.printStackTrace();
        }
    }

    private static void execTestProcess(String[] testCmd) throws Exception {
        block12: {
            Process pr = null;
            try {
                ProcessStreamResult prout = null;
                ProcessStreamResult prerr = null;
                FileOutputStream fos = null;
                BufferedOutputStream bos = null;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < testCmd.length; ++i) {
                    sb.append(testCmd[i] + " ");
                }
                if (verbose) {
                    System.out.println(sb.toString());
                }
                pr = Runtime.getRuntime().exec(testCmd);
                String inEncoding = null;
                String outEncoding = null;
                if (isI18N) {
                    outEncoding = inEncoding = "UTF-8";
                }
                if (codeset != null) {
                    inEncoding = codeset;
                }
                if (testEncoding != null) {
                    inEncoding = testEncoding;
                }
                fos = useOutput ? new FileOutputStream(tmpOutFile) : new FileOutputStream(stdOutFile);
                bos = new BufferedOutputStream(fos, 1024);
                prout = new ProcessStreamResult(pr.getInputStream(), bos, timeoutStr, inEncoding, outEncoding);
                prerr = new ProcessStreamResult(pr.getErrorStream(), bos, timeoutStr, inEncoding, outEncoding);
                if (framework != null && !framework.equals("") && verbose) {
                    System.out.println("The test should be running...");
                }
                if (timeout != -1) {
                    TimedProcess tp = new TimedProcess(pr);
                    tp.waitFor(timeout * 60);
                    pr = null;
                }
                boolean outInterrupt = prout.Wait();
                boolean errInterrupt = prerr.Wait();
                if (errInterrupt || outInterrupt) {
                    pwDiff.println("The test timed out...");
                    System.out.println("Test timed out...");
                    pr.destroy();
                    pr = null;
                }
                fos.close();
                bos.close();
                if (pr != null) {
                    pr.destroy();
                    pr = null;
                }
            }
            catch (IOException ioe) {
                System.out.println("IOException: " + ioe.getMessage());
            }
            catch (Throwable t) {
                pwDiff.println("Process exception: " + t);
                System.out.println("Process exception: " + t.getMessage());
                t.printStackTrace();
                if (pr == null) break block12;
                pr.destroy();
                pr = null;
            }
        }
    }

    private static void execTestNoProcess(Properties sysProp, String systemHome, String propString, String scriptPath) throws Exception {
        Properties ptmp = System.getProperties();
        ptmp.put("gemfirexd.system.home", systemHome);
        ptmp.put("gemfirexd.infolog.append", "true");
        if (framework.startsWith("DerbyNet")) {
            ptmp.put("hostName=", hostName);
        }
        System.setProperties(ptmp);
        String pathStr = "";
        try {
            pathStr = tmpOutFile.getCanonicalPath().replace(File.separatorChar, fileSep);
        }
        catch (IOException e) {
            FileWriter fw = new FileWriter(tmpOutFile);
            fw.close();
            pathStr = tmpOutFile.getCanonicalPath().replace(File.separatorChar, fileSep);
        }
        PrintStream ps = new PrintStream(new FileOutputStream(pathStr), true);
        RunTest.composePolicyFile();
        boolean installedSecurityManager = RunTest.installSecurityManager();
        if (testType.equals("sql")) {
            String[] ijarg = new String[]{"-p", propString, scriptPath};
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(ps);
            System.setErr(ps);
            RunIJ ij2 = new RunIJ(ijarg);
            Thread ijThread = new Thread(ij2);
            try {
                ijThread.start();
                if (timeout < 0) {
                    ijThread.join();
                } else {
                    ijThread.join(timeout * 60 * 1000);
                }
            }
            catch (Exception e) {
                System.out.println("Aiiie! Got some kind of exception " + e);
            }
            if (shutdownurl != null) {
                String[] sdargs = new String[]{systemHome, shutdownurl};
                shutdown.main(sdargs);
            }
            ptmp = System.getProperties();
            ptmp.put("ij.defaultResourcePackage", "/org/apache/derbyTesting/");
            ptmp.put("usesystem", "");
            System.setProperties(ptmp);
            System.setOut(stdout);
            System.setErr(stderr);
        } else if (testType.equals("java")) {
            if (javaPath == null) {
                javaPath = "org.apache.derbyTesting.functionTests.tests." + testDirName;
            }
            String[] args = new String[]{"-p", propString};
            Class[] classArray = new Class[]{args.getClass()};
            String testName = javaPath + "." + testBase;
            Class<?> JavaTest = Class.forName(testName);
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(ps);
            System.setErr(ps);
            Method testMain = JavaTest.getMethod("main", classArray);
            Object[] argObj = new Object[]{args};
            RunClass testObject = new RunClass(testMain, argObj);
            Thread testThread = new Thread(testObject);
            try {
                testThread.start();
                if (timeout < 0) {
                    testThread.join();
                } else {
                    testThread.join(timeout * 60 * 1000);
                }
            }
            catch (Exception e) {
                System.out.println("Exception upon invoking test..." + e);
                e.printStackTrace();
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            System.setOut(stdout);
            System.setErr(stderr);
        } else if (testType.equals("multi")) {
            System.out.println("scriptiflename is: later " + scriptFileName);
            String[] args = new String[]{scriptFileName, "-i", mtestdir, "-o", outDir.getPath()};
            System.out.println("Try running MultiTest.main");
            for (int i = 0; i < args.length; ++i) {
                System.out.println("args: " + args[i]);
            }
            System.exit(1);
            MultiTest.main(args);
        } else if (testType.equals("unit")) {
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(ps);
            System.setErr(ps);
            System.out.println("Unit tests not implemented yet with useprocess=false");
            System.setOut(stdout);
            System.setErr(stderr);
            System.out.println("Unit tests not implemented yet with useprocess=false");
        } else if (testType.equals("junit")) {
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            System.setOut(ps);
            System.setErr(ps);
            if (javaPath == null) {
                javaPath = "org.apache.derbyTesting.functionTests.tests." + testDirName;
            }
            String testName = javaPath + "." + testBase;
            Class<?> testClass = Class.forName(testName);
            TestSuite junitTestSuite = null;
            try {
                Method suiteMethod = testClass.getMethod("suite", null);
                junitTestSuite = (TestSuite)suiteMethod.invoke(null, null);
            }
            catch (Exception ex) {
                junitTestSuite = new TestSuite(testClass);
            }
            if (junitTestSuite != null) {
                TestRunner.run((Test)junitTestSuite);
            } else {
                System.out.println("Not able to extract JUnit TestSuite from test class " + testName);
            }
            System.setOut(stdout);
            System.setErr(stderr);
        }
        ps.close();
        if (installedSecurityManager) {
            System.setSecurityManager(null);
        }
    }

    static void addSkiptestReason(String reason) {
        if (skiptestReason.length() > 0) {
            skiptestReason.append(System.getProperty("line.separator", "\n"));
        }
        skiptestReason.append(reason);
    }

    static boolean verifyFramework(String framework) {
        String validFmString = "";
        for (int i = 0; i < validFrameworks.length; ++i) {
            validFmString = validFmString + " " + validFrameworks[i];
            if (!validFrameworks[i].equals(framework)) continue;
            return true;
        }
        System.err.println("Invalid framework: " + framework);
        System.err.println("Valid frameworks are: " + validFmString);
        return false;
    }

    public static InputStream loadTestResource(String loc) {
        return new Object().getClass().getResourceAsStream(testResourceHome + loc);
    }

    private static String convertPathForWin(String path) {
        String tmp = "a" + path + "a";
        int i = tmp.indexOf(47);
        while (i != -1) {
            tmp = tmp.substring(0, i) + "\\\\" + tmp.substring(i + 1);
            i = tmp.indexOf(47);
        }
        tmp = tmp.substring(1, tmp.length() - 1);
        return tmp;
    }

    private static boolean installSecurityManager() throws ClassNotFoundException, IOException {
        boolean haveSecurityManagerAlready;
        if (jvmName.startsWith("j9") && !jvmName.equals("j9_foundation11")) {
            return false;
        }
        boolean installedSecurityManager = false;
        boolean bl = haveSecurityManagerAlready = System.getSecurityManager() != null;
        if (runWithoutSecurityManager) {
            if (haveSecurityManagerAlready) {
                System.out.println("noSecurityManager=true,useProcess=false but SecurityManager installed by previous test");
            } else {
                System.out.println("-- SecurityManager not installed --");
            }
        } else if (!haveSecurityManagerAlready) {
            Vector propList = jvm.getSecurityProps(null);
            Enumeration e = propList.elements();
            while (e.hasMoreElements()) {
                String dashDOpt = (String)e.nextElement();
                if ("java.security.manager".equals(dashDOpt)) continue;
                int eq = dashDOpt.indexOf("=");
                String key = dashDOpt.substring(0, eq);
                String value = dashDOpt.substring(eq + 1);
                System.setProperty(key, value);
            }
            System.setSecurityManager(new SecurityManager());
            installedSecurityManager = true;
        }
        return installedSecurityManager;
    }

    private static void generateUTF8OutFile(File FinalOutFile) throws IOException {
        if (generateUTF8Out) {
            int c;
            keepfiles = true;
            File UTF8OutFile = new File(UTF8OutName);
            BufferedReader inFile = new BufferedReader(new FileReader(FinalOutFile));
            FileOutputStream fos = new FileOutputStream(UTF8OutFile);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            while ((c = inFile.read()) != -1) {
                bw.write(c);
            }
            bw.flush();
            bw.close();
            fos.close();
        }
    }

    static {
        serverNeedsStopping = false;
        jvmnet = false;
        jvmName = "currentjvm";
        isjdk12test = false;
        classpath = "";
        classpathServer = "";
        framework = "embedded";
        J9_STATEMENTCACHESIZE = "20";
        usesystem = "";
        searchCP = "";
        useCommonDB = false;
        keepfiles = false;
        useprocess = true;
        systemdiff = false;
        upgradetest = false;
        encryption = false;
        jdk12exttest = false;
        generateUTF8Out = false;
        runningdir = "";
        outputdir = "";
        mtestdir = "";
        testSpecialProps = "";
        testJavaFlags = "";
        reportstderr = true;
        timeout = -1;
        skipsed = false;
        commonDBHome = "testCSHome";
        dbIsNew = true;
        runwithjvm = "true";
        startServer = true;
        replacePolicyFile = false;
        scriptName = "";
        testDirName = "";
        defaultPackageName = "/org/apache/derbyTesting/";
        javaPath = "org.apache.derbyTesting.";
        shutdownurl = "";
        printWriter = null;
        pwDiff = null;
        topsuitedir = "";
        topsuiteName = "";
        topreportdir = "";
        suiteName = "";
        isSuiteRun = false;
        lastTestFailed = false;
        isI18N = false;
        codeset = null;
        junitXASingle = false;
        isSed = null;
    }
}

