/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseToDdlTask;
import org.apache.ddlutils.task.TestTaskBase;
import org.apache.ddlutils.task.WriteSchemaToFileCommand;
import org.apache.tools.ant.BuildException;

public class TestWriteSchemaToFileCommand
extends TestTaskBase {
    public static Test suite() throws Exception {
        return TestWriteSchemaToFileCommand.getTests(TestWriteSchemaToFileCommand.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(DatabaseToDdlTask task, Database expectedModel) throws IOException {
        WriteSchemaToFileCommand subTask = new WriteSchemaToFileCommand();
        File tmpFile = File.createTempFile("schema", ".xml");
        try {
            subTask.setOutputFile(tmpFile);
            task.addWriteSchemaToFile(subTask);
            task.setModelName("roundtriptest");
            task.execute();
            this.assertEquals(expectedModel, new DatabaseIO().read(tmpFile), this.isUseDelimitedIdentifiers());
        }
        finally {
            if (!tmpFile.delete()) {
                this.getLog().warn((Object)("Could not delete temporary file " + tmpFile.getAbsolutePath()));
            }
        }
    }

    public void testEmptyDatabase() throws IOException {
        this.runTask(this.getDatabaseToDdlTaskInstance(), new Database("roundtriptest"));
    }

    public void testSimpleModel() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.runTask(this.getDatabaseToDdlTaskInstance(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testSimpleModelWithDelimitedIdentifiers() throws IOException {
        if (!this.isUseDelimitedIdentifiers()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='A PK' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='A Value' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='A Value' foreign='A PK'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='A PK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='A Value' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='A Value' foreign='A PK'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='A PK' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='A Value' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='A Value' foreign='A PK'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='A PK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='A Value' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='A Value' foreign='A PK'/>\n    </foreign-key>\n  </table>\n</database>");
        this.runTask(this.getDatabaseToDdlTaskInstance(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testIncludeSingleTable() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTables("roundtrip1");
        } else {
            task.setIncludeTables("ROUNDTRIP1");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>"));
    }

    public void testIncludeSingleTableWithFk() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTables("roundtrip1");
        } else {
            task.setIncludeTables("ROUNDTRIP1");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testIncludeSingleTableViaRegExp() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTableFilter("Round.*1");
        } else {
            task.setIncludeTableFilter("ROUND.*1");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>"));
    }

    public void testIncludeSingleTableWithFkViaRegExp() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTableFilter("Round.*1");
        } else {
            task.setIncludeTableFilter("ROUND.*1");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testIncludeMultipleTables() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTables("roundtrip1,roundtrip3");
        } else {
            task.setIncludeTables("ROUNDTRIP1,ROUNDTRIP3");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testIncludeMultipleTablesWithFKPointingToThem() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTables("roundtrip1,roundtrip3");
        } else {
            task.setIncludeTables("ROUNDTRIP1,ROUNDTRIP3");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testIncludeMultipleTablesViaRegExp() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTableFilter(".*trip_[1|3]");
        } else {
            task.setIncludeTableFilter(".*TRIP_[1|3]");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testIncludeMultipleTablesWithFKPointingToThemViaRegExp() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTableFilter(".*trip_*[1|3]");
        } else {
            task.setIncludeTableFilter(".*TRIP_*[1|3]");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testExcludeSingleTable() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTables("roundtrip2");
        } else {
            task.setExcludeTables("ROUNDTRIP2");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>"));
    }

    public void testExcludeSingleTableWithFk() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTables("roundtrip1");
        } else {
            task.setExcludeTables("ROUNDTRIP1");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testExcludeSingleTableViaRegExp() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTableFilter("Round.*_2");
        } else {
            task.setExcludeTableFilter("ROUND.*_2");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>"));
    }

    public void testExcludeSingleTableWithFkViaRegExp() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTableFilter("Round.*_2");
        } else {
            task.setExcludeTableFilter("ROUND.*_2");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testExcludeMultipleTables() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTables("roundtrip1,roundtrip3");
        } else {
            task.setExcludeTables("ROUNDTRIP1,ROUNDTRIP3");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>"));
    }

    public void testExcludeMultipleTablesWithFKPointingToThem() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTables("roundtrip1,roundtrip3");
        } else {
            task.setExcludeTables("ROUNDTRIP1,ROUNDTRIP3");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testExcludeMultipleTablesViaRegExp() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTableFilter(".*trip_[1|3]");
        } else {
            task.setExcludeTableFilter(".*TRIP_[1|3]");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>"));
    }

    public void testExcludeMultipleTablesWithFKPointingToThemViaRegExp() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setExcludeTableFilter(".*trip_*[1|3]");
        } else {
            task.setExcludeTableFilter(".*TRIP_*[1|3]");
        }
        try {
            this.runTask(task, this.readModelFromDatabase("roundtriptest"));
            TestWriteSchemaToFileCommand.fail();
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    public void testIncludeAndExcludeMultipleTables() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_4'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_4'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_4'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        if (this.isUseDelimitedIdentifiers()) {
            task.setIncludeTables("Roundtrip_1,Roundtrip_3,Roundtrip_4");
            task.setExcludeTables("Roundtrip_1,Roundtrip_3");
        } else {
            task.setIncludeTables("ROUNDTRIP_1,ROUNDTRIP_3,ROUNDTRIP_4");
            task.setExcludeTables("ROUNDTRIP_1,ROUNDTRIP_3");
        }
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_4'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>"));
    }

    public void testIncludeAndExcludeMultipleTablesViaRegExp() throws IOException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip4'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip4'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.setIncludeTableFilter(".*[1|2|3]");
        task.setExcludeTableFilter(".*[1|3]");
        this.runTask(task, this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>"));
    }
}

