/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.task.DatabaseToDdlTask;
import org.apache.ddlutils.task.TestTaskBase;
import org.apache.ddlutils.task.WriteDataToFileCommand;

public class TestWriteDataToFileCommand
extends TestTaskBase {
    public static Test suite() throws Exception {
        return TestWriteDataToFileCommand.getTests(TestWriteDataToFileCommand.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(DatabaseToDdlTask task, Map expectedData) throws IOException {
        WriteDataToFileCommand subTask = new WriteDataToFileCommand();
        File tmpFile = File.createTempFile("data", ".xml");
        try {
            subTask.setOutputFile(tmpFile);
            task.addWriteDataToFile(subTask);
            task.setModelName("roundtriptest");
            task.execute();
            DataReader dataReader = new DataReader();
            final HashMap readData = new HashMap();
            dataReader.setModel(this.getAdjustedModel());
            dataReader.setSink(new DataSink(){

                public void addBean(DynaBean bean) throws DataSinkException {
                    String key = ((SqlDynaClass)bean.getDynaClass()).getTableName();
                    ArrayList<DynaBean> beans = (ArrayList<DynaBean>)readData.get(key);
                    if (beans == null) {
                        beans = new ArrayList<DynaBean>();
                        readData.put(key, beans);
                    }
                    beans.add(bean);
                }

                public void end() throws DataSinkException {
                }

                public void start() throws DataSinkException {
                }
            });
            dataReader.read(tmpFile);
            TestWriteDataToFileCommand.assertEquals((String)"Not the same tables in the expected and actual data", expectedData.keySet(), readData.keySet());
        }
        finally {
            if (!tmpFile.delete()) {
                this.getLog().warn((Object)("Could not delete temporary file " + tmpFile.getAbsolutePath()));
            }
        }
    }

    public void testEmptyDatabase() throws IOException {
        this.runTask(this.getDatabaseToDdlTaskInstance(), new HashMap());
    }

    public void testSimpleModel() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        ArrayList<DynaBean> beans = new ArrayList<DynaBean>();
        beans.add(this.insertRow("roundtrip", new Object[]{"test1", new Integer(1)}));
        beans.add(this.insertRow("roundtrip", new Object[]{"test2", null}));
        HashMap<String, ArrayList<DynaBean>> expected = new HashMap<String, ArrayList<DynaBean>>();
        expected.put("roundtrip", beans);
        this.runTask(this.getDatabaseToDdlTaskInstance(), expected);
    }

    public void testComplexModel() throws IOException {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip_1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip_3'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip_3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        ArrayList<DynaBean> beans1 = new ArrayList<DynaBean>();
        ArrayList<DynaBean> beans2 = new ArrayList<DynaBean>();
        ArrayList<DynaBean> beans3 = new ArrayList<DynaBean>();
        beans1.add(this.insertRow("Roundtrip_1", new Object[]{"test1", null}));
        beans2.add(this.insertRow("Roundtrip_2", new Object[]{new Integer(3), null}));
        beans3.add(this.insertRow("Roundtrip_3", new Object[]{new Integer(1), "test1"}));
        beans2.add(this.insertRow("Roundtrip_2", new Object[]{new Integer(2), new Integer(1)}));
        beans1.add(this.insertRow("Roundtrip_1", new Object[]{"test2", new Integer(1)}));
        beans3.add(this.insertRow("Roundtrip_3", new Object[]{new Integer(3), null}));
        beans3.add(this.insertRow("Roundtrip_3", new Object[]{new Integer(4), "test2"}));
        beans1.add(this.insertRow("Roundtrip_1", new Object[]{"test3", new Integer(3)}));
        beans3.add(this.insertRow("Roundtrip_3", new Object[]{new Integer(2), "test3"}));
        beans2.add(this.insertRow("Roundtrip_2", new Object[]{new Integer(1), new Integer(2)}));
        HashMap<String, ArrayList<DynaBean>> expected = new HashMap<String, ArrayList<DynaBean>>();
        expected.put("Roundtrip_1", beans1);
        expected.put("Roundtrip_2", beans2);
        expected.put("Roundtrip_3", beans3);
        this.runTask(this.getDatabaseToDdlTaskInstance(), expected);
    }
}

