/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import junit.framework.Test;
import org.apache.ddlutils.task.DatabaseToDdlTask;
import org.apache.ddlutils.task.TestTaskBase;
import org.apache.ddlutils.task.WriteDataToDatabaseCommand;

public class TestWriteDataToDatabaseCommand
extends TestTaskBase {
    public static Test suite() throws Exception {
        return TestWriteDataToDatabaseCommand.getTests(TestWriteDataToDatabaseCommand.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(DatabaseToDdlTask task, String dataXml, boolean useBatchMode, boolean ensureFkOrder) throws IOException {
        WriteDataToDatabaseCommand subTask = new WriteDataToDatabaseCommand();
        File tmpFile = File.createTempFile("schema", ".xml");
        FileWriter writer = null;
        try {
            writer = new FileWriter(tmpFile);
            writer.write(dataXml);
            writer.close();
            subTask.setDataFile(tmpFile);
            subTask.setBatchSize(100);
            subTask.setFailOnError(true);
            subTask.setUseBatchMode(useBatchMode);
            subTask.setEnsureForeignKeyOrder(ensureFkOrder);
            task.addWriteDataToDatabase(subTask);
            task.setModelName("roundtriptest");
            task.execute();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    this.getLog().error((Object)("Could not close the writer for the temporary file " + tmpFile.getAbsolutePath()), (Throwable)ex);
                }
            }
            if (!tmpFile.delete()) {
                this.getLog().warn((Object)("Could not delete temporary file " + tmpFile.getAbsolutePath()));
            }
        }
    }

    public void testSimple() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String dataXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <roundtrip pk='val1' avalue='1'/>\n  <roundtrip pk='val2' avalue='2'/>\n  <roundtrip pk='val3' avalue='3'/>\n</data>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.runTask(this.getDatabaseToDdlTaskInstance(), "<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <roundtrip pk='val1' avalue='1'/>\n  <roundtrip pk='val2' avalue='2'/>\n  <roundtrip pk='val3' avalue='3'/>\n</data>", false, false);
        List beans = this.getRows("roundtrip", "pk");
        TestWriteDataToDatabaseCommand.assertEquals((int)3, (int)beans.size());
        this.assertEquals("val1", beans.get(0), "pk");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        this.assertEquals("val2", beans.get(1), "pk");
        this.assertEquals(new Integer(2), beans.get(1), "avalue");
        this.assertEquals("val3", beans.get(2), "pk");
        this.assertEquals(new Integer(3), beans.get(2), "avalue");
    }

    public void testBatchMode() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        StringBuilder dataXml = new StringBuilder();
        int numObjs = 2000;
        dataXml.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>");
        for (int idx = 0; idx < 2000; ++idx) {
            dataXml.append("  <roundtrip pk='val");
            dataXml.append(idx);
            dataXml.append("' avalue='");
            dataXml.append(idx);
            dataXml.append("'/>\n");
        }
        dataXml.append("</data>");
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.runTask(this.getDatabaseToDdlTaskInstance(), dataXml.toString(), true, false);
        List beans = this.getRows("roundtrip", "avalue");
        TestWriteDataToDatabaseCommand.assertEquals((int)2000, (int)beans.size());
        for (int idx = 0; idx < 2000; ++idx) {
            this.assertEquals("val" + idx, beans.get(idx), "pk");
            this.assertEquals(new Integer(idx), beans.get(idx), "avalue");
        }
    }
}

