/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import junit.framework.Test;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseToDdlTask;
import org.apache.ddlutils.task.DropTablesCommand;
import org.apache.ddlutils.task.TestTaskBase;

public class TestDropTablesCommand
extends TestTaskBase {
    public static Test suite() throws Exception {
        return TestDropTablesCommand.getTests(TestDropTablesCommand.class);
    }

    public void testEmptyDatabase() {
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testSingleTable() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testSingleTableWithAutoIncrementColumn() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testSingleTableWithIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testSingleTableWithUniqeIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testSingleTablesWithSelfReferencingFK() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testTwoTablesWithFK() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testTwoTablesWithCircularFK() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        task.addDropTables(new DropTablesCommand());
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testNamesListWithSingleName() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("roundtrip1");
        task.addDropTables(subTask);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testNamesListWithMultipleNames() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("roundtrip1,roundtrip2,roundtrip3");
        task.addDropTables(subTask);
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testNamesListWithSingleDelimitedName() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("Roundtrip 1");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testNamesListWithMultipleDelimitedNames() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("Roundtrip 2,Roundtrip 1");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testNamesListWithSingleDelimitedNameWithComma() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip, 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip, 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip, 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip, 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip, 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip, 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip, 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip, 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip, 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("Roundtrip\\, 2");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip, 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testNamesListWithSingleDelimitedNameEndingInComma() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2,'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2,'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2,'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2,'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("Roundtrip 2\\,");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testNamesListWithMultipleDelimitedNameWithCommas() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip, 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2,'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2,'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip, 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip, 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2,'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2,'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip, 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("Roundtrip\\, 1,Roundtrip 2\\,");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(new Database("roundtriptest"), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testEmptyNamesList() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTables("");
        task.addDropTables(subTask);
        task.execute();
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testSimpleRegExp() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTableFilter(".*2");
        task.addDropTables(subTask);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testRegExpInDelimitedIdentifierMode() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTableFilter(".*\\s[2|3]");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testRegExpMultipleTables() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrap3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrap3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrap3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTableFilter(".*trip.*");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrap3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testRegExpMultipleTablesInDelimitedIdentifierMode() {
        if (!this.getPlatformInfo().isDelimitedIdentifiersSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.getPlatform().setDelimitedIdentifierModeOn(true);
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip 1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='Roundtrip 2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip 2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='Roundtrip A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='Roundtrip 1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTableFilter(".*\\d");
        task.addDropTables(subTask);
        task.setUseDelimitedSqlIdentifiers(true);
        task.execute();
        this.assertEquals(this.adjustModel(this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>")), this.readModelFromDatabase("roundtriptest"), true);
    }

    public void testRegExpMatchingNothing() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTableFilter(".*\\s\\D");
        task.addDropTables(subTask);
        task.execute();
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"), false);
    }

    public void testEmptyRegExp() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        DatabaseToDdlTask task = this.getDatabaseToDdlTaskInstance();
        DropTablesCommand subTask = new DropTablesCommand();
        subTask.setTableFilter("");
        task.addDropTables(subTask);
        task.execute();
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"), false);
    }
}

