/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import org.apache.ddlutils.TestPlatformBase;

public class TestSybasePlatform
extends TestPlatformBase {
    @Override
    protected String getDatabaseName() {
        return "Sybase";
    }

    public void testColumnTypes() throws Exception {
        this.assertEqualsIgnoringWhitespaces("SET quoted_identifier on;\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'coltype')\nBEGIN\n    DROP TABLE \"coltype\"\nEND;\nSET quoted_identifier on;\nCREATE TABLE \"coltype\"\n(\n    \"COL_ARRAY\"           IMAGE NULL,\n    \"COL_BIGINT\"          DECIMAL(19,0) NULL,\n    \"COL_BINARY\"          BINARY(254) NULL,\n    \"COL_BIT\"             SMALLINT NULL,\n    \"COL_BLOB\"            IMAGE NULL,\n    \"COL_BOOLEAN\"         SMALLINT NULL,\n    \"COL_CHAR\"            CHAR(15) NULL,\n    \"COL_CLOB\"            TEXT NULL,\n    \"COL_DATALINK\"        IMAGE NULL,\n    \"COL_DATE\"            DATETIME NULL,\n    \"COL_DECIMAL\"         DECIMAL(15,3) NULL,\n    \"COL_DECIMAL_NOSCALE\" DECIMAL(15,0) NULL,\n    \"COL_DISTINCT\"        IMAGE NULL,\n    \"COL_DOUBLE\"          DOUBLE PRECISION NULL,\n    \"COL_FLOAT\"           DOUBLE PRECISION NULL,\n    \"COL_INTEGER\"         INT NULL,\n    \"COL_JAVA_OBJECT\"     IMAGE NULL,\n    \"COL_LONGVARBINARY\"   IMAGE NULL,\n    \"COL_LONGVARCHAR\"     TEXT NULL,\n    \"COL_NULL\"            IMAGE NULL,\n    \"COL_NUMERIC\"         NUMERIC(15,0) NULL,\n    \"COL_OTHER\"           IMAGE NULL,\n    \"COL_REAL\"            REAL NULL,\n    \"COL_REF\"             IMAGE NULL,\n    \"COL_SMALLINT\"        SMALLINT NULL,\n    \"COL_STRUCT\"          IMAGE NULL,\n    \"COL_TIME\"            DATETIME NULL,\n    \"COL_TIMESTAMP\"       DATETIME NULL,\n    \"COL_TINYINT\"         SMALLINT NULL,\n    \"COL_VARBINARY\"       VARBINARY(15) NULL,\n    \"COL_VARCHAR\"         VARCHAR(15) NULL\n);\n", this.getColumnTestDatabaseCreationSql());
    }

    public void testColumnConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("SET quoted_identifier on;\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'constraints')\nBEGIN\n    DROP TABLE \"constraints\"\nEND;\nSET quoted_identifier on;\nCREATE TABLE \"constraints\"\n(\n    \"COL_PK\"               VARCHAR(32) NULL,\n    \"COL_PK_AUTO_INCR\"     INT IDENTITY,\n    \"COL_NOT_NULL\"         BINARY(100) NOT NULL,\n    \"COL_NOT_NULL_DEFAULT\" DOUBLE PRECISION DEFAULT -2.0 NOT NULL,\n    \"COL_DEFAULT\"          CHAR(4) DEFAULT 'test' NULL,\n    \"COL_AUTO_INCR\"        DECIMAL(19,0) IDENTITY,\n    PRIMARY KEY (\"COL_PK\", \"COL_PK_AUTO_INCR\")\n);\n", this.getConstraintTestDatabaseCreationSql());
    }

    public void testTableConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("SET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'RI' AND name = 'testfk')\n    ALTER TABLE \"table3\" DROP CONSTRAINT \"testfk\";\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'RI' AND name = 'table2_FK_COL_L_FK_2_table1')\n    ALTER TABLE \"table2\" DROP CONSTRAINT \"table2_FK_COL_L_FK_2_table1\";\nSET quoted_identifier on;\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'table3')\nBEGIN\n    DROP TABLE \"table3\"\nEND;\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'table2')\nBEGIN\n    DROP TABLE \"table2\"\nEND;\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'table1')\nBEGIN\n    DROP TABLE \"table1\"\nEND;\nSET quoted_identifier on;\nCREATE TABLE \"table1\"\n(\n    \"COL_PK_1\"    VARCHAR(32) NOT NULL,\n    \"COL_PK_2\"    INT NULL,\n    \"COL_INDEX_1\" BINARY(100) NOT NULL,\n    \"COL_INDEX_2\" DOUBLE PRECISION NOT NULL,\n    \"COL_INDEX_3\" CHAR(4) NULL,\n    PRIMARY KEY (\"COL_PK_1\", \"COL_PK_2\")\n);\nCREATE INDEX \"testindex1\" ON \"table1\" (\"COL_INDEX_2\");\nCREATE UNIQUE INDEX \"testindex2\" ON \"table1\" (\"COL_INDEX_3\", \"COL_INDEX_1\");\nSET quoted_identifier on;\nCREATE TABLE \"table2\"\n(\n    \"COL_PK\"   INT NULL,\n    \"COL_FK_1\" INT NULL,\n    \"COL_FK_2\" VARCHAR(32) NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nSET quoted_identifier on;\nCREATE TABLE \"table3\"\n(\n    \"COL_PK\" VARCHAR(16) NULL,\n    \"COL_FK\" INT NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nALTER TABLE \"table2\" ADD CONSTRAINT \"table2_FK_COL_L_FK_2_table1\" FOREIGN KEY (\"COL_FK_1\", \"COL_FK_2\") REFERENCES \"table1\" (\"COL_PK_2\", \"COL_PK_1\");\nALTER TABLE \"table3\" ADD CONSTRAINT \"testfk\" FOREIGN KEY (\"COL_FK\") REFERENCES \"table2\" (\"COL_PK\");\n", this.getTableConstraintTestDatabaseCreationSql());
    }

    public void testCharacterEscaping() throws Exception {
        this.assertEqualsIgnoringWhitespaces("SET quoted_identifier on;\nSET quoted_identifier on;\nIF EXISTS (SELECT 1 FROM sysobjects WHERE type = 'U' AND name = 'escapedcharacters')\nBEGIN\n    DROP TABLE \"escapedcharacters\"\nEND;\nSET quoted_identifier on;\nCREATE TABLE \"escapedcharacters\"\n(\n    \"COL_PK\"   INT NULL,\n    \"COL_TEXT\" VARCHAR(128) DEFAULT '''' NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\n", this.getCharEscapingTestDatabaseCreationSql());
    }
}

