/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import java.util.HashMap;
import org.apache.ddlutils.TestBase;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.platform.TestPlatform;

public class TestSqlBuilder
extends TestBase {
    public void testUpdateSql1() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='id' autoIncrement='true' type='INTEGER' primaryKey='true'/>\n    <column name='name' type='VARCHAR' size='15'/>\n  </table>\n</database>";
        TestPlatform platform = new TestPlatform();
        SqlBuilder sqlBuilder = platform.getSqlBuilder();
        Database database = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='id' autoIncrement='true' type='INTEGER' primaryKey='true'/>\n    <column name='name' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "ddlutils");
        map.put("id", new Integer(0));
        platform.setDelimitedIdentifierModeOn(true);
        String sql = sqlBuilder.getUpdateSql(database.getTable(0), map, false);
        TestSqlBuilder.assertEquals((String)"UPDATE \"TestTable\" SET \"name\" = 'ddlutils' WHERE \"id\" = '0'", (String)sql);
    }

    public void testUpdateSql2() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='id' autoIncrement='true' type='INTEGER' primaryKey='true'/>\n    <column name='name' type='VARCHAR' size='15'/>\n  </table>\n</database>";
        TestPlatform platform = new TestPlatform();
        SqlBuilder sqlBuilder = platform.getSqlBuilder();
        Database database = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='id' autoIncrement='true' type='INTEGER' primaryKey='true'/>\n    <column name='name' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        HashMap<String, Integer> oldMap = new HashMap<String, Integer>();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        oldMap.put("id", new Integer(0));
        newMap.put("name", "ddlutils");
        newMap.put("id", new Integer(1));
        platform.setDelimitedIdentifierModeOn(true);
        String sql = sqlBuilder.getUpdateSql(database.getTable(0), oldMap, newMap, false);
        TestSqlBuilder.assertEquals((String)"UPDATE \"TestTable\" SET \"id\" = '1', \"name\" = 'ddlutils' WHERE \"id\" = '0'", (String)sql);
    }
}

