/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import org.apache.ddlutils.TestPlatformBase;

public class TestPostgresqlPlatform
extends TestPlatformBase {
    @Override
    protected String getDatabaseName() {
        return "PostgreSql";
    }

    public void testColumnTypes() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"coltype\" CASCADE;\nCREATE TABLE \"coltype\"\n(\n    \"COL_ARRAY\"           BYTEA,\n    \"COL_BIGINT\"          BIGINT,\n    \"COL_BINARY\"          BYTEA,\n    \"COL_BIT\"             BOOLEAN,\n    \"COL_BLOB\"            BYTEA,\n    \"COL_BOOLEAN\"         BOOLEAN,\n    \"COL_CHAR\"            CHAR(15),\n    \"COL_CLOB\"            TEXT,\n    \"COL_DATALINK\"        BYTEA,\n    \"COL_DATE\"            DATE,\n    \"COL_DECIMAL\"         NUMERIC(15,3),\n    \"COL_DECIMAL_NOSCALE\" NUMERIC(15,0),\n    \"COL_DISTINCT\"        BYTEA,\n    \"COL_DOUBLE\"          DOUBLE PRECISION,\n    \"COL_FLOAT\"           DOUBLE PRECISION,\n    \"COL_INTEGER\"         INTEGER,\n    \"COL_JAVA_OBJECT\"     BYTEA,\n    \"COL_LONGVARBINARY\"   BYTEA,\n    \"COL_LONGVARCHAR\"     TEXT,\n    \"COL_NULL\"            BYTEA,\n    \"COL_NUMERIC\"         NUMERIC(15,0),\n    \"COL_OTHER\"           BYTEA,\n    \"COL_REAL\"            REAL,\n    \"COL_REF\"             BYTEA,\n    \"COL_SMALLINT\"        SMALLINT,\n    \"COL_STRUCT\"          BYTEA,\n    \"COL_TIME\"            TIME,\n    \"COL_TIMESTAMP\"       TIMESTAMP,\n    \"COL_TINYINT\"         SMALLINT,\n    \"COL_VARBINARY\"       BYTEA,\n    \"COL_VARCHAR\"         VARCHAR(15)\n);\n", this.getColumnTestDatabaseCreationSql());
    }

    public void testColumnConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"constraints\" CASCADE;\nDROP SEQUENCE \"constraints_COL_K_AUTO_INCR_seq\";\nDROP SEQUENCE \"constraints_COL_AUTO_INCR_seq\";\nCREATE SEQUENCE \"constraints_COL_K_AUTO_INCR_seq\";\nCREATE SEQUENCE \"constraints_COL_AUTO_INCR_seq\";\nCREATE TABLE \"constraints\"\n(\n    \"COL_PK\"               VARCHAR(32),\n    \"COL_PK_AUTO_INCR\"     INTEGER UNIQUE DEFAULT nextval('\"constraints_COL_K_AUTO_INCR_seq\"'),\n    \"COL_NOT_NULL\"         BYTEA NOT NULL,\n    \"COL_NOT_NULL_DEFAULT\" DOUBLE PRECISION DEFAULT -2.0 NOT NULL,\n    \"COL_DEFAULT\"          CHAR(4) DEFAULT 'test',\n    \"COL_AUTO_INCR\"        BIGINT UNIQUE DEFAULT nextval('\"constraints_COL_AUTO_INCR_seq\"'),\n    PRIMARY KEY (\"COL_PK\", \"COL_PK_AUTO_INCR\")\n);\n", this.getConstraintTestDatabaseCreationSql());
    }

    public void testTableConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"table3\" DROP CONSTRAINT \"testfk\";\nALTER TABLE \"table2\" DROP CONSTRAINT \"table2_FK_COL_F_COL_FK_2_table1\";\nDROP TABLE \"table3\" CASCADE;\nDROP TABLE \"table2\" CASCADE;\nDROP TABLE \"table1\" CASCADE;\nCREATE TABLE \"table1\"\n(\n    \"COL_PK_1\"    VARCHAR(32) NOT NULL,\n    \"COL_PK_2\"    INTEGER,\n    \"COL_INDEX_1\" BYTEA NOT NULL,\n    \"COL_INDEX_2\" DOUBLE PRECISION NOT NULL,\n    \"COL_INDEX_3\" CHAR(4),\n    PRIMARY KEY (\"COL_PK_1\", \"COL_PK_2\")\n);\nCREATE INDEX \"testindex1\" ON \"table1\" (\"COL_INDEX_2\");\nCREATE UNIQUE INDEX \"testindex2\" ON \"table1\" (\"COL_INDEX_3\", \"COL_INDEX_1\");\nCREATE TABLE \"table2\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_FK_1\" INTEGER,\n    \"COL_FK_2\" VARCHAR(32) NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nCREATE TABLE \"table3\"\n(\n    \"COL_PK\" VARCHAR(16),\n    \"COL_FK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nALTER TABLE \"table2\" ADD CONSTRAINT \"table2_FK_COL_F_COL_FK_2_table1\" FOREIGN KEY (\"COL_FK_1\", \"COL_FK_2\") REFERENCES \"table1\" (\"COL_PK_2\", \"COL_PK_1\");\nALTER TABLE \"table3\" ADD CONSTRAINT \"testfk\" FOREIGN KEY (\"COL_FK\") REFERENCES \"table2\" (\"COL_PK\");\n", this.getTableConstraintTestDatabaseCreationSql());
    }

    public void testCharacterEscaping() throws Exception {
        String schema = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='escapetest'>\n  <table name='escapedcharacters'>\n    <column name='COL_PK' type='INTEGER' primaryKey='true'/>\n    <column name='COL_TEXT' type='VARCHAR' size='128' default='&#39; &#09; &#10; &#13; \\'/>\n  </table>\n</database>";
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"escapedcharacters\" CASCADE;\nCREATE TABLE \"escapedcharacters\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_TEXT\" VARCHAR(128) DEFAULT '\\' \\t \\n \\r \\\\',\n    PRIMARY KEY (\"COL_PK\")\n);\n", this.getDatabaseCreationSql("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='escapetest'>\n  <table name='escapedcharacters'>\n    <column name='COL_PK' type='INTEGER' primaryKey='true'/>\n    <column name='COL_TEXT' type='VARCHAR' size='128' default='&#39; &#09; &#10; &#13; \\'/>\n  </table>\n</database>"));
    }
}

