/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import junit.framework.TestCase;
import org.apache.ddlutils.PlatformUtils;

public class TestPlatformUtils
extends TestCase {
    private PlatformUtils _platformUtils;

    protected void setUp() throws Exception {
        this._platformUtils = new PlatformUtils();
    }

    protected void tearDown() throws Exception {
        this._platformUtils = null;
    }

    public void testAxionDriver() {
        TestPlatformUtils.assertEquals((String)"Axion", (String)this._platformUtils.determineDatabaseType("org.axiondb.jdbc.AxionDriver", null));
    }

    public void testAxionUrl() {
        TestPlatformUtils.assertEquals((String)"Axion", (String)this._platformUtils.determineDatabaseType(null, "jdbc:axiondb:testdb"));
        TestPlatformUtils.assertEquals((String)"Axion", (String)this._platformUtils.determineDatabaseType(null, "jdbc:axiondb:testdb:/tmp/testdbdir"));
    }

    public void testDb2Driver() {
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType("com.ibm.db2.jcc.DB2Driver", null));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType("COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver", null));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType("COM.ibm.db2.jdbc.app.DB2Driver", null));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType("com.ddtek.jdbc.db2.DB2Driver", null));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType("com.inet.drda.DRDADriver", null));
    }

    public void testDb2Url() {
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType(null, "jdbc:db2://sysmvs1.stl.ibm.com:5021/san_jose"));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType(null, "jdbc:db2os390://sysmvs1.stl.ibm.com:5021/san_jose"));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType(null, "jdbc:db2os390sqlj://sysmvs1.stl.ibm.com:5021/san_jose"));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType(null, "jdbc:datadirect:db2://server1:50000;DatabaseName=jdbc;User=test;Password=secret"));
        TestPlatformUtils.assertEquals((String)"DB2", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetdb2://server1:50000"));
    }

    public void testCloudscapeUrl() {
        TestPlatformUtils.assertEquals((String)"Cloudscape", (String)this._platformUtils.determineDatabaseType(null, "jdbc:db2j:net:database"));
        TestPlatformUtils.assertEquals((String)"Cloudscape", (String)this._platformUtils.determineDatabaseType(null, "jdbc:cloudscape:net:database"));
    }

    public void testDerbyDriver() {
        TestPlatformUtils.assertEquals((String)"Derby", (String)this._platformUtils.determineDatabaseType("org.apache.derby.jdbc.ClientDriver", null));
        TestPlatformUtils.assertEquals((String)"Derby", (String)this._platformUtils.determineDatabaseType("org.apache.derby.jdbc.EmbeddedDriver", null));
    }

    public void testDerbyUrl() {
        TestPlatformUtils.assertEquals((String)"Derby", (String)this._platformUtils.determineDatabaseType(null, "jdbc:derby:sample"));
    }

    public void testFirebirdDriver() {
        TestPlatformUtils.assertEquals((String)"Firebird", (String)this._platformUtils.determineDatabaseType("org.firebirdsql.jdbc.FBDriver", null));
    }

    public void testFirebirdUrl() {
        TestPlatformUtils.assertEquals((String)"Firebird", (String)this._platformUtils.determineDatabaseType(null, "jdbc:firebirdsql://localhost:8080/path/to/db.fdb"));
        TestPlatformUtils.assertEquals((String)"Firebird", (String)this._platformUtils.determineDatabaseType(null, "jdbc:firebirdsql:native:localhost/8080:/path/to/db.fdb"));
        TestPlatformUtils.assertEquals((String)"Firebird", (String)this._platformUtils.determineDatabaseType(null, "jdbc:firebirdsql:local://localhost:8080:/path/to/db.fdb"));
        TestPlatformUtils.assertEquals((String)"Firebird", (String)this._platformUtils.determineDatabaseType(null, "jdbc:firebirdsql:embedded:localhost/8080:/path/to/db.fdb"));
    }

    public void testHsqldbDriver() {
        TestPlatformUtils.assertEquals((String)"HsqlDb", (String)this._platformUtils.determineDatabaseType("org.hsqldb.jdbcDriver", null));
    }

    public void testHsqldbUrl() {
        TestPlatformUtils.assertEquals((String)"HsqlDb", (String)this._platformUtils.determineDatabaseType(null, "jdbc:hsqldb:/opt/db/testdb"));
    }

    public void testInterbaseDriver() {
        TestPlatformUtils.assertEquals((String)"Interbase", (String)this._platformUtils.determineDatabaseType("interbase.interclient.Driver", null));
    }

    public void testInterbaseUrl() {
        TestPlatformUtils.assertEquals((String)"Interbase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:interbase://localhost/e:/testbed/database/employee.gdb"));
    }

    public void testMckoiDriver() {
        TestPlatformUtils.assertEquals((String)"McKoi", (String)this._platformUtils.determineDatabaseType("com.mckoi.JDBCDriver", null));
    }

    public void testMckoiUrl() {
        TestPlatformUtils.assertEquals((String)"McKoi", (String)this._platformUtils.determineDatabaseType(null, "jdbc:mckoi:local://./db.conf"));
        TestPlatformUtils.assertEquals((String)"McKoi", (String)this._platformUtils.determineDatabaseType(null, "jdbc:mckoi://db.myhost.org/"));
    }

    public void testMsSqlDriver() {
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType("com.microsoft.jdbc.sqlserver.SQLServerDriver", null));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType("com.ddtek.jdbc.sqlserver.SQLServerDriver", null));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType("com.jnetdirect.jsql.JSQLDriver", null));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType("com.inet.tds.TdsDriver", null));
    }

    public void testMsSqlUrl() {
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:microsoft:sqlserver://localhost:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:datadirect:sqlserver://server1:1433;User=test;Password=secret"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:JSQLConnect://localhost/database=master/user=sa/sqlVersion=6"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetdae:210.1.164.19:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetdae6:[2002:d201:a413::d201:a413]:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetdae7:localHost:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetdae7a://MyServer/pipe/sql/query"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:inetdae:210.1.164.19:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:inetdae6:[2002:d201:a413::d201:a413]:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:inetdae7:localHost:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:inetdae7a://MyServer/pipe/sql/query"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:jdbc:inetdae:210.1.164.19:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:jdbc:inetdae6:[2002:d201:a413::d201:a413]:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:jdbc:inetdae7:localHost:1433"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:jdbc:inetdae7a://MyServer/pipe/sql/query"));
        TestPlatformUtils.assertEquals((String)"MsSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:jtds:sqlserver://localhost:8080/test"));
    }

    public void testMySqlDriver() {
        TestPlatformUtils.assertEquals((String)"MySQL", (String)this._platformUtils.determineDatabaseType("com.mysql.jdbc.Driver", null));
        TestPlatformUtils.assertEquals((String)"MySQL", (String)this._platformUtils.determineDatabaseType("org.gjt.mm.mysql.Driver", null));
    }

    public void testMySqlUrl() {
        TestPlatformUtils.assertEquals((String)"MySQL", (String)this._platformUtils.determineDatabaseType(null, "jdbc:mysql://localhost:1234/test"));
    }

    public void testOracleDriver() {
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType("oracle.jdbc.driver.OracleDriver", null));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType("oracle.jdbc.dnlddriver.OracleDriver", null));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType("com.ddtek.jdbc.oracle.OracleDriver", null));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType("com.inet.ora.OraDriver", null));
    }

    public void testOracleUrl() {
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType(null, "jdbc:oracle:thin:@myhost:1521:orcl"));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType(null, "jdbc:oracle:oci8:@(description=(address=(host=myhost)(protocol=tcp)(port=1521))(connect_data=(sid=orcl)))"));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType(null, "jdbc:oracle:dnldthin:@myhost:1521:orcl"));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType(null, "jdbc:oracle:dnldthin:@myhost:1521:orcl"));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType(null, "jdbc:datadirect:oracle://server3:1521;ServiceName=ORCL;User=test;Password=secret"));
        TestPlatformUtils.assertEquals((String)"Oracle", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetora:www.inetsoftware.de:1521:orcl?traceLevel=2"));
    }

    public void testPostgreSqlDriver() {
        TestPlatformUtils.assertEquals((String)"PostgreSql", (String)this._platformUtils.determineDatabaseType("org.postgresql.Driver", null));
    }

    public void testPostgreSqlUrl() {
        TestPlatformUtils.assertEquals((String)"PostgreSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:postgresql://localhost:1234/test"));
        TestPlatformUtils.assertEquals((String)"PostgreSql", (String)this._platformUtils.determineDatabaseType(null, "jdbc:postgresql://[::1]:5740/accounting"));
    }

    public void testSapDbDriver() {
        TestPlatformUtils.assertEquals((String)"SapDB", (String)this._platformUtils.determineDatabaseType("com.sap.dbtech.jdbc.DriverSapDB", null));
    }

    public void testSapDbUrl() {
        TestPlatformUtils.assertEquals((String)"SapDB", (String)this._platformUtils.determineDatabaseType(null, "jdbc:sapdb://servermachine:9876/TST"));
    }

    public void testSybaseDriver() {
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType("com.sybase.jdbc.SybDriver", null));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType("com.sybase.jdbc2.jdbc.SybDriver", null));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType("com.ddtek.jdbc.sybase.SybaseDriver", null));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType("com.inet.syb.SybDriver", null));
    }

    public void testSybaseUrl() {
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:sybase:Tds:xyz:3767orjdbc:sybase:Tds:130.214.90.27:3767"));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:datadirect:sybase://server2:5000;User=test;Password=secret"));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetsyb:www.inetsoftware.de:3333"));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:inetsyb:www.inetsoftware.de:3333"));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:inetpool:jdbc:inetsyb:www.inetsoftware.de:3333"));
        TestPlatformUtils.assertEquals((String)"Sybase", (String)this._platformUtils.determineDatabaseType(null, "jdbc:jtds:sybase://localhost:8080/test"));
    }
}

