/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import org.apache.ddlutils.TestPlatformBase;

public class TestOracle8Platform
extends TestPlatformBase {
    @Override
    protected String getDatabaseName() {
        return "Oracle";
    }

    public void testColumnTypes() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"coltype\" CASCADE CONSTRAINTS;\nCREATE TABLE \"coltype\"\n(\n    \"COL_ARRAY\"           BLOB,\n    \"COL_BIGINT\"          NUMBER(38),\n    \"COL_BINARY\"          RAW(254),\n    \"COL_BIT\"             NUMBER(1),\n    \"COL_BLOB\"            BLOB,\n    \"COL_BOOLEAN\"         NUMBER(1),\n    \"COL_CHAR\"            CHAR(15),\n    \"COL_CLOB\"            CLOB,\n    \"COL_DATALINK\"        BLOB,\n    \"COL_DATE\"            DATE,\n    \"COL_DECIMAL\"         NUMBER(15,3),\n    \"COL_DECIMAL_NOSCALE\" NUMBER(15,0),\n    \"COL_DISTINCT\"        BLOB,\n    \"COL_DOUBLE\"          DOUBLE PRECISION,\n    \"COL_FLOAT\"           FLOAT,\n    \"COL_INTEGER\"         INTEGER,\n    \"COL_JAVA_OBJECT\"     BLOB,\n    \"COL_LONGVARBINARY\"   BLOB,\n    \"COL_LONGVARCHAR\"     CLOB,\n    \"COL_NULL\"            BLOB,\n    \"COL_NUMERIC\"         NUMBER(15,0),\n    \"COL_OTHER\"           BLOB,\n    \"COL_REAL\"            REAL,\n    \"COL_REF\"             BLOB,\n    \"COL_SMALLINT\"        NUMBER(5),\n    \"COL_STRUCT\"          BLOB,\n    \"COL_TIME\"            DATE,\n    \"COL_TIMESTAMP\"       DATE,\n    \"COL_TINYINT\"         NUMBER(3),\n    \"COL_VARBINARY\"       RAW(15),\n    \"COL_VARCHAR\"         VARCHAR2(15)\n);\n", this.getColumnTestDatabaseCreationSql());
    }

    public void testColumnConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TRIGGER \"trg_constraints_L_PK_AUTO_INCR\";\nDROP SEQUENCE \"seq_constraints_L_PK_AUTO_INCR\";\nDROP TRIGGER \"trg_constraints_COL_AUTO_INCR\";\nDROP SEQUENCE \"seq_constraints_COL_AUTO_INCR\";\nDROP TABLE \"constraints\" CASCADE CONSTRAINTS;\nCREATE SEQUENCE \"seq_constraints_L_PK_AUTO_INCR\";\nCREATE SEQUENCE \"seq_constraints_COL_AUTO_INCR\";\nCREATE TABLE \"constraints\"\n(\n    \"COL_PK\"               VARCHAR2(32),\n    \"COL_PK_AUTO_INCR\"     INTEGER,\n    \"COL_NOT_NULL\"         RAW(100) NOT NULL,\n    \"COL_NOT_NULL_DEFAULT\" DOUBLE PRECISION DEFAULT -2.0 NOT NULL,\n    \"COL_DEFAULT\"          CHAR(4) DEFAULT 'test',\n    \"COL_AUTO_INCR\"        NUMBER(38),\n    PRIMARY KEY (\"COL_PK\", \"COL_PK_AUTO_INCR\")\n);\nCREATE OR REPLACE TRIGGER \"trg_constraints_L_PK_AUTO_INCR\" BEFORE INSERT ON \"constraints\" FOR EACH ROW WHEN (new.\"COL_PK_AUTO_INCR\" IS NULL)\nBEGIN SELECT \"seq_constraints_L_PK_AUTO_INCR\".nextval INTO :new.\"COL_PK_AUTO_INCR\" FROM dual; END;;\nCREATE OR REPLACE TRIGGER \"trg_constraints_COL_AUTO_INCR\" BEFORE INSERT ON \"constraints\" FOR EACH ROW WHEN (new.\"COL_AUTO_INCR\" IS NULL)\nBEGIN SELECT \"seq_constraints_COL_AUTO_INCR\".nextval INTO :new.\"COL_AUTO_INCR\" FROM dual; END;;\n", this.getConstraintTestDatabaseCreationSql());
    }

    public void testTableConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"table3\" CASCADE CONSTRAINTS;\nDROP TABLE \"table2\" CASCADE CONSTRAINTS;\nDROP TABLE \"table1\" CASCADE CONSTRAINTS;\nCREATE TABLE \"table1\"\n(\n    \"COL_PK_1\"    VARCHAR2(32) NOT NULL,\n    \"COL_PK_2\"    INTEGER,\n    \"COL_INDEX_1\" RAW(100) NOT NULL,\n    \"COL_INDEX_2\" DOUBLE PRECISION NOT NULL,\n    \"COL_INDEX_3\" CHAR(4),\n    PRIMARY KEY (\"COL_PK_1\", \"COL_PK_2\")\n);\nCREATE INDEX \"testindex1\" ON \"table1\" (\"COL_INDEX_2\");\nCREATE UNIQUE INDEX \"testindex2\" ON \"table1\" (\"COL_INDEX_3\", \"COL_INDEX_1\");\nCREATE TABLE \"table2\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_FK_1\" INTEGER,\n    \"COL_FK_2\" VARCHAR2(32) NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nCREATE TABLE \"table3\"\n(\n    \"COL_PK\" VARCHAR2(16),\n    \"COL_FK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nALTER TABLE \"table2\" ADD CONSTRAINT \"table2_FK_COL_F_OL_FK_2_table1\" FOREIGN KEY (\"COL_FK_1\", \"COL_FK_2\") REFERENCES \"table1\" (\"COL_PK_2\", \"COL_PK_1\");\nALTER TABLE \"table3\" ADD CONSTRAINT \"testfk\" FOREIGN KEY (\"COL_FK\") REFERENCES \"table2\" (\"COL_PK\");\n", this.getTableConstraintTestDatabaseCreationSql());
    }

    public void testCharacterEscaping() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"escapedcharacters\" CASCADE CONSTRAINTS;\nCREATE TABLE \"escapedcharacters\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_TEXT\" VARCHAR2(128) DEFAULT '''',\n    PRIMARY KEY (\"COL_PK\")\n);\n", this.getCharEscapingTestDatabaseCreationSql());
    }
}

