/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import org.apache.ddlutils.TestPlatformBase;

public class TestGemFireXDPlatform
extends TestPlatformBase {
    @Override
    protected String getDatabaseName() {
        return "GemFireXD";
    }

    public void testColumnTypes() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"coltype\";\nCREATE TABLE \"coltype\"\n(\n    \"COL_ARRAY\"           BLOB,\n    \"COL_BIGINT\"          BIGINT,\n    \"COL_BINARY\"          CHAR(254) FOR BIT DATA,\n    \"COL_BIT\"             SMALLINT,\n    \"COL_BLOB\"            BLOB,\n    \"COL_BOOLEAN\"         SMALLINT,\n    \"COL_CHAR\"            CHAR(15),\n    \"COL_CLOB\"            CLOB,\n    \"COL_DATALINK\"        LONG VARCHAR FOR BIT DATA,\n    \"COL_DATE\"            DATE,\n    \"COL_DECIMAL\"         DECIMAL(15,3),\n    \"COL_DECIMAL_NOSCALE\" DECIMAL(15,0),\n    \"COL_DISTINCT\"        BLOB,\n    \"COL_DOUBLE\"          DOUBLE,\n    \"COL_FLOAT\"           DOUBLE,\n    \"COL_INTEGER\"         INTEGER,\n    \"COL_JAVA_OBJECT\"     BLOB,\n    \"COL_LONGVARBINARY\"   LONG VARCHAR FOR BIT DATA,\n    \"COL_LONGVARCHAR\"     LONG VARCHAR,\n    \"COL_NULL\"            LONG VARCHAR FOR BIT DATA,\n    \"COL_NUMERIC\"         NUMERIC(15,0),\n    \"COL_OTHER\"           BLOB,\n    \"COL_REAL\"            REAL,\n    \"COL_REF\"             LONG VARCHAR FOR BIT DATA,\n    \"COL_SMALLINT\"        SMALLINT,\n    \"COL_STRUCT\"          BLOB,\n    \"COL_TIME\"            TIME,\n    \"COL_TIMESTAMP\"       TIMESTAMP,\n    \"COL_TINYINT\"         SMALLINT,\n    \"COL_VARBINARY\"       VARCHAR(15) FOR BIT DATA,\n    \"COL_VARCHAR\"         VARCHAR(15)\n);\n", this.getColumnTestDatabaseCreationSql());
    }

    public void testColumnConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"constraints\";\nCREATE TABLE \"constraints\"\n(\n    \"COL_PK\"               VARCHAR(32),\n    \"COL_PK_AUTO_INCR\"     INTEGER GENERATED BY DEFAULT AS IDENTITY,\n    \"COL_NOT_NULL\"         CHAR(100) FOR BIT DATA NOT NULL,\n    \"COL_NOT_NULL_DEFAULT\" DOUBLE DEFAULT -2.0 NOT NULL,\n    \"COL_DEFAULT\"          CHAR(4) DEFAULT 'test',\n    \"COL_AUTO_INCR\"        BIGINT GENERATED BY DEFAULT AS IDENTITY,\n    PRIMARY KEY (\"COL_PK\", \"COL_PK_AUTO_INCR\")\n);\n", this.getConstraintTestDatabaseCreationSql());
    }

    public void testTableConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"table3\" DROP CONSTRAINT \"testfk\";\nALTER TABLE \"table2\" DROP CONSTRAINT \"table2_FK_COL_FK_1_COL_FK_2_table1\";\nDROP TABLE \"table3\";\nDROP TABLE \"table2\";\nDROP TABLE \"table1\";\nCREATE TABLE \"table1\"\n(\n    \"COL_PK_1\"    VARCHAR(32) NOT NULL,\n    \"COL_PK_2\"    INTEGER,\n    \"COL_INDEX_1\" CHAR(100) FOR BIT DATA NOT NULL,\n    \"COL_INDEX_2\" DOUBLE NOT NULL,\n    \"COL_INDEX_3\" CHAR(4),\n    PRIMARY KEY (\"COL_PK_1\", \"COL_PK_2\")\n);\nCREATE INDEX \"table1_testindex1\" ON \"table1\" (\"COL_INDEX_2\");\nCREATE UNIQUE INDEX \"table1_testindex2\" ON \"table1\" (\"COL_INDEX_3\", \"COL_INDEX_1\");\nCREATE TABLE \"table2\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_FK_1\" INTEGER,\n    \"COL_FK_2\" VARCHAR(32) NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nCREATE TABLE \"table3\"\n(\n    \"COL_PK\" VARCHAR(16),\n    \"COL_FK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nALTER TABLE \"table2\" ADD CONSTRAINT \"table2_FK_COL_FK_1_COL_FK_2_table1\"   FOREIGN KEY (\"COL_FK_1\", \"COL_FK_2\")   REFERENCES \"table1\" (\"COL_PK_2\", \"COL_PK_1\");\nALTER TABLE \"table3\" ADD CONSTRAINT \"testfk\"   FOREIGN KEY (\"COL_FK\") REFERENCES \"table2\" (\"COL_PK\");\n", this.getTableConstraintTestDatabaseCreationSql());
    }

    public void testCharacterEscaping() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"escapedcharacters\";\nCREATE TABLE \"escapedcharacters\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_TEXT\" VARCHAR(128) DEFAULT '''',\n    PRIMARY KEY (\"COL_PK\")\n);\n", this.getCharEscapingTestDatabaseCreationSql());
    }
}

