/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.platform;

import org.apache.ddlutils.TestPlatformBase;

public class TestFirebirdPlatform
extends TestPlatformBase {
    @Override
    protected String getDatabaseName() {
        return "Firebird";
    }

    public void testColumnTypes() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"coltype\";\nCREATE TABLE \"coltype\"\n(\n    \"COL_ARRAY\"           BLOB ,\n    \"COL_BIGINT\"          BIGINT,\n    \"COL_BINARY\"          BLOB,\n    \"COL_BIT\"             SMALLINT,\n    \"COL_BLOB\"            BLOB ,\n    \"COL_BOOLEAN\"         SMALLINT,\n    \"COL_CHAR\"            CHAR(15),\n    \"COL_CLOB\"            BLOB SUB_TYPE TEXT,\n    \"COL_DATALINK\"        BLOB,\n    \"COL_DATE\"            DATE,\n    \"COL_DECIMAL\"         DECIMAL(15,3),\n    \"COL_DECIMAL_NOSCALE\" DECIMAL(15,0),\n    \"COL_DISTINCT\"        BLOB,\n    \"COL_DOUBLE\"          DOUBLE PRECISION,\n    \"COL_FLOAT\"           DOUBLE PRECISION,\n    \"COL_INTEGER\"         INTEGER,\n    \"COL_JAVA_OBJECT\"     BLOB,\n    \"COL_LONGVARBINARY\"   BLOB,\n    \"COL_LONGVARCHAR\"     BLOB SUB_TYPE TEXT,\n    \"COL_NULL\"            BLOB,\n    \"COL_NUMERIC\"         NUMERIC(15,0),\n    \"COL_OTHER\"           BLOB,\n    \"COL_REAL\"            FLOAT,\n    \"COL_REF\"             BLOB,\n    \"COL_SMALLINT\"        SMALLINT,\n    \"COL_STRUCT\"          BLOB,\n    \"COL_TIME\"            TIME,\n    \"COL_TIMESTAMP\"       TIMESTAMP,\n    \"COL_TINYINT\"         SMALLINT,\n    \"COL_VARBINARY\"       BLOB(15),\n    \"COL_VARCHAR\"         VARCHAR(15)\n);\n", this.getColumnTestDatabaseCreationSql());
    }

    public void testColumnConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TRIGGER \"trg_constraints_OL_PK_AUTO_INCR\";\nDROP GENERATOR \"gen_constraints_OL_PK_AUTO_INCR\";\nDROP TRIGGER \"trg_constraints_COL_AUTO_INCR\";\nDROP GENERATOR \"gen_constraints_COL_AUTO_INCR\";\nDROP TABLE \"constraints\";\nCREATE TABLE \"constraints\"\n(\n    \"COL_PK\"               VARCHAR(32),\n    \"COL_PK_AUTO_INCR\"     INTEGER,\n    \"COL_NOT_NULL\"         BLOB(100) NOT NULL,\n    \"COL_NOT_NULL_DEFAULT\" DOUBLE PRECISION DEFAULT -2.0 NOT NULL,\n    \"COL_DEFAULT\"          CHAR(4) DEFAULT 'test',\n    \"COL_AUTO_INCR\"        BIGINT,\n    PRIMARY KEY (\"COL_PK\", \"COL_PK_AUTO_INCR\")\n);\nCREATE GENERATOR \"gen_constraints_OL_PK_AUTO_INCR\";\nCREATE TRIGGER \"trg_constraints_OL_PK_AUTO_INCR\" FOR \"constraints\"\nACTIVE BEFORE INSERT POSITION 0 AS\nBEGIN IF (NEW.\"COL_PK_AUTO_INCR\" IS NULL) THEN NEW.\"COL_PK_AUTO_INCR\" = GEN_ID(\"gen_constraints_OL_PK_AUTO_INCR\", 1); END;\nCREATE GENERATOR \"gen_constraints_COL_AUTO_INCR\";\nCREATE TRIGGER \"trg_constraints_COL_AUTO_INCR\" FOR \"constraints\"\nACTIVE BEFORE INSERT POSITION 0 AS\nBEGIN IF (NEW.\"COL_AUTO_INCR\" IS NULL) THEN NEW.\"COL_AUTO_INCR\" = GEN_ID(\"gen_constraints_COL_AUTO_INCR\", 1); END;\n", this.getConstraintTestDatabaseCreationSql());
    }

    public void testTableConstraints() throws Exception {
        this.assertEqualsIgnoringWhitespaces("ALTER TABLE \"table3\" DROP CONSTRAINT \"testfk\";\nALTER TABLE \"table2\" DROP CONSTRAINT \"table2_FK_COL_F_COL_FK_2_table1\";\nDROP TABLE \"table3\";\nDROP TABLE \"table2\";\nDROP TABLE \"table1\";\nCREATE TABLE \"table1\"\n(\n    \"COL_PK_1\"    VARCHAR(32) NOT NULL,\n    \"COL_PK_2\"    INTEGER,\n    \"COL_INDEX_1\" BLOB(100) NOT NULL,\n    \"COL_INDEX_2\" DOUBLE PRECISION NOT NULL,\n    \"COL_INDEX_3\" CHAR(4),\n    PRIMARY KEY (\"COL_PK_1\", \"COL_PK_2\")\n);\nCREATE INDEX \"testindex1\" ON \"table1\" (\"COL_INDEX_2\");\nCREATE UNIQUE INDEX \"testindex2\" ON \"table1\" (\"COL_INDEX_3\", \"COL_INDEX_1\");\nCREATE TABLE \"table2\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_FK_1\" INTEGER,\n    \"COL_FK_2\" VARCHAR(32) NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nCREATE TABLE \"table3\"\n(\n    \"COL_PK\" VARCHAR(16),\n    \"COL_FK\" INTEGER NOT NULL,\n    PRIMARY KEY (\"COL_PK\")\n);\nALTER TABLE \"table2\" ADD CONSTRAINT \"table2_FK_COL_F_COL_FK_2_table1\" FOREIGN KEY (\"COL_FK_1\", \"COL_FK_2\") REFERENCES \"table1\" (\"COL_PK_2\", \"COL_PK_1\");\nALTER TABLE \"table3\" ADD CONSTRAINT \"testfk\" FOREIGN KEY (\"COL_FK\") REFERENCES \"table2\" (\"COL_PK\");\n", this.getTableConstraintTestDatabaseCreationSql());
    }

    public void testCharacterEscaping() throws Exception {
        this.assertEqualsIgnoringWhitespaces("DROP TABLE \"escapedcharacters\";\nCREATE TABLE \"escapedcharacters\"\n(\n    \"COL_PK\"   INTEGER,\n    \"COL_TEXT\" VARCHAR(128) DEFAULT '''',\n    PRIMARY KEY (\"COL_PK\")\n);\n", this.getCharEscapingTestDatabaseCreationSql());
    }
}

