/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.model;

import junit.framework.TestCase;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.NonUniqueIndex;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.UniqueIndex;

public class TestArrayAccessAtTable
extends TestCase {
    private Table _testedTable;
    private Column _column1;
    private Column _column2;
    private UniqueIndex _uniqueIndex;
    private NonUniqueIndex _nonUniqueIndex;

    public void setUp() {
        this._testedTable = new Table();
        this._column1 = new Column();
        this._column1.setName("column1");
        this._column1.setPrimaryKey(true);
        this._column2 = new Column();
        this._column2.setName("column2");
        this._testedTable.addColumn(this._column1);
        this._testedTable.addColumn(this._column2);
        this._uniqueIndex = new UniqueIndex();
        this._testedTable.addIndex((Index)this._uniqueIndex);
        this._nonUniqueIndex = new NonUniqueIndex();
        this._testedTable.addIndex((Index)this._nonUniqueIndex);
    }

    public void testGetPrimaryKeyColumns() {
        Column[] primaryKeyColumns = this._testedTable.getPrimaryKeyColumns();
        TestArrayAccessAtTable.assertEquals((int)1, (int)primaryKeyColumns.length);
        TestArrayAccessAtTable.assertSame((Object)this._column1, (Object)primaryKeyColumns[0]);
    }

    public void testGetColumns() {
        Column[] columns = this._testedTable.getColumns();
        TestArrayAccessAtTable.assertEquals((int)2, (int)columns.length);
        TestArrayAccessAtTable.assertSame((Object)this._column1, (Object)columns[0]);
        TestArrayAccessAtTable.assertSame((Object)this._column2, (Object)columns[1]);
    }

    public void testGetNonUniqueIndices() {
        Index[] nonUniqueIndices = this._testedTable.getNonUniqueIndices();
        TestArrayAccessAtTable.assertEquals((int)1, (int)nonUniqueIndices.length);
        TestArrayAccessAtTable.assertSame((Object)this._nonUniqueIndex, (Object)nonUniqueIndices[0]);
    }

    public void testGetUniqueIndices() {
        Index[] uniqueIndices = this._testedTable.getUniqueIndices();
        TestArrayAccessAtTable.assertEquals((int)1, (int)uniqueIndices.length);
        TestArrayAccessAtTable.assertSame((Object)this._uniqueIndex, (Object)uniqueIndices[0]);
    }
}

