/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io.converters;

import java.sql.Time;
import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.TimeConverter;

public class TestTimeConverter
extends TestCase {
    private TimeConverter _timeConverter;

    protected void setUp() throws Exception {
        super.setUp();
        this._timeConverter = new TimeConverter();
    }

    protected void tearDown() throws Exception {
        this._timeConverter = null;
        super.tearDown();
    }

    public void testNormalConvertFromHoursMinutesSecondsTimeString() {
        String textRep = "02:15:59";
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(10, 2);
        cal.set(12, 15);
        cal.set(13, 59);
        Object result = this._timeConverter.convertFromString(textRep, 92);
        TestTimeConverter.assertTrue((boolean)(result instanceof Time));
        TestTimeConverter.assertEquals((long)cal.getTimeInMillis(), (long)((Time)result).getTime());
    }

    public void testNormalConvertFromHoursMinutesTimeString() {
        String textRep = "02:15";
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(10, 2);
        cal.set(12, 15);
        Object result = this._timeConverter.convertFromString(textRep, 92);
        TestTimeConverter.assertTrue((boolean)(result instanceof Time));
        TestTimeConverter.assertEquals((long)cal.getTimeInMillis(), (long)((Time)result).getTime());
    }

    public void testNormalConvertFromHoursTimeString() {
        String textRep = "02";
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(10, 2);
        Object result = this._timeConverter.convertFromString(textRep, 92);
        TestTimeConverter.assertTrue((boolean)(result instanceof Time));
        TestTimeConverter.assertEquals((long)cal.getTimeInMillis(), (long)((Time)result).getTime());
    }

    public void testNormalConvertFromIsoDateTimeString() {
        String textRep = "2004-01-13 04:45:09.245";
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(10, 4);
        cal.set(12, 45);
        cal.set(13, 9);
        Object result = this._timeConverter.convertFromString(textRep, 92);
        TestTimeConverter.assertTrue((boolean)(result instanceof Time));
        TestTimeConverter.assertEquals((long)cal.getTimeInMillis(), (long)((Time)result).getTime());
    }

    public void testConvertFromStringWithInvalidSqlType() {
        String textRep = "02:15:59";
        Object result = this._timeConverter.convertFromString(textRep, 4);
        TestTimeConverter.assertNotNull((Object)result);
        TestTimeConverter.assertEquals((Object)textRep, (Object)result);
    }

    public void testConvertFromStringWithNullTextRep() {
        String textRep = null;
        Object result = this._timeConverter.convertFromString(textRep, 92);
        TestTimeConverter.assertNull((Object)result);
    }

    public void testConvertFromStringWithInvalidTextRep() {
        String textRep = "99:99:99";
        try {
            this._timeConverter.convertFromString(textRep, 92);
            TestTimeConverter.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testConvertFromStringWithAlphaTextRep() {
        String textRep = "aa:bb:cc";
        try {
            this._timeConverter.convertFromString(textRep, 92);
            TestTimeConverter.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testNormalConvertToString() {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(10, 2);
        cal.set(12, 15);
        cal.set(13, 59);
        Time time = new Time(cal.getTimeInMillis());
        String result = this._timeConverter.convertToString((Object)time, 92);
        TestTimeConverter.assertNotNull((Object)result);
        TestTimeConverter.assertEquals((String)"02:15:59", (String)result);
    }

    public void testConvertToStringWithNullTime() {
        Object time = null;
        String result = this._timeConverter.convertToString(time, 92);
        TestTimeConverter.assertNull((Object)result);
    }

    public void testConvertToStringWithWrongType() {
        Date date = new Date();
        try {
            this._timeConverter.convertToString((Object)date, 92);
            TestTimeConverter.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

