/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io.converters;

import java.util.Calendar;
import java.util.Date;
import junit.framework.TestCase;
import org.apache.ddlutils.io.converters.ConversionException;
import org.apache.ddlutils.io.converters.DateConverter;

public class TestDateConverter
extends TestCase {
    private DateConverter _dateConverter;

    protected void setUp() throws Exception {
        super.setUp();
        this._dateConverter = new DateConverter();
    }

    protected void tearDown() throws Exception {
        this._dateConverter = null;
        super.tearDown();
    }

    public void testNormalConvertFromYearMonthDateString() {
        String textRep = "2005-12-19";
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(2005, 11, 19);
        Object result = this._dateConverter.convertFromString(textRep, 91);
        TestDateConverter.assertTrue((boolean)(result instanceof java.sql.Date));
        TestDateConverter.assertEquals((long)cal.getTimeInMillis(), (long)((java.sql.Date)result).getTime());
    }

    public void testNormalConvertFromYearMonthString() {
        String textRep = "2005-12";
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(2005, 11, 1);
        Object result = this._dateConverter.convertFromString(textRep, 91);
        TestDateConverter.assertTrue((boolean)(result instanceof java.sql.Date));
        TestDateConverter.assertEquals((long)cal.getTimeInMillis(), (long)((java.sql.Date)result).getTime());
    }

    public void testNormalConvertFromYearString() {
        String textRep = "2005";
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2005, 0, 1);
        Object result = this._dateConverter.convertFromString(textRep, 91);
        TestDateConverter.assertTrue((boolean)(result instanceof java.sql.Date));
        TestDateConverter.assertEquals((long)cal.getTimeInMillis(), (long)((java.sql.Date)result).getTime());
    }

    public void testNormalConvertFromFullDateTimeString() {
        String textRep = "2005-06-07 10:11:12";
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(2005, 5, 7);
        Object result = this._dateConverter.convertFromString(textRep, 91);
        TestDateConverter.assertTrue((boolean)(result instanceof java.sql.Date));
        TestDateConverter.assertEquals((long)cal.getTimeInMillis(), (long)((java.sql.Date)result).getTime());
    }

    public void testConvertFromStringWithInvalidSqlType() {
        String textRep = "2005-12-19";
        Object result = this._dateConverter.convertFromString(textRep, 4);
        TestDateConverter.assertNotNull((Object)result);
        TestDateConverter.assertEquals((Object)textRep, (Object)result);
    }

    public void testConvertFromStringWithNullTextRep() {
        String textRep = null;
        Object result = this._dateConverter.convertFromString(textRep, 91);
        TestDateConverter.assertNull((Object)result);
    }

    public void testConvertFromStringWithInvalidTextRep() {
        String textRep = "9999-99-99";
        try {
            this._dateConverter.convertFromString(textRep, 91);
            TestDateConverter.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testConvertFromStringWithAlphaTextRep() {
        String textRep = "aaaa-bb-cc";
        try {
            this._dateConverter.convertFromString(textRep, 91);
            TestDateConverter.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }

    public void testNormalConvertToString() {
        Calendar cal = Calendar.getInstance();
        cal.setLenient(false);
        cal.clear();
        cal.set(2005, 11, 19);
        java.sql.Date date = new java.sql.Date(cal.getTimeInMillis());
        String result = this._dateConverter.convertToString((Object)date, 91);
        TestDateConverter.assertNotNull((Object)result);
        TestDateConverter.assertEquals((String)"2005-12-19", (String)result);
    }

    public void testConvertToStringWithNullDate() {
        Object date = null;
        String result = this._dateConverter.convertToString(date, 91);
        TestDateConverter.assertNull((Object)result);
    }

    public void testConvertToStringWithWrongType() {
        Date date = new Date();
        try {
            this._dateConverter.convertToString((Object)date, 91);
            TestDateConverter.fail((String)"ConversionException expected");
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
    }
}

