/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;
import org.apache.ddlutils.io.DatabaseDataIO;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.InputSource;

public class TestMisc
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestMisc.getTests(TestMisc.class);
    }

    public void testIdentityOverrideOn() throws Exception {
        if (!this.getPlatformInfo().isIdentityOverrideAllowed()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String modelXml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n  <table name='misc2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='12,0' required='false'/>\n    <foreign-key name='test' foreignTable='misc1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n  <table name='misc2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='test' foreignTable='misc1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(true);
        if (isSybase) {
            this.insertRow("misc1", new Object[]{new BigDecimal(10), new Integer(1)});
            this.insertRow("misc1", new Object[]{new BigDecimal(12), new Integer(2)});
            this.insertRow("misc1", new Object[]{new BigDecimal(13), new Integer(3)});
            this.insertRow("misc2", new Object[]{new Integer(1), new BigDecimal(10)});
            this.insertRow("misc2", new Object[]{new Integer(2), new BigDecimal(13)});
        } else {
            this.insertRow("misc1", new Object[]{new Integer(10), new Integer(1)});
            this.insertRow("misc1", new Object[]{new Integer(12), new Integer(2)});
            this.insertRow("misc1", new Object[]{new Integer(13), new Integer(3)});
            this.insertRow("misc2", new Object[]{new Integer(1), new Integer(10)});
            this.insertRow("misc2", new Object[]{new Integer(2), new Integer(13)});
        }
        StringWriter stringWriter = new StringWriter();
        DatabaseDataIO dataIO = new DatabaseDataIO();
        dataIO.writeDataToXML(this.getPlatform(), this.getModel(), (Writer)stringWriter, "UTF-8");
        String dataAsXml = stringWriter.toString();
        SAXReader reader = new SAXReader();
        Document testDoc = reader.read(new InputSource(new StringReader(dataAsXml)));
        List misc1Rows = testDoc.selectNodes("//misc1");
        List misc2Rows = testDoc.selectNodes("//misc2");
        String pkColumnName = "pk";
        String fkColumnName = "fk";
        String valueColumnName = "avalue";
        if (misc1Rows.size() == 0) {
            misc1Rows = testDoc.selectNodes("//MISC1");
            misc2Rows = testDoc.selectNodes("//MISC2");
            pkColumnName = pkColumnName.toUpperCase();
            fkColumnName = fkColumnName.toUpperCase();
            valueColumnName = valueColumnName.toUpperCase();
        }
        TestMisc.assertEquals((int)3, (int)misc1Rows.size());
        TestMisc.assertEquals((String)"10", (String)((Element)misc1Rows.get(0)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"1", (String)((Element)misc1Rows.get(0)).attributeValue(valueColumnName));
        TestMisc.assertEquals((String)"12", (String)((Element)misc1Rows.get(1)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"2", (String)((Element)misc1Rows.get(1)).attributeValue(valueColumnName));
        TestMisc.assertEquals((String)"13", (String)((Element)misc1Rows.get(2)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"3", (String)((Element)misc1Rows.get(2)).attributeValue(valueColumnName));
        TestMisc.assertEquals((int)2, (int)misc2Rows.size());
        TestMisc.assertEquals((String)"1", (String)((Element)misc2Rows.get(0)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"10", (String)((Element)misc2Rows.get(0)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"2", (String)((Element)misc2Rows.get(1)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"13", (String)((Element)misc2Rows.get(1)).attributeValue(fkColumnName));
        this.dropDatabase();
        this.createDatabase(modelXml);
        StringReader stringReader = new StringReader(dataAsXml);
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        List beans = this.getRows("misc1");
        if (isSybase) {
            this.assertEquals(new BigDecimal(10), beans.get(0), "pk");
            this.assertEquals(new BigDecimal(12), beans.get(1), "pk");
            this.assertEquals(new BigDecimal(13), beans.get(2), "pk");
        } else {
            this.assertEquals(new Integer(10), beans.get(0), "pk");
            this.assertEquals(new Integer(12), beans.get(1), "pk");
            this.assertEquals(new Integer(13), beans.get(2), "pk");
        }
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        this.assertEquals(new Integer(2), beans.get(1), "avalue");
        this.assertEquals(new Integer(3), beans.get(2), "avalue");
        beans = this.getRows("misc2");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        if (isSybase) {
            this.assertEquals(new BigDecimal(10), beans.get(0), "fk");
            this.assertEquals(new BigDecimal(13), beans.get(1), "fk");
        } else {
            this.assertEquals(new Integer(10), beans.get(0), "fk");
            this.assertEquals(new Integer(13), beans.get(1), "fk");
        }
    }

    public void testIdentityOverrideOff() throws Exception {
        if (!this.getPlatformInfo().isIdentityOverrideAllowed()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String modelXml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n  <table name='misc2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='12,0' required='false'/>\n    <foreign-key name='test' foreignTable='misc1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n  <table name='misc2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='test' foreignTable='misc1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(true);
        if (isSybase) {
            this.insertRow("misc1", new Object[]{new BigDecimal(10), new Integer(1)});
            this.insertRow("misc1", new Object[]{new BigDecimal(12), new Integer(2)});
            this.insertRow("misc1", new Object[]{new BigDecimal(13), new Integer(3)});
            this.insertRow("misc2", new Object[]{new Integer(1), new BigDecimal(10)});
            this.insertRow("misc2", new Object[]{new Integer(2), new BigDecimal(13)});
        } else {
            this.insertRow("misc1", new Object[]{new Integer(10), new Integer(1)});
            this.insertRow("misc1", new Object[]{new Integer(12), new Integer(2)});
            this.insertRow("misc1", new Object[]{new Integer(13), new Integer(3)});
            this.insertRow("misc2", new Object[]{new Integer(1), new Integer(10)});
            this.insertRow("misc2", new Object[]{new Integer(2), new Integer(13)});
        }
        StringWriter stringWriter = new StringWriter();
        DatabaseDataIO dataIO = new DatabaseDataIO();
        dataIO.writeDataToXML(this.getPlatform(), this.getModel(), (Writer)stringWriter, "UTF-8");
        String dataAsXml = stringWriter.toString();
        SAXReader reader = new SAXReader();
        Document testDoc = reader.read(new InputSource(new StringReader(dataAsXml)));
        List misc1Rows = testDoc.selectNodes("//misc1");
        List misc2Rows = testDoc.selectNodes("//misc2");
        String pkColumnName = "pk";
        String fkColumnName = "fk";
        String valueColumnName = "avalue";
        if (misc1Rows.size() == 0) {
            misc1Rows = testDoc.selectNodes("//MISC1");
            misc2Rows = testDoc.selectNodes("//MISC2");
            pkColumnName = pkColumnName.toUpperCase();
            fkColumnName = fkColumnName.toUpperCase();
            valueColumnName = valueColumnName.toUpperCase();
        }
        TestMisc.assertEquals((int)3, (int)misc1Rows.size());
        TestMisc.assertEquals((String)"10", (String)((Element)misc1Rows.get(0)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"1", (String)((Element)misc1Rows.get(0)).attributeValue(valueColumnName));
        TestMisc.assertEquals((String)"12", (String)((Element)misc1Rows.get(1)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"2", (String)((Element)misc1Rows.get(1)).attributeValue(valueColumnName));
        TestMisc.assertEquals((String)"13", (String)((Element)misc1Rows.get(2)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"3", (String)((Element)misc1Rows.get(2)).attributeValue(valueColumnName));
        TestMisc.assertEquals((int)2, (int)misc2Rows.size());
        TestMisc.assertEquals((String)"1", (String)((Element)misc2Rows.get(0)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"10", (String)((Element)misc2Rows.get(0)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"2", (String)((Element)misc2Rows.get(1)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"13", (String)((Element)misc2Rows.get(1)).attributeValue(fkColumnName));
        this.dropDatabase();
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(false);
        StringReader stringReader = new StringReader(dataAsXml);
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        List beans = this.getRows("misc1");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "pk");
            this.assertEquals(new BigDecimal(2), beans.get(1), "pk");
            this.assertEquals(new BigDecimal(3), beans.get(2), "pk");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "pk");
            this.assertEquals(new Integer(2), beans.get(1), "pk");
            this.assertEquals(new Integer(3), beans.get(2), "pk");
        }
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        this.assertEquals(new Integer(2), beans.get(1), "avalue");
        this.assertEquals(new Integer(3), beans.get(2), "avalue");
        beans = this.getRows("misc2");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "fk");
            this.assertEquals(new BigDecimal(3), beans.get(1), "fk");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "fk");
            this.assertEquals(new Integer(3), beans.get(1), "fk");
        }
    }

    public void testSelfReferenceIdentityOverrideOff() throws Exception {
        if ("HsqlDb".equals(this.getPlatform().getName())) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String modelXml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='fk' type='NUMERIC' size='12,0' required='false'/>\n    <foreign-key name='test' foreignTable='misc'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='test' foreignTable='misc'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(false);
        if (isSybase) {
            this.insertRow("misc", new Object[]{new BigDecimal(1), null});
            this.insertRow("misc", new Object[]{new BigDecimal(2), new BigDecimal(1)});
            this.insertRow("misc", new Object[]{new BigDecimal(3), new BigDecimal(2)});
            this.insertRow("misc", new Object[]{new BigDecimal(4), new BigDecimal(4)});
        } else {
            this.insertRow("misc", new Object[]{new Integer(1), null});
            this.insertRow("misc", new Object[]{new Integer(2), new Integer(1)});
            this.insertRow("misc", new Object[]{new Integer(3), new Integer(2)});
            this.insertRow("misc", new Object[]{new Integer(4), new Integer(4)});
        }
        StringWriter stringWriter = new StringWriter();
        DatabaseDataIO dataIO = new DatabaseDataIO();
        dataIO.writeDataToXML(this.getPlatform(), this.getModel(), (Writer)stringWriter, "UTF-8");
        String dataAsXml = stringWriter.toString();
        SAXReader reader = new SAXReader();
        Document testDoc = reader.read(new InputSource(new StringReader(dataAsXml)));
        List miscRows = testDoc.selectNodes("//misc");
        String pkColumnName = "pk";
        String fkColumnName = "fk";
        if (miscRows.size() == 0) {
            miscRows = testDoc.selectNodes("//MISC");
            pkColumnName = pkColumnName.toUpperCase();
            fkColumnName = fkColumnName.toUpperCase();
        }
        TestMisc.assertEquals((int)4, (int)miscRows.size());
        TestMisc.assertEquals((String)"1", (String)((Element)miscRows.get(0)).attributeValue(pkColumnName));
        TestMisc.assertNull((Object)((Element)miscRows.get(0)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"2", (String)((Element)miscRows.get(1)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"1", (String)((Element)miscRows.get(1)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"3", (String)((Element)miscRows.get(2)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"2", (String)((Element)miscRows.get(2)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"4", (String)((Element)miscRows.get(3)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"4", (String)((Element)miscRows.get(3)).attributeValue(fkColumnName));
        this.dropDatabase();
        this.createDatabase(modelXml);
        StringReader stringReader = new StringReader(dataAsXml);
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        List beans = this.getRows("misc");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "pk");
            TestMisc.assertNull((Object)((DynaBean)beans.get(0)).get("fk"));
            this.assertEquals(new BigDecimal(2), beans.get(1), "pk");
            this.assertEquals(new BigDecimal(1), beans.get(1), "fk");
            this.assertEquals(new BigDecimal(3), beans.get(2), "pk");
            this.assertEquals(new BigDecimal(2), beans.get(2), "fk");
            this.assertEquals(new BigDecimal(4), beans.get(3), "pk");
            this.assertEquals(new BigDecimal(4), beans.get(3), "fk");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "pk");
            TestMisc.assertNull((Object)((DynaBean)beans.get(0)).get("fk"));
            this.assertEquals(new Integer(2), beans.get(1), "pk");
            this.assertEquals(new Integer(1), beans.get(1), "fk");
            this.assertEquals(new Integer(3), beans.get(2), "pk");
            this.assertEquals(new Integer(2), beans.get(2), "fk");
            this.assertEquals(new Integer(4), beans.get(3), "pk");
            this.assertEquals(new Integer(4), beans.get(3), "fk");
        }
    }

    public void testSelfReferenceIdentityOverrideOn() throws Exception {
        if (!this.getPlatformInfo().isIdentityOverrideAllowed()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String modelXml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='fk' type='NUMERIC' size='12,0' required='false'/>\n    <foreign-key name='test' foreignTable='misc'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='test' foreignTable='misc'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(true);
        if (isSybase) {
            this.insertRow("misc", new Object[]{new BigDecimal(10), null});
            this.insertRow("misc", new Object[]{new BigDecimal(11), new BigDecimal(10)});
            this.insertRow("misc", new Object[]{new BigDecimal(12), new BigDecimal(11)});
            this.insertRow("misc", new Object[]{new BigDecimal(13), new BigDecimal(13)});
        } else {
            this.insertRow("misc", new Object[]{new Integer(10), null});
            this.insertRow("misc", new Object[]{new Integer(11), new Integer(10)});
            this.insertRow("misc", new Object[]{new Integer(12), new Integer(11)});
            this.insertRow("misc", new Object[]{new Integer(13), new Integer(13)});
        }
        StringWriter stringWriter = new StringWriter();
        DatabaseDataIO dataIO = new DatabaseDataIO();
        dataIO.writeDataToXML(this.getPlatform(), this.getModel(), (Writer)stringWriter, "UTF-8");
        String dataAsXml = stringWriter.toString();
        SAXReader reader = new SAXReader();
        Document testDoc = reader.read(new InputSource(new StringReader(dataAsXml)));
        List miscRows = testDoc.selectNodes("//misc");
        String pkColumnName = "pk";
        String fkColumnName = "fk";
        if (miscRows.size() == 0) {
            miscRows = testDoc.selectNodes("//MISC");
            pkColumnName = pkColumnName.toUpperCase();
            fkColumnName = fkColumnName.toUpperCase();
        }
        TestMisc.assertEquals((int)4, (int)miscRows.size());
        TestMisc.assertEquals((String)"10", (String)((Element)miscRows.get(0)).attributeValue(pkColumnName));
        TestMisc.assertNull((Object)((Element)miscRows.get(0)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"11", (String)((Element)miscRows.get(1)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"10", (String)((Element)miscRows.get(1)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"12", (String)((Element)miscRows.get(2)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"11", (String)((Element)miscRows.get(2)).attributeValue(fkColumnName));
        TestMisc.assertEquals((String)"13", (String)((Element)miscRows.get(3)).attributeValue(pkColumnName));
        TestMisc.assertEquals((String)"13", (String)((Element)miscRows.get(3)).attributeValue(fkColumnName));
        this.dropDatabase();
        this.createDatabase(modelXml);
        StringReader stringReader = new StringReader(dataAsXml);
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        List beans = this.getRows("misc");
        if (isSybase) {
            this.assertEquals(new BigDecimal(10), beans.get(0), "pk");
            TestMisc.assertNull((Object)((DynaBean)beans.get(0)).get("fk"));
            this.assertEquals(new BigDecimal(11), beans.get(1), "pk");
            this.assertEquals(new BigDecimal(10), beans.get(1), "fk");
            this.assertEquals(new BigDecimal(12), beans.get(2), "pk");
            this.assertEquals(new BigDecimal(11), beans.get(2), "fk");
            this.assertEquals(new BigDecimal(13), beans.get(3), "pk");
            this.assertEquals(new BigDecimal(13), beans.get(3), "fk");
        } else {
            this.assertEquals(new Integer(10), beans.get(0), "pk");
            TestMisc.assertNull((Object)((DynaBean)beans.get(0)).get("fk"));
            this.assertEquals(new Integer(11), beans.get(1), "pk");
            this.assertEquals(new Integer(10), beans.get(1), "fk");
            this.assertEquals(new Integer(12), beans.get(2), "pk");
            this.assertEquals(new Integer(11), beans.get(2), "fk");
            this.assertEquals(new Integer(13), beans.get(3), "pk");
            this.assertEquals(new Integer(13), beans.get(3), "fk");
        }
    }

    public void testSelfReferences() throws Exception {
        if (!this.getPlatformInfo().isIdentityOverrideAllowed()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String modelXml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='id' primaryKey='true' required='true' type='NUMERIC' size='10,0' autoIncrement='true'/>\n    <column name='parent_id' primaryKey='false' required='false' type='NUMERIC' size='10,0' autoIncrement='false'/>\n    <foreign-key foreignTable='misc' name='misc_parent_fk'>\n      <reference local='parent_id' foreign='id'/>\n    </foreign-key>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='id' primaryKey='true' required='true' type='SMALLINT' size='2' autoIncrement='true'/>\n    <column name='parent_id' primaryKey='false' required='false' type='SMALLINT' size='2' autoIncrement='false'/>\n    <foreign-key foreignTable='misc' name='misc_parent_fk'>\n      <reference local='parent_id' foreign='id'/>\n    </foreign-key>\n  </table>\n</database>";
        String dataXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <misc id='4' parent_id='1'/>\n  <misc id='7' parent_id='1'/>\n  <misc id='3' parent_id='2'/>\n  <misc id='5' parent_id='3'/>\n  <misc id='8' parent_id='7'/>\n  <misc id='9' parent_id='6'/>\n  <misc id='10' parent_id='4'/>\n  <misc id='1'/>\n  <misc id='2'/>\n  <misc id='6'/>\n  <misc id='11'/>\n  <misc id='12' parent_id='11'/>\n</data>";
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(true);
        DatabaseDataIO dataIO = new DatabaseDataIO();
        StringReader stringReader = new StringReader("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <misc id='4' parent_id='1'/>\n  <misc id='7' parent_id='1'/>\n  <misc id='3' parent_id='2'/>\n  <misc id='5' parent_id='3'/>\n  <misc id='8' parent_id='7'/>\n  <misc id='9' parent_id='6'/>\n  <misc id='10' parent_id='4'/>\n  <misc id='1'/>\n  <misc id='2'/>\n  <misc id='6'/>\n  <misc id='11'/>\n  <misc id='12' parent_id='11'/>\n</data>");
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        List beans = this.getRows("misc", "id");
        if (isSybase) {
            TestMisc.assertEquals((int)12, (int)beans.size());
            this.assertEquals(new BigDecimal(1), beans.get(0), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(0)).get("parent_id"));
            this.assertEquals(new BigDecimal(2), beans.get(1), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(1)).get("parent_id"));
            this.assertEquals(new BigDecimal(3), beans.get(2), "id");
            this.assertEquals(new BigDecimal(2), beans.get(2), "parent_id");
            this.assertEquals(new BigDecimal(4), beans.get(3), "id");
            this.assertEquals(new BigDecimal(1), beans.get(3), "parent_id");
            this.assertEquals(new BigDecimal(5), beans.get(4), "id");
            this.assertEquals(new BigDecimal(3), beans.get(4), "parent_id");
            this.assertEquals(new BigDecimal(6), beans.get(5), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(5)).get("parent_id"));
            this.assertEquals(new BigDecimal(7), beans.get(6), "id");
            this.assertEquals(new BigDecimal(1), beans.get(6), "parent_id");
            this.assertEquals(new BigDecimal(8), beans.get(7), "id");
            this.assertEquals(new BigDecimal(7), beans.get(7), "parent_id");
            this.assertEquals(new BigDecimal(9), beans.get(8), "id");
            this.assertEquals(new BigDecimal(6), beans.get(8), "parent_id");
            this.assertEquals(new BigDecimal(10), beans.get(9), "id");
            this.assertEquals(new BigDecimal(4), beans.get(9), "parent_id");
            this.assertEquals(new BigDecimal(11), beans.get(10), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(10)).get("parent_id"));
            this.assertEquals(new BigDecimal(12), beans.get(11), "id");
            this.assertEquals(new BigDecimal(11), beans.get(11), "parent_id");
        } else {
            TestMisc.assertEquals((int)12, (int)beans.size());
            this.assertEquals(new Integer(1), beans.get(0), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(0)).get("parent_id"));
            this.assertEquals(new Integer(2), beans.get(1), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(1)).get("parent_id"));
            this.assertEquals(new Integer(3), beans.get(2), "id");
            this.assertEquals(new Integer(2), beans.get(2), "parent_id");
            this.assertEquals(new Integer(4), beans.get(3), "id");
            this.assertEquals(new Integer(1), beans.get(3), "parent_id");
            this.assertEquals(new Integer(5), beans.get(4), "id");
            this.assertEquals(new Integer(3), beans.get(4), "parent_id");
            this.assertEquals(new Integer(6), beans.get(5), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(5)).get("parent_id"));
            this.assertEquals(new Integer(7), beans.get(6), "id");
            this.assertEquals(new Integer(1), beans.get(6), "parent_id");
            this.assertEquals(new Integer(8), beans.get(7), "id");
            this.assertEquals(new Integer(7), beans.get(7), "parent_id");
            this.assertEquals(new Integer(9), beans.get(8), "id");
            this.assertEquals(new Integer(6), beans.get(8), "parent_id");
            this.assertEquals(new Integer(10), beans.get(9), "id");
            this.assertEquals(new Integer(4), beans.get(9), "parent_id");
            this.assertEquals(new Integer(11), beans.get(10), "id");
            TestMisc.assertNull((Object)((DynaBean)beans.get(10)).get("parent_id"));
            this.assertEquals(new Integer(12), beans.get(11), "id");
            this.assertEquals(new Integer(11), beans.get(11), "parent_id");
        }
    }

    public void testMultiSelfReferences() throws Exception {
        if (!this.getPlatformInfo().isIdentityOverrideAllowed()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String modelXml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='id' primaryKey='true' required='true' type='NUMERIC' size='6,0' autoIncrement='true'/>\n    <column name='left_id' primaryKey='false' required='false' type='NUMERIC' size='6,0' autoIncrement='false'/>\n    <column name='right_id' primaryKey='false' required='false' type='NUMERIC' size='6,0' autoIncrement='false'/>\n    <foreign-key foreignTable='misc' name='misc_left_fk'>\n      <reference local='left_id' foreign='id'/>\n    </foreign-key>\n    <foreign-key foreignTable='misc' name='misc_right_fk'>\n      <reference local='right_id' foreign='id'/>\n    </foreign-key>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='misc'>\n    <column name='id' primaryKey='true' required='true' type='SMALLINT' size='2' autoIncrement='true'/>\n    <column name='left_id' primaryKey='false' required='false' type='SMALLINT' size='2' autoIncrement='false'/>\n    <column name='right_id' primaryKey='false' required='false' type='SMALLINT' size='2' autoIncrement='false'/>\n    <foreign-key foreignTable='misc' name='misc_left_fk'>\n      <reference local='left_id' foreign='id'/>\n    </foreign-key>\n    <foreign-key foreignTable='misc' name='misc_right_fk'>\n      <reference local='right_id' foreign='id'/>\n    </foreign-key>\n  </table>\n</database>";
        String dataXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <misc id='1' left_id='2' right_id='3'/>\n  <misc id='3' left_id='2' right_id='4'/>\n  <misc id='2' left_id='5' right_id='4'/>\n  <misc id='5' right_id='6'/>\n  <misc id='6'/>\n  <misc id='4' left_id='6'/>\n</data>";
        this.createDatabase(modelXml);
        this.getPlatform().setIdentityOverrideOn(true);
        DatabaseDataIO dataIO = new DatabaseDataIO();
        StringReader stringReader = new StringReader("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <misc id='1' left_id='2' right_id='3'/>\n  <misc id='3' left_id='2' right_id='4'/>\n  <misc id='2' left_id='5' right_id='4'/>\n  <misc id='5' right_id='6'/>\n  <misc id='6'/>\n  <misc id='4' left_id='6'/>\n</data>");
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        List beans = this.getRows("misc", "id");
        TestMisc.assertEquals((int)6, (int)beans.size());
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "id");
            this.assertEquals(new BigDecimal(2), beans.get(0), "left_id");
            this.assertEquals(new BigDecimal(3), beans.get(0), "right_id");
            this.assertEquals(new BigDecimal(2), beans.get(1), "id");
            this.assertEquals(new BigDecimal(5), beans.get(1), "left_id");
            this.assertEquals(new BigDecimal(4), beans.get(1), "right_id");
            this.assertEquals(new BigDecimal(3), beans.get(2), "id");
            this.assertEquals(new BigDecimal(2), beans.get(2), "left_id");
            this.assertEquals(new BigDecimal(4), beans.get(2), "right_id");
            this.assertEquals(new BigDecimal(4), beans.get(3), "id");
            this.assertEquals(new BigDecimal(6), beans.get(3), "left_id");
            this.assertEquals((Object)null, beans.get(3), "right_id");
            this.assertEquals(new BigDecimal(5), beans.get(4), "id");
            this.assertEquals((Object)null, beans.get(4), "left_id");
            this.assertEquals(new BigDecimal(6), beans.get(4), "right_id");
            this.assertEquals(new BigDecimal(6), beans.get(5), "id");
            this.assertEquals((Object)null, beans.get(5), "left_id");
            this.assertEquals((Object)null, beans.get(5), "right_id");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "id");
            this.assertEquals(new Integer(2), beans.get(0), "left_id");
            this.assertEquals(new Integer(3), beans.get(0), "right_id");
            this.assertEquals(new Integer(2), beans.get(1), "id");
            this.assertEquals(new Integer(5), beans.get(1), "left_id");
            this.assertEquals(new Integer(4), beans.get(1), "right_id");
            this.assertEquals(new Integer(3), beans.get(2), "id");
            this.assertEquals(new Integer(2), beans.get(2), "left_id");
            this.assertEquals(new Integer(4), beans.get(2), "right_id");
            this.assertEquals(new Integer(4), beans.get(3), "id");
            this.assertEquals(new Integer(6), beans.get(3), "left_id");
            this.assertEquals((Object)null, beans.get(3), "right_id");
            this.assertEquals(new Integer(5), beans.get(4), "id");
            this.assertEquals((Object)null, beans.get(4), "left_id");
            this.assertEquals(new Integer(6), beans.get(4), "right_id");
            this.assertEquals(new Integer(6), beans.get(5), "id");
            this.assertEquals((Object)null, beans.get(5), "left_id");
            this.assertEquals((Object)null, beans.get(5), "right_id");
        }
    }

    public void testComplexTableModel() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='AtoA' foreignTable='A'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='B'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk1' type='INTEGER' required='false'/>\n    <column name='fk2' type='INTEGER' required='false'/>\n    <foreign-key name='BtoB' foreignTable='B'>\n      <reference local='fk1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key name='BtoG' foreignTable='G'>\n      <reference local='fk2' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='C'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='CtoD' foreignTable='D'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='D'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='DtoF' foreignTable='F'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='E'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='F'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='FtoC' foreignTable='C'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='G'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='AtoA' foreignTable='A'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='B'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk1' type='INTEGER' required='false'/>\n    <column name='fk2' type='INTEGER' required='false'/>\n    <foreign-key name='BtoB' foreignTable='B'>\n      <reference local='fk1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key name='BtoG' foreignTable='G'>\n      <reference local='fk2' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='C'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='CtoD' foreignTable='D'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='D'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='DtoF' foreignTable='F'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='E'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='F'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='FtoC' foreignTable='C'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='G'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.getPlatform().setIdentityOverrideOn(true);
        this.insertRow("E", new Object[]{new Integer(1)});
        this.insertRow("G", new Object[]{new Integer(1)});
        this.insertRow("G", new Object[]{new Integer(2)});
        this.insertRow("A", new Object[]{new Integer(2), null});
        this.insertRow("A", new Object[]{new Integer(1), new Integer(2)});
        this.insertRow("B", new Object[]{new Integer(2), null, new Integer(2)});
        this.insertRow("B", new Object[]{new Integer(1), new Integer(2), new Integer(1)});
        this.insertRow("D", new Object[]{new Integer(2), null});
        this.insertRow("C", new Object[]{new Integer(2), new Integer(2)});
        this.insertRow("F", new Object[]{new Integer(1), new Integer(2)});
        this.insertRow("D", new Object[]{new Integer(1), new Integer(1)});
        this.insertRow("C", new Object[]{new Integer(1), new Integer(1)});
        StringWriter stringWriter = new StringWriter();
        DatabaseDataIO dataIO = new DatabaseDataIO();
        dataIO.writeDataToXML(this.getPlatform(), this.getModel(), (Writer)stringWriter, "UTF-8");
        String dataAsXml = stringWriter.toString();
        SAXReader reader = new SAXReader();
        Document testDoc = reader.read(new InputSource(new StringReader(dataAsXml)));
        boolean uppercase = false;
        List rows = testDoc.selectNodes("/*/*");
        String pkColumnName = "pk";
        TestMisc.assertEquals((int)12, (int)rows.size());
        if (!"e".equals(((Element)rows.get(0)).getName())) {
            TestMisc.assertEquals((String)"E", (String)((Element)rows.get(0)).getName());
            uppercase = true;
        }
        if (!"pk".equals(((Element)rows.get(0)).attribute(0).getName())) {
            pkColumnName = pkColumnName.toUpperCase();
        }
        TestMisc.assertEquals((String)"1", (String)((Element)rows.get(0)).attributeValue(pkColumnName));
        HashSet<String> pkValues = new HashSet<String>();
        HashSet<String> expectedValues = new HashSet<String>(Arrays.asList("1", "2"));
        TestMisc.assertEquals((String)(uppercase ? "G" : "g"), (String)((Element)rows.get(1)).getName());
        TestMisc.assertEquals((String)(uppercase ? "G" : "g"), (String)((Element)rows.get(2)).getName());
        pkValues.add(((Element)rows.get(1)).attributeValue(pkColumnName));
        pkValues.add(((Element)rows.get(2)).attributeValue(pkColumnName));
        TestMisc.assertEquals(pkValues, expectedValues);
        pkValues.clear();
        TestMisc.assertEquals((String)(uppercase ? "A" : "a"), (String)((Element)rows.get(3)).getName());
        TestMisc.assertEquals((String)(uppercase ? "A" : "a"), (String)((Element)rows.get(4)).getName());
        pkValues.add(((Element)rows.get(3)).attributeValue(pkColumnName));
        pkValues.add(((Element)rows.get(4)).attributeValue(pkColumnName));
        TestMisc.assertEquals(pkValues, expectedValues);
        pkValues.clear();
        TestMisc.assertEquals((String)(uppercase ? "B" : "b"), (String)((Element)rows.get(5)).getName());
        TestMisc.assertEquals((String)(uppercase ? "B" : "b"), (String)((Element)rows.get(6)).getName());
        pkValues.add(((Element)rows.get(5)).attributeValue(pkColumnName));
        pkValues.add(((Element)rows.get(6)).attributeValue(pkColumnName));
        TestMisc.assertEquals(pkValues, expectedValues);
        pkValues.clear();
        TestMisc.assertEquals((String)(uppercase ? "C" : "c"), (String)((Element)rows.get(7)).getName());
        TestMisc.assertEquals((String)(uppercase ? "C" : "c"), (String)((Element)rows.get(8)).getName());
        pkValues.add(((Element)rows.get(7)).attributeValue(pkColumnName));
        pkValues.add(((Element)rows.get(8)).attributeValue(pkColumnName));
        TestMisc.assertEquals(pkValues, expectedValues);
        pkValues.clear();
        TestMisc.assertEquals((String)(uppercase ? "D" : "d"), (String)((Element)rows.get(9)).getName());
        TestMisc.assertEquals((String)(uppercase ? "D" : "d"), (String)((Element)rows.get(10)).getName());
        pkValues.add(((Element)rows.get(9)).attributeValue(pkColumnName));
        pkValues.add(((Element)rows.get(10)).attributeValue(pkColumnName));
        TestMisc.assertEquals(pkValues, expectedValues);
        pkValues.clear();
        TestMisc.assertEquals((String)(uppercase ? "F" : "f"), (String)((Element)rows.get(11)).getName());
        TestMisc.assertEquals((String)"1", (String)((Element)rows.get(11)).attributeValue(pkColumnName));
        this.dropDatabase();
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='AtoA' foreignTable='A'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='B'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk1' type='INTEGER' required='false'/>\n    <column name='fk2' type='INTEGER' required='false'/>\n    <foreign-key name='BtoB' foreignTable='B'>\n      <reference local='fk1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key name='BtoG' foreignTable='G'>\n      <reference local='fk2' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='C'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='CtoD' foreignTable='D'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='D'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='DtoF' foreignTable='F'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='E'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='F'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='FtoC' foreignTable='C'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='G'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        StringReader stringReader = new StringReader(dataAsXml);
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{stringReader});
        TestMisc.assertEquals((int)2, (int)this.getRows("A").size());
        TestMisc.assertEquals((int)2, (int)this.getRows("B").size());
        TestMisc.assertEquals((int)2, (int)this.getRows("C").size());
        TestMisc.assertEquals((int)2, (int)this.getRows("D").size());
        TestMisc.assertEquals((int)1, (int)this.getRows("E").size());
        TestMisc.assertEquals((int)1, (int)this.getRows("F").size());
        TestMisc.assertEquals((int)2, (int)this.getRows("G").size());
    }

    public void testDdlUtils178() throws Exception {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n  <database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n    <table name='ad_sequence_no'>\n      <column name='ad_sequence_id' required='true' type='NUMERIC' size='10'/>\n      <column name='ad_year' required='true' type='VARCHAR' size='4' default='0000'/>\n      <column name='ad_client_id' required='true' type='NUMERIC' size='10'/>\n      <unique name='ad_sequence_no_key'>\n        <unique-column name='ad_sequence_id'/>\n        <unique-column name='ad_year'/>\n      </unique>\n    </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n  <database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n    <table name='ad_sequence_no'>\n      <column name='ad_sequence_id' required='true' type='NUMERIC' size='10'/>\n      <column name='ad_year' required='true' type='VARCHAR' size='4' default='0000'/>\n      <column name='ad_client_id' required='true' type='NUMERIC' size='10'/>\n      <unique name='ad_sequence_no_key'>\n        <unique-column name='ad_sequence_id'/>\n        <unique-column name='ad_year'/>\n      </unique>\n    </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDdlUtils179() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='AtoA' foreignTable='A'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='B'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk1' type='INTEGER' required='false'/>\n    <column name='fk2' type='INTEGER' required='false'/>\n    <foreign-key name='BtoB' foreignTable='B'>\n      <reference local='fk1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key name='BtoG' foreignTable='G'>\n      <reference local='fk2' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='C'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='CtoD' foreignTable='D'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='D'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='DtoF' foreignTable='F'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='E'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='F'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='FtoC' foreignTable='C'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='G'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='A'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='AtoA' foreignTable='A'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='B'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk1' type='INTEGER' required='false'/>\n    <column name='fk2' type='INTEGER' required='false'/>\n    <foreign-key name='BtoB' foreignTable='B'>\n      <reference local='fk1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key name='BtoG' foreignTable='G'>\n      <reference local='fk2' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='C'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='CtoD' foreignTable='D'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='D'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='DtoF' foreignTable='F'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='E'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='F'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key name='FtoC' foreignTable='C'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='G'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database readModel = this.readModelFromDatabase("roundtriptest");
        this.assertEquals(this.getAdjustedModel(), readModel);
        File tmpFile = File.createTempFile("model", ".xml");
        try {
            DatabaseIO dbIO = new DatabaseIO();
            FileOutputStream out = new FileOutputStream(tmpFile);
            dbIO.write(readModel, (OutputStream)out);
            out.flush();
            out.close();
            this.assertEquals(this.getAdjustedModel(), dbIO.read(tmpFile));
        }
        finally {
            if (!tmpFile.delete()) {
                this.getLog().warn((Object)("Could not delete the temporary file " + tmpFile.getAbsolutePath()));
            }
        }
    }

    public void testDdlUtils214() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk2' type='VARCHAR' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk2' type='VARCHAR' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database readModel = this.readModelFromDatabase("roundtriptest");
        this.assertEquals(this.getAdjustedModel(), readModel);
        this.insertRow("roundtrip1", new Object[]{new Integer(1), "foo"});
        this.insertRow("roundtrip1", new Object[]{new Integer(2), "bar"});
        this.insertRow("roundtrip2", new Object[]{"foo", new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{"bar", new Integer(2)});
        List beans1 = this.getRows("roundtrip1", "pk1");
        List beans2 = this.getRows("roundtrip2", "pk1");
        TestMisc.assertEquals((int)2, (int)beans1.size());
        TestMisc.assertEquals((int)2, (int)beans2.size());
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals("foo", beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans1.get(1), "pk1");
        this.assertEquals("bar", beans1.get(1), "pk2");
        this.assertEquals(new Integer(1), beans2.get(0), "pk1");
        this.assertEquals("foo", beans2.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(1), "pk1");
        this.assertEquals("bar", beans2.get(1), "pk2");
        this.deleteRow("roundtrip1", new Object[]{new Integer(1), "foo"});
        this.deleteRow("roundtrip2", new Object[]{"foo", new Integer(1)});
        beans1 = this.getRows("roundtrip1", "pk1");
        beans2 = this.getRows("roundtrip2", "pk1");
        TestMisc.assertEquals((int)1, (int)beans1.size());
        TestMisc.assertEquals((int)1, (int)beans2.size());
        this.assertEquals(new Integer(2), beans1.get(0), "pk1");
        this.assertEquals("bar", beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk1");
        this.assertEquals("bar", beans2.get(0), "pk2");
    }

    public void testDdlUtils227() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip'>\n    <column name='Pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue' type='VARCHAR'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip'>\n    <column name='Pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue' type='VARCHAR'/>\n  </table>\n</database>");
        Database readModel = this.readModelFromDatabase("roundtriptest");
        this.assertEquals(this.getAdjustedModel(), readModel);
        this.insertRow("Roundtrip", new Object[]{new Integer(1), "foo"});
        List beans = this.getRows("Roundtrip");
        TestMisc.assertEquals((int)1, (int)beans.size());
        this.assertEquals(new Integer(1), beans.get(0), "Pk");
        this.assertEquals("foo", beans.get(0), "Avalue");
        Table table = this.getModel().findTable("Roundtrip", this.getPlatform().isDelimitedIdentifierModeOn());
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM (SELECT * FROM ");
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        query.append(table.getName());
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            query.append(this.getPlatformInfo().getDelimiterToken());
        }
        query.append(")");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "PostgreSql".equals(this.getPlatform().getName()) || "Derby".equals(this.getPlatform().getName()) || "MsSql".equals(this.getPlatform().getName())) {
            query.append(" AS ");
            if (this.getPlatform().isDelimitedIdentifierModeOn()) {
                query.append(this.getPlatformInfo().getDelimiterToken());
            }
            query.append(table.getName());
            if (this.getPlatform().isDelimitedIdentifierModeOn()) {
                query.append(this.getPlatformInfo().getDelimiterToken());
            }
        }
        beans = this.getPlatform().fetch(this.getModel(), query.toString(), new Table[]{table});
        TestMisc.assertEquals((int)1, (int)beans.size());
        this.assertEquals(new Integer(1), beans.get(0), "Pk");
        this.assertEquals("foo", beans.get(0), "Avalue");
    }
}

