/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.math.BigDecimal;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;

public class TestInsertColumn
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestInsertColumn.getTests(TestInsertColumn.class);
    }

    public void testInsertColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue");
    }

    public void testInsertAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "avalue");
        } else {
            Object avalue = ((DynaBean)beans.get(0)).get("avalue");
            TestInsertColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
        }
    }

    public void testInsertRequiredColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' default='2' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' default='2' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal(2), beans.get(0), "avalue");
    }

    public void testInsertColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestInsertColumn.assertTrue((avalue == null || new Double(2.0).equals(avalue) ? 1 : 0) != 0);
    }

    public void testInsertRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' autoIncrement='true' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' autoIncrement='true' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "avalue");
        } else {
            Object avalue = ((DynaBean)beans.get(0)).get("avalue");
            TestInsertColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
        }
    }

    public void testAddRequiredColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='CHAR' size='8' default='text' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='CHAR' size='8' default='text' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue);
        }
    }

    public void testAddAndInsertMultipleColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0' required='true'/>\n    <column name='avalue4' type='VARCHAR' size='16'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Double(3.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0' required='true'/>\n    <column name='avalue4' type='VARCHAR' size='16'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
        this.assertEquals(new Double(3.0), beans.get(0), "avalue3");
        this.assertEquals((Object)null, beans.get(0), "avalue4");
    }

    public void testInsertPKAndColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestInsertColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testInsertPKAndAutoIncrementColumn() {
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "avalue");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        }
    }

    public void testAddAndInsertPKAndMultipleColumns() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertColumnIntoPK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertAutoIncrementColumnIntoPK() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(-1), new Integer(2)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if (isSybase) {
            this.assertEquals(new BigDecimal(-1), beans.get(0), "pk1");
        } else {
            this.assertEquals(new Integer(-1), beans.get(0), "pk1");
        }
        TestInsertColumn.assertEquals((Object)new Integer(2), (Object)((DynaBean)beans.get(0)).get("avalue"));
    }

    public void testInsertMultipleColumnsIntoPK() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertNonUniqueIndexAndColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue");
    }

    public void testInsertNonUniqueIndexAndAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
    }

    public void testInsertNonUniqueIndexAndRequiredColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertNonUniqueIndexAndColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue");
    }

    public void testInsertNonUniqueIndexAndrequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
    }

    public void testInsertNonUniqueIndexAndRequiredColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue);
        }
    }

    public void testAddAndInsertNonUniqueIndexAndMultipleColumns() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertUniqueIndexAndColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue");
    }

    public void testInsertUniqueIndexAndAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
    }

    public void testInsertUniqueIndexAndRequiredColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertUniqueIndexAndColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue");
    }

    public void testInsertUniqueIndexAndRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
    }

    public void testInsertUniqueIndexAndRequiredColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue);
        }
    }

    public void testAddAndInsertUniqueIndexAndMultipleColumns() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
    }

    public void testInsertAutoIncrementColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
    }

    public void testInsertRequiredColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertColumnWithDefaultIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue2");
    }

    public void testInsertRequiredAutoIncrementColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
    }

    public void testInsertRequiredColumnWithDefaultIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' default='text' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' default='text' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue2);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue2);
        }
    }

    public void testAddAndInsertMultipleColumnsIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n      <index-column name='avalue3'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n      <index-column name='avalue3'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
    }

    public void testInsertAutoIncrementColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
    }

    public void testInsertRequiredColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertColumnWithDefaultIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue2");
    }

    public void testInsertRequiredAutoIncrementColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
    }

    public void testInsertRequiredColumnWithDefaultIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' default='text' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' default='text' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue2);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue2);
        }
    }

    public void testAddAndInsertMultipleColumnsIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        TestInsertColumn.assertTrue((boolean)this.getRows("roundtrip").isEmpty());
    }

    public void testInsertFKAndLocalColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("text", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals((Object)null, beans2.get(0), "avalue");
    }

    public void testInsertFKAndLocalAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testInsertFKAndLocalRequiredColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new BigDecimal(1), beans1.get(0), "pk");
        TestInsertColumn.assertTrue((boolean)beans2.isEmpty());
    }

    public void testInsertFKAndLocalColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='DOUBLE' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Double(1.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='DOUBLE' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(1.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Double(1.0), beans2.get(0), "avalue");
    }

    public void testInsertFKAndLocalRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testInsertFKAndLocalRequiredColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        Object pk1 = ((DynaBean)beans1.get(0)).get("pk");
        Object avalue = ((DynaBean)beans2.get(0)).get("avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)pk1);
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)pk1);
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue);
        }
    }

    public void testAddAndInsertFKAndMultipleLocalColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(3)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        TestInsertColumn.assertTrue((boolean)beans2.isEmpty());
    }

    public void testInsertFKAndForeignColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testInsertFKAndForeignAutoIncrementColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testInsertFKAndForeignColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Double(1.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(1.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Double(1.0), beans2.get(0), "avalue");
    }

    public void testAddAndInsertFKAndMultipleForeignColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testInsertColumnsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testInsertAutoIncrementColumnIntoFK() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' autoIncrement='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' autoIncrement='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Integer(1), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testInsertRequiredColumnsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testInsertColumnsWithDefaultsIntoFK() {
        if (this.getPlatformInfo().isPrimaryKeyColumnsHaveToBeRequired()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='DOUBLE' primaryKey='true' default='2'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='DOUBLE' primaryKey='true' default='2'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        this.assertEquals(new Double(2.0), beans2.get(0), "avalue2");
    }

    public void testInsertRequiredAutoIncrementColumnIntoFK() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Integer(1), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testInsertRequiredColumnsWithDefaultsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='CHAR' size='8' primaryKey='true' required='true' default='text'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' required='true' default='text'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='CHAR' size='8' primaryKey='true' required='true' default='text'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' required='true' default='text'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        Object pk2 = ((DynaBean)beans1.get(0)).get("pk2");
        Object avalue2 = ((DynaBean)beans2.get(0)).get("avalue2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "HsqlDb".equals(this.getPlatform().getName()) || "MaxDB".equals(this.getPlatform().getName())) {
            TestInsertColumn.assertEquals((Object)"text", (Object)pk2);
            TestInsertColumn.assertEquals((Object)"text", (Object)avalue2);
        } else {
            TestInsertColumn.assertEquals((Object)"text    ", (Object)pk2);
            TestInsertColumn.assertEquals((Object)"text    ", (Object)avalue2);
        }
    }

    public void testAddAndInsertMultipleColumnsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' default='1' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' default='1'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue3' foreign='pk3'/>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' default='1' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' default='1'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue3' foreign='pk3'/>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }
}

