/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;

public class TestDropColumn
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestDropColumn.getTests(TestDropColumn.class);
    }

    public void testDropColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIMESTAMP'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIMESTAMP'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new java.sql.Date(new Date().getTime())});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropRequiredColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='3.1'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='3.1'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropRequiredColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='text'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropMultipleColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='CHAR' size='8' default='text'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='CHAR' size='8' default='text'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), null, new Integer(2), new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue2");
    }

    public void testDropMultipleColumnsInclAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='CHAR' size='8' default='text'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n    <column name='avalue3' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='CHAR' size='8' default='text'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n    <column name='avalue3' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), null, new Double(2.0), null});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue2");
    }

    public void testDropPKColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new Integer(3)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "pk2");
        this.assertEquals(new Integer(3), beans.get(0), "avalue");
    }

    public void testDropSinglePKColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue");
    }

    public void testDropMultiplePKColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "pk2");
        this.assertEquals(new Integer(4), beans.get(0), "avalue");
    }

    public void testDropAllPKColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(4), beans.get(0), "avalue");
    }

    public void testDropColumnFromIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("text", beans.get(0), "avalue2");
    }

    public void testDropSingleColumnFromIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropMultipleColumnsFromIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue3' type='TIMESTAMP'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n      <index-column name='avalue3'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <column name='avalue3' type='TIMESTAMP'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n      <index-column name='avalue3'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("text", beans.get(0), "avalue2");
    }

    public void testDropAllColumnsFromIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text", new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropSingleLocalColumnFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("text", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
    }

    public void testDropSingleForeignColumnFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text", new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(2), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("text", beans2.get(0), "avalue");
    }

    public void testDropAllLocalColumnsFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text", new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text", new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("text", beans1.get(0), "pk1");
        this.assertEquals(new Integer(2), beans1.get(0), "pk2");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
    }

    public void testDropAllForeignColumnsFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text", new Integer(2), new Integer(3)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text", new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(3), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("text", beans2.get(0), "avalue1");
        this.assertEquals(new Integer(2), beans2.get(0), "avalue2");
    }

    public void testDropLocalAndForeignColumnFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text", new Integer(2), new Integer(3)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text", new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(2), beans1.get(0), "pk2");
        this.assertEquals(new Integer(3), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "avalue2");
    }

    public void testDropMultipleLocalAndForeignColumnsFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue3' foreign='pk3'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue3' foreign='pk3'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text", new Integer(2), new Double(4.0), new Integer(3)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text", new Integer(2), new Double(4.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(2), beans1.get(0), "pk2");
        this.assertEquals(new Integer(3), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "avalue2");
    }

    public void testDropAllLocalAndForeignColumnsFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue3' foreign='pk3'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue3' foreign='pk3'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text", new Integer(2), new Double(4.0), new Integer(3)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "text", new Integer(2), new Double(4.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(3), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
    }
}

