/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import junit.framework.Test;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;
import org.apache.ddlutils.io.BinaryObjectsHelper;
import org.apache.ddlutils.io.DatabaseDataIO;
import org.apache.ddlutils.model.Database;

public class TestDatatypes
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestDatatypes.getTests(TestDatatypes.class);
    }

    protected void performDataTypeTest(String modelXml, Object value1, Object value2) {
        this.performDataTypeTest(modelXml, value1, value2, value1, value2);
    }

    protected void performDataTypeTest(String modelXml, Object value1, Object value2, Object defaultValue) {
        this.performDataTypeTest(modelXml, value1, value2, value1 == null ? defaultValue : value1, value2 == null ? defaultValue : value2);
    }

    protected void performDataTypeTest(String modelXml, Object inserted1, Object inserted2, Object expected1, Object expected2) {
        this.createDatabase(modelXml);
        this.insertRow("roundtrip", new Object[]{new Integer(1), inserted1});
        this.insertRow("roundtrip", new Object[]{new Integer(2), inserted2});
        List beans = this.getRows("roundtrip");
        this.assertEquals(expected1, beans.get(0), "avalue");
        this.assertEquals(expected2, beans.get(1), "avalue");
        Database modelFromDb = this.readModelFromDatabase("roundtriptest");
        this.assertEquals(this.getAdjustedModel(), modelFromDb);
        String alterTablesSql = this.getAlterTablesSql(modelFromDb).trim();
        TestDatatypes.assertEquals((String)"", (String)alterTablesSql);
        StringWriter stringWriter = new StringWriter();
        DatabaseDataIO dataIO = new DatabaseDataIO();
        dataIO.writeDataToXML(this.getPlatform(), this.getModel(), (Writer)stringWriter, "UTF-8");
        String dataSql = stringWriter.toString();
        TestDatatypes.assertTrue((dataSql != null && dataSql.length() > 0 ? 1 : 0) != 0);
        this.getPlatform().dropTables(this.getModel(), false);
        this.createDatabase(modelXml);
        dataIO.writeDataToDatabase(this.getPlatform(), this.getModel(), new Reader[]{new StringReader(dataSql)});
        beans = this.getRows("roundtrip");
        this.assertEquals(expected1, beans.get(0), "avalue");
        this.assertEquals(expected2, beans.get(1), "avalue");
    }

    public void testBit() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIT'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIT'/>\n  </table>\n</database>", Boolean.TRUE, Boolean.FALSE);
    }

    public void testBitWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIT' required='true' default='FALSE'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIT' required='true' default='FALSE'/>\n  </table>\n</database>", null, Boolean.TRUE, Boolean.FALSE);
    }

    public void testBoolean() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BOOLEAN'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BOOLEAN'/>\n  </table>\n</database>", Boolean.FALSE, Boolean.TRUE);
    }

    public void testBooleanWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BOOLEAN' required='true' default='true'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BOOLEAN' required='true' default='true'/>\n  </table>\n</database>", Boolean.TRUE, null, Boolean.TRUE);
    }

    public void testTinyInt() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TINYINT'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TINYINT'/>\n  </table>\n</database>", new Integer(254), new Integer(-254));
    }

    public void testTinyIntWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TINYINT' required='true' default='-200'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TINYINT' required='true' default='-200'/>\n  </table>\n</database>", new Integer(128), null, new Integer(-200));
    }

    public void testSmallInt() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='SMALLINT'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='SMALLINT'/>\n  </table>\n</database>", new Integer(Short.MIN_VALUE), new Integer(Short.MAX_VALUE));
    }

    public void testSmallIntWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='SMALLINT' required='true' default='-30000'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='SMALLINT' required='true' default='-30000'/>\n  </table>\n</database>", new Integer(256), null, new Integer(-30000));
    }

    public void testInteger() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>", new Integer(0), new Integer(Integer.MIN_VALUE));
    }

    public void testIntegerWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' default='2147483647'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' default='2147483647'/>\n  </table>\n</database>", null, new Integer(0x7FFFFFFE), new Integer(Integer.MAX_VALUE));
    }

    public void testBigInt() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIGINT'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIGINT'/>\n  </table>\n</database>", new Long(Long.MAX_VALUE), new Long(0L));
    }

    public void testBigIntWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIGINT' required='true' default='-9000000000000000000'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BIGINT' required='true' default='-9000000000000000000'/>\n  </table>\n</database>", null, new Long(-1L), new Long(-9000000000000000000L));
    }

    public void testReal() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='REAL'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='REAL'/>\n  </table>\n</database>", new Float(12345.6f), new Float(0.0f));
    }

    public void testRealWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='REAL' required='true' default='-1.01234'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='REAL' required='true' default='-1.01234'/>\n  </table>\n</database>", new Float(1.0E20f), null, new Float(-1.01234f));
    }

    public void testFloat() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='FLOAT'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='FLOAT'/>\n  </table>\n</database>", new Double(-1.0), new Double(1.0E-45));
    }

    public void testFloatWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='FLOAT' required='true' default='12345678.9012345'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='FLOAT' required='true' default='12345678.9012345'/>\n  </table>\n</database>", null, new Double(1.0E25), new Double(1.23456789012345E7));
    }

    public void testDouble() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>", new Double(1.0E38), new Double(1.01));
    }

    public void testDoubleWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' required='true' default='-987654321.098765'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' required='true' default='-987654321.098765'/>\n  </table>\n</database>", new Double(-1.0E25), null, new Double(-9.87654321098765E8));
    }

    public void testDecimal() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='13'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='13'/>\n  </table>\n</database>", new BigDecimal("0"), new BigDecimal("-1234567890123"));
    }

    public void testDecimalWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='15' required='true' default='123456789012345'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='15' required='true' default='123456789012345'/>\n  </table>\n</database>", null, new BigDecimal("-1"), new BigDecimal("123456789012345"));
    }

    public void testDecimalWithScale() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='15,7'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='15,7'/>\n  </table>\n</database>", new BigDecimal("0.0100001"), new BigDecimal("-87654321.1234567"));
    }

    public void testDecimalWithScaleAndDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='15,7' required='true' default='12345678.7654321'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='15,7' required='true' default='12345678.7654321'/>\n  </table>\n</database>", new BigDecimal("1.0000001"), null, new BigDecimal("12345678.7654321"));
    }

    public void testNumeric() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12'/>\n  </table>\n</database>", new BigDecimal("210987654321"), new BigDecimal("-2"));
    }

    public void testNumericWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='15' required='true' default='-123456789012345'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='15' required='true' default='-123456789012345'/>\n  </table>\n</database>", null, new BigDecimal("100"), new BigDecimal("-123456789012345"));
    }

    public void testNumericWithScale() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='15,8'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='15,8'/>\n  </table>\n</database>", new BigDecimal("1234567.89012345"), new BigDecimal("1.00000001"));
    }

    public void testNumericWithScaleAndDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='15,8' required='true' default='-1234567.87654321'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='15,8' required='true' default='-1234567.87654321'/>\n  </table>\n</database>", null, new BigDecimal("1e-8"), new BigDecimal("-1234567.87654321"));
    }

    public void testChar() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='10'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='10'/>\n  </table>\n</database>", null, "1234567890");
    }

    public void testCharWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='15' required='true' default='543210987654321'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='15' required='true' default='543210987654321'/>\n  </table>\n</database>", null, "123456789012345", "543210987654321", "123456789012345");
    }

    public void testVarChar() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>", "123456789012345678", null);
    }

    public void testVarCharWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='254' required='true' default='some value'/>\n  </table>\n</database>";
        String value = "12345678901234567890123456789012345678901234567890123456789012341234567890123456789012345678901234567890123456789012345678901234123456789012345678901234567890123456789012345678901234567890123412345678901234567890123456789012345678901234567890123456789012";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='254' required='true' default='some value'/>\n  </table>\n</database>", null, "12345678901234567890123456789012345678901234567890123456789012341234567890123456789012345678901234567890123456789012345678901234123456789012345678901234567890123456789012345678901234567890123412345678901234567890123456789012345678901234567890123456789012", "some value");
    }

    public void testVarCharWithDefaultValueWithQuote() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='12' required='true' default='someone&apos;s'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='12' required='true' default='someone&apos;s'/>\n  </table>\n</database>", null, "123456", "someone's");
    }

    public void testVarCharWithSingleQuoteAsDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='12' required='true' default='&apos;'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='12' required='true' default='&apos;'/>\n  </table>\n</database>", null, "123456", "'");
    }

    public void testLongVarChar() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='LONGVARCHAR'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='LONGVARCHAR'/>\n  </table>\n</database>", null, "some not too long text");
    }

    public void testLongVarCharWithDefault() {
        if (!this.getPlatformInfo().isDefaultValuesForLongTypesSupported() || "Interbase".equals(this.getPlatform().getName())) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='LONGVARCHAR' required='true' default='some value'/>\n  </table>\n</database>";
        String value = "1234567890123456789012345678901234567890123456789012345678901234123456789012345678901234567890123456789012345678901234567890123412345678901234567890123456789012345678901234567890123456789012341234567890123456789012345678901234567890123456789012345678901234";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='LONGVARCHAR' required='true' default='some value'/>\n  </table>\n</database>", null, "1234567890123456789012345678901234567890123456789012345678901234123456789012345678901234567890123456789012345678901234567890123412345678901234567890123456789012345678901234567890123456789012341234567890123456789012345678901234567890123456789012345678901234", "some value");
    }

    public void testDate() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DATE'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DATE'/>\n  </table>\n</database>", null, new Date(103, 12, 25));
    }

    public void testDateWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DATE' required='true' default='2000-01-01'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DATE' required='true' default='2000-01-01'/>\n  </table>\n</database>", new Date(105, 0, 1), null, new Date(100, 0, 1));
    }

    public void testTime() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIME'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIME'/>\n  </table>\n</database>", new Time(3, 47, 15), null);
    }

    public void testTimeWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIME' required='true' default='11:27:03'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIME' required='true' default='11:27:03'/>\n  </table>\n</database>", new Time(23, 59, 59), null, new Time(11, 27, 3));
    }

    public void testTimestamp() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIMESTAMP'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIMESTAMP'/>\n  </table>\n</database>", new Timestamp(70, 0, 1, 0, 0, 0, 0), new Timestamp(100, 10, 11, 10, 10, 10, 0));
    }

    public void testTimestampWithDefault() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIMESTAMP' required='true' default='1985-06-17 16:17:18'/>\n  </table>\n</database>";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='TIMESTAMP' required='true' default='1985-06-17 16:17:18'/>\n  </table>\n</database>", new Timestamp(90, 9, 21, 20, 25, 39, 0), null, new Timestamp(85, 5, 17, 16, 17, 18, 0));
    }

    public void testBinary() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BINARY'/>\n  </table>\n</database>";
        HashMap<String, String> value1 = new HashMap<String, String>();
        ArrayList<String> value2 = new ArrayList<String>();
        value1.put("test", "some value");
        value2.add("some other value");
        BinaryObjectsHelper helper = new BinaryObjectsHelper();
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BINARY'/>\n  </table>\n</database>", helper.serialize(value1), helper.serialize(value2), value1, value2);
    }

    public void testVarBinary() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARBINARY'/>\n  </table>\n</database>";
        TreeSet<String> value1 = new TreeSet<String>();
        String value2 = "a value, nothing special";
        value1.add("o look, a value !");
        BinaryObjectsHelper helper = new BinaryObjectsHelper();
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARBINARY'/>\n  </table>\n</database>", helper.serialize(value1), helper.serialize((Object)value2), value1, value2);
    }

    public void testLongVarBinary() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='LONGVARBINARY'/>\n  </table>\n</database>";
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("test1", "some value");
        value.put(null, "some other value");
        BinaryObjectsHelper helper = new BinaryObjectsHelper();
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='LONGVARBINARY'/>\n  </table>\n</database>", helper.serialize(value), null, value, null);
    }

    public void testBlob() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BLOB'/>\n  </table>\n</database>";
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("test1", "some value");
        value.put(null, "some other value");
        BinaryObjectsHelper helper = new BinaryObjectsHelper();
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='BLOB'/>\n  </table>\n</database>", helper.serialize(value), null, value, null);
    }

    public void testClob() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CLOB'/>\n  </table>\n</database>";
        String value = "1234567890123456789012345678901234567890123456789012345678901234123456789012345678901234567890123456789012345678901234567890123412345678901234567890123456789012345678901234567890123456789012341234567890123456789012345678901234567890123456789012345678901234";
        this.performDataTypeTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CLOB'/>\n  </table>\n</database>", null, "1234567890123456789012345678901234567890123456789012345678901234123456789012345678901234567890123456789012345678901234567890123412345678901234567890123456789012345678901234567890123456789012341234567890123456789012345678901234567890123456789012345678901234");
    }
}

