/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.io.DdlUtilsXMLException;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.ForeignKey;
import org.apache.ddlutils.model.Index;
import org.apache.ddlutils.model.IndexColumn;
import org.apache.ddlutils.model.ModelException;
import org.apache.ddlutils.model.Reference;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.model.TypeMap;

public class TestDatabaseIO
extends TestCase {
    private Database readModel(String modelAsXml) {
        DatabaseIO dbIO = new DatabaseIO();
        dbIO.setUseInternalDtd(true);
        dbIO.setValidateXml(true);
        return dbIO.read((Reader)new StringReader(modelAsXml));
    }

    private String writeModel(Database model) {
        StringWriter writer = new StringWriter();
        new DatabaseIO().write(model, (Writer)writer);
        return StringUtils.replace((String)writer.toString(), (String)"\r\n", (String)"\n");
    }

    private void assertEquals(String name, String description, int numColumns, int numPrimaryKeyColumns, int numAutoIncrementColumns, int numForeignKeys, int numIndexes, Table table) {
        TestDatabaseIO.assertEquals((String)name, (String)table.getName());
        TestDatabaseIO.assertEquals((String)description, (String)table.getDescription());
        TestDatabaseIO.assertEquals((int)numColumns, (int)table.getColumnCount());
        TestDatabaseIO.assertEquals((int)numPrimaryKeyColumns, (int)table.getPrimaryKeyColumns().length);
        TestDatabaseIO.assertEquals((int)numAutoIncrementColumns, (int)table.getAutoIncrementColumns().length);
        TestDatabaseIO.assertEquals((int)numForeignKeys, (int)table.getForeignKeyCount());
        TestDatabaseIO.assertEquals((int)numIndexes, (int)table.getIndexCount());
    }

    private void assertEquals(String name, int typeCode, int size, int scale, String defaultValue, String description, String javaName, boolean isPrimaryKey, boolean isRequired, boolean isAutoIncrement, Column column) {
        TestDatabaseIO.assertEquals((String)name, (String)column.getName());
        TestDatabaseIO.assertEquals((String)TypeMap.getJdbcTypeName((int)typeCode), (String)column.getType());
        TestDatabaseIO.assertEquals((int)typeCode, (int)column.getTypeCode());
        TestDatabaseIO.assertEquals((int)size, (int)column.getSizeAsInt());
        TestDatabaseIO.assertEquals((int)size, (int)column.getPrecisionRadix());
        TestDatabaseIO.assertEquals((int)scale, (int)column.getScale());
        if (size <= 0 && scale <= 0) {
            TestDatabaseIO.assertNull((Object)column.getSize());
        } else if (scale == 0) {
            TestDatabaseIO.assertEquals((String)("" + size), (String)column.getSize());
        } else {
            TestDatabaseIO.assertEquals((String)("" + size + "," + scale), (String)column.getSize());
        }
        TestDatabaseIO.assertEquals((String)defaultValue, (String)column.getDefaultValue());
        TestDatabaseIO.assertEquals((String)description, (String)column.getDescription());
        TestDatabaseIO.assertEquals((String)javaName, (String)column.getJavaName());
        TestDatabaseIO.assertEquals((boolean)isPrimaryKey, (boolean)column.isPrimaryKey());
        TestDatabaseIO.assertEquals((boolean)isRequired, (boolean)column.isRequired());
        TestDatabaseIO.assertEquals((boolean)isAutoIncrement, (boolean)column.isAutoIncrement());
    }

    private void assertEquals(String name, CascadeActionEnum onUpdate, CascadeActionEnum onDelete, Table referencedTable, int numReferences, ForeignKey foreignKey) {
        TestDatabaseIO.assertEquals((String)name, (String)foreignKey.getName());
        TestDatabaseIO.assertEquals((Object)onUpdate, (Object)foreignKey.getOnUpdate());
        TestDatabaseIO.assertEquals((Object)onDelete, (Object)foreignKey.getOnDelete());
        TestDatabaseIO.assertEquals((Object)referencedTable, (Object)foreignKey.getForeignTable());
        TestDatabaseIO.assertEquals((String)referencedTable.getName(), (String)foreignKey.getForeignTableName());
        TestDatabaseIO.assertEquals((int)numReferences, (int)foreignKey.getReferenceCount());
    }

    private void assertEquals(Column localColumn, Column foreignColumn, Reference ref) {
        TestDatabaseIO.assertEquals((Object)localColumn, (Object)ref.getLocalColumn());
        TestDatabaseIO.assertEquals((String)localColumn.getName(), (String)ref.getLocalColumnName());
        TestDatabaseIO.assertEquals((Object)foreignColumn, (Object)ref.getForeignColumn());
        TestDatabaseIO.assertEquals((String)foreignColumn.getName(), (String)ref.getForeignColumnName());
    }

    private void assertEquals(String name, boolean isUnique, int numColumns, Index index) {
        TestDatabaseIO.assertEquals((String)name, (String)index.getName());
        TestDatabaseIO.assertEquals((boolean)isUnique, (boolean)index.isUnique());
        TestDatabaseIO.assertEquals((int)numColumns, (int)index.getColumnCount());
    }

    private void assertEquals(Column column, String size, IndexColumn indexColumn) {
        TestDatabaseIO.assertEquals((Object)column, (Object)indexColumn.getColumn());
        TestDatabaseIO.assertEquals((String)column.getName(), (String)indexColumn.getName());
        TestDatabaseIO.assertEquals((String)size, (String)indexColumn.getSize());
    }

    private void assertEquals(String expectedXml, Database model) {
        TestDatabaseIO.assertEquals((String)expectedXml, (String)this.writeModel(model));
    }

    public void testNoDatabaseElement() {
        try {
            this.readModel("<data-base xmlns='http://db.apache.org/ddlutils/schema/1.1'></data-base>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testDatabaseWithoutNamespace() {
        try {
            this.readModel("<database></database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testDatabaseWithoutName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1'>\n  <table name='TestTable'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testNoTables() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)0, (int)model.getTableCount());
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\" />\n", model);
    }

    public void testTableWithoutColumns() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        this.assertEquals("SomeTable", "Some table", 0, 0, 0, 0, 0, model.getTable(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\" />\n</database>\n", model);
    }

    public void testTableWithoutName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testSingleColumn() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='INTEGER'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 4, 0, 0, null, null, null, false, false, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }

    public void testColumnWithoutName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TestTable'>\n    <column type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testColumnWithoutType() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TestTable'>\n    <column name='id'\n            primaryKey='true'\n            required='true'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testColumnTypes() throws Exception {
        int idx;
        StringBuilder modelXml = new StringBuilder();
        int[] types = TypeMap.getSuportedJdbcTypes();
        modelXml.append("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n");
        modelXml.append("  <table name='SomeTable'\n");
        modelXml.append("         description='Some table'>\n");
        for (int idx2 = 0; idx2 < types.length; ++idx2) {
            modelXml.append("    <column name='ID");
            modelXml.append(idx2);
            modelXml.append("' type='");
            modelXml.append(TypeMap.getJdbcTypeName((int)types[idx2]));
            modelXml.append("'/>\n");
        }
        modelXml.append("  </table>\n");
        modelXml.append("</database>");
        Database model = this.readModel(modelXml.toString());
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", types.length, 0, 0, 0, 0, table);
        for (idx = 0; idx < types.length; ++idx) {
            this.assertEquals("ID" + idx, types[idx], 0, 0, null, null, null, false, false, false, table.getColumn(idx));
        }
        modelXml.setLength(0);
        modelXml.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        modelXml.append("<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n");
        modelXml.append("  <table name=\"SomeTable\" description=\"Some table\">\n");
        for (idx = 0; idx < types.length; ++idx) {
            modelXml.append("    <column name=\"ID");
            modelXml.append(idx);
            modelXml.append("\" primaryKey=\"false\" required=\"false\" type=\"");
            modelXml.append(TypeMap.getJdbcTypeName((int)types[idx]));
            modelXml.append("\" autoIncrement=\"false\" />\n");
        }
        modelXml.append("  </table>\n");
        modelXml.append("</database>\n");
        this.assertEquals(modelXml.toString(), model);
    }

    public void testColumnWithIllegalType() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TestTable'>\n    <column name='id'\n            type='illegal'\n            primaryKey='true'\n            required='true'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testPrimaryKeyColumn() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='INTEGER'\n            primaryKey='true'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 1, 0, 0, 0, table);
        Column column = table.getColumn(0);
        this.assertEquals("ID", 4, 0, 0, null, null, null, true, false, false, column);
        TestDatabaseIO.assertEquals((Object)column, (Object)table.getPrimaryKeyColumns()[0]);
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"true\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }

    public void testRequiredColumn() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='INTEGER'\n            required='true'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 4, 0, 0, null, null, null, false, true, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"true\" type=\"INTEGER\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }

    public void testAutoIncrementColumn() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='INTEGER'\n            autoIncrement='true'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 1, 0, 0, table);
        Column column = table.getColumn(0);
        this.assertEquals("ID", 4, 0, 0, null, null, null, false, false, true, column);
        TestDatabaseIO.assertEquals((Object)column, (Object)table.getAutoIncrementColumns()[0]);
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"true\" />\n  </table>\n</database>\n", model);
    }

    public void testColumnWithSize1() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='20'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 12, 20, 0, null, null, null, false, false, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"20\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }

    public void testColumnWithSize2() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='DECIMAL'\n            size='10,3'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 3, 10, 3, null, null, null, false, false, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"DECIMAL\" size=\"10,3\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }

    public void testColumnWithDescription() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='INTEGER'\n            description='Foo'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 4, 0, 0, null, "Foo", null, false, false, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" description=\"Foo\" />\n  </table>\n</database>\n", model);
    }

    public void testColumnWithDefault() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='32'\n            default='Test string'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 12, 32, 0, "Test string", null, null, false, false, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"32\" default=\"Test string\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }

    public void testColumnWithJavaName() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='DOUBLE'\n            javaName='testString'/>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 0, 0, 0, 0, table);
        this.assertEquals("ID", 8, 0, 0, null, null, "testString", false, false, false, table.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"false\" required=\"false\" type=\"DOUBLE\" autoIncrement=\"false\" javaName=\"testString\" />\n  </table>\n</database>\n", model);
    }

    public void testSingleForeignkey() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)2, (int)model.getTableCount());
        Table someTable = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 1, 0, 0, 0, someTable);
        Column pkColumn = someTable.getColumn(0);
        this.assertEquals("ID", 12, 16, 0, null, "The primary key", null, true, true, false, pkColumn);
        Table anotherTable = model.getTable(1);
        this.assertEquals("AnotherTable", "And another table", 1, 0, 0, 1, 0, anotherTable);
        Column fkColumn = anotherTable.getColumn(0);
        this.assertEquals("Some_ID", 12, 16, 0, null, "The foreign key", null, false, false, false, fkColumn);
        ForeignKey fk = anotherTable.getForeignKey(0);
        this.assertEquals(null, CascadeActionEnum.NONE, CascadeActionEnum.NONE, someTable, 1, fk);
        this.assertEquals(fkColumn, pkColumn, fk.getFirstReference());
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"true\" required=\"true\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The primary key\" />\n  </table>\n  <table name=\"AnotherTable\" description=\"And another table\">\n    <column name=\"Some_ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The foreign key\" />\n    <foreign-key foreignTable=\"SomeTable\">\n      <reference local=\"Some_ID\" foreign=\"ID\" />\n    </foreign-key>\n  </table>\n</database>\n", model);
    }

    public void testForeignkeyWithTwoReferences() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n    <column name='VALUE1'\n            type='INTEGER'\n            required='false'\n            description='A value'/>\n    <column name='VALUE2'\n            type='DOUBLE'\n            required='false'\n            description='Another value'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <column name='Some_Value'\n            type='DOUBLE'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='Some_ID' foreign='ID'/>\n       <reference local='Some_Value' foreign='VALUE2'/>\n    </foreign-key>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)2, (int)model.getTableCount());
        Table someTable = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 3, 1, 0, 0, 0, someTable);
        this.assertEquals("ID", 12, 16, 0, null, "The primary key", null, true, true, false, someTable.getColumn(0));
        Table anotherTable = model.getTable(1);
        this.assertEquals("AnotherTable", "And another table", 2, 0, 0, 1, 0, anotherTable);
        this.assertEquals("Some_ID", 12, 16, 0, null, "The foreign key", null, false, false, false, anotherTable.getColumn(0));
        ForeignKey fk = anotherTable.getForeignKey(0);
        this.assertEquals(null, CascadeActionEnum.NONE, CascadeActionEnum.NONE, someTable, 2, fk);
        this.assertEquals(anotherTable.getColumn(0), someTable.getColumn(0), fk.getReference(0));
        this.assertEquals(anotherTable.getColumn(1), someTable.getColumn(2), fk.getReference(1));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"true\" required=\"true\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The primary key\" />\n    <column name=\"VALUE1\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" description=\"A value\" />\n    <column name=\"VALUE2\" primaryKey=\"false\" required=\"false\" type=\"DOUBLE\" autoIncrement=\"false\" description=\"Another value\" />\n  </table>\n  <table name=\"AnotherTable\" description=\"And another table\">\n    <column name=\"Some_ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The foreign key\" />\n    <column name=\"Some_Value\" primaryKey=\"false\" required=\"false\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <foreign-key foreignTable=\"SomeTable\">\n      <reference local=\"Some_ID\" foreign=\"ID\" />\n      <reference local=\"Some_Value\" foreign=\"VALUE2\" />\n    </foreign-key>\n  </table>\n</database>\n", model);
    }

    public void testForeignKeyWithoutReferences() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable'>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testNamedForeignkey() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key name='The foreignkey' foreignTable='SomeTable'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)2, (int)model.getTableCount());
        Table someTable = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 1, 0, 0, 0, someTable);
        this.assertEquals("ID", 12, 16, 0, null, "The primary key", null, true, true, false, someTable.getColumn(0));
        Table anotherTable = model.getTable(1);
        this.assertEquals("AnotherTable", "And another table", 1, 0, 0, 1, 0, anotherTable);
        this.assertEquals("Some_ID", 12, 16, 0, null, "The foreign key", null, false, false, false, anotherTable.getColumn(0));
        ForeignKey fk = anotherTable.getForeignKey(0);
        this.assertEquals("The foreignkey", CascadeActionEnum.NONE, CascadeActionEnum.NONE, someTable, 1, fk);
        this.assertEquals(anotherTable.getColumn(0), someTable.getColumn(0), fk.getReference(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"true\" required=\"true\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The primary key\" />\n  </table>\n  <table name=\"AnotherTable\" description=\"And another table\">\n    <column name=\"Some_ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The foreign key\" />\n    <foreign-key foreignTable=\"SomeTable\" name=\"The foreignkey\">\n      <reference local=\"Some_ID\" foreign=\"ID\" />\n    </foreign-key>\n  </table>\n</database>\n", model);
    }

    public void testForeignkeysWithOnUpdate() throws Exception {
        CascadeActionEnum enumValue;
        StringBuilder modelXml = new StringBuilder();
        modelXml.append("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n");
        modelXml.append("  <table name='SomeTable'\n");
        modelXml.append("         description='Some table'>\n");
        modelXml.append("    <column name='ID'\n");
        modelXml.append("            type='VARCHAR'\n");
        modelXml.append("            size='16'\n");
        modelXml.append("            primaryKey='true'\n");
        modelXml.append("            required='true'\n");
        modelXml.append("            description='The primary key'/>\n");
        modelXml.append("  </table>\n");
        modelXml.append("  <table name='AnotherTable'\n");
        modelXml.append("         description='And another table'>\n");
        modelXml.append("    <column name='Some_ID'\n");
        modelXml.append("            type='VARCHAR'\n");
        modelXml.append("            size='16'\n");
        modelXml.append("            description='The foreign key'/>\n");
        Iterator it = CascadeActionEnum.iterator();
        while (it.hasNext()) {
            CascadeActionEnum enumValue2 = (CascadeActionEnum)it.next();
            modelXml.append("    <foreign-key name='foreignkey ");
            modelXml.append(enumValue2.getName());
            modelXml.append("' foreignTable='SomeTable' onUpdate='");
            modelXml.append(enumValue2.getName());
            modelXml.append("'>\n");
            modelXml.append("       <reference local='Some_ID' foreign='ID'/>\n");
            modelXml.append("    </foreign-key>\n");
        }
        modelXml.append("  </table>\n");
        modelXml.append("</database>");
        Database model = this.readModel(modelXml.toString());
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)2, (int)model.getTableCount());
        Table someTable = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 1, 0, 0, 0, someTable);
        this.assertEquals("ID", 12, 16, 0, null, "The primary key", null, true, true, false, someTable.getColumn(0));
        Table anotherTable = model.getTable(1);
        this.assertEquals("AnotherTable", "And another table", 1, 0, 0, CascadeActionEnum.getEnumList().size(), 0, anotherTable);
        this.assertEquals("Some_ID", 12, 16, 0, null, "The foreign key", null, false, false, false, anotherTable.getColumn(0));
        int idx = 0;
        Iterator it2 = CascadeActionEnum.iterator();
        while (it2.hasNext()) {
            enumValue = (CascadeActionEnum)it2.next();
            ForeignKey fk = anotherTable.getForeignKey(idx);
            this.assertEquals("foreignkey " + enumValue.getName(), enumValue, CascadeActionEnum.NONE, someTable, 1, fk);
            this.assertEquals(anotherTable.getColumn(0), someTable.getColumn(0), fk.getReference(0));
            ++idx;
        }
        modelXml.setLength(0);
        modelXml.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        modelXml.append("<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n");
        modelXml.append("  <table name=\"SomeTable\" description=\"Some table\">\n");
        modelXml.append("    <column name=\"ID\" primaryKey=\"true\" required=\"true\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The primary key\" />\n");
        modelXml.append("  </table>\n");
        modelXml.append("  <table name=\"AnotherTable\" description=\"And another table\">\n");
        modelXml.append("    <column name=\"Some_ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The foreign key\" />\n");
        it2 = CascadeActionEnum.iterator();
        while (it2.hasNext()) {
            enumValue = (CascadeActionEnum)it2.next();
            modelXml.append("    <foreign-key foreignTable=\"SomeTable\" name=\"foreignkey ");
            modelXml.append(enumValue.getName());
            if (enumValue != CascadeActionEnum.NONE) {
                modelXml.append("\" onUpdate=\"");
                modelXml.append(enumValue.getName());
            }
            modelXml.append("\">\n");
            modelXml.append("      <reference local=\"Some_ID\" foreign=\"ID\" />\n");
            modelXml.append("    </foreign-key>\n");
            ++idx;
        }
        modelXml.append("  </table>\n");
        modelXml.append("</database>\n");
        this.assertEquals(modelXml.toString(), model);
    }

    public void testForeignkeysWithOnDelete() throws Exception {
        CascadeActionEnum enumValue;
        StringBuilder modelXml = new StringBuilder();
        modelXml.append("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n");
        modelXml.append("  <table name='SomeTable'\n");
        modelXml.append("         description='Some table'>\n");
        modelXml.append("    <column name='ID'\n");
        modelXml.append("            type='VARCHAR'\n");
        modelXml.append("            size='16'\n");
        modelXml.append("            primaryKey='true'\n");
        modelXml.append("            required='true'\n");
        modelXml.append("            description='The primary key'/>\n");
        modelXml.append("  </table>\n");
        modelXml.append("  <table name='AnotherTable'\n");
        modelXml.append("         description='And another table'>\n");
        modelXml.append("    <column name='Some_ID'\n");
        modelXml.append("            type='VARCHAR'\n");
        modelXml.append("            size='16'\n");
        modelXml.append("            description='The foreign key'/>\n");
        Iterator it = CascadeActionEnum.iterator();
        while (it.hasNext()) {
            CascadeActionEnum enumValue2 = (CascadeActionEnum)it.next();
            modelXml.append("    <foreign-key name='foreignkey ");
            modelXml.append(enumValue2.getName());
            modelXml.append("' foreignTable='SomeTable' onDelete='");
            modelXml.append(enumValue2.getName());
            modelXml.append("'>\n");
            modelXml.append("       <reference local='Some_ID' foreign='ID'/>\n");
            modelXml.append("    </foreign-key>\n");
        }
        modelXml.append("  </table>\n");
        modelXml.append("</database>");
        Database model = this.readModel(modelXml.toString());
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)2, (int)model.getTableCount());
        Table someTable = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 1, 1, 0, 0, 0, someTable);
        this.assertEquals("ID", 12, 16, 0, null, "The primary key", null, true, true, false, someTable.getColumn(0));
        Table anotherTable = model.getTable(1);
        this.assertEquals("AnotherTable", "And another table", 1, 0, 0, CascadeActionEnum.getEnumList().size(), 0, anotherTable);
        this.assertEquals("Some_ID", 12, 16, 0, null, "The foreign key", null, false, false, false, anotherTable.getColumn(0));
        int idx = 0;
        Iterator it2 = CascadeActionEnum.iterator();
        while (it2.hasNext()) {
            enumValue = (CascadeActionEnum)it2.next();
            ForeignKey fk = anotherTable.getForeignKey(idx);
            this.assertEquals("foreignkey " + enumValue.getName(), CascadeActionEnum.NONE, enumValue, someTable, 1, fk);
            this.assertEquals(anotherTable.getColumn(0), someTable.getColumn(0), fk.getReference(0));
            ++idx;
        }
        modelXml.setLength(0);
        modelXml.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        modelXml.append("<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n");
        modelXml.append("  <table name=\"SomeTable\" description=\"Some table\">\n");
        modelXml.append("    <column name=\"ID\" primaryKey=\"true\" required=\"true\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The primary key\" />\n");
        modelXml.append("  </table>\n");
        modelXml.append("  <table name=\"AnotherTable\" description=\"And another table\">\n");
        modelXml.append("    <column name=\"Some_ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The foreign key\" />\n");
        it2 = CascadeActionEnum.iterator();
        while (it2.hasNext()) {
            enumValue = (CascadeActionEnum)it2.next();
            modelXml.append("    <foreign-key foreignTable=\"SomeTable\" name=\"foreignkey ");
            modelXml.append(enumValue.getName());
            if (enumValue != CascadeActionEnum.NONE) {
                modelXml.append("\" onDelete=\"");
                modelXml.append(enumValue.getName());
            }
            modelXml.append("\">\n");
            modelXml.append("      <reference local=\"Some_ID\" foreign=\"ID\" />\n");
            modelXml.append("    </foreign-key>\n");
            ++idx;
        }
        modelXml.append("  </table>\n");
        modelXml.append("</database>\n");
        this.assertEquals(modelXml.toString(), model);
    }

    public void testForeignKeyWithIllegalOnUpdateValue() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable' onUpdate='illegal'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithEmptyOnUpdateValue() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable' onUpdate=''>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithIllegalOnDeleteValue() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable' onDelete='illegal'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithEmptyOnDeleteValue() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable' onDelete=''>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testForeignKeyReferencingUndefinedTable() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='TheTable'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testForeignKeyUsingUndefinedColumn() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='ID' foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testForeignKeyReferencingUndefinedColumn() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='Some_ID' foreign='TheID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithoutLocalColumn() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference foreign='ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithoutRemoteColumn() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='Some_ID'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testTwoForeignkeys() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n    <column name='VALUE1'\n            type='INTEGER'\n            required='false'\n            description='A value'/>\n    <column name='VALUE2'\n            type='DOUBLE'\n            required='false'\n            description='Another value'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <column name='Some_Value'\n            type='DOUBLE'/>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n    <foreign-key foreignTable='SomeTable'>\n       <reference local='Some_Value' foreign='VALUE2'/>\n    </foreign-key>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)2, (int)model.getTableCount());
        Table someTable = model.getTable(0);
        this.assertEquals("SomeTable", "Some table", 3, 1, 0, 0, 0, someTable);
        this.assertEquals("ID", 12, 16, 0, null, "The primary key", null, true, true, false, someTable.getColumn(0));
        Table anotherTable = model.getTable(1);
        this.assertEquals("AnotherTable", "And another table", 2, 0, 0, 2, 0, anotherTable);
        this.assertEquals("Some_ID", 12, 16, 0, null, "The foreign key", null, false, false, false, anotherTable.getColumn(0));
        ForeignKey fk = anotherTable.getForeignKey(0);
        this.assertEquals(null, CascadeActionEnum.NONE, CascadeActionEnum.NONE, someTable, 1, fk);
        this.assertEquals(anotherTable.getColumn(0), someTable.getColumn(0), fk.getReference(0));
        fk = anotherTable.getForeignKey(1);
        this.assertEquals(null, CascadeActionEnum.NONE, CascadeActionEnum.NONE, someTable, 1, fk);
        this.assertEquals(anotherTable.getColumn(1), someTable.getColumn(2), fk.getReference(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\" description=\"Some table\">\n    <column name=\"ID\" primaryKey=\"true\" required=\"true\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The primary key\" />\n    <column name=\"VALUE1\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" description=\"A value\" />\n    <column name=\"VALUE2\" primaryKey=\"false\" required=\"false\" type=\"DOUBLE\" autoIncrement=\"false\" description=\"Another value\" />\n  </table>\n  <table name=\"AnotherTable\" description=\"And another table\">\n    <column name=\"Some_ID\" primaryKey=\"false\" required=\"false\" type=\"VARCHAR\" size=\"16\" autoIncrement=\"false\" description=\"The foreign key\" />\n    <column name=\"Some_Value\" primaryKey=\"false\" required=\"false\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <foreign-key foreignTable=\"SomeTable\">\n      <reference local=\"Some_ID\" foreign=\"ID\" />\n    </foreign-key>\n    <foreign-key foreignTable=\"SomeTable\">\n      <reference local=\"Some_Value\" foreign=\"VALUE2\" />\n    </foreign-key>\n  </table>\n</database>\n", model);
    }

    public void testTwoForeignkeysWithSameName() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'\n         description='Some table'>\n    <column name='ID'\n            type='VARCHAR'\n            size='16'\n            primaryKey='true'\n            required='true'\n            description='The primary key'/>\n    <column name='VALUE1'\n            type='INTEGER'\n            required='false'\n            description='A value'/>\n    <column name='VALUE2'\n            type='DOUBLE'\n            required='false'\n            description='Another value'/>\n  </table>\n  <table name='AnotherTable'\n         description='And another table'>\n    <column name='Some_ID'\n            type='VARCHAR'\n            size='16'\n            description='The foreign key'/>\n    <column name='Some_Value'\n            type='DOUBLE'/>\n    <foreign-key name='The foreignkey' foreignTable='SomeTable'>\n       <reference local='Some_ID' foreign='ID'/>\n    </foreign-key>\n    <foreign-key name='The foreignkey' foreignTable='SomeTable'>\n       <reference local='Some_Value' foreign='VALUE2'/>\n    </foreign-key>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testSingleIndex() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <index>\n      <index-column name='value'/>\n    </index>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndex", null, 2, 1, 0, 0, 1, table);
        this.assertEquals("id", 8, 0, 0, null, null, null, true, true, false, table.getColumn(0));
        this.assertEquals("value", 5, 0, 0, "1", null, null, false, false, false, table.getColumn(1));
        Index index = table.getIndex(0);
        this.assertEquals(null, false, 1, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndex\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <column name=\"value\" primaryKey=\"false\" required=\"false\" type=\"SMALLINT\" default=\"1\" autoIncrement=\"false\" />\n    <index>\n      <index-column name=\"value\" />\n    </index>\n  </table>\n</database>\n", model);
    }

    public void testIndexWithTwoColumns() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='when'\n            type='TIMESTAMP'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <index>\n      <index-column name='when'/>\n      <index-column name='id'/>\n    </index>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndex", null, 3, 1, 0, 0, 1, table);
        this.assertEquals("id", 8, 0, 0, null, null, null, true, true, false, table.getColumn(0));
        this.assertEquals("when", 93, 0, 0, null, null, null, false, true, false, table.getColumn(1));
        this.assertEquals("value", 5, 0, 0, "1", null, null, false, false, false, table.getColumn(2));
        Index index = table.getIndex(0);
        this.assertEquals(null, false, 2, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals(table.getColumn(0), null, index.getColumn(1));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndex\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <column name=\"when\" primaryKey=\"false\" required=\"true\" type=\"TIMESTAMP\" autoIncrement=\"false\" />\n    <column name=\"value\" primaryKey=\"false\" required=\"false\" type=\"SMALLINT\" default=\"1\" autoIncrement=\"false\" />\n    <index>\n      <index-column name=\"when\" />\n      <index-column name=\"id\" />\n    </index>\n  </table>\n</database>\n", model);
    }

    public void testIndexWithName() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <index name='The Index'>\n      <index-column name='value'/>\n    </index>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndex", null, 2, 1, 0, 0, 1, table);
        this.assertEquals("id", 8, 0, 0, null, null, null, true, true, false, table.getColumn(0));
        this.assertEquals("value", 5, 0, 0, "1", null, null, false, false, false, table.getColumn(1));
        Index index = table.getIndex(0);
        this.assertEquals("The Index", false, 1, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndex\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <column name=\"value\" primaryKey=\"false\" required=\"false\" type=\"SMALLINT\" default=\"1\" autoIncrement=\"false\" />\n    <index name=\"The Index\">\n      <index-column name=\"value\" />\n    </index>\n  </table>\n</database>\n", model);
    }

    public void testIndexWithoutColumns() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <index>\n    </index>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testIndexWithUndefinedColumns() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <index>\n      <index-column name='theValue'/>\n    </index>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testIndexWithNoNameColumn() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <index>\n      <index-column/>\n    </index>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testSingleUniqueIndex() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <unique>\n      <unique-column name='value'/>\n    </unique>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndex", null, 2, 1, 0, 0, 1, table);
        this.assertEquals("id", 8, 0, 0, null, null, null, true, true, false, table.getColumn(0));
        this.assertEquals("value", 5, 0, 0, "1", null, null, false, false, false, table.getColumn(1));
        Index index = table.getIndex(0);
        this.assertEquals(null, true, 1, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndex\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <column name=\"value\" primaryKey=\"false\" required=\"false\" type=\"SMALLINT\" default=\"1\" autoIncrement=\"false\" />\n    <unique>\n      <unique-column name=\"value\" />\n    </unique>\n  </table>\n</database>\n", model);
    }

    public void testUniqueIndexWithTwoColumns() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='when'\n            type='TIMESTAMP'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <unique>\n      <unique-column name='when'/>\n      <unique-column name='id'/>\n    </unique>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndex", null, 3, 1, 0, 0, 1, table);
        this.assertEquals("id", 8, 0, 0, null, null, null, true, true, false, table.getColumn(0));
        this.assertEquals("when", 93, 0, 0, null, null, null, false, true, false, table.getColumn(1));
        this.assertEquals("value", 5, 0, 0, "1", null, null, false, false, false, table.getColumn(2));
        Index index = table.getIndex(0);
        this.assertEquals(null, true, 2, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals(table.getColumn(0), null, index.getColumn(1));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndex\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <column name=\"when\" primaryKey=\"false\" required=\"true\" type=\"TIMESTAMP\" autoIncrement=\"false\" />\n    <column name=\"value\" primaryKey=\"false\" required=\"false\" type=\"SMALLINT\" default=\"1\" autoIncrement=\"false\" />\n    <unique>\n      <unique-column name=\"when\" />\n      <unique-column name=\"id\" />\n    </unique>\n  </table>\n</database>\n", model);
    }

    public void testUniqueIndexWithName() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <unique name='The Index'>\n      <unique-column name='value'/>\n    </unique>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndex", null, 2, 1, 0, 0, 1, table);
        this.assertEquals("id", 8, 0, 0, null, null, null, true, true, false, table.getColumn(0));
        this.assertEquals("value", 5, 0, 0, "1", null, null, false, false, false, table.getColumn(1));
        Index index = table.getIndex(0);
        this.assertEquals("The Index", true, 1, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndex\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"DOUBLE\" autoIncrement=\"false\" />\n    <column name=\"value\" primaryKey=\"false\" required=\"false\" type=\"SMALLINT\" default=\"1\" autoIncrement=\"false\" />\n    <unique name=\"The Index\">\n      <unique-column name=\"value\" />\n    </unique>\n  </table>\n</database>\n", model);
    }

    public void testUniqueIndexWithoutColumns() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <unique>\n    </unique>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testUniqueIndexWithUndefinedColumns() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <unique>\n      <unique-column name='theValue'/>\n    </unique>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testUniqueIndexWithNoNameColumn() throws Exception {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndex'>\n    <column name='id'\n            type='DOUBLE'\n            primaryKey='true'\n            required='true'/>\n    <column name='value'\n            type='SMALLINT'\n            default='1'/>\n    <unique>\n      <unique-column/>\n    </unique>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testMixedIndexes() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWithIndexes'>\n    <column name='id'\n            type='SMALLINT'\n            primaryKey='false'\n            required='true'\n            autoIncrement='true'/>\n    <column name='when'\n            type='DATE'/>\n    <unique name='important column'>\n      <unique-column name='id'/>\n    </unique>\n    <index>\n      <index-column name='when'/>\n    </index>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("TableWithIndexes", null, 2, 0, 1, 0, 2, table);
        this.assertEquals("id", 5, 0, 0, null, null, null, false, true, true, table.getColumn(0));
        this.assertEquals("when", 91, 0, 0, null, null, null, false, false, false, table.getColumn(1));
        TestDatabaseIO.assertEquals((Object)table.getColumn(0), (Object)table.getAutoIncrementColumns()[0]);
        Index index = table.getIndex(0);
        this.assertEquals("important column", true, 1, index);
        this.assertEquals(table.getColumn(0), null, index.getColumn(0));
        index = table.getIndex(1);
        this.assertEquals(null, false, 1, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"TableWithIndexes\">\n    <column name=\"id\" primaryKey=\"false\" required=\"true\" type=\"SMALLINT\" autoIncrement=\"true\" />\n    <column name=\"when\" primaryKey=\"false\" required=\"false\" type=\"DATE\" autoIncrement=\"false\" />\n    <unique name=\"important column\">\n      <unique-column name=\"id\" />\n    </unique>\n    <index>\n      <index-column name=\"when\" />\n    </index>\n  </table>\n</database>\n", model);
    }

    public void testComplex() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='A'\n         description='Table A'>\n    <column name='id'\n            type='INTEGER'\n            autoIncrement='true'\n            primaryKey='true'\n            required='true'\n            description='The primary key of table A'/>\n    <column name='parentId'\n            type='INTEGER'\n            description='The field for the foreign key parent'/>\n    <column name='name'\n            type='VARCHAR'\n            size='32'\n            required='true'\n            description='The name'/>\n    <foreign-key name='parent' foreignTable='A'>\n       <reference local='parentId' foreign='id'/>\n    </foreign-key>\n    <unique>\n      <unique-column name='name'/>\n    </unique>\n  </table>\n  <table name='B'\n         description='Table B'>\n    <column name='id'\n            type='TIMESTAMP'\n            primaryKey='true'\n            required='true'\n            description='The primary key of table B'/>\n    <column name='aid'\n            type='INTEGER'\n            description='The field for the foreign key towards A'/>\n    <column name='cid'\n            type='CHAR'\n            size='32'\n            description='The field for the foreign key towards C'/>\n    <foreign-key foreignTable='A'>\n       <reference local='aid' foreign='id'/>\n    </foreign-key>\n    <foreign-key foreignTable='C'>\n       <reference local='cid' foreign='id'/>\n    </foreign-key>\n    <index>\n      <index-column name='aid'/>\n      <index-column name='cid'/>\n    </index>\n  </table>\n  <table name='C'\n         description='Table C'>\n    <column name='id'\n            type='CHAR'\n            size='32'\n            primaryKey='true'\n            required='true'\n            description='The primary key of table C'/>\n    <column name='text'\n            type='LONGVARCHAR'\n            description='The text'/>\n    <index name='byText'>\n      <index-column name='text'/>\n    </index>\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)3, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("A", "Table A", 3, 1, 1, 1, 1, table);
        this.assertEquals("id", 4, 0, 0, null, "The primary key of table A", null, true, true, true, table.getColumn(0));
        this.assertEquals("parentId", 4, 0, 0, null, "The field for the foreign key parent", null, false, false, false, table.getColumn(1));
        this.assertEquals("name", 12, 32, 0, null, "The name", null, false, true, false, table.getColumn(2));
        TestDatabaseIO.assertEquals((Object)table.getColumn(0), (Object)table.getAutoIncrementColumns()[0]);
        ForeignKey fk = table.getForeignKey(0);
        this.assertEquals("parent", CascadeActionEnum.NONE, CascadeActionEnum.NONE, table, 1, fk);
        this.assertEquals(table.getColumn(1), table.getColumn(0), fk.getFirstReference());
        Index index = table.getIndex(0);
        this.assertEquals(null, true, 1, index);
        this.assertEquals(table.getColumn(2), null, index.getColumn(0));
        table = model.getTable(1);
        this.assertEquals("B", "Table B", 3, 1, 0, 2, 1, table);
        this.assertEquals("id", 93, 0, 0, null, "The primary key of table B", null, true, true, false, table.getColumn(0));
        this.assertEquals("aid", 4, 0, 0, null, "The field for the foreign key towards A", null, false, false, false, table.getColumn(1));
        this.assertEquals("cid", 1, 32, 0, null, "The field for the foreign key towards C", null, false, false, false, table.getColumn(2));
        fk = table.getForeignKey(0);
        this.assertEquals(null, CascadeActionEnum.NONE, CascadeActionEnum.NONE, model.getTable(0), 1, fk);
        this.assertEquals(table.getColumn(1), model.getTable(0).getColumn(0), fk.getFirstReference());
        fk = table.getForeignKey(1);
        this.assertEquals(null, CascadeActionEnum.NONE, CascadeActionEnum.NONE, model.getTable(2), 1, fk);
        this.assertEquals(table.getColumn(2), model.getTable(2).getColumn(0), fk.getFirstReference());
        index = table.getIndex(0);
        this.assertEquals(null, false, 2, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals(table.getColumn(2), null, index.getColumn(1));
        table = model.getTable(2);
        this.assertEquals("C", "Table C", 2, 1, 0, 0, 1, table);
        this.assertEquals("id", 1, 32, 0, null, "The primary key of table C", null, true, true, false, table.getColumn(0));
        this.assertEquals("text", -1, 0, 0, null, "The text", null, false, false, false, table.getColumn(1));
        index = table.getIndex(0);
        this.assertEquals("byText", false, 1, index);
        this.assertEquals(table.getColumn(1), null, index.getColumn(0));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"A\" description=\"Table A\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"INTEGER\" autoIncrement=\"true\" description=\"The primary key of table A\" />\n    <column name=\"parentId\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" description=\"The field for the foreign key parent\" />\n    <column name=\"name\" primaryKey=\"false\" required=\"true\" type=\"VARCHAR\" size=\"32\" autoIncrement=\"false\" description=\"The name\" />\n    <foreign-key foreignTable=\"A\" name=\"parent\">\n      <reference local=\"parentId\" foreign=\"id\" />\n    </foreign-key>\n    <unique>\n      <unique-column name=\"name\" />\n    </unique>\n  </table>\n  <table name=\"B\" description=\"Table B\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"TIMESTAMP\" autoIncrement=\"false\" description=\"The primary key of table B\" />\n    <column name=\"aid\" primaryKey=\"false\" required=\"false\" type=\"INTEGER\" autoIncrement=\"false\" description=\"The field for the foreign key towards A\" />\n    <column name=\"cid\" primaryKey=\"false\" required=\"false\" type=\"CHAR\" size=\"32\" autoIncrement=\"false\" description=\"The field for the foreign key towards C\" />\n    <foreign-key foreignTable=\"A\">\n      <reference local=\"aid\" foreign=\"id\" />\n    </foreign-key>\n    <foreign-key foreignTable=\"C\">\n      <reference local=\"cid\" foreign=\"id\" />\n    </foreign-key>\n    <index>\n      <index-column name=\"aid\" />\n      <index-column name=\"cid\" />\n    </index>\n  </table>\n  <table name=\"C\" description=\"Table C\">\n    <column name=\"id\" primaryKey=\"true\" required=\"true\" type=\"CHAR\" size=\"32\" autoIncrement=\"false\" description=\"The primary key of table C\" />\n    <column name=\"text\" primaryKey=\"false\" required=\"false\" type=\"LONGVARCHAR\" autoIncrement=\"false\" description=\"The text\" />\n    <index name=\"byText\">\n      <index-column name=\"text\" />\n    </index>\n  </table>\n</database>\n", model);
    }

    public void testUndefinedIndexColumn() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWidthIndex'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n    <index name='test index'>\n      <index-column name='id'/>\n      <index-column name='value'/>\n    </index>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testTwoTablesWithTheSameName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TestTable'>\n    <column name='id1'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n  </table>\n  <table name='TestTable'>\n    <column name='id2'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testTwoColumnsWithTheSameName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TestTable'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n    <column name='id'\n            type='VARCHAR'/>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testUndefinedUniqueColumn() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWidthUnique'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n    <unique>\n      <unique-column name='value'/>\n    </unique>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testTwoIndicesWithTheSameName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWidthIndex'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n    <column name='value1'\n            type='INTEGER'\n            required='true'/>\n    <column name='value2'\n            type='INTEGER'\n            required='true'/>\n    <index name='the index'>\n      <index-column name='value1'/>\n    </index>\n    <index name='the index'>\n      <index-column name='value2'/>\n    </index>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testTwoUniqueIndicesWithTheSameName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWidthUnique'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n    <column name='value1'\n            type='INTEGER'\n            required='true'/>\n    <column name='value2'\n            type='INTEGER'\n            required='true'/>\n    <unique name='the unique'>\n      <unique-column name='value1'/>\n    </unique>\n    <unique name='the unique'>\n      <unique-column name='value2'/>\n    </unique>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testUniqueAndNormalIndexWithTheSameName() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableWidthUnique'>\n    <column name='id'\n            type='INTEGER'\n            primaryKey='true'\n            required='true'/>\n    <column name='value1'\n            type='INTEGER'\n            required='true'/>\n    <column name='value2'\n            type='INTEGER'\n            required='true'/>\n    <index name='test'>\n      <index-column name='value1'/>\n    </index>\n    <unique name='test'>\n      <unique-column name='value2'/>\n    </unique>\n  </table>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void testFaultReadOfTable() {
        try {
            this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='db' >\n  <index name='NotATable'/>\n</database>");
            TestDatabaseIO.fail();
        }
        catch (DdlUtilsXMLException ddlUtilsXMLException) {
            // empty catch block
        }
    }

    public void testTurbineExtension() throws Exception {
        Database model = this.readModel("<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='SomeTable'>\n    <column name='intField'\n            type='BOOLEANINT'/>\n    <column name='charField'\n            type='BOOLEANCHAR' />\n  </table>\n</database>");
        TestDatabaseIO.assertEquals((String)"test", (String)model.getName());
        TestDatabaseIO.assertEquals((int)1, (int)model.getTableCount());
        Table table = model.getTable(0);
        this.assertEquals("SomeTable", null, 2, 0, 0, 0, 0, table);
        this.assertEquals("intField", -6, 0, 0, null, null, null, false, false, false, table.getColumn(0));
        this.assertEquals("charField", 1, 0, 0, null, null, null, false, false, false, table.getColumn(1));
        this.assertEquals("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns=\"http://db.apache.org/ddlutils/schema/1.1\" name=\"test\">\n  <table name=\"SomeTable\">\n    <column name=\"intField\" primaryKey=\"false\" required=\"false\" type=\"TINYINT\" autoIncrement=\"false\" />\n    <column name=\"charField\" primaryKey=\"false\" required=\"false\" type=\"CHAR\" autoIncrement=\"false\" />\n  </table>\n</database>\n", model);
    }
}

