/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataSink;
import org.apache.ddlutils.io.DataSinkException;
import org.apache.ddlutils.io.DataWriter;
import org.apache.ddlutils.io.DatabaseIO;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.model.Table;

public class TestDataReaderAndWriter
extends TestCase {
    private Database readModel(String schemaXml) {
        DatabaseIO modelIO = new DatabaseIO();
        modelIO.setValidateXml(true);
        return modelIO.read((Reader)new StringReader(schemaXml));
    }

    private byte[] writeBean(Database model, SqlDynaBean bean, String encoding) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataWriter dataWriter = new DataWriter((OutputStream)output, encoding);
        dataWriter.writeDocumentStart();
        dataWriter.write(bean);
        dataWriter.writeDocumentEnd();
        return output.toByteArray();
    }

    private List readBeans(Database model, byte[] dataXml) {
        ArrayList beans = new ArrayList();
        DataReader dataReader = new DataReader();
        dataReader.setModel(model);
        dataReader.setSink((DataSink)new TestDataSink(beans));
        dataReader.read((InputStream)new ByteArrayInputStream(dataXml));
        return beans;
    }

    private List readBeans(Database model, String dataXml) {
        ArrayList beans = new ArrayList();
        DataReader dataReader = new DataReader();
        dataReader.setModel(model);
        dataReader.setSink((DataSink)new TestDataSink(beans));
        dataReader.read((Reader)new StringReader(dataXml));
        return beans;
    }

    private void roundtripTest(Database model, SqlDynaBean bean, String encoding, String expectedDataXml) throws UnsupportedEncodingException {
        byte[] xmlData = this.writeBean(model, bean, encoding);
        TestDataReaderAndWriter.assertEquals((String)expectedDataXml, (String)new String(xmlData, encoding));
        List beans = this.readBeans(model, xmlData);
        TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
        TestDataReaderAndWriter.assertEquals((Object)bean, beans.get(0));
    }

    public void testRead() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='bookstore'>\n  <table name='author'>\n    <column name='author_id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='name' type='VARCHAR' size='50' required='true'/>\n    <column name='organisation' type='VARCHAR' size='50' required='false'/>\n  </table>\n  <table name='book'>\n    <column name='book_id' type='INTEGER' required='true' primaryKey='true' autoIncrement='true'/>\n    <column name='isbn' type='VARCHAR' size='15' required='true'/>\n    <column name='author_id' type='INTEGER' required='true'/>\n    <column name='title' type='VARCHAR' size='255' default='N/A' required='true'/>\n    <column name='issue_date' type='DATE' required='false'/>\n    <foreign-key foreignTable='author'>\n      <reference local='author_id' foreign='author_id'/>\n    </foreign-key>\n    <index name='book_isbn'>\n      <index-column name='isbn'/>\n    </index>\n  </table>\n</database>");
        List beans = this.readBeans(model, "<data>\n  <author author_id='1' name='Ernest Hemingway'/>\n  <author author_id='2' name='William Shakespeare'/>\n  <book book_id='1' author_id='1'>\n    <isbn>0684830493</isbn>\n    <title>Old Man And The Sea</title>\n    <issue_date>1952</issue_date>\n  </book>\n  <book book_id='2' author_id='2'>\n    <isbn>0198321465</isbn>\n    <title>Macbeth</title>\n    <issue_date>1606</issue_date>\n  </book>\n  <book book_id='3' author_id='2'>\n    <isbn>0140707026</isbn>\n    <title>A Midsummer Night's Dream</title>\n    <issue_date>1595</issue_date>\n  </book>\n</data>");
        TestDataReaderAndWriter.assertEquals((int)5, (int)beans.size());
        DynaBean obj1 = (DynaBean)beans.get(0);
        DynaBean obj2 = (DynaBean)beans.get(1);
        DynaBean obj3 = (DynaBean)beans.get(2);
        DynaBean obj4 = (DynaBean)beans.get(3);
        DynaBean obj5 = (DynaBean)beans.get(4);
        TestDataReaderAndWriter.assertEquals((String)"author", (String)obj1.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj1.get("author_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"Ernest Hemingway", (String)obj1.get("name").toString());
        TestDataReaderAndWriter.assertEquals((String)"author", (String)obj2.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj2.get("author_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"William Shakespeare", (String)obj2.get("name").toString());
        TestDataReaderAndWriter.assertEquals((String)"book", (String)obj3.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj3.get("book_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj3.get("author_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"0684830493", (String)obj3.get("isbn").toString());
        TestDataReaderAndWriter.assertEquals((String)"Old Man And The Sea", (String)obj3.get("title").toString());
        TestDataReaderAndWriter.assertEquals((String)"1952-01-01", (String)obj3.get("issue_date").toString());
        TestDataReaderAndWriter.assertEquals((String)"book", (String)obj4.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj4.get("book_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj4.get("author_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"0198321465", (String)obj4.get("isbn").toString());
        TestDataReaderAndWriter.assertEquals((String)"Macbeth", (String)obj4.get("title").toString());
        TestDataReaderAndWriter.assertEquals((String)"1606-01-01", (String)obj4.get("issue_date").toString());
        TestDataReaderAndWriter.assertEquals((String)"book", (String)obj5.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"3", (String)obj5.get("book_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj5.get("author_id").toString());
        TestDataReaderAndWriter.assertEquals((String)"0140707026", (String)obj5.get("isbn").toString());
        TestDataReaderAndWriter.assertEquals((String)"A Midsummer Night's Dream", (String)obj5.get("title").toString());
        TestDataReaderAndWriter.assertEquals((String)"1595-01-01", (String)obj5.get("issue_date").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadFromFile1() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testDataXml = "<data>\n  <test id='1' value='foo'/>\n</data>";
        File tmpFile = File.createTempFile("data", ".xml");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
            writer.write(testDataXml);
            ((Writer)writer).close();
            ArrayList beans = new ArrayList();
            DataReader dataReader = new DataReader();
            dataReader.setModel(model);
            dataReader.setSink((DataSink)new TestDataSink(beans));
            dataReader.read(tmpFile.getAbsolutePath());
            TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
            DynaBean obj = (DynaBean)beans.get(0);
            TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
            TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
            TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("value").toString());
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadFromFile2() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testDataXml = "<data>\n  <test id='1' value='foo'/>\n</data>";
        File tmpFile = File.createTempFile("data", ".xml");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
            writer.write(testDataXml);
            ((Writer)writer).close();
            ArrayList beans = new ArrayList();
            DataReader dataReader = new DataReader();
            dataReader.setModel(model);
            dataReader.setSink((DataSink)new TestDataSink(beans));
            dataReader.read(tmpFile);
            TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
            DynaBean obj = (DynaBean)beans.get(0);
            TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
            TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
            TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("value").toString());
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadFromFile3() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testDataXml = "<data>\n  <test id='1' value='foo'/>\n</data>";
        File tmpFile = File.createTempFile("data", ".xml");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
            writer.write(testDataXml);
            ((Writer)writer).close();
            ArrayList beans = new ArrayList();
            DataReader dataReader = new DataReader();
            dataReader.setModel(model);
            dataReader.setSink((DataSink)new TestDataSink(beans));
            dataReader.read((InputStream)new FileInputStream(tmpFile));
            TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
            DynaBean obj = (DynaBean)beans.get(0);
            TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
            TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
            TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("value").toString());
        }
        finally {
            tmpFile.delete();
        }
    }

    public void testSubElements() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        List beans = this.readBeans(model, "<data>\n  <test id='1'>\n    <value>foo</value>\n  </test>\n  <test id='2' value='foo'>\n    <value>bar</value>\n  </test>\n  <test id='3' value='baz'>\n  </test>\n</data>");
        TestDataReaderAndWriter.assertEquals((int)3, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("value").toString());
        obj = (DynaBean)beans.get(1);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertEquals((String)"bar", (String)obj.get("value").toString());
        obj = (DynaBean)beans.get(2);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"3", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertEquals((String)"baz", (String)obj.get("value").toString());
    }

    public void testRootElementNameDoesntMatter() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        List beans = this.readBeans(model, "<someRandomName>\n  <test id='1' value='foo'/>\n</someRandomName>");
        TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("value").toString());
    }

    public void testElementForUndefinedTable() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        List beans = this.readBeans(model, "<data>\n  <test id='1' value='foo'/>\n  <other id='2' value='bar'/>\n  <test id='3' value='baz'/>\n</data>");
        TestDataReaderAndWriter.assertEquals((int)2, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("value").toString());
        obj = (DynaBean)beans.get(1);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"3", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertEquals((String)"baz", (String)obj.get("value").toString());
    }

    public void testAttributeForUndefinedColumn() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        List beans = this.readBeans(model, "<data>\n  <test id='1' value1='foo'/>\n</data>");
        TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertNull((Object)obj.get("value"));
    }

    public void testSubElementForUndefinedColumn() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        List beans = this.readBeans(model, "<data>\n  <test id='1'>\n    <value2>foo</value2>\n  </test>\n</data>");
        TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("id").toString());
        TestDataReaderAndWriter.assertNull((Object)obj.get("value"));
    }

    public void testCaseSensitivityTurnedOn() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='Test'>\n    <column name='Id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testDataXml = "<data>\n  <test Id='1' Value='foo'/>\n  <Test Id='2' value='baz'/>\n</data>";
        ArrayList beans = new ArrayList();
        DataReader dataReader = new DataReader();
        dataReader.setCaseSensitive(true);
        dataReader.setModel(model);
        dataReader.setSink((DataSink)new TestDataSink(beans));
        dataReader.read((Reader)new StringReader(testDataXml));
        TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"Test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj.get("Id").toString());
        TestDataReaderAndWriter.assertNull((Object)obj.get("Value"));
    }

    public void testCaseSensitivityTurnedOff() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='Test'>\n    <column name='Id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testDataXml = "<data>\n  <test Id='1' Value='foo'/>\n  <Test Id='2' value='bar'/>\n  <Test id='3' Value='baz'/>\n</data>";
        ArrayList beans = new ArrayList();
        DataReader dataReader = new DataReader();
        dataReader.setCaseSensitive(false);
        dataReader.setModel(model);
        dataReader.setSink((DataSink)new TestDataSink(beans));
        dataReader.read((Reader)new StringReader(testDataXml));
        TestDataReaderAndWriter.assertEquals((int)3, (int)beans.size());
        DynaBean obj = (DynaBean)beans.get(0);
        TestDataReaderAndWriter.assertEquals((String)"Test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"1", (String)obj.get("Id").toString());
        TestDataReaderAndWriter.assertEquals((String)"foo", (String)obj.get("Value").toString());
        obj = (DynaBean)beans.get(1);
        TestDataReaderAndWriter.assertEquals((String)"Test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"2", (String)obj.get("Id").toString());
        TestDataReaderAndWriter.assertEquals((String)"bar", (String)obj.get("Value").toString());
        obj = (DynaBean)beans.get(2);
        TestDataReaderAndWriter.assertEquals((String)"Test", (String)obj.getDynaClass().getName());
        TestDataReaderAndWriter.assertEquals((String)"3", (String)obj.get("Id").toString());
        TestDataReaderAndWriter.assertEquals((String)"baz", (String)obj.get("Value").toString());
    }

    public void testSpecialCharacters() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Special Characters: \u0001\t\u0010";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "ISO-8859-1", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <test id=\"1\">\n    <value base64=\"true\">" + new String(Base64.encodeBase64((byte[])testedValue.getBytes("UTF-8")), "ISO-8859-1") + "</value>\n" + "  </test>\n" + "</data>\n");
    }

    public void testSpecialCharactersUTF8() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Special Characters: \u0001\t\u0010";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "ISO-8859-1", "<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <test id=\"1\">\n    <value base64=\"true\">" + new String(Base64.encodeBase64((byte[])testedValue.getBytes("UTF-8")), "UTF-8") + "</value>\n" + "  </test>\n" + "</data>\n");
    }

    public void testCData() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value1' type='VARCHAR' size='50' required='true'/>\n    <column name='value2' type='VARCHAR' size='4000' required='true'/>\n    <column name='value3' type='LONGVARCHAR' size='4000' required='true'/>\n    <column name='value4' type='LONGVARCHAR' size='4000' required='true'/>\n    <column name='value5' type='LONGVARCHAR' size='4000' required='true'/>\n  </table>\n</database>");
        String testedValue1 = "<?xml version='1.0' encoding='ISO-8859-1'?><test><![CDATA[some text]]></test>";
        String testedValue2 = StringUtils.repeat((String)"a ", (int)1000) + testedValue1;
        String testedValue3 = "<div>\n<h1><![CDATA[WfMOpen]]></h1>\n" + StringUtils.repeat((String)"Make it longer\n", (int)99) + "</div>";
        String testedValue4 = "<![CDATA[" + StringUtils.repeat((String)"b \n", (int)1000) + "]]>";
        String testedValue5 = "<<![CDATA[" + StringUtils.repeat((String)"b \n", (int)500) + "]]>><![CDATA[" + StringUtils.repeat((String)"c \n", (int)500) + "]]>";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value1", (Object)testedValue1);
        bean.set("value2", (Object)testedValue2);
        bean.set("value3", (Object)testedValue3);
        bean.set("value4", (Object)testedValue4);
        bean.set("value5", (Object)testedValue5);
        byte[] xmlData = this.writeBean(model, bean, "UTF-8");
        List beans = this.readBeans(model, xmlData);
        TestDataReaderAndWriter.assertEquals((int)1, (int)beans.size());
        TestDataReaderAndWriter.assertEquals((Object)bean, beans.get(0));
    }

    public void testTableNameLong() throws Exception {
        String tableName = StringUtils.repeat((String)"test", (int)100);
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='" + tableName + "'>\n" + "    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n" + "    <column name='value' type='VARCHAR' size='50' required='true'/>\n" + "  </table>\n" + "</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table id=\"1\" value=\"" + testedValue + "\">\n" + "    <table-name>" + tableName + "</table-name>\n" + "  </table>\n" + "</data>\n");
    }

    public void testTableNameNotAValidXmlIdentifier() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test$'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table table-name=\"test$\" id=\"1\" value=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testTableNameInvalidAndLong() throws Exception {
        String tableName = StringUtils.repeat((String)"table name", (int)50);
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='" + tableName + "'>\n" + "    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n" + "    <column name='value' type='VARCHAR' size='50' required='true'/>\n" + "  </table>\n" + "</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table id=\"1\" value=\"" + testedValue + "\">\n" + "    <table-name>" + tableName + "</table-name>\n" + "  </table>\n" + "</data>\n");
    }

    public void testTableNameContainsAmpersand() throws Exception {
        String tableName = "test&table";
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName("value");
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName(tableName);
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table table-name=\"test&amp;table\" id=\"1\" value=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testTableNameContainsLessCharacter() throws Exception {
        String tableName = "test<table";
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName("value");
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName(tableName);
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table table-name=\"test&lt;table\" id=\"1\" value=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testTableNameContainsMoreCharacter() throws Exception {
        String tableName = "test>table";
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName("value");
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName(tableName);
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table table-name=\"test>table\" id=\"1\" value=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testTableNameContainsInvalidCharacters() throws Exception {
        String tableName = "test\u0000table";
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName("value");
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName(tableName);
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table id=\"1\" value=\"" + testedValue + "\">\n" + "    <table-name " + "base64" + "=\"true\">" + new String(Base64.encodeBase64((byte[])tableName.getBytes("UTF-8")), "UTF-8") + "</table-name>\n" + "  </table>\n" + "</data>\n");
    }

    public void testTableNameIsTable() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='table'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        DatabaseIO modelIO = new DatabaseIO();
        modelIO.setValidateXml(true);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <table table-name=\"table\" id=\"1\" value=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testColumnNameAndValueShort() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\" value=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testColumnNameShortAndValueLong() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='400' required='true'/>\n  </table>\n</database>");
        String testedValue = StringUtils.repeat((String)"Some Text", (int)40);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <value>" + testedValue + "</value>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameShortAndInvalidAndValueShort() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='the value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("the value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"the value\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameShortAndInvalidAndValueLong() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='the value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = StringUtils.repeat((String)"Some Text", (int)40);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("the value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"the value\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameLongAndValueShort() throws Exception {
        String columnName = StringUtils.repeat((String)"value", (int)100);
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='" + columnName + "' type='VARCHAR' size='50' required='true'/>\n" + "  </table>\n" + "</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column>\n      <column-name>" + columnName + "</column-name>\n" + "      <column-value>" + testedValue + "</column-value>\n" + "    </column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameLongAndValueLong() throws Exception {
        String columnName = StringUtils.repeat((String)"value", (int)100);
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='" + columnName + "' type='VARCHAR' size='500' required='true'/>\n" + "  </table>\n" + "</database>");
        String testedValue = StringUtils.repeat((String)"Some Text", (int)40);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column>\n      <column-name>" + columnName + "</column-name>\n" + "      <column-value>" + testedValue + "</column-value>\n" + "    </column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameAndValueLong() throws Exception {
        String columnName = StringUtils.repeat((String)"value", (int)100);
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='" + columnName + "' type='VARCHAR' size='50' required='true'/>\n" + "  </table>\n" + "</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column>\n      <column-name>" + columnName + "</column-name>\n" + "      <column-value>" + testedValue + "</column-value>\n" + "    </column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameAndValueShortAndInvalid() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='the value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "the\u0000value";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("the value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"the value\" base64=\"true\">" + new String(Base64.encodeBase64((byte[])testedValue.getBytes("UTF-8")), "UTF-8") + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameLongAndValueInvalidAndShort() throws Exception {
        String columnName = StringUtils.repeat((String)"value", (int)100);
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='" + columnName + "' type='VARCHAR' size='50' required='true'/>\n" + "  </table>\n" + "</database>");
        String testedValue = "the\u0000value";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column>\n      <column-name>" + columnName + "</column-name>\n" + "      <column-value " + "base64" + "=\"true\">" + new String(Base64.encodeBase64((byte[])testedValue.getBytes("UTF-8")), "UTF-8") + "</column-value>\n" + "    </column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameAndValueLongAndInvalid() throws Exception {
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        String columnName = StringUtils.repeat((String)"the\u0000name", (int)100);
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName(columnName);
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName("test");
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = StringUtils.repeat((String)"the\u0000value", (int)40);
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column>\n      <column-name base64=\"true\">" + new String(Base64.encodeBase64((byte[])columnName.getBytes("UTF-8")), "UTF-8") + "</column-name>\n" + "      <column-value " + "base64" + "=\"true\">" + new String(Base64.encodeBase64((byte[])testedValue.getBytes("UTF-8")), "UTF-8") + "</column-value>\n" + "    </column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameContainsInvalidCharacters() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "the\u0000value";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("value", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <value base64=\"true\">" + new String(Base64.encodeBase64((byte[])testedValue.getBytes("UTF-8")), "UTF-8") + "</value>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnValueContainsInvalidCharacters() throws Exception {
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        String columnName = "the\u0000value";
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName(columnName);
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName("test");
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column>\n      <column-name base64=\"true\">" + new String(Base64.encodeBase64((byte[])columnName.getBytes("UTF-8")), "UTF-8") + "</column-name>\n" + "      <column-value>" + testedValue + "</column-value>\n" + "    </column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnValueContainsAmpersand() throws Exception {
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        String columnName = "foo&bar";
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName(columnName);
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName("test");
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"foo&amp;bar\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnValueContainsLessCharacter() throws Exception {
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        String columnName = "foo<bar";
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName(columnName);
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName("test");
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"foo&lt;bar\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnValueContainsMoreCharacter() throws Exception {
        Database model = new Database("test");
        Table table = new Table();
        Column idColumn = new Column();
        Column valueColumn = new Column();
        String columnName = "foo>bar";
        idColumn.setName("id");
        idColumn.setType("INTEGER");
        idColumn.setPrimaryKey(true);
        idColumn.setRequired(true);
        valueColumn.setName(columnName);
        valueColumn.setType("VARCHAR");
        valueColumn.setSize("50");
        valueColumn.setRequired(true);
        table.setName("test");
        table.addColumn(idColumn);
        table.addColumn(valueColumn);
        model.addTable(table);
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        String testedValue = "Some Text";
        bean.set("id", (Object)new Integer(1));
        bean.set(columnName, (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"foo>bar\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameIsColumn() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='column' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("column", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\" column=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testColumnNameIsColumnName() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='column-name' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("column-name", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\" column-name=\"" + testedValue + "\" />\n" + "</data>\n");
    }

    public void testColumnNameIsTableName() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='table-name' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("table-name", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"table-name\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    public void testColumnNameIsBase64() throws Exception {
        Database model = this.readModel("<?xml version='1.0' encoding='UTF-8'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='test'>\n    <column name='id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='base64' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        String testedValue = "Some Text";
        SqlDynaBean bean = (SqlDynaBean)model.createDynaBeanFor(model.getTable(0));
        bean.set("id", (Object)new Integer(1));
        bean.set("base64", (Object)testedValue);
        this.roundtripTest(model, bean, "UTF-8", "<?xml version='1.0' encoding='UTF-8'?>\n<data>\n  <test id=\"1\">\n    <column column-name=\"base64\">" + testedValue + "</column>\n" + "  </test>\n" + "</data>\n");
    }

    private static class TestDataSink
    implements DataSink {
        private final ArrayList readObjects;

        private TestDataSink(ArrayList readObjects) {
            this.readObjects = readObjects;
        }

        public void start() throws DataSinkException {
        }

        public void addBean(DynaBean bean) throws DataSinkException {
            this.readObjects.add(bean);
        }

        public void end() throws DataSinkException {
        }
    }
}

