/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.util.List;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.lang.StringUtils;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;
import org.apache.ddlutils.model.CascadeActionEnum;
import org.apache.ddlutils.model.Database;

public class TestConstraints
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestConstraints.getTests(TestConstraints.class);
    }

    protected void performConstraintsTest(String modelXml, boolean checkAlteration) {
        this.createDatabase(modelXml);
        Database modelFromDb = this.readModelFromDatabase("roundtriptest");
        this.assertEquals(this.getAdjustedModel(), modelFromDb);
        if (checkAlteration) {
            String alterTablesSql = this.getAlterTablesSql(modelFromDb).trim();
            TestConstraints.assertTrue((alterTablesSql.length() == 0 ? 1 : 0) != 0);
        }
    }

    public void testLongTableName() {
        if (this.getSqlBuilder().getMaxTableNameLength() == -1) {
            return;
        }
        String tableName = StringUtils.repeat((String)"Test", (int)(this.getSqlBuilder().getMaxTableNameLength() / 4 + 3));
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='" + tableName + "'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + "    <column name='avalue' type='INTEGER' required='false'/>\n" + "  </table>\n" + "</database>";
        this.performConstraintsTest(modelXml, true);
    }

    public void testLongColumnName() {
        if (this.getPlatformInfo().getMaxColumnNameLength() == -1) {
            return;
        }
        String columnName = StringUtils.repeat((String)"Test", (int)(this.getSqlBuilder().getMaxColumnNameLength() / 4 + 3));
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='lengthtest'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='" + columnName + "' type='INTEGER' required='false'/>\n" + "  </table>\n" + "</database>";
        this.performConstraintsTest(modelXml, true);
    }

    public void testLongConstraintName() {
        if (this.getSqlBuilder().getMaxConstraintNameLength() == -1) {
            return;
        }
        String constraintName = StringUtils.repeat((String)"Test", (int)(this.getSqlBuilder().getMaxConstraintNameLength() / 4 + 3));
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <index name='" + constraintName + "'>\n" + "      <index-column name='avalue'/>\n" + "    </index>\n" + "  </table>\n" + "</database>";
        this.performConstraintsTest(modelXml, true);
    }

    public void testLongForeignKeyName() {
        if (this.getSqlBuilder().getMaxForeignKeyNameLength() == -1) {
            return;
        }
        String fkName = StringUtils.repeat((String)"Test", (int)(this.getSqlBuilder().getMaxForeignKeyNameLength() / 4 + 3));
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key name='" + fkName + "' foreignTable='roundtrip_1'>\n" + "      <reference local='avalue' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        this.performConstraintsTest(modelXml, true);
    }

    public void testNullableColumn() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n</database>", true);
    }

    public void testNotNullableColumn() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' required='true'/>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' required='true'/>\n  </table>\n</database>", true);
    }

    public void testAutoIncrementIntegerColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String modelXml = "Sybase".equals(this.getPlatform().getName()) ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n  </table>\n</database>";
        this.performConstraintsTest(modelXml, this.getPlatformInfo().getIdentityStatusReadingSupported());
    }

    public void testPrimaryKeyAutoIncrementColumn() {
        String modelXml = "Sybase".equals(this.getPlatform().getName()) ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>";
        this.performConstraintsTest(modelXml, this.getPlatformInfo().getIdentityStatusReadingSupported());
    }

    public void testAutoIncrementPrimaryKeyWithUnderscoreInName() {
        String modelXml = "Sybase".equals(this.getPlatform().getName()) ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='PK_Column' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='PK_Column' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>";
        this.performConstraintsTest(modelXml, this.getPlatformInfo().getIdentityStatusReadingSupported());
    }

    public void testIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <index name='TEST_INDEX'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <index name='TEST_INDEX'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>", true);
    }

    public void testUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value_1' type='DOUBLE'/>\n    <column name='value_2' type='VARCHAR' size='32'/>\n    <unique name='test_index'>\n      <unique-column name='value_2'/>\n      <unique-column name='value_1'/>\n    </unique>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='value_1' type='DOUBLE'/>\n    <column name='value_2' type='VARCHAR' size='32'/>\n    <unique name='test_index'>\n      <unique-column name='value_2'/>\n      <unique-column name='value_1'/>\n    </unique>\n  </table>\n</database>", true);
    }

    public void testPrimaryKeyIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <index name='test_index'>\n      <index-column name='avalue'/>\n      <index-column name='pk_1'/>\n    </index>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <index name='test_index'>\n      <index-column name='avalue'/>\n      <index-column name='pk_1'/>\n    </index>\n  </table>\n</database>", true);
    }

    public void testSimpleForeignKey() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
    }

    public void testOverlappingForeignKeys() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='value_1' type='INTEGER' required='true'/>\n    <column name='value_2' type='INTEGER'/>\n    <column name='value_3' type='VARCHAR' size='32'/>\n    <foreign-key name='fk_1' foreignTable='roundtrip_1'>\n      <reference local='value_1' foreign='pk_1'/>\n      <reference local='value_3' foreign='pk_2'/>\n    </foreign-key>\n    <foreign-key foreignTable='roundtrip_1'>\n      <reference local='value_2' foreign='pk_1'/>\n      <reference local='value_3' foreign='pk_2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='value_1' type='INTEGER' required='true'/>\n    <column name='value_2' type='INTEGER'/>\n    <column name='value_3' type='VARCHAR' size='32'/>\n    <foreign-key name='fk_1' foreignTable='roundtrip_1'>\n      <reference local='value_1' foreign='pk_1'/>\n      <reference local='value_3' foreign='pk_2'/>\n    </foreign-key>\n    <foreign-key foreignTable='roundtrip_1'>\n      <reference local='value_2' foreign='pk_1'/>\n      <reference local='value_3' foreign='pk_2'/>\n    </foreign-key>\n  </table>\n</database>", true);
    }

    public void testCircularForeignKeys() {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='value_1' type='INTEGER'/>\n    <column name='value_2' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip_2'>\n      <reference local='value_1' foreign='pk_1'/>\n      <reference local='value_2' foreign='pk_2'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='value_1' type='VARCHAR' size='32' required='true'/>\n    <column name='value_2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1'>\n      <reference local='value_2' foreign='pk_1'/>\n      <reference local='value_1' foreign='pk_2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='value_1' type='INTEGER'/>\n    <column name='value_2' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip_2'>\n      <reference local='value_1' foreign='pk_1'/>\n      <reference local='value_2' foreign='pk_2'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk_1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk_2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='value_1' type='VARCHAR' size='32' required='true'/>\n    <column name='value_2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1'>\n      <reference local='value_2' foreign='pk_1'/>\n      <reference local='value_1' foreign='pk_2'/>\n    </foreign-key>\n  </table>\n</database>", true);
    }

    public void testForeignKeyWithOnDeleteRestrict() {
        if (!this.getPlatformInfo().isActionSupportedForOnDelete(CascadeActionEnum.RESTRICT)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='restrict'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='restrict'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        try {
            this.deleteRow("roundtrip_1", new Object[]{new Integer(1)});
            TestConstraints.fail();
        }
        catch (DdlUtilsException ddlUtilsException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithOnDeleteCascade() {
        if (!this.getPlatformInfo().isActionSupportedForOnDelete(CascadeActionEnum.CASCADE)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='cascade'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='cascade'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        this.deleteRow("roundtrip_1", new Object[]{new Integer(1)});
        beansTable1 = this.getRows("roundtrip_1");
        beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)0, (int)beansTable1.size());
        TestConstraints.assertEquals((int)0, (int)beansTable2.size());
    }

    public void testForeignKeyWithOnDeleteSetNull() {
        if (!this.getPlatformInfo().isActionSupportedForOnDelete(CascadeActionEnum.SET_NULL)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='setnull'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='setnull'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        this.deleteRow("roundtrip_1", new Object[]{new Integer(1)});
        beansTable1 = this.getRows("roundtrip_1");
        beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)0, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals((Object)null, beansTable2.get(0), "avalue");
    }

    public void testForeignKeyWithOnDeleteSetDefault() {
        if (!this.getPlatformInfo().isActionSupportedForOnDelete(CascadeActionEnum.SET_DEFAULT)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false' default='2'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='setdefault'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false' default='2'/>\n    <foreign-key foreignTable='roundtrip_1' onDelete='setdefault'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)2, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(2), beansTable1.get(1), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        this.deleteRow("roundtrip_1", new Object[]{new Integer(1)});
        beansTable1 = this.getRows("roundtrip_1");
        beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(2), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(2), beansTable2.get(0), "avalue");
    }

    public void testForeignKeyWithOnUpdateRestrict() {
        if (!this.getPlatformInfo().isActionSupportedForOnUpdate(CascadeActionEnum.RESTRICT)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='restrict'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='restrict'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        try {
            this.updateRow("roundtrip_1", (DynaBean)beansTable1.get(0), new Object[]{new Integer(5)});
            TestConstraints.fail();
        }
        catch (DdlUtilsException ddlUtilsException) {
            // empty catch block
        }
    }

    public void testForeignKeyWithOnUpdateCascade() {
        if (!this.getPlatformInfo().isActionSupportedForOnUpdate(CascadeActionEnum.CASCADE)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='cascade'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='cascade'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        this.updateRow("roundtrip_1", (DynaBean)beansTable1.get(0), new Object[]{new Integer(2)});
        beansTable1 = this.getRows("roundtrip_1");
        beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(2), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(2), beansTable2.get(0), "avalue");
    }

    public void testForeignKeyWithOnUpdateSetNull() {
        if (!this.getPlatformInfo().isActionSupportedForOnUpdate(CascadeActionEnum.SET_NULL)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='setnull'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='setnull'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(1)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
        this.updateRow("roundtrip_1", (DynaBean)beansTable1.get(0), new Object[]{new Integer(2)});
        beansTable1 = this.getRows("roundtrip_1");
        beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)1, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(2), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals((Object)null, beansTable2.get(0), "avalue");
    }

    public void testForeignKeyWithOnUpdateSetDefault() {
        if (!this.getPlatformInfo().isActionSupportedForOnUpdate(CascadeActionEnum.SET_DEFAULT)) {
            return;
        }
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false' default='1'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='setdefault'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.performConstraintsTest("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip_1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip_2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false' default='1'/>\n    <foreign-key foreignTable='roundtrip_1' onUpdate='setdefault'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>", true);
        this.insertRow("roundtrip_1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip_1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip_2", new Object[]{new Integer(5), new Integer(2)});
        List beansTable1 = this.getRows("roundtrip_1");
        List beansTable2 = this.getRows("roundtrip_2");
        TestConstraints.assertEquals((int)2, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(1), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(2), beansTable1.get(1), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(2), beansTable2.get(0), "avalue");
        this.updateRow("roundtrip_1", (DynaBean)beansTable1.get(1), new Object[]{new Integer(0)});
        beansTable1 = this.getRows("roundtrip_1", "pk");
        beansTable2 = this.getRows("roundtrip_2", "pk");
        TestConstraints.assertEquals((int)2, (int)beansTable1.size());
        TestConstraints.assertEquals((int)1, (int)beansTable2.size());
        this.assertEquals(new Integer(0), beansTable1.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable1.get(1), "pk");
        this.assertEquals(new Integer(5), beansTable2.get(0), "pk");
        this.assertEquals(new Integer(1), beansTable2.get(0), "avalue");
    }
}

