/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;

public class TestChangeColumn
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestChangeColumn.getTests(TestChangeColumn.class);
    }

    public void testColumnTypeIntegerToDouble() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue");
    }

    public void testColumnTypeSmallintToVarchar() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='SMALLINT'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='SMALLINT'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Short(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        if (bean.get("avalue") instanceof String) {
            bean.set("avalue", (Object)((String)bean.get("avalue")).trim());
        }
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("2", beans.get(0), "avalue");
    }

    public void testPKColumnTypeIntegerToDouble() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Double(2.0), beans.get(0), "pk");
    }

    public void testPKColumnTypeIntegerToVarchar() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        if (bean.get("pk") instanceof String) {
            bean.set("pk", (Object)((String)bean.get("pk")).trim());
        }
        this.assertEquals("1", beans.get(0), "pk");
    }

    public void testPKAndFKColumnTypesIntegerToVarchar() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='128' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='128' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='128' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='128' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        DynaBean bean1 = (DynaBean)beans1.get(0);
        DynaBean bean2 = (DynaBean)beans2.get(0);
        if (bean1.get("pk") instanceof String) {
            bean1.set("pk", (Object)((String)bean1.get("pk")).trim());
        }
        if (bean2.get("fk") instanceof String) {
            bean2.set("fk", (Object)((String)bean2.get("fk")).trim());
        }
        this.assertEquals("1", bean1, "pk");
        this.assertEquals(new Integer(1), bean2, "pk");
        this.assertEquals("1", bean2, "fk");
    }

    public void testPKAndFKColumnTypesAndDropFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' primaryKey='false' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' required='false'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' primaryKey='false' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' required='false'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        DynaBean bean1 = (DynaBean)beans1.get(0);
        DynaBean bean2 = (DynaBean)beans2.get(0);
        if (bean1.get("pk") instanceof String) {
            bean1.set("pk", (Object)((String)bean1.get("pk")).trim());
        }
        if (bean2.get("fk") instanceof String) {
            bean2.set("fk", (Object)((String)bean2.get("fk")).trim());
        }
        this.assertEquals("1", bean1, "pk");
        this.assertEquals(new Integer(1), bean2, "pk");
        this.assertEquals("1", bean2, "fk");
    }

    public void testIndexColumnTypeIntegerToDouble() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue1");
        this.assertEquals("text", beans.get(0), "avalue2");
    }

    public void testIndexColumnTypeSmallintToVarchar() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='20'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Short(2), new Double(3.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='20'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        if (bean.get("avalue1") instanceof String) {
            bean.set("avalue1", (Object)((String)bean.get("avalue1")).trim());
        }
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("2", beans.get(0), "avalue1");
        this.assertEquals(new Double(3.0), beans.get(0), "avalue2");
    }

    public void testIndexColumnTypeAndDropIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='8' required='false'/>\n    <index name='avalue_index'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='8' required='false'/>\n    <index name='avalue_index'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(1)});
        this.insertRow("roundtrip", new Object[]{new Integer(2), new Integer(10)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='false'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals(new Integer(10), beans.get(1), "avalue");
    }

    public void testUniqueIndexColumnTypeIntegerToDouble() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue1");
        this.assertEquals("text", beans.get(0), "avalue2");
    }

    public void testUniqueIndexColumnTypeSmallintToVarchar() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='20'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Short(2), new Double(3.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='20'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        if (bean.get("avalue1") instanceof String) {
            bean.set("avalue1", (Object)((String)bean.get("avalue1")).trim());
        }
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("2", beans.get(0), "avalue1");
        this.assertEquals(new Double(3.0), beans.get(0), "avalue2");
    }

    public void testColumnIncreaseSize() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testColumnDecreaseSize() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='16' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "12345678901234567890123456789012"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='16' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        TestChangeColumn.assertTrue(("12345678901234567890123456789012".equals(bean.get("avalue")) || "1234567890123456".equals(bean.get("avalue")) ? 1 : 0) != 0);
    }

    public void testPKColumnIncreaseSize() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{"test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        TestChangeColumn.assertEquals((String)"test", (String)((String)bean.get("pk")).trim());
    }

    public void testPKColumnDecreaseSize() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='16' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{"12345678901234567890123456789012"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='CHAR' size='16' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        TestChangeColumn.assertTrue(("12345678901234567890123456789012".equals(bean.get("pk")) || "1234567890123456".equals(bean.get("pk")) ? 1 : 0) != 0);
    }

    public void testPKAndFKColumnIncreaseSize() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='32' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='128' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='128' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='32' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"test"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='128' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='128' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("test", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("test", beans2.get(0), "fk");
    }

    public void testPKAndFKColumnDecreaseSize() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='32' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='16' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='16' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='32' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"test"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='16' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='16' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        DynaBean bean1 = (DynaBean)beans1.get(0);
        DynaBean bean2 = (DynaBean)beans2.get(0);
        TestChangeColumn.assertEquals((String)"test", (String)((String)bean1.get("pk")).trim());
        this.assertEquals(new Integer(1), bean2, "pk");
        TestChangeColumn.assertEquals((String)"test", (String)((String)bean2.get("fk")).trim());
    }

    public void testIndexColumnIncreaseSize() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='40'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='40'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals("text", beans.get(0), "avalue2");
    }

    public void testIndexColumnDecreaseSize() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='32'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='32'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        this.assertEquals(new Integer(2), bean, "avalue1");
        TestChangeColumn.assertEquals((Object)"text", (Object)((String)bean.get("avalue2")).trim());
    }

    public void testUniqueIndexColumnIncreaseSize() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='16'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='16'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        this.assertEquals(new Integer(2), bean, "avalue1");
        TestChangeColumn.assertEquals((Object)"text", (Object)((String)bean.get("avalue2")).trim());
    }

    public void testUniqueIndexColumnDecreaseSize() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='40'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='40'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals("text", beans.get(0), "avalue2");
    }

    public void testColumnIncreasePrecision() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='10,5' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='16,5' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='10,5' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("12345.12345")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='16,5' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new BigDecimal("12345.12345"), beans.get(0), "avalue");
    }

    public void testColumnDecreasePrecision() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='12,5' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,5' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='12,5' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("12345.12345")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,5' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new BigDecimal("12345.12345"), beans.get(0), "avalue");
    }

    public void testPKColumnIncreasePrecision() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='16,5' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new BigDecimal("12345.12345")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='16,5' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal("12345.12345"), beans.get(0), "pk");
    }

    public void testPKColumnDecreasePrecision() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='12,5' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='12,5' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new BigDecimal("12345.12345")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='DECIMAL' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal("12345.12345"), beans.get(0), "pk");
    }

    public void testPKAndFKColumnIncreasePrecision() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='8,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='8,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='11,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='11,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='8,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='8,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal("123456.12")});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='11,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='11,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new BigDecimal("123456.12"), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new BigDecimal("123456.12"), beans2.get(0), "fk");
    }

    public void testPKAndFKColumnDecreasePrecision() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='10,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='8,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='8,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='10,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal("123456.12")});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='8,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='8,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new BigDecimal("123456.12"), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new BigDecimal("123456.12"), beans2.get(0), "fk");
    }

    public void testIndexColumnIncreasePrecision() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='8,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='12,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='8,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("123456.12"), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='12,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new BigDecimal("123456.12"), beans.get(0), "avalue1");
        this.assertEquals(new Integer(2), beans.get(0), "avalue2");
    }

    public void testIndexColumnDecreasePrecision() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='10,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='8,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='10,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("123456.12"), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='8,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new BigDecimal("123456.12"), beans.get(0), "avalue1");
        this.assertEquals(new Integer(2), beans.get(0), "avalue2");
    }

    public void testUniqueIndexColumnIncreasePrecision() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='8,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='9,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='8,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='9,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new BigDecimal("123456.12"), beans.get(0), "avalue2");
    }

    public void testUniqueIndexColumnDecreasePrecision() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='9,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='8,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='9,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='8,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new BigDecimal("123456.12"), beans.get(0), "avalue2");
    }

    public void testColumnIncreaseScale() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,4' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,5' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,4' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("12345.1234")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,5' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        TestChangeColumn.assertTrue((bean.get("avalue").equals(new BigDecimal("12345.1234")) || bean.get("avalue").equals(new BigDecimal("12345.12340")) ? 1 : 0) != 0);
    }

    public void testColumnDecreaseScale() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,5' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,3' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,5' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("12345.123")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DECIMAL' size='10,3' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new BigDecimal("12345.123"), beans.get(0), "avalue");
    }

    public void testPKColumnIncreaseScale() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,3' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,3' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new BigDecimal("12345.123")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        TestChangeColumn.assertTrue((bean.get("pk").equals(new BigDecimal("12345.123")) || bean.get("pk").equals(new BigDecimal("12345.12300")) ? 1 : 0) != 0);
    }

    public void testPKColumnDecreaseScale() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,3' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,5' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new BigDecimal("12345.123")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,3' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal("12345.123"), beans.get(0), "pk");
    }

    public void testPKAndFKColumnIncreaseScale() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DECIMAL' size='11,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DECIMAL' size='11,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DECIMAL' size='11,5' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DECIMAL' size='11,5' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DECIMAL' size='11,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DECIMAL' size='11,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal("123456.12")});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DECIMAL' size='11,5' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DECIMAL' size='11,5' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        DynaBean bean1 = (DynaBean)beans1.get(0);
        DynaBean bean2 = (DynaBean)beans2.get(0);
        TestChangeColumn.assertTrue((bean1.get("pk").equals(new BigDecimal("123456.12")) || bean1.get("pk").equals(new BigDecimal("123456.12000")) ? 1 : 0) != 0);
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        TestChangeColumn.assertTrue((bean2.get("fk").equals(new BigDecimal("123456.12")) || bean2.get("fk").equals(new BigDecimal("123456.12000")) ? 1 : 0) != 0);
    }

    public void testPKAndFKColumnDecreaseScale() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='11,5' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='11,5' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='11,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='11,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='11,5' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='11,5' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal("123456.12")});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='11,2' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='11,2' required='false'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new BigDecimal("123456.12"), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new BigDecimal("123456.12"), beans2.get(0), "fk");
    }

    public void testIndexColumnIncreaseScale() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='NUMERIC' size='11,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='NUMERIC' size='11,5'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='NUMERIC' size='11,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("123456.12"), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='NUMERIC' size='11,5'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        this.assertEquals(new Integer(2), bean, "avalue2");
        TestChangeColumn.assertTrue((new BigDecimal("123456.12").equals(bean.get("avalue1")) || new BigDecimal("123456.12000").equals(bean.get("avalue1")) ? 1 : 0) != 0);
    }

    public void testIndexColumnDecreaseScale() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='11,5'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='11,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='11,5'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("123456.12"), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DECIMAL' size='11,2'/>\n    <column name='avalue2' type='INTEGER'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new BigDecimal("123456.12"), beans.get(0), "avalue1");
        this.assertEquals(new Integer(2), beans.get(0), "avalue2");
    }

    public void testUniqueIndexColumnIncreaseScale() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DECIMAL' size='11,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DECIMAL' size='11,5'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DECIMAL' size='11,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DECIMAL' size='11,5'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        this.assertEquals(new Integer(2), bean, "avalue1");
        TestChangeColumn.assertTrue((new BigDecimal("123456.12").equals(bean.get("avalue2")) || new BigDecimal("123456.12000").equals(bean.get("avalue2")) ? 1 : 0) != 0);
    }

    public void testUniqueIndexColumnDecreaseScale() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='11,5'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='11,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='11,5'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), new BigDecimal("123456.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='11,2'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new BigDecimal("123456.12"), beans.get(0), "avalue2");
    }

    public void testColumnMakeRequired() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testColumnUnmakeRequired() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue");
    }

    public void testPKColumnMakeRequired() {
        if (this.getPlatformInfo().isPrimaryKeyColumnAutomaticallyRequired() || this.getPlatformInfo().isPrimaryKeyColumnsHaveToBeRequired()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new BigDecimal("12345678.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal("12345678.12"), beans.get(0), "pk");
    }

    public void testPKColumnUnmakeRequired() {
        if (this.getPlatformInfo().isPrimaryKeyColumnAutomaticallyRequired() || this.getPlatformInfo().isPrimaryKeyColumnsHaveToBeRequired()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new BigDecimal("12345678.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='10,2' primaryKey='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal("12345678.12"), beans.get(0), "pk");
    }

    public void testFKColumnMakeRequired() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "fk");
    }

    public void testFKColumnUnmakeRequired() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "fk");
    }

    public void testPKAndFKColumnMakeRequired() {
        if (this.getPlatformInfo().isPrimaryKeyColumnAutomaticallyRequired() || this.getPlatformInfo().isPrimaryKeyColumnsHaveToBeRequired()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='10' primaryKey='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='10'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='10' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='10' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='10' primaryKey='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='10'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"1234567890"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "1234567890"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='10' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='CHAR' size='10' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("1234567890", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("1234567890", beans2.get(0), "fk");
    }

    public void testPKAndFKColumnUnmakeRequired() {
        if (this.getPlatformInfo().isPrimaryKeyColumnAutomaticallyRequired() || this.getPlatformInfo().isPrimaryKeyColumnsHaveToBeRequired()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "fk");
    }

    public void testIndexColumnMakeRequired() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP' required='true'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), time});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP' required='true'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(time, beans.get(0), "avalue2");
    }

    public void testIndexColumnUnmakeRequired() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT' required='true'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT' required='true'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), time});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='SMALLINT'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(time, beans.get(0), "avalue2");
    }

    public void testUniqueIndexColumnMakeRequired() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='16'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20' required='true'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='16'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20' required='true'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        this.assertEquals(new Integer(2), bean, "avalue1");
        TestChangeColumn.assertEquals((Object)"text", (Object)((String)bean.get("avalue2")).trim());
    }

    public void testUniqueIndexColumnUnmakeRequired() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='CHAR' size='16'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='CHAR' size='16'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='20'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        this.assertEquals(new Integer(1), bean, "pk");
        this.assertEquals(new Integer(2), bean, "avalue1");
        TestChangeColumn.assertEquals((Object)"text", (Object)((String)bean.get("avalue2")).trim());
    }

    public void testColumnMakeAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue' type='NUMERIC' size='12,0'/>\n" : "    <column name='avalue' type='INTEGER'/>\n") + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n") + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("0") : new Integer(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), value});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(value, beans.get(0), "avalue");
    }

    public void testColumnUnmakeAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n") + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue' type='NUMERIC' size='12,0'/>\n" : "    <column name='avalue' type='INTEGER'/>\n") + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Number value = isSybase ? new BigDecimal("1") : new Integer(1);
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(value, beans.get(0), "avalue");
    }

    public void testPKColumnMakeAutoIncrement() {
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n") + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("5") : new Integer(5);
        this.insertRow("roundtrip", new Object[]{value});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(value, beans.get(0), "pk");
    }

    public void testPKColumnUnmakeAutoIncrement() {
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n") + "    <column name='avalue' type='INTEGER'/>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "    <column name='avalue' type='INTEGER'/>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{null, new Integer(2)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Number value = isSybase ? new BigDecimal("1") : new Integer(1);
        this.assertEquals(value, beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue");
    }

    public void testFKColumnMakeAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0'/>\n" : "    <column name='fk' type='INTEGER'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='fk' type='INTEGER' autoIncrement='true'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("0") : new Integer(0);
        this.insertRow("roundtrip1", new Object[]{value});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), value});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(value, beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(value, beans2.get(0), "fk");
    }

    public void testFKColumnnUnmakeAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='fk' type='INTEGER' autoIncrement='true'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0'/>\n" : "    <column name='fk' type='INTEGER'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("1") : new Integer(1);
        this.insertRow("roundtrip1", new Object[]{value});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(value, beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(value, beans2.get(0), "fk");
    }

    public void testPKAndFKColumnMakeAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0'/>\n" : "    <column name='fk' type='INTEGER'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n") + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='fk' type='INTEGER' autoIncrement='true'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("0") : new Integer(0);
        this.insertRow("roundtrip1", new Object[]{value});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), value});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(value, beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(value, beans2.get(0), "fk");
    }

    public void testPKAndFKColumnUnmakeAutoIncrement() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n") + "    <column name='avalue' type='INTEGER'/>\n" + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='fk' type='INTEGER' autoIncrement='true'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n" + (isSybase ? "    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n" : "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n") + "    <column name='avalue' type='INTEGER'/>\n" + "  </table>\n" + "  <table name='roundtrip2'>\n" + "    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='fk' type='NUMERIC' size='12,0'/>\n" : "    <column name='fk' type='INTEGER'/>\n") + "    <foreign-key foreignTable='roundtrip1'>\n" + "      <reference local='fk' foreign='pk'/>\n" + "    </foreign-key>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip1", new Object[]{null, new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        Number value = isSybase ? new BigDecimal("1") : new Integer(1);
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(value, beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(value, beans2.get(0), "fk");
    }

    public void testIndexColumnMakeAutoIncrement() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue1' type='NUMERIC' size='12,0'/>\n" : "    <column name='avalue1' type='INTEGER'/>\n") + "    <column name='avalue2' type='TIMESTAMP'/>\n" + "    <index name='testindex'>\n" + "      <index-column name='avalue1'/>\n" + "      <index-column name='avalue2'/>\n" + "    </index>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue1' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='avalue1' type='INTEGER' autoIncrement='true'/>\n") + "    <column name='avalue2' type='TIMESTAMP'/>\n" + "    <index name='testindex'>\n" + "      <index-column name='avalue1'/>\n" + "      <index-column name='avalue2'/>\n" + "    </index>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("0") : new Integer(0);
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), value, time});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(time, beans.get(0), "avalue2");
        this.assertEquals(value, beans.get(0), "avalue1");
    }

    public void testIndexColumnUnmakeAutoIncrement() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16'/>\n" + (isSybase ? "    <column name='avalue2' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n") + "    <index name='testindex'>\n" + "      <index-column name='avalue1'/>\n" + "      <index-column name='avalue2'/>\n" + "    </index>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16'/>\n" + (isSybase ? "    <column name='avalue2' type='NUMERIC' size='12,0'/>\n" : "    <column name='avalue2' type='INTEGER'/>\n") + "    <index name='testindex'>\n" + "      <index-column name='avalue1'/>\n" + "      <index-column name='avalue2'/>\n" + "    </index>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        Number value = isSybase ? new BigDecimal("1") : new Integer(1);
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("test", beans.get(0), "avalue1");
        this.assertEquals(value, beans.get(0), "avalue2");
    }

    public void testUniqueIndexColumnMakeAutoIncrement() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16'/>\n" + (isSybase ? "    <column name='avalue2' type='NUMERIC' size='12,0'/>\n" : "    <column name='avalue2' type='INTEGER'/>\n") + "    <unique name='testindex'>\n" + "      <unique-column name='avalue1'/>\n" + "      <unique-column name='avalue2'/>\n" + "    </unique>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16'/>\n" + (isSybase ? "    <column name='avalue2' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n") + "    <unique name='testindex'>\n" + "      <unique-column name='avalue1'/>\n" + "      <unique-column name='avalue2'/>\n" + "    </unique>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Number value = isSybase ? new BigDecimal("0") : new Integer(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test", value});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("test", beans.get(0), "avalue1");
        this.assertEquals(value, beans.get(0), "avalue2");
    }

    public void testUniqeIndexColumnUnmakeAutoIncrement() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue1' type='NUMERIC' size='12,0' autoIncrement='true'/>\n" : "    <column name='avalue1' type='INTEGER' autoIncrement='true'/>\n") + "    <column name='avalue2' type='TIMESTAMP'/>\n" + "    <unique name='testindex'>\n" + "      <unique-column name='avalue1'/>\n" + "      <unique-column name='avalue2'/>\n" + "    </unique>\n" + "  </table>\n" + "</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n" + (isSybase ? "    <column name='avalue1' type='NUMERIC' size='12,0'/>\n" : "    <column name='avalue1' type='INTEGER'/>\n") + "    <column name='avalue2' type='TIMESTAMP'/>\n" + "    <unique name='testindex'>\n" + "      <unique-column name='avalue1'/>\n" + "      <unique-column name='avalue2'/>\n" + "    </unique>\n" + "  </table>\n" + "</database>";
        this.createDatabase(model1Xml);
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), null, time});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Number value = isSybase ? new BigDecimal("1") : new Integer(1);
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(value, beans.get(0), "avalue1");
        this.assertEquals(time, beans.get(0), "avalue2");
    }

    public void testColumnAddDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2.0'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Double(1.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2.0'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Double(1.0), beans.get(0), "avalue");
    }

    public void testColumnChangeDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' default='1'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' default='20'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' default='1'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' default='20'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue");
    }

    public void testColumnRemoveDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' default='test'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' default='test'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testPKColumnAddDefault() throws ParseException {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='TIMESTAMP' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='TIMESTAMP' primaryKey='true' required='true' default='2000-01-01 00:00:00'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='TIMESTAMP' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{time, new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='TIMESTAMP' primaryKey='true' required='true' default='2000-01-01 00:00:00'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{null, new Integer(2)});
        List beans = this.getRows("roundtrip", "avalue");
        Timestamp defaultTime = Timestamp.valueOf("2000-01-01 00:00:00");
        this.assertEquals(time, beans.get(0), "pk");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        this.assertEquals(defaultTime, beans.get(1), "pk");
        this.assertEquals(new Integer(2), beans.get(1), "avalue");
    }

    public void testPKColumnChangeDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true' default='old'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true' default='new'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true' default='old'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{null, new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true' default='new'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{null, new Integer(2)});
        List beans = this.getRows("roundtrip", "avalue");
        this.assertEquals("old", beans.get(0), "pk");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        this.assertEquals("new", beans.get(1), "pk");
        this.assertEquals(new Integer(2), beans.get(1), "avalue");
    }

    public void testPKColumnRemoveDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,2' primaryKey='true' required='true' default='2'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,2' primaryKey='true' required='true' default='2.20'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,2' primaryKey='true' required='true' default='2'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{null, new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,2' primaryKey='true' required='true' default='2.20'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        DynaBean bean = (DynaBean)beans.get(0);
        TestChangeColumn.assertTrue((bean.get("pk").equals(new BigDecimal("2")) || bean.get("pk").equals(new BigDecimal("2.00")) ? 1 : 0) != 0);
        this.assertEquals(new Integer(1), bean, "avalue");
    }

    public void testFKColumnAddDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='12' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='12'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='12' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='12' default='text'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='12' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='12'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"test"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='12' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='12' default='text'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip1", new Object[]{"text"});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("test", beans1.get(0), "pk");
        this.assertEquals("text", beans1.get(1), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("test", beans2.get(0), "fk");
        this.assertEquals(new Integer(2), beans2.get(1), "pk");
        this.assertEquals("text", beans2.get(1), "fk");
    }

    public void testFKColumnChangeDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' default='2.0'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' default='3.0'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' default='2.0'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='DOUBLE' default='3.0'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip1", new Object[]{new Double(3.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk");
        this.assertEquals(new Double(3.0), beans1.get(1), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "fk");
        this.assertEquals(new Integer(2), beans2.get(1), "pk");
        this.assertEquals(new Double(3.0), beans2.get(1), "fk");
    }

    public void testFKColumnRemoveDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' default='2'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' default='2'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(2), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "fk");
    }

    public void testPKAndFKColumnAddDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='12'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12' primaryKey='true' required='true' default='1'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='12' default='1'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='12'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal("0"), new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new BigDecimal("0")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12' primaryKey='true' required='true' default='1'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='NUMERIC' size='12' default='1'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip1", new Object[]{null, new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new BigDecimal("0"), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans1.get(0), "avalue");
        this.assertEquals(new BigDecimal("1"), beans1.get(1), "pk");
        this.assertEquals(new Integer(2), beans1.get(1), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new BigDecimal("0"), beans2.get(0), "fk");
        this.assertEquals(new Integer(2), beans2.get(1), "pk");
        this.assertEquals(new BigDecimal("1"), beans2.get(1), "fk");
    }

    public void testPKAndFKColumnChangeDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' default='2'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' default='2'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' default='3'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' default='3'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' default='2'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' default='2'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{null, new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' default='3'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='INTEGER' default='3'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip1", new Object[]{null, new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(2), beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans1.get(0), "avalue");
        this.assertEquals(new Integer(3), beans1.get(1), "pk");
        this.assertEquals(new Integer(2), beans1.get(1), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "fk");
        this.assertEquals(new Integer(2), beans2.get(1), "pk");
        this.assertEquals(new Integer(3), beans2.get(1), "fk");
    }

    public void testPKAndFKColumnRemoveDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='16' primaryKey='true' required='true' default='text'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='16' default='text'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='16' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='16'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='16' primaryKey='true' required='true' default='text'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='16' default='text'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{null, new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='16' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='fk' type='VARCHAR' size='16'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='fk' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("text", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("text", beans2.get(0), "fk");
    }

    public void testIndexColumnAddDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='3'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), time});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='3'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{new Integer(2), null, time});
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(time, beans.get(0), "avalue2");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals(new Integer(3), beans.get(1), "avalue1");
        this.assertEquals(time, beans.get(1), "avalue2");
    }

    public void testIndexColumnChangeDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12' default='3'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12' default='4'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12' default='3'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12' default='4'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{new Integer(2), new Integer(3)});
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new BigDecimal("3"), beans.get(0), "avalue2");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals(new Integer(3), beans.get(1), "avalue1");
        this.assertEquals(new BigDecimal("4"), beans.get(1), "avalue2");
    }

    public void testIndexColumnRemoveDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16' default='text'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16' default='text'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), null, new BigDecimal("3")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='16'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <index name='testindex'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{new Integer(2), "test", new BigDecimal("4")});
        List beans = this.getRows("roundtrip", "pk");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("text", beans.get(0), "avalue1");
        this.assertEquals(new BigDecimal("3"), beans.get(0), "avalue2");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals("test", beans.get(1), "avalue1");
        this.assertEquals(new BigDecimal("4"), beans.get(1), "avalue2");
    }

    public void testUniqueIndexColumnAddDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP' default='2000-01-01 00:00:00'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        Timestamp time = new Timestamp(new Date().getTime());
        time.setNanos(0);
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2), time});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='TIMESTAMP' default='2000-01-01 00:00:00'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{new Integer(2), new Integer(3)});
        List beans = this.getRows("roundtrip");
        Timestamp defaultTime = Timestamp.valueOf("2000-01-01 00:00:00");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(time, beans.get(0), "avalue2");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals(new Integer(3), beans.get(1), "avalue1");
        this.assertEquals(defaultTime, beans.get(1), "avalue2");
    }

    public void testUniqueIndexColumnChangeDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='3'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='4'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='3'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), null, new BigDecimal("2")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='4'/>\n    <column name='avalue2' type='NUMERIC' size='12'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{new Integer(2), null, new BigDecimal("3")});
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(3), beans.get(0), "avalue1");
        this.assertEquals(new BigDecimal("2"), beans.get(0), "avalue2");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals(new Integer(4), beans.get(1), "avalue1");
        this.assertEquals(new BigDecimal("3"), beans.get(1), "avalue2");
    }

    public void testUniqueIndexColumnRemoveDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='16' default='text'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='16'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='16' default='text'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(3)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='16'/>\n    <unique name='testindex'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        this.insertRow("roundtrip", new Object[]{new Integer(2), new Integer(4), "test"});
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(3), beans.get(0), "avalue1");
        this.assertEquals("text", beans.get(0), "avalue2");
        this.assertEquals(new Integer(2), beans.get(1), "pk");
        this.assertEquals(new Integer(4), beans.get(1), "avalue1");
        this.assertEquals("test", beans.get(1), "avalue2");
    }

    public void testChangeDatatypeAndSize1() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='4' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='4' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testChangeDatatypeAndSize2() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='10,2' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='8' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='10,2' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new BigDecimal("12345678.12")});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='8' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("12345678", beans.get(0), "avalue");
    }
}

