/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;
import org.apache.ddlutils.model.Database;

public class TestAlteration
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestAlteration.getTests(TestAlteration.class);
    }

    public void testChangeColumnOrder() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test", "value", null, null});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("test", beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
        this.assertEquals(new Double(1.0), beans.get(0), "avalue3");
        this.assertEquals("value", beans.get(0), "avalue4");
    }

    public void testChangeColumnOrderWithAutoIncrementPK() {
        String model2Xml;
        String model1Xml;
        if ("Sybase".equals(this.getPlatform().getName())) {
            model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>";
            model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n  </table>\n</database>";
        } else {
            model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>";
            model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n  </table>\n</database>";
        }
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{null, "test", "value", null, null});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("test", beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
        this.assertEquals(new Double(1.0), beans.get(0), "avalue3");
        this.assertEquals("value", beans.get(0), "avalue4");
    }

    public void testChangeColumnOrderWithAutoIncrementColumn() {
        String model2Xml;
        String model1Xml;
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isMultipleIdentityColumnsSupported()) {
            return;
        }
        if ("Sybase".equals(this.getPlatform().getName())) {
            model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true' autoIncrement='true'/>\n  </table>\n</database>";
            model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true' autoIncrement='true'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n  </table>\n</database>";
        } else {
            model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue2' type='INTEGER' required='true' autoIncrement='true'/>\n  </table>\n</database>";
            model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER' required='true' autoIncrement='true'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='5'/>\n  </table>\n</database>";
        }
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test", "value", null, null});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("test", beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
        this.assertEquals(new Double(1.0), beans.get(0), "avalue3");
        this.assertEquals("value", beans.get(0), "avalue4");
    }

    public void testDropColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testDropAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model1Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testAddColumnToPK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testRemoveColumnFromPK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='false' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='false' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testDropPKColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testAddIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='50'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='50'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='50'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), null, new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='50'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue1");
        this.assertEquals(new Integer(2), beans.get(0), "avalue2");
    }

    public void testAddUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue");
    }

    public void testDropUniqueIndex() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n    <unique name='test_index'>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n    <unique name='test_index'>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Double(2.0), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue1");
        this.assertEquals("test", beans.get(0), "avalue2");
    }

    public void testDropIndexOverlappingWithForeignKeys() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n    <index name='test_index'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue2' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue2' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n    <index name='test_index'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue2' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{"test"});
        this.insertRow("roundtrip3", new Object[]{new Integer(1), new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='50' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='50'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk'/>\n    </foreign-key>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue2' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        List beans3 = this.getRows("roundtrip3");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals("test", beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans3.get(0), "pk");
        this.assertEquals(new Integer(1), beans3.get(0), "avalue1");
        this.assertEquals("test", beans3.get(0), "avalue2");
    }

    public void testDropIndexOverlappingWithRemoteForeignKey() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50'/>\n    <index name='test_index'>\n      <index-column name='pk'/>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50'/>\n    <index name='test_index'>\n      <index-column name='pk'/>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), "test"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='50'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals("test", beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testRemoveColumnFromUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='INTEGER'/>\n    <unique name='test_index'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='INTEGER'/>\n    <unique name='test_index'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='INTEGER'/>\n    <unique name='test_index'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Double(2.0), new Integer(3)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE'/>\n    <column name='avalue2' type='INTEGER'/>\n    <unique name='test_index'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Double(2.0), beans.get(0), "avalue1");
        this.assertEquals(new Integer(3), beans.get(0), "avalue2");
    }

    public void testAddFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{"2", new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true'/>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals("2", beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testDropFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Double(2.0), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testDropCamelCaseFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip1'>\n    <column name='Pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='Roundtrip2'>\n    <column name='Pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue1' type='DOUBLE' required='true'/>\n    <column name='Avalue2' type='INTEGER' required='true'/>\n    <foreign-key name='Rt1_To_Rt2' foreignTable='Roundtrip1'>\n      <reference local='Avalue2' foreign='Pk1'/>\n      <reference local='Avalue1' foreign='Pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip1'>\n    <column name='Pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='Roundtrip2'>\n    <column name='Pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue1' type='DOUBLE' required='true'/>\n    <column name='Avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip1'>\n    <column name='Pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='Roundtrip2'>\n    <column name='Pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue1' type='DOUBLE' required='true'/>\n    <column name='Avalue2' type='INTEGER' required='true'/>\n    <foreign-key name='Rt1_To_Rt2' foreignTable='Roundtrip1'>\n      <reference local='Avalue2' foreign='Pk1'/>\n      <reference local='Avalue1' foreign='Pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("Roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("Roundtrip2", new Object[]{new Integer(2), new Double(2.0), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='Roundtrip1'>\n    <column name='Pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='Roundtrip2'>\n    <column name='Pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue1' type='DOUBLE' required='true'/>\n    <column name='Avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("Roundtrip1");
        List beans2 = this.getRows("Roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "Pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "Pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "Pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "Avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "Avalue2");
    }

    public void testDropFKAndCorrespondingIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || "Firebird".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Double(2.0), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testDropFKButNotCorrespondingIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || "Firebird".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Double(2.0), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue2'/>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testDropFKAndDifferentIndexWithSameName() {
        if (!this.getPlatformInfo().isIndicesSupported() || "MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "Firebird".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Double(2.0), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testDropFKButNotDifferentIndexWithSameName() {
        if (!this.getPlatformInfo().isIndicesSupported() || "MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName()) || "Firebird".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n    <foreign-key name='test' foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Double(2.0), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='DOUBLE' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Double(2.0), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testDropFKs() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip4'>\n    <column name='pk' primaryKey='true' required='true' type='INTEGER' />\n    <column name='fk1' required='true' type='INTEGER' />\n    <column name='fk2' type='INTEGER' required='false' />\n    <foreign-key name='roundtrip1_fk' foreignTable='roundtrip1'>\n      <reference foreign='pk' local='pk' />\n    </foreign-key>\n    <foreign-key name='roundtrip2_fk1' foreignTable='roundtrip2'>\n      <reference foreign='pk' local='fk1' />\n    </foreign-key>\n    <foreign-key name='roundtrip2_fk2' foreignTable='roundtrip2'>\n      <reference foreign='pk' local='fk2' />\n    </foreign-key>\n    <foreign-key name='roundtrip3_fk' foreignTable='roundtrip3'>\n      <reference foreign='pk1' local='pk' />\n      <reference foreign='pk2' local='fk2' />\n    </foreign-key>\n   </table> \n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip4'>\n    <column name='pk' primaryKey='true' required='true' type='INTEGER' />\n    <column name='fk1' required='true' type='INTEGER' />\n    <column name='fk2' type='INTEGER' required='false' />\n   </table> \n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip4'>\n    <column name='pk' primaryKey='true' required='true' type='INTEGER' />\n    <column name='fk1' required='true' type='INTEGER' />\n    <column name='fk2' type='INTEGER' required='false' />\n    <foreign-key name='roundtrip1_fk' foreignTable='roundtrip1'>\n      <reference foreign='pk' local='pk' />\n    </foreign-key>\n    <foreign-key name='roundtrip2_fk1' foreignTable='roundtrip2'>\n      <reference foreign='pk' local='fk1' />\n    </foreign-key>\n    <foreign-key name='roundtrip2_fk2' foreignTable='roundtrip2'>\n      <reference foreign='pk' local='fk2' />\n    </foreign-key>\n    <foreign-key name='roundtrip3_fk' foreignTable='roundtrip3'>\n      <reference foreign='pk1' local='pk' />\n      <reference foreign='pk2' local='fk2' />\n    </foreign-key>\n   </table> \n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(3)});
        this.insertRow("roundtrip3", new Object[]{new Integer(1), new Integer(2)});
        this.insertRow("roundtrip4", new Object[]{new Integer(1), new Integer(3), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip3'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip4'>\n    <column name='pk' primaryKey='true' required='true' type='INTEGER' />\n    <column name='fk1' required='true' type='INTEGER' />\n    <column name='fk2' type='INTEGER' required='false' />\n   </table> \n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        List beans3 = this.getRows("roundtrip3");
        List beans4 = this.getRows("roundtrip4");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(3), beans2.get(1), "pk");
        this.assertEquals(new Integer(1), beans3.get(0), "pk1");
        this.assertEquals(new Integer(2), beans3.get(0), "pk2");
        this.assertEquals(new Integer(1), beans4.get(0), "pk");
        this.assertEquals(new Integer(3), beans4.get(0), "fk1");
        this.assertEquals(new Integer(2), beans4.get(0), "fk2");
    }

    public void testAddReferenceToFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' default='0.0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='0.0' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' default='0.0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='0.0' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(0.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        this.assertEquals(new Double(0.0), beans2.get(0), "avalue2");
    }

    public void testRemoveReferenceFromFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='12' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='12' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='12' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='12' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n      <reference local='avalue1' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), "test"});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), "test", new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue2' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testAddTable1() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip1");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testAddTable2() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model3Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip2", new Object[]{"test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32' required='true'/>\n    <foreign-key foreignTable='roundtrip2'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals("test", beans1.get(0), "avalue");
        this.assertEquals("test", beans2.get(0), "pk");
    }

    public void testAddAutoIncrementTable() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "Sybase".equals(this.getPlatform().getName()) ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' autoIncrement='true' required='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' autoIncrement='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"1"});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip1");
        this.assertEquals("1", beans.get(0), "pk");
    }

    public void testRemoveTable1() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Double(2.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip1");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
    }

    public void testRemoveTable2() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='20' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"test"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals("test", beans.get(0), "avalue");
    }

    public void testRemoveTable3() {
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n</database>";
        String model1Xml = "Sybase".equals(this.getPlatform().getName()) ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='VARCHAR' size='20' required='true'/>\n  </table>\n</database>";
        this.createDatabase(model1Xml);
        this.insertRow("roundtrip", new Object[]{null, "1"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testIssue54() throws Exception {
        String modelXml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='coltype'>\n    <column name='COL_FLOAT' primaryKey='false' required='false' type='FLOAT'/>\n    <column name='COL_BOOLEAN' primaryKey='false' required='false' type='BOOLEAN'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='coltype'>\n    <column name='COL_FLOAT' primaryKey='false' required='false' type='FLOAT'/>\n    <column name='COL_BOOLEAN' primaryKey='false' required='false' type='BOOLEAN'/>\n  </table>\n</database>");
        Properties props = this.getTestProperties();
        String catalog = props.getProperty("ddlutils.catalog");
        String schema = props.getProperty("ddlutils.schema");
        Database model = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='coltype'>\n    <column name='COL_FLOAT' primaryKey='false' required='false' type='FLOAT'/>\n    <column name='COL_BOOLEAN' primaryKey='false' required='false' type='BOOLEAN'/>\n  </table>\n</database>");
        this.getPlatform().setSqlCommentsOn(false);
        String alterationSql = this.getPlatform().getAlterTablesSql(catalog, schema, null, model);
        this.assertEqualsIgnoringWhitespaces("", alterationSql);
    }

    public void testRenamePK() throws Exception {
        String model1Xml = "<?xml version='1.0'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='id' primaryKey='true' required='true' type='INTEGER'/>\n    <column name='avalue' primaryKey='false' required='false' type='VARCHAR' size='40'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' primaryKey='true' required='true' type='INTEGER'/>\n    <column name='avalue' primaryKey='false' required='false' type='VARCHAR' size='40'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='id' primaryKey='true' required='true' type='INTEGER'/>\n    <column name='avalue' primaryKey='false' required='false' type='VARCHAR' size='40'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test"});
        this.alterDatabase("<?xml version='1.0'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' primaryKey='true' required='true' type='INTEGER'/>\n    <column name='avalue' primaryKey='false' required='false' type='VARCHAR' size='40'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals((Object)null, beans.get(0), "pk");
            this.assertEquals("test", beans.get(0), "avalue");
        } else {
            TestAlteration.assertTrue((boolean)beans.isEmpty());
        }
    }
}

