/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.io;

import java.math.BigDecimal;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;

public class TestAddColumn
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestAddColumn.getTests(TestAddColumn.class);
    }

    public void testAddColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue");
    }

    public void testAddAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "avalue");
        } else {
            Object avalue = ((DynaBean)beans.get(0)).get("avalue");
            TestAddColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
        }
    }

    public void testAddSecondAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported() || !this.getPlatformInfo().isMultipleIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' autoIncrement='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue1 = ((DynaBean)beans.get(0)).get("avalue1");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        TestAddColumn.assertTrue((avalue1 == null || new Integer(1).equals(avalue1) ? 1 : 0) != 0);
        TestAddColumn.assertTrue((avalue2 == null || new Integer(1).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' default='2' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' default='2' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new BigDecimal(2), beans.get(0), "avalue");
    }

    public void testAddColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestAddColumn.assertTrue((avalue == null || new Double(2.0).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' autoIncrement='true' required='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "avalue");
        } else {
            Object avalue = ((DynaBean)beans.get(0)).get("avalue");
            TestAddColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
        }
    }

    public void testAddRequiredColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' default='sometext' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' default='sometext' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestAddColumn.assertTrue((avalue == null || "sometext".equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddMultipleColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='16'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "test", new Integer(3)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='VARCHAR' size='32'/>\n    <column name='avalue2' type='INTEGER'/>\n    <column name='avalue3' type='DOUBLE' default='1.0'/>\n    <column name='avalue4' type='VARCHAR' size='16'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue3 = ((DynaBean)beans.get(0)).get("avalue3");
        this.assertEquals("test", beans.get(0), "avalue1");
        this.assertEquals(new Integer(3), beans.get(0), "avalue2");
        TestAddColumn.assertTrue((avalue3 == null || new Double(1.0).equals(avalue3) ? 1 : 0) != 0);
        this.assertEquals((Object)null, beans.get(0), "avalue4");
    }

    public void testAddPKAndColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals((Object)null, beans.get(0), "pk");
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddPKAndAutoIncrementColumn() {
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "pk");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "pk");
        }
    }

    public void testAddPKAndMultipleColumns() {
        if (this.getPlatformInfo().isPrimaryKeyColumnsHaveToBeRequired()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' default='2'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' default='2'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals((Object)null, beans.get(0), "pk1");
            this.assertEquals((Object)null, beans.get(0), "pk2");
            this.assertEquals(new Double(2.0), beans.get(0), "pk3");
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddPKAndMultipleRequiredColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true' default='2'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true' default='2'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals((Object)null, beans.get(0), "pk1");
            this.assertEquals((Object)null, beans.get(0), "pk2");
            this.assertEquals(new Double(2.0), beans.get(0), "pk3");
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddPKAndMultipleColumnsInclAutoIncrement() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals(new Integer(1), beans.get(0), "pk1");
            this.assertEquals((Object)null, beans.get(0), "pk2");
            this.assertEquals((Object)null, beans.get(0), "pk3");
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddColumnIntoPK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals(new Integer(1), beans.get(0), "pk1");
            this.assertEquals((Object)null, beans.get(0), "pk2");
            this.assertEquals(new Integer(2), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddAutoIncrementColumnIntoPK() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        boolean isSybase = "Sybase".equals(this.getPlatform().getName());
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = isSybase ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(-1), new Integer(2)});
        this.alterDatabase(model2Xml);
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertEquals((Object)new Integer(-1), (Object)((DynaBean)beans.get(0)).get("pk1"));
        TestAddColumn.assertEquals((Object)new Integer(2), (Object)((DynaBean)beans.get(0)).get("avalue"));
        if (isSybase) {
            this.assertEquals(new BigDecimal(1), beans.get(0), "pk2");
        } else {
            this.assertEquals(new Integer(1), beans.get(0), "pk2");
        }
    }

    public void testAddMultipleColumnsIntoPK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals(new Integer(1), beans.get(0), "pk1");
            this.assertEquals((Object)null, beans.get(0), "pk2");
            this.assertEquals((Object)null, beans.get(0), "pk3");
            this.assertEquals((Object)null, beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddMultipleColumnsIntoPKWithAutoIncrement() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{null, new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals(new Integer(1), beans.get(0), "pk1");
            this.assertEquals((Object)null, beans.get(0), "pk2");
            this.assertEquals((Object)null, beans.get(0), "pk3");
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddMultipleColumnsInclAutoIncrementIntoPK() {
        if (!this.getPlatformInfo().isMixingIdentityAndNormalPrimaryKeyColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), "text"});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        if ("McKoi".equals(this.getPlatform().getName())) {
            this.assertEquals(new Integer(1), beans.get(0), "pk1");
            this.assertEquals("text", beans.get(0), "pk2");
            this.assertEquals((Object)null, beans.get(0), "pk3");
            this.assertEquals(new Integer(1), beans.get(0), "avalue");
        } else {
            TestAddColumn.assertTrue((boolean)beans.isEmpty());
        }
    }

    public void testAddNonUniqueIndexAndColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue");
    }

    public void testAddNonUniqueIndexAndAutoIncrementColumn() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestAddColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddNonUniqueIndexAndRequiredColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddNonUniqueIndexAndColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestAddColumn.assertTrue((avalue == null || new Double(2.0).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddNonUniqueIndexAndRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
    }

    public void testAddNonUniqueIndexAndRequiredColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='sometext'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='sometext'/>\n    <index name='test'>\n      <index-column name='avalue'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("sometext", beans.get(0), "avalue");
    }

    public void testAddNonUniqueIndexAndMultipleColumns() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddUniqueIndexAndColumn() {
        if (!this.getPlatformInfo().isIndicesSupported() || "Interbase".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals((Object)null, beans.get(0), "avalue");
    }

    public void testAddUniqueIndexAndAutoIncrementColumn() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestAddColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddUniqueIndexAndRequiredColumn() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddUniqueIndexAndColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='2'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue = ((DynaBean)beans.get(0)).get("avalue");
        TestAddColumn.assertTrue((avalue == null || new Double(2.0).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddUniqueIndexAndRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(1), beans.get(0), "avalue");
    }

    public void testAddUniqueIndexAndRequiredColumnWithDefault() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='sometext'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='sometext'/>\n    <unique name='test'>\n      <unique-column name='avalue'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals("sometext", beans.get(0), "avalue");
    }

    public void testAddUniqueIndexAndMultipleColumns() {
        if (!this.getPlatformInfo().isIndicesSupported() || "Interbase".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddUniqueIndexAndMultipleRequiredColumns() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true' default='1'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true' default='1'/>\n    <column name='avalue2' type='VARCHAR' size='32' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
    }

    public void testAddAutoIncrementColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        TestAddColumn.assertTrue((avalue2 == null || new Integer(1).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddColumnWithDefaultIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        TestAddColumn.assertTrue((avalue2 == null || new Double(2.0).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredAutoIncrementColumnIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
    }

    public void testAddRequiredColumnWithDefaultIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='8' default='sometext' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='8' default='sometext' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals("sometext", beans.get(0), "avalue2");
    }

    public void testAddMultipleColumnsIntoNonUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n      <index-column name='avalue3'/>\n    </index>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n    </index>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <index name='test'>\n      <index-column name='avalue1'/>\n      <index-column name='avalue2'/>\n      <index-column name='avalue3'/>\n    </index>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || "Interbase".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals((Object)null, beans.get(0), "avalue2");
    }

    public void testAddAutoIncrementColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        TestAddColumn.assertTrue((avalue2 == null || new Integer(1).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddColumnWithDefaultIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        Object avalue2 = ((DynaBean)beans.get(0)).get("avalue2");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        TestAddColumn.assertTrue((avalue2 == null || new Double(2.0).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredAutoIncrementColumnIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || !this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(1), beans.get(0), "pk");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans.get(0), "avalue2");
    }

    public void testAddRequiredColumnWithDefaultIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' default='sometext' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='CHAR' size='8' default='sometext' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        this.assertEquals(new Integer(2), beans.get(0), "avalue1");
        this.assertEquals("sometext", beans.get(0), "avalue2");
    }

    public void testAddMultipleColumnsIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported() || "Interbase".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' default='3'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddMultipleRequiredColumnsIntoUniqueIndex() {
        if (!this.getPlatformInfo().isIndicesSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true' default='3'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n    </unique>\n  </table>\n</database>");
        this.insertRow("roundtrip", new Object[]{new Integer(1), new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' required='true'/>\n    <column name='avalue2' type='INTEGER' required='true' default='3'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <unique name='test'>\n      <unique-column name='avalue1'/>\n      <unique-column name='avalue2'/>\n      <unique-column name='avalue3'/>\n    </unique>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans = this.getRows("roundtrip");
        TestAddColumn.assertTrue((boolean)beans.isEmpty());
    }

    public void testAddFKAndLocalColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"text"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("text", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals((Object)null, beans2.get(0), "avalue");
    }

    public void testAddFKAndLocalAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        Object avalue = ((DynaBean)beans2.get(0)).get("avalue");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        TestAddColumn.assertTrue((avalue == null || new Integer(1).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddFKAndLocalRequiredColumn() {
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new BigDecimal(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='NUMERIC' size='12,0' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new BigDecimal(1), beans1.get(0), "pk");
        TestAddColumn.assertTrue((boolean)beans2.isEmpty());
    }

    public void testAddFKAndLocalColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='1'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Double(1.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE' default='1'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        Object avalue = ((DynaBean)beans2.get(0)).get("avalue");
        this.assertEquals(new Double(1.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        TestAddColumn.assertTrue((avalue == null || new Double(1.0).equals(avalue) ? 1 : 0) != 0);
    }

    public void testAddFKAndLocalRequiredAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER' required='true' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testAddFKAndLocalRequiredColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='moretext'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{"moretext"});
        this.insertRow("roundtrip2", new Object[]{new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk' type='CHAR' size='8' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='CHAR' size='8' required='true' default='moretext'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals("moretext", beans1.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals("moretext", beans2.get(0), "avalue");
    }

    public void testAddFKAndMultipleLocalColumns() {
        if ("MySQL".equals(this.getPlatform().getName()) || "MySQL5".equals(this.getPlatform().getName())) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1), new Double(2.0)});
        this.insertRow("roundtrip2", new Object[]{new Integer(3)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER' default='1'/>\n    <column name='avalue2' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        TestAddColumn.assertTrue((boolean)beans2.isEmpty());
    }

    public void testAddFKAndForeignColumn() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testAddFKAndForeignAutoIncrementColumn() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue");
    }

    public void testAddFKAndForeignColumnWithDefault() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(2)});
        this.insertRow("roundtrip2", new Object[]{new Integer(1), new Double(1.0)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue' foreign='pk'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Double(1.0), beans1.get(0), "pk");
        this.assertEquals(new Integer(2), beans1.get(0), "avalue");
        this.assertEquals(new Integer(1), beans2.get(0), "pk");
        this.assertEquals(new Double(1.0), beans2.get(0), "avalue");
    }

    public void testAddFKAndMultipleForeignColumns() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='avalue' type='INTEGER'/>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true' default='1'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testAddColumnsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='VARCHAR' size='32'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testAddAutoIncrementColumnIntoFK() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        Object avalue2 = ((DynaBean)beans2.get(0)).get("avalue2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Integer(1), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        TestAddColumn.assertTrue((avalue2 == null || new Integer(1).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredColumnsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='NUMERIC' size='12,0' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='NUMERIC' size='12,0' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }

    public void testAddColumnsWithDefaultsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true' default='2'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='DOUBLE' primaryKey='true' required='true' default='2'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='DOUBLE' default='2'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        Object avalue2 = ((DynaBean)beans2.get(0)).get("avalue2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Double(2.0), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        TestAddColumn.assertTrue((avalue2 == null || new Double(2.0).equals(avalue2) ? 1 : 0) != 0);
    }

    public void testAddRequiredAutoIncrementColumnIntoFK() {
        if (!this.getPlatformInfo().isNonPrimaryKeyIdentityColumnsSupported()) {
            return;
        }
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' required='true' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' required='true' autoIncrement='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals(new Integer(1), beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue2");
    }

    public void testAddRequiredColumnsWithDefaultsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='CHAR' size='8' primaryKey='true' required='true' default='sometext'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='8' required='true' default='sometext'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.insertRow("roundtrip1", new Object[]{new Integer(1)});
        this.insertRow("roundtrip2", new Object[]{new Integer(2), new Integer(1)});
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='CHAR' size='8' primaryKey='true' required='true' default='sometext'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='CHAR' size='8' required='true' default='sometext'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n    </foreign-key>\n  </table>\n</database>");
        List beans1 = this.getRows("roundtrip1");
        List beans2 = this.getRows("roundtrip2");
        this.assertEquals(new Integer(1), beans1.get(0), "pk1");
        this.assertEquals("sometext", beans1.get(0), "pk2");
        this.assertEquals(new Integer(2), beans2.get(0), "pk");
        this.assertEquals(new Integer(1), beans2.get(0), "avalue1");
        this.assertEquals("sometext", beans2.get(0), "avalue2");
    }

    public void testAddMultipleColumnsIntoFK() {
        String model1Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>";
        String model2Xml = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' default='1'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' default='1'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue3' foreign='pk3'/>\n    </foreign-key>\n  </table>\n</database>";
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n    </foreign-key>\n  </table>\n</database>");
        this.alterDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='roundtriptest'>\n  <table name='roundtrip1'>\n    <column name='pk1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='pk2' type='INTEGER' primaryKey='true' required='true' default='1'/>\n    <column name='pk3' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n  <table name='roundtrip2'>\n    <column name='pk' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='avalue1' type='INTEGER'/>\n    <column name='avalue2' type='INTEGER' default='1'/>\n    <column name='avalue3' type='DOUBLE' required='true'/>\n    <foreign-key foreignTable='roundtrip1'>\n      <reference local='avalue1' foreign='pk1'/>\n      <reference local='avalue2' foreign='pk2'/>\n      <reference local='avalue3' foreign='pk3'/>\n    </foreign-key>\n  </table>\n</database>");
        this.assertEquals(this.getAdjustedModel(), this.readModelFromDatabase("roundtriptest"));
    }
}

