/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.dynabean;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.ddlutils.TestAgainstLiveDatabaseBase;
import org.apache.ddlutils.dynabean.SqlDynaBean;
import org.apache.ddlutils.dynabean.SqlDynaClass;
import org.apache.ddlutils.io.TestAlteration;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.ModelBasedResultSetIterator;

public class TestDynaSqlQueries
extends TestAgainstLiveDatabaseBase {
    public static Test suite() throws Exception {
        return TestDynaSqlQueries.getTests(TestAlteration.class);
    }

    private String asIdentifier(String name) {
        if (this.getPlatform().isDelimitedIdentifierModeOn()) {
            return this.getPlatformInfo().getDelimiterToken() + name + this.getPlatformInfo().getDelimiterToken();
        }
        return name;
    }

    public void testSimpleQuery() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        this.insertData("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <TestTable TheId='1' TheText='Text 1'/>\n  <TestTable TheId='2' TheText='Text 2'/>\n  <TestTable TheId='3' TheText='Text 3'/></data>");
        ModelBasedResultSetIterator it = (ModelBasedResultSetIterator)this.getPlatform().query(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertTrue((boolean)it.hasNext());
        TestDynaSqlQueries.assertTrue((boolean)it.hasNext());
        DynaBean bean = (DynaBean)it.next();
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 1", (Object)this.getPropertyValue(bean, "TheText"));
        TestDynaSqlQueries.assertTrue((boolean)it.hasNext());
        bean = (DynaBean)it.next();
        TestDynaSqlQueries.assertEquals((Object)new Integer(2), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 2", (Object)this.getPropertyValue(bean, "TheText"));
        TestDynaSqlQueries.assertTrue((boolean)it.hasNext());
        bean = (DynaBean)it.next();
        TestDynaSqlQueries.assertEquals((Object)new Integer(3), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 3", (Object)this.getPropertyValue(bean, "TheText"));
        TestDynaSqlQueries.assertFalse((boolean)it.hasNext());
        TestDynaSqlQueries.assertFalse((boolean)it.isConnectionOpen());
    }

    public void testSimpleFetch() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        this.insertData("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <TestTable TheId='1' TheText='Text 1'/>\n  <TestTable TheId='2' TheText='Text 2'/>\n  <TestTable TheId='3' TheText='Text 3'/></data>");
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)3, (int)beans.size());
        DynaBean bean = (DynaBean)beans.get(0);
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 1", (Object)this.getPropertyValue(bean, "TheText"));
        bean = (DynaBean)beans.get(1);
        TestDynaSqlQueries.assertEquals((Object)new Integer(2), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 2", (Object)this.getPropertyValue(bean, "TheText"));
        bean = (DynaBean)beans.get(2);
        TestDynaSqlQueries.assertEquals((Object)new Integer(3), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 3", (Object)this.getPropertyValue(bean, "TheText"));
    }

    public void testAutoIncrement() throws Exception {
        String modelXml = "Sybase".equals(this.getPlatform().getName()) ? "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='NUMERIC' size='12,0' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>" : "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true' autoIncrement='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>";
        this.createDatabase(modelXml);
        SqlDynaClass dynaClass = this.getModel().getDynaClassFor("TestTable");
        DynaBean bean = null;
        Object id1 = null;
        Object id2 = null;
        Object id3 = null;
        bean = dynaClass.newInstance();
        bean.set("TheText", (Object)"Text 1");
        this.getPlatform().insert(this.getModel(), bean);
        if (this.getPlatformInfo().isLastIdentityValueReadable()) {
            id1 = this.getPropertyValue(bean, "TheId");
            TestDynaSqlQueries.assertNotNull((Object)id1);
        }
        bean = dynaClass.newInstance();
        bean.set("TheText", (Object)"Text 2");
        this.getPlatform().insert(this.getModel(), bean);
        if (this.getPlatformInfo().isLastIdentityValueReadable()) {
            id2 = this.getPropertyValue(bean, "TheId");
            TestDynaSqlQueries.assertNotNull((Object)id2);
        }
        bean = dynaClass.newInstance();
        bean.set("TheText", (Object)"Text 3");
        this.getPlatform().insert(this.getModel(), bean);
        if (this.getPlatformInfo().isLastIdentityValueReadable()) {
            id3 = this.getPropertyValue(bean, "TheId");
            TestDynaSqlQueries.assertNotNull((Object)id3);
        }
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)3, (int)beans.size());
        bean = (DynaBean)beans.get(0);
        if (this.getPlatformInfo().isLastIdentityValueReadable()) {
            TestDynaSqlQueries.assertEquals((Object)id1, (Object)this.getPropertyValue(bean, "TheId"));
        } else {
            TestDynaSqlQueries.assertNotNull((Object)this.getPropertyValue(bean, "TheId"));
        }
        TestDynaSqlQueries.assertEquals((Object)"Text 1", (Object)this.getPropertyValue(bean, "TheText"));
        bean = (DynaBean)beans.get(1);
        if (this.getPlatformInfo().isLastIdentityValueReadable()) {
            TestDynaSqlQueries.assertEquals((Object)id2, (Object)this.getPropertyValue(bean, "TheId"));
        } else {
            TestDynaSqlQueries.assertNotNull((Object)this.getPropertyValue(bean, "TheId"));
        }
        TestDynaSqlQueries.assertEquals((Object)"Text 2", (Object)this.getPropertyValue(bean, "TheText"));
        bean = (DynaBean)beans.get(2);
        if (this.getPlatformInfo().isLastIdentityValueReadable()) {
            TestDynaSqlQueries.assertEquals((Object)id3, (Object)this.getPropertyValue(bean, "TheId"));
        } else {
            TestDynaSqlQueries.assertNotNull((Object)this.getPropertyValue(bean, "TheId"));
        }
        TestDynaSqlQueries.assertEquals((Object)"Text 3", (Object)this.getPropertyValue(bean, "TheText"));
    }

    public void testJoinQuery() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable1'>\n    <column name='Id1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Id2' type='INTEGER'/>\n  </table>\n  <table name='TestTable2'>\n    <column name='Id' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Avalue' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        this.insertData("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <TestTable1 Id1='1'/>\n  <TestTable1 Id1='2' Id2='3'/>\n  <TestTable2 Id='1' Avalue='Text 1'/>\n  <TestTable2 Id='2' Avalue='Text 2'/>\n  <TestTable2 Id='3' Avalue='Text 3'/></data>");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        sql.append(this.asIdentifier("Id1"));
        sql.append(",");
        sql.append(this.asIdentifier("Avalue"));
        sql.append(" FROM ");
        sql.append(this.asIdentifier("TestTable1"));
        sql.append(",");
        sql.append(this.asIdentifier("TestTable2"));
        sql.append(" WHERE ");
        sql.append(this.asIdentifier("Id2"));
        sql.append("=");
        sql.append(this.asIdentifier("Id"));
        ModelBasedResultSetIterator it = (ModelBasedResultSetIterator)this.getPlatform().query(this.getModel(), sql.toString(), new Table[]{this.getModel().getTable(0), this.getModel().getTable(1)});
        TestDynaSqlQueries.assertTrue((boolean)it.hasNext());
        DynaBean bean = (DynaBean)it.next();
        TestDynaSqlQueries.assertEquals((Object)new Integer(2), (Object)this.getPropertyValue(bean, "Id1"));
        TestDynaSqlQueries.assertEquals((Object)"Text 3", (Object)this.getPropertyValue(bean, "Avalue"));
        TestDynaSqlQueries.assertFalse((boolean)it.hasNext());
        TestDynaSqlQueries.assertFalse((boolean)it.isConnectionOpen());
    }

    public void testInsertSingle() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        SqlDynaClass dynaClass = SqlDynaClass.newInstance((Table)this.getModel().getTable(0));
        SqlDynaBean dynaBean = new SqlDynaBean((DynaClass)dynaClass);
        dynaBean.set("TheId", (Object)new Integer(1));
        dynaBean.set("TheText", (Object)"Text 1");
        this.getPlatform().insert(this.getModel(), (DynaBean)dynaBean);
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)1, (int)beans.size());
        DynaBean bean = (DynaBean)beans.get(0);
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 1", (Object)this.getPropertyValue(bean, "TheText"));
    }

    public void testInsertMultiple() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        SqlDynaClass dynaClass = SqlDynaClass.newInstance((Table)this.getModel().getTable(0));
        SqlDynaBean dynaBean1 = new SqlDynaBean((DynaClass)dynaClass);
        SqlDynaBean dynaBean2 = new SqlDynaBean((DynaClass)dynaClass);
        SqlDynaBean dynaBean3 = new SqlDynaBean((DynaClass)dynaClass);
        dynaBean1.set("TheId", (Object)new Integer(1));
        dynaBean1.set("TheText", (Object)"Text 1");
        dynaBean2.set("TheId", (Object)new Integer(2));
        dynaBean2.set("TheText", (Object)"Text 2");
        dynaBean3.set("TheId", (Object)new Integer(3));
        dynaBean3.set("TheText", (Object)"Text 3");
        ArrayList<SqlDynaBean> dynaBeans = new ArrayList<SqlDynaBean>();
        dynaBeans.add(dynaBean1);
        dynaBeans.add(dynaBean2);
        dynaBeans.add(dynaBean3);
        this.getPlatform().insert(this.getModel(), dynaBeans);
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)3, (int)beans.size());
        DynaBean bean = (DynaBean)beans.get(0);
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 1", (Object)this.getPropertyValue(bean, "TheText"));
        bean = (DynaBean)beans.get(1);
        TestDynaSqlQueries.assertEquals((Object)new Integer(2), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 2", (Object)this.getPropertyValue(bean, "TheText"));
        bean = (DynaBean)beans.get(2);
        TestDynaSqlQueries.assertEquals((Object)new Integer(3), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 3", (Object)this.getPropertyValue(bean, "TheText"));
    }

    public void testUpdate() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        this.insertData("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <TestTable TheId='1' TheText='Text 1'/>\n</data>");
        SqlDynaClass dynaClass = SqlDynaClass.newInstance((Table)this.getModel().getTable(0));
        SqlDynaBean dynaBean = new SqlDynaBean((DynaClass)dynaClass);
        dynaBean.set("TheId", (Object)new Integer(1));
        dynaBean.set("TheText", (Object)"Text 10");
        this.getPlatform().update(this.getModel(), (DynaBean)dynaBean);
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)1, (int)beans.size());
        DynaBean bean = (DynaBean)beans.get(0);
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 10", (Object)this.getPropertyValue(bean, "TheText"));
    }

    public void testExists() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        this.insertData("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <TestTable TheId='1' TheText='Text 1'/>\n  <TestTable TheId='3' TheText='Text 3'/>\n</data>");
        SqlDynaClass dynaClass = SqlDynaClass.newInstance((Table)this.getModel().getTable(0));
        SqlDynaBean dynaBean1 = new SqlDynaBean((DynaClass)dynaClass);
        SqlDynaBean dynaBean2 = new SqlDynaBean((DynaClass)dynaClass);
        SqlDynaBean dynaBean3 = new SqlDynaBean((DynaClass)dynaClass);
        dynaBean1.set("TheId", (Object)new Integer(1));
        dynaBean1.set("TheText", (Object)"Text 1");
        dynaBean2.set("TheId", (Object)new Integer(2));
        dynaBean2.set("TheText", (Object)"Text 2");
        dynaBean3.set("TheId", (Object)new Integer(3));
        dynaBean3.set("TheText", (Object)"Text 30");
        TestDynaSqlQueries.assertTrue((boolean)this.getPlatform().exists(this.getModel(), (DynaBean)dynaBean1));
        TestDynaSqlQueries.assertFalse((boolean)this.getPlatform().exists(this.getModel(), (DynaBean)dynaBean2));
        TestDynaSqlQueries.assertTrue((boolean)this.getPlatform().exists(this.getModel(), (DynaBean)dynaBean3));
    }

    public void testStoreNew() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        SqlDynaClass dynaClass = SqlDynaClass.newInstance((Table)this.getModel().getTable(0));
        SqlDynaBean dynaBean = new SqlDynaBean((DynaClass)dynaClass);
        dynaBean.set("TheId", (Object)new Integer(1));
        dynaBean.set("TheText", (Object)"Text 1");
        this.getPlatform().store(this.getModel(), (DynaBean)dynaBean);
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)1, (int)beans.size());
        DynaBean bean = (DynaBean)beans.get(0);
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 1", (Object)this.getPropertyValue(bean, "TheText"));
    }

    public void testStoreExisting() throws Exception {
        this.createDatabase("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='ddlutils'>\n  <table name='TestTable'>\n    <column name='TheId' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='TheText' type='VARCHAR' size='15'/>\n  </table>\n</database>");
        this.insertData("<?xml version='1.0' encoding='ISO-8859-1'?>\n<data>\n  <TestTable TheId='1' TheText='Text 1'/>\n</data>");
        SqlDynaClass dynaClass = SqlDynaClass.newInstance((Table)this.getModel().getTable(0));
        SqlDynaBean dynaBean = new SqlDynaBean((DynaClass)dynaClass);
        dynaBean.set("TheId", (Object)new Integer(1));
        dynaBean.set("TheText", (Object)"Text 10");
        this.getPlatform().store(this.getModel(), (DynaBean)dynaBean);
        List beans = this.getPlatform().fetch(this.getModel(), "SELECT * FROM " + this.asIdentifier("TestTable"), new Table[]{this.getModel().getTable(0)});
        TestDynaSqlQueries.assertEquals((int)1, (int)beans.size());
        DynaBean bean = (DynaBean)beans.get(0);
        TestDynaSqlQueries.assertEquals((Object)new Integer(1), (Object)this.getPropertyValue(bean, "TheId"));
        TestDynaSqlQueries.assertEquals((Object)"Text 10", (Object)this.getPropertyValue(bean, "TheText"));
    }
}

