/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.List;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.ColumnDefinitionChange;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.TestComparisonBase;
import org.apache.ddlutils.model.Database;

public class TestTableComparison
extends TestComparisonBase {
    public void testAddColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        AddColumnChange change = (AddColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col1", 8, null, null, false, false, false, change.getNewColumn());
        TestTableComparison.assertEquals((String)"ColPK", (String)change.getPreviousColumn());
        TestTableComparison.assertNull((Object)change.getNextColumn());
    }

    public void testAddAutoIncrementColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColA' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColA' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        AddColumnChange change = (AddColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("ColA", 4, null, null, false, false, true, change.getNewColumn());
        TestTableComparison.assertEquals((String)"ColPK", (String)change.getPreviousColumn());
        TestTableComparison.assertNull((Object)change.getNextColumn());
    }

    public void testAddRequiredColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColA' type='INTEGER' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColA' type='INTEGER' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        AddColumnChange change = (AddColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("ColA", 4, null, null, false, true, false, change.getNewColumn());
        TestTableComparison.assertEquals((String)"ColPK", (String)change.getPreviousColumn());
        TestTableComparison.assertNull((Object)change.getNextColumn());
    }

    public void testAddColumnWithSizeAndDefaultValue() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLA' type='VARCHAR' size='32' default='text'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLA' type='VARCHAR' size='32' default='text'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        AddColumnChange change = (AddColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("COLA", 12, "32", "text", false, false, false, change.getNewColumn());
        TestTableComparison.assertEquals((String)"ColPK", (String)change.getPreviousColumn());
        TestTableComparison.assertNull((Object)change.getNextColumn());
    }

    public void testMakeColumnRequired() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='false'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='false'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, null, false, true, false, change.getNewColumn());
    }

    public void testMakeColumnNotRequired() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' required='false'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' required='false'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, null, false, false, false, change.getNewColumn());
    }

    public void testMakeColumnAutoIncrement() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='false'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='false'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, null, false, false, true, change.getNewColumn());
    }

    public void testMakeColumnNotAutoIncrement() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' autoIncrement='false'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER' autoIncrement='false'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 12, "32", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType3() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='10,5'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='10,5'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 2, "10,5", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType4() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='CHAR' size='32'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='CHAR' size='32'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 1, "32", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType5() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='32,5'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='32,5'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 2, "32,5", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType6() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='10,5'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='10,5'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 12, "32", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType7() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='FLOAT'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='FLOAT'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 6, null, null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnDataType8() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='10,5'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='TIMESTAMP'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='10,5'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='TIMESTAMP'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 93, null, null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnSize() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' size='8' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' size='8' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 12, "32", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnPrecisionAndScale() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='16,5'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='DECIMAL' size='32,7'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DECIMAL' size='16,5'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='DECIMAL' size='32,7'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 3, "32,7", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnScale() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='32,0'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='32,5'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='32,0'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='NUMERIC' size='32,5'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 2, "32,5", null, false, false, false, change.getNewColumn());
    }

    public void testRemoveUnnecessaryColumnSize() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' size='8'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' size='8'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertTrue((boolean)changes.isEmpty());
    }

    public void testAddDefaultValue() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' default='0'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' default='0'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, "0", false, false, false, change.getNewColumn());
    }

    public void testChangeDefaultValue() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' default='1'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' default='2'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' default='1'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' default='2'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, "2", false, false, false, change.getNewColumn());
    }

    public void testSameDefaultValueExpressedDifferently() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE' default='10'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='DOUBLE' default='1e+1'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='DOUBLE' default='10'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='DOUBLE' default='1e+1'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertTrue((boolean)changes.isEmpty());
    }

    public void testRemoveDefaultValue() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16' default='1'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16' default='1'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 12, "16", null, false, false, false, change.getNewColumn());
    }

    public void testMakeColumnRequiredWithDefaultValue() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true' default='0'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER' required='true' default='0'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 4, null, "0", false, true, false, change.getNewColumn());
    }

    public void testMakeColumnNotRequiredWithoutDefaultValue() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16' default='1' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16' default='1' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='VARCHAR' size='16'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnDefinitionChange change = (ColumnDefinitionChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertColumn("Col", 12, "16", null, false, false, false, change.getNewColumn());
    }

    public void testChangeColumnOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        ColumnOrderChange change = (ColumnOrderChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestTableComparison.assertEquals((int)3, (int)change.getNewPosition("Col1", true));
        TestTableComparison.assertEquals((int)-1, (int)change.getNewPosition("Col2", true));
        TestTableComparison.assertEquals((int)1, (int)change.getNewPosition("Col3", true));
    }

    public void testAddColumnAndChangeColumnOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)2, (int)changes.size());
        ColumnOrderChange change1 = (ColumnOrderChange)changes.get(0);
        AddColumnChange change2 = (AddColumnChange)changes.get(1);
        TestTableComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestTableComparison.assertEquals((int)2, (int)change1.getNewPosition("Col1", false));
        TestTableComparison.assertEquals((int)1, (int)change1.getNewPosition("Col2", false));
        TestTableComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertColumn("Col3", 12, "32", null, false, false, false, change2.getNewColumn());
        TestTableComparison.assertEquals((String)"ColPK", (String)change2.getPreviousColumn());
        TestTableComparison.assertEquals((String)"Col2", (String)change2.getNextColumn());
    }

    public void testRemoveColumnAndChangeColumnOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n    <column name='Col1' type='DOUBLE'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col2' type='INTEGER' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)2, (int)changes.size());
        RemoveColumnChange change1 = (RemoveColumnChange)changes.get(0);
        ColumnOrderChange change2 = (ColumnOrderChange)changes.get(1);
        TestTableComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestTableComparison.assertEquals((String)"Col3", (String)change1.getChangedColumn());
        TestTableComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        TestTableComparison.assertEquals((int)-1, (int)change2.getNewPosition("ColPK", true));
        TestTableComparison.assertEquals((int)2, (int)change2.getNewPosition("Col1", true));
        TestTableComparison.assertEquals((int)1, (int)change2.getNewPosition("Col2", true));
    }

    public void testDropColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='DOUBLE'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        RemoveColumnChange change = (RemoveColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestTableComparison.assertEquals((String)"Col1", (String)change.getChangedColumn());
    }

    public void testDropAutoIncrementColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER' autoIncrement='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        RemoveColumnChange change = (RemoveColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestTableComparison.assertEquals((String)"Col1", (String)change.getChangedColumn());
    }

    public void testDropRequiredColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestTableComparison.assertEquals((int)1, (int)changes.size());
        RemoveColumnChange change = (RemoveColumnChange)changes.get(0);
        TestTableComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestTableComparison.assertEquals((String)"Col1", (String)change.getChangedColumn());
    }
}

