/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.List;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.ColumnOrderChange;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemovePrimaryKeyChange;
import org.apache.ddlutils.alteration.TestComparisonBase;
import org.apache.ddlutils.model.Database;

public class TestPrimaryKeyComparison
extends TestComparisonBase {
    public void testAddPrimaryKeyColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)2, (int)changes.size());
        AddColumnChange colChange = (AddColumnChange)changes.get(0);
        AddPrimaryKeyChange pkChange = (AddPrimaryKeyChange)changes.get(1);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        this.assertColumn("ColPK1", 4, null, null, false, true, false, colChange.getNewColumn());
        TestPrimaryKeyComparison.assertNull((Object)colChange.getPreviousColumn());
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)colChange.getNextColumn());
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)1, (int)pkChange.getPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK1", (String)pkChange.getPrimaryKeyColumns()[0]);
    }

    public void testMakeColumnPrimaryKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        AddPrimaryKeyChange change = (AddPrimaryKeyChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)1, (int)change.getPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK", (String)change.getPrimaryKeyColumns()[0]);
    }

    public void testAddColumnToPrimaryKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        PrimaryKeyChange change = (PrimaryKeyChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)2, (int)change.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK1", (String)change.getNewPrimaryKeyColumns()[0]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)change.getNewPrimaryKeyColumns()[1]);
    }

    public void testChangeColumnOrderInPrimaryKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)2, (int)changes.size());
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(0);
        ColumnOrderChange colChange = (ColumnOrderChange)changes.get(1);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK3", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK1", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)2, (int)colChange.getNewPosition("ColPK1", true));
        TestPrimaryKeyComparison.assertEquals((int)0, (int)colChange.getNewPosition("ColPK2", true));
        TestPrimaryKeyComparison.assertEquals((int)1, (int)colChange.getNewPosition("ColPK3", true));
    }

    public void testAddColumnAndChangeColumnOrderInPrimaryKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)4, (int)changes.size());
        PrimaryKeyChange pkChange1 = (PrimaryKeyChange)changes.get(0);
        ColumnOrderChange colChange1 = (ColumnOrderChange)changes.get(1);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(2);
        PrimaryKeyChange pkChange2 = (PrimaryKeyChange)changes.get(3);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange1.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)2, (int)pkChange1.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK3", (String)pkChange1.getNewPrimaryKeyColumns()[0]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK1", (String)pkChange1.getNewPrimaryKeyColumns()[1]);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)1, (int)colChange1.getNewPosition("ColPK1", true));
        TestPrimaryKeyComparison.assertEquals((int)-1, (int)colChange1.getNewPosition("ColPK2", true));
        TestPrimaryKeyComparison.assertEquals((int)0, (int)colChange1.getNewPosition("ColPK3", true));
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        this.assertColumn("ColPK2", 4, null, null, false, true, false, colChange2.getNewColumn());
        TestPrimaryKeyComparison.assertNull((Object)colChange2.getPreviousColumn());
        TestPrimaryKeyComparison.assertEquals((String)"ColPK3", (String)colChange2.getNextColumn());
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange2.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)3, (int)pkChange2.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)pkChange2.getNewPrimaryKeyColumns()[0]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK3", (String)pkChange2.getNewPrimaryKeyColumns()[1]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK1", (String)pkChange2.getNewPrimaryKeyColumns()[2]);
    }

    public void testRemoveColumnAndChangeColumnOrderInPrimaryKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)3, (int)changes.size());
        RemoveColumnChange colChange1 = (RemoveColumnChange)changes.get(0);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(1);
        ColumnOrderChange colChange2 = (ColumnOrderChange)changes.get(2);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)colChange1.getChangedColumn());
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)2, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK3", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK1", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)1, (int)colChange2.getNewPosition("ColPK1", true));
        TestPrimaryKeyComparison.assertEquals((int)-1, (int)colChange2.getNewPosition("ColPK2", true));
        TestPrimaryKeyComparison.assertEquals((int)0, (int)colChange2.getNewPosition("ColPK3", true));
    }

    public void testMakeColumnNotPrimaryKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        PrimaryKeyChange change = (PrimaryKeyChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)1, (int)change.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)change.getNewPrimaryKeyColumns()[0]);
    }

    public void testDropPrimaryKeyColumn1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COL' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COL' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        RemoveColumnChange colChange = (RemoveColumnChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((String)"ColPK", (String)colChange.getChangedColumn());
    }

    public void testDropPrimaryKeyColumn2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        RemoveColumnChange colChange = (RemoveColumnChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)colChange.getChangedColumn());
    }

    public void testRemovePrimaryKey1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        RemovePrimaryKeyChange change = (RemovePrimaryKeyChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
    }

    public void testRemovePrimaryKey2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK1' type='INTEGER' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='INTEGER' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK1' type='INTEGER' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='INTEGER' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        RemovePrimaryKeyChange pkChange = (RemovePrimaryKeyChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange.getChangedTable());
    }

    public void testChangePrimaryKeyColumns() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK4' type='INTEGER' required='true'/>\n    <column name='ColPK5' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' required='true'/>\n    <column name='ColPK4' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK5' type='INTEGER' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n    <column name='ColPK3' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK4' type='INTEGER' required='true'/>\n    <column name='ColPK5' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='ColPK1' type='INTEGER' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='INTEGER' required='true'/>\n    <column name='ColPK4' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK5' type='INTEGER' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestPrimaryKeyComparison.assertEquals((int)1, (int)changes.size());
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(0);
        TestPrimaryKeyComparison.assertEquals((String)"TableA", (String)pkChange.getChangedTable());
        TestPrimaryKeyComparison.assertEquals((int)2, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK2", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestPrimaryKeyComparison.assertEquals((String)"ColPK4", (String)pkChange.getNewPrimaryKeyColumns()[1]);
    }
}

