/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.List;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddTableChange;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.RemoveTableChange;
import org.apache.ddlutils.alteration.TestComparisonBase;
import org.apache.ddlutils.model.Database;

public class TestModelComparison
extends TestComparisonBase {
    public void testAddTable() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)1, (int)changes.size());
        AddTableChange change = (AddTableChange)changes.get(0);
        this.assertTable("TABLEB", null, 1, 0, 0, change.getNewTable());
        this.assertColumn("COLPK", 4, null, null, true, true, false, change.getNewTable().getColumn(0));
    }

    public void testAddTableWithIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLA' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='COLA'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLA' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='COLA'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)1, (int)changes.size());
        AddTableChange change = (AddTableChange)changes.get(0);
        this.assertTable("TABLEB", null, 2, 0, 1, change.getNewTable());
        this.assertColumn("COLPK", 4, null, null, true, true, false, change.getNewTable().getColumn(0));
        this.assertColumn("COLA", 8, null, null, false, false, false, change.getNewTable().getColumn(1));
        this.assertIndex("TestIndex", false, new String[]{"COLA"}, change.getNewTable().getIndex(0));
    }

    public void testAddTableAndForeignKeyToIt() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKB' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKB' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)2, (int)changes.size());
        AddTableChange tableChange = (AddTableChange)changes.get(0);
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(1);
        this.assertTable("TABLEB", null, 1, 0, 0, tableChange.getNewTable());
        this.assertColumn("COLPK", 4, null, null, true, true, false, tableChange.getNewTable().getColumn(0));
        TestModelComparison.assertEquals((String)"TABLEA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFKB", "TABLEB", new String[]{"COLFK"}, new String[]{"COLPK"}, fkChange.getNewForeignKey());
    }

    public void testAddTablesWithForeignKeys() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKB' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKA' foreignTable='TABLEA'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKB' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKA' foreignTable='TABLEA'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)4, (int)changes.size());
        AddTableChange tableChange1 = (AddTableChange)changes.get(0);
        AddTableChange tableChange2 = (AddTableChange)changes.get(1);
        AddForeignKeyChange fkChange1 = (AddForeignKeyChange)changes.get(2);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(3);
        this.assertTable("TABLEA", null, 2, 0, 0, tableChange1.getNewTable());
        this.assertColumn("COLPK", 4, null, null, true, true, false, tableChange1.getNewTable().getColumn(0));
        this.assertColumn("COLFK", 4, null, null, false, false, false, tableChange1.getNewTable().getColumn(1));
        this.assertTable("TABLEB", null, 2, 0, 0, tableChange2.getNewTable());
        this.assertColumn("COLPK", 4, null, null, true, true, false, tableChange2.getNewTable().getColumn(0));
        this.assertColumn("COLFK", 4, null, null, false, false, false, tableChange2.getNewTable().getColumn(1));
        TestModelComparison.assertEquals((String)"TABLEA", (String)fkChange1.getChangedTable());
        this.assertForeignKey("TESTFKB", "TABLEB", new String[]{"COLFK"}, new String[]{"COLPK"}, fkChange1.getNewForeignKey());
        TestModelComparison.assertEquals((String)"TABLEB", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFKA", "TABLEA", new String[]{"COLFK"}, new String[]{"COLPK"}, fkChange2.getNewForeignKey());
    }

    public void testDropTable() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)1, (int)changes.size());
        RemoveTableChange change = (RemoveTableChange)changes.get(0);
        TestModelComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
    }

    public void testDropTableWithIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColA' type='INTEGER'/>\n    <index name='TestIndex'>\n      <index-column name='ColA'/>\n    </index>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColA' type='INTEGER'/>\n    <index name='TestIndex'>\n      <index-column name='ColA'/>\n    </index>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)1, (int)changes.size());
        RemoveTableChange change = (RemoveTableChange)changes.get(0);
        TestModelComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
    }

    public void testDropTableWithForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKB' foreignTable='TableB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKB' foreignTable='TableB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)2, (int)changes.size());
        RemoveForeignKeyChange fkChange = (RemoveForeignKeyChange)changes.get(0);
        RemoveTableChange tableChange = (RemoveTableChange)changes.get(1);
        TestModelComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        TestModelComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange.findChangedForeignKey(model1, false));
        TestModelComparison.assertEquals((String)"TableA", (String)tableChange.getChangedTable());
    }

    public void testDropTableAndForeignKeyToIt() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKA' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFKA' foreignTable='TableA'>\n      <reference local='COLFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)2, (int)changes.size());
        RemoveForeignKeyChange fkChange = (RemoveForeignKeyChange)changes.get(0);
        RemoveTableChange tableChange = (RemoveTableChange)changes.get(1);
        TestModelComparison.assertEquals((String)"TableB", (String)fkChange.getChangedTable());
        TestModelComparison.assertEquals((Object)model1.findTable("TableB").getForeignKey(0), (Object)fkChange.findChangedForeignKey(model1, false));
        TestModelComparison.assertEquals((String)"TableA", (String)tableChange.getChangedTable());
    }

    public void testAddAndDropTable() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestModelComparison.assertEquals((int)2, (int)changes.size());
        RemoveTableChange change1 = (RemoveTableChange)changes.get(0);
        AddTableChange change2 = (AddTableChange)changes.get(1);
        TestModelComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        this.assertTable("TABLEA", null, 1, 0, 0, change2.getNewTable());
        this.assertColumn("COLPK", 4, null, null, true, true, false, change2.getNewTable().getColumn(0));
    }
}

