/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.List;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddIndexChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemoveIndexChange;
import org.apache.ddlutils.alteration.TestComparisonBase;
import org.apache.ddlutils.model.Database;

public class TestIndexComparison
extends TestComparisonBase {
    public void testAddSingleColumnIndex1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)1, (int)changes.size());
        AddIndexChange change = (AddIndexChange)changes.get(0);
        TestIndexComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertIndex("TESTINDEX", false, new String[]{"Col"}, change.getNewIndex());
    }

    public void testAddSingleColumnIndex2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL' type='INTEGER'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        AddColumnChange colChange = (AddColumnChange)changes.get(0);
        AddIndexChange indexChange = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        this.assertColumn("COL", 4, null, null, false, false, false, colChange.getNewColumn());
        TestIndexComparison.assertEquals((String)"ColPK", (String)colChange.getPreviousColumn());
        TestIndexComparison.assertNull((Object)colChange.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange.getChangedTable());
        this.assertIndex("TESTINDEX", false, new String[]{"COL"}, indexChange.getNewIndex());
    }

    public void testAddMultiColumnIndex1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <column name='Col3' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)1, (int)changes.size());
        AddIndexChange change = (AddIndexChange)changes.get(0);
        TestIndexComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"Col3", "Col1", "Col2"}, change.getNewIndex());
    }

    public void testAddMultiColumnIndex2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)4, (int)changes.size());
        AddColumnChange colChange1 = (AddColumnChange)changes.get(0);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(1);
        AddColumnChange colChange3 = (AddColumnChange)changes.get(2);
        AddIndexChange indexChange = (AddIndexChange)changes.get(3);
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        this.assertColumn("COL1", 4, null, null, false, false, false, colChange1.getNewColumn());
        TestIndexComparison.assertEquals((String)"ColPK", (String)colChange1.getPreviousColumn());
        TestIndexComparison.assertNull((Object)colChange1.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        this.assertColumn("COL2", 8, null, null, false, false, false, colChange2.getNewColumn());
        TestIndexComparison.assertEquals((String)"COL1", (String)colChange2.getPreviousColumn());
        TestIndexComparison.assertNull((Object)colChange2.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange3.getChangedTable());
        this.assertColumn("COL3", 12, "32", null, false, false, false, colChange3.getNewColumn());
        TestIndexComparison.assertEquals((String)"COL2", (String)colChange3.getPreviousColumn());
        TestIndexComparison.assertNull((Object)colChange3.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL3", "COL1", "COL2"}, indexChange.getNewIndex());
    }

    public void testAddNewColumnToMultiColumnIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)3, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        AddColumnChange colChange = (AddColumnChange)changes.get(1);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(2);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        this.assertColumn("COL2", 8, null, null, false, false, false, colChange.getNewColumn());
        TestIndexComparison.assertEquals((String)"COL1", (String)colChange.getPreviousColumn());
        TestIndexComparison.assertEquals((String)"COL3", (String)colChange.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL3", "COL1", "COL2"}, indexChange2.getNewIndex());
    }

    public void testAddNewColumnsToSingleColumnIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n      <unique-column name='COL3'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n      <unique-column name='COL3'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)4, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        AddColumnChange colChange1 = (AddColumnChange)changes.get(1);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(2);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(3);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        this.assertColumn("COL1", 4, null, null, false, false, false, colChange1.getNewColumn());
        TestIndexComparison.assertEquals((String)"ColPK", (String)colChange1.getPreviousColumn());
        TestIndexComparison.assertEquals((String)"COL3", (String)colChange1.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        this.assertColumn("COL2", 8, null, null, false, false, false, colChange2.getNewColumn());
        TestIndexComparison.assertEquals((String)"COL1", (String)colChange2.getPreviousColumn());
        TestIndexComparison.assertEquals((String)"COL3", (String)colChange2.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL1", "COL3", "COL2"}, indexChange2.getNewIndex());
    }

    public void testAddColumnToMultiColumnIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL3'/>\n      <index-column name='COL2'/>\n    </index>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL3'/>\n      <index-column name='COL1'/>\n      <index-column name='COL2'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL3'/>\n      <index-column name='COL2'/>\n    </index>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL3'/>\n      <index-column name='COL1'/>\n      <index-column name='COL2'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", false, new String[]{"COL3", "COL1", "COL2"}, indexChange2.getNewIndex());
    }

    public void testAddColumnsToSingleColumnIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL3", "COL1", "COL2"}, indexChange2.getNewIndex());
    }

    public void testChangeIndexColumnOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col2'/>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col2'/>\n      <unique-column name='Col1'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange change1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange change2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)change1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertIndex("TestIndex", true, new String[]{"Col2", "Col1"}, change2.getNewIndex());
    }

    public void testAddIndexColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange change1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange change2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)change1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertIndex("TestIndex", false, new String[]{"Col1", "Col2"}, change2.getNewIndex());
    }

    public void testRemoveIndexColumn() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange change1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange change2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)change1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertIndex("TestIndex", false, new String[]{"Col1"}, change2.getNewIndex());
    }

    public void testChangeIndexType() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <index name='TestIndex'>\n      <index-column name='Col1'/>\n      <index-column name='Col2'/>\n    </index>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col1' type='INTEGER'/>\n    <column name='Col2' type='DOUBLE'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col1'/>\n      <unique-column name='Col2'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange change1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange change2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)change1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertIndex("TestIndex", true, new String[]{"Col1", "Col2"}, change2.getNewIndex());
    }

    public void testDropColumnFromSingleColumnIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL1'/>\n    </index>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL1'/>\n    </index>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange indexChange = (RemoveIndexChange)changes.get(0);
        RemoveColumnChange colChange = (RemoveColumnChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        TestIndexComparison.assertEquals((String)"COL1", (String)colChange.getChangedColumn());
    }

    public void testDropColumnFromMultiColumnIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL2'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL2'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)3, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        RemoveColumnChange colChange = (RemoveColumnChange)changes.get(1);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(2);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        TestIndexComparison.assertEquals((String)"COL2", (String)colChange.getChangedColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL3", "COL1"}, indexChange2.getNewIndex());
    }

    public void testAddColumnAndChangeIndexColumnOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n      <unique-column name='COL3'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n      <unique-column name='COL2'/>\n      <unique-column name='COL3'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)3, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        AddColumnChange colChange = (AddColumnChange)changes.get(1);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(2);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        this.assertColumn("COL2", 8, null, null, false, false, false, colChange.getNewColumn());
        TestIndexComparison.assertEquals((String)"COL1", (String)colChange.getPreviousColumn());
        TestIndexComparison.assertEquals((String)"COL3", (String)colChange.getNextColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL1", "COL2", "COL3"}, indexChange2.getNewIndex());
    }

    public void testDropColumnAndChangeIndexColumnOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL2'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n      <unique-column name='COL3'/>\n    </unique>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL3'/>\n      <unique-column name='COL2'/>\n      <unique-column name='COL1'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <unique name='TESTINDEX'>\n      <unique-column name='COL1'/>\n      <unique-column name='COL3'/>\n    </unique>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)3, (int)changes.size());
        RemoveIndexChange indexChange1 = (RemoveIndexChange)changes.get(0);
        RemoveColumnChange colChange = (RemoveColumnChange)changes.get(1);
        AddIndexChange indexChange2 = (AddIndexChange)changes.get(2);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        TestIndexComparison.assertEquals((String)"COL2", (String)colChange.getChangedColumn());
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange2.getChangedTable());
        this.assertIndex("TESTINDEX", true, new String[]{"COL1", "COL3"}, indexChange2.getNewIndex());
    }

    public void testDropIndex1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)1, (int)changes.size());
        RemoveIndexChange change = (RemoveIndexChange)changes.get(0);
        TestIndexComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)change.findChangedIndex(model1, true));
    }

    public void testDropIndex2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL3'/>\n      <index-column name='COL2'/>\n      <index-column name='COL1'/>\n    </index>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n    <index name='TESTINDEX'>\n      <index-column name='COL3'/>\n      <index-column name='COL2'/>\n      <index-column name='COL1'/>\n    </index>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COL1' type='INTEGER'/>\n    <column name='COL2' type='DOUBLE'/>\n    <column name='COL3' type='VARCHAR' size='32'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)1, (int)changes.size());
        RemoveIndexChange indexChange = (RemoveIndexChange)changes.get(0);
        TestIndexComparison.assertEquals((String)"TableA", (String)indexChange.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)indexChange.findChangedIndex(model1, false));
    }

    public void testAddAndDropIndex() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n    <unique name='TestIndex'>\n      <unique-column name='Col'/>\n    </unique>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n    <index name='TestIndex'>\n      <index-column name='Col'/>\n    </index>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestIndexComparison.assertEquals((int)2, (int)changes.size());
        RemoveIndexChange change1 = (RemoveIndexChange)changes.get(0);
        AddIndexChange change2 = (AddIndexChange)changes.get(1);
        TestIndexComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestIndexComparison.assertEquals((Object)model1.findTable("TableA").getIndex(0), (Object)change1.findChangedIndex(model1, false));
        TestIndexComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertIndex("TestIndex", false, new String[]{"Col"}, change2.getNewIndex());
    }
}

