/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.alteration;

import java.util.List;
import org.apache.ddlutils.alteration.AddColumnChange;
import org.apache.ddlutils.alteration.AddForeignKeyChange;
import org.apache.ddlutils.alteration.AddPrimaryKeyChange;
import org.apache.ddlutils.alteration.PrimaryKeyChange;
import org.apache.ddlutils.alteration.RemoveColumnChange;
import org.apache.ddlutils.alteration.RemoveForeignKeyChange;
import org.apache.ddlutils.alteration.TestComparisonBase;
import org.apache.ddlutils.model.Database;

public class TestForeignKeyComparison
extends TestComparisonBase {
    public void testAddColumnAndForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)2, (int)changes.size());
        AddColumnChange colChange = (AddColumnChange)changes.get(0);
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(1);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        this.assertColumn("COLFK", 4, null, null, false, false, false, colChange.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK", (String)colChange.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"COLFK"}, new String[]{"ColPK"}, fkChange.getNewForeignKey());
    }

    public void testAddColumnAndForeignKeyToIt() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n  <table name='TableB'>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n  <table name='TableB'>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='Col' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)3, (int)changes.size());
        AddColumnChange colChange = (AddColumnChange)changes.get(0);
        AddPrimaryKeyChange pkChange = (AddPrimaryKeyChange)changes.get(1);
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(2);
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange.getChangedTable());
        this.assertColumn("COLPK", 4, null, null, false, true, false, colChange.getNewColumn());
        TestForeignKeyComparison.assertNull((Object)colChange.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"Col", (String)colChange.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)1, (int)pkChange.getPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK", (String)pkChange.getPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"COLFK"}, new String[]{"COLPK"}, fkChange.getNewForeignKey());
    }

    public void testAddColumnsAndForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)4, (int)changes.size());
        AddColumnChange colChange1 = (AddColumnChange)changes.get(0);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(1);
        AddColumnChange colChange3 = (AddColumnChange)changes.get(2);
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(3);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        this.assertColumn("COLFK1", 4, null, null, false, false, false, colChange1.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK", (String)colChange1.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange1.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        this.assertColumn("COLFK2", 8, null, null, false, false, false, colChange2.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"COLFK1", (String)colChange2.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange2.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange3.getChangedTable());
        this.assertColumn("COLFK3", 12, "32", null, false, false, false, colChange3.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"COLFK2", (String)colChange3.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange3.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"COLFK2", "COLFK1", "COLFK3"}, new String[]{"ColPK1", "ColPK2", "ColPK3"}, fkChange.getNewForeignKey());
    }

    public void testAddColumnsAndForeignKeyToThem() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)4, (int)changes.size());
        AddColumnChange colChange1 = (AddColumnChange)changes.get(0);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(1);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(2);
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(3);
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange1.getChangedTable());
        this.assertColumn("COLPK1", 8, null, null, false, true, false, colChange1.getNewColumn());
        TestForeignKeyComparison.assertNull((Object)colChange1.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK3", (String)colChange1.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange2.getChangedTable());
        this.assertColumn("COLPK2", 4, null, null, false, true, false, colChange2.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)colChange2.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK3", (String)colChange2.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"ColPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "ColFK1", "ColFK3"}, new String[]{"COLPK1", "COLPK2", "ColPK3"}, fkChange.getNewForeignKey());
    }

    public void testAddColumnsAndForeignKeyBetweenThem() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK2' type='DOUBLE'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK2' type='DOUBLE'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)6, (int)changes.size());
        AddColumnChange colChange1 = (AddColumnChange)changes.get(0);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(1);
        AddColumnChange colChange3 = (AddColumnChange)changes.get(2);
        AddColumnChange colChange4 = (AddColumnChange)changes.get(3);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(4);
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(5);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        this.assertColumn("COLFK1", 4, null, null, false, false, false, colChange1.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK", (String)colChange1.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColFK2", (String)colChange1.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        this.assertColumn("COLFK3", 12, "32", null, false, false, false, colChange2.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColFK2", (String)colChange2.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange2.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange3.getChangedTable());
        this.assertColumn("COLPK1", 8, null, null, false, true, false, colChange3.getNewColumn());
        TestForeignKeyComparison.assertNull((Object)colChange3.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK3", (String)colChange3.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange4.getChangedTable());
        this.assertColumn("COLPK2", 4, null, null, false, true, false, colChange4.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)colChange4.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK3", (String)colChange4.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"ColPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "COLFK1", "COLFK3"}, new String[]{"COLPK1", "COLPK2", "ColPK3"}, fkChange.getNewForeignKey());
    }

    public void testAddSingleReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK' foreign='COLPK'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)1, (int)changes.size());
        AddForeignKeyChange change = (AddForeignKeyChange)changes.get(0);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)change.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK"}, new String[]{"ColPK"}, change.getNewForeignKey());
    }

    public void testAddMultiReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)1, (int)changes.size());
        AddForeignKeyChange fkChange = (AddForeignKeyChange)changes.get(0);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "ColFK1", "ColFK3"}, new String[]{"ColPK1", "ColPK2", "COLPK3"}, fkChange.getNewForeignKey());
    }

    public void testAddLocalColumnToMultiReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK2'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK2'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)4, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        AddColumnChange colChange = (AddColumnChange)changes.get(1);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(2);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(3);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange.getChangedTable());
        this.assertColumn("COLFK2", 8, null, null, false, false, false, colChange.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColFK1", (String)colChange.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColFK3", (String)colChange.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"ColPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"ColPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"COLFK2", "ColFK1", "ColFK3"}, new String[]{"ColPK1", "ColPK2", "COLPK3"}, fkChange2.getNewForeignKey());
    }

    public void testAddForeignColumnToMultiReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='ColPK1'/>\n      <reference local='ColFK1' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='ColPK1'/>\n      <reference local='ColFK1' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)4, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        AddColumnChange colChange = (AddColumnChange)changes.get(1);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(2);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(3);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange.getChangedTable());
        this.assertColumn("COLPK3", 12, "32", null, false, true, false, colChange.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK2", (String)colChange.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"ColPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"ColPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "ColFK1", "ColFK3"}, new String[]{"ColPK1", "ColPK2", "COLPK3"}, fkChange2.getNewForeignKey());
    }

    public void testAddColumnsToSingleReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='DOUBLE' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)7, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        AddColumnChange colChange1 = (AddColumnChange)changes.get(1);
        AddColumnChange colChange2 = (AddColumnChange)changes.get(2);
        AddColumnChange colChange3 = (AddColumnChange)changes.get(3);
        AddColumnChange colChange4 = (AddColumnChange)changes.get(4);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(5);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(6);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        this.assertColumn("COLFK1", 4, null, null, false, false, false, colChange1.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK", (String)colChange1.getPreviousColumn());
        TestForeignKeyComparison.assertEquals((String)"ColFK2", (String)colChange1.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange2.getChangedTable());
        this.assertColumn("COLFK3", 12, "32", null, false, false, false, colChange2.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColFK2", (String)colChange2.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange2.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange3.getChangedTable());
        this.assertColumn("COLPK2", 4, null, null, false, true, false, colChange3.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"ColPK1", (String)colChange3.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange3.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange4.getChangedTable());
        this.assertColumn("COLPK3", 12, "32", null, false, true, false, colChange4.getNewColumn());
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)colChange4.getPreviousColumn());
        TestForeignKeyComparison.assertNull((Object)colChange4.getNextColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"ColPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "COLFK1", "COLFK3"}, new String[]{"ColPK1", "COLPK2", "COLPK3"}, fkChange2.getNewForeignKey());
    }

    public void testAddReferenceToMultiReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)3, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(1);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(2);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "ColFK1", "ColFK3"}, new String[]{"COLPK1", "COLPK2", "COLPK3"}, fkChange2.getNewForeignKey());
    }

    public void testAddReferencesToSingleReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='COLPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='COLPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)3, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(1);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(2);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "ColFK1", "ColFK3"}, new String[]{"COLPK1", "COLPK2", "COLPK3"}, fkChange2.getNewForeignKey());
    }

    public void testForeignKeyReferenceOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK1'/>\n      <reference local='ColFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='ColPK2'/>\n      <reference local='ColFK1' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK1'/>\n      <reference local='ColFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='ColPK2'/>\n      <reference local='ColFK1' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestForeignKeyComparison.assertTrue((boolean)changes.isEmpty());
    }

    public void testAddReferenceToForeignKeyAndChangeOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)3, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(1);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(2);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)3, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)pkChange.getNewPrimaryKeyColumns()[2]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK1", "ColFK2", "ColFK3"}, new String[]{"COLPK2", "COLPK1", "COLPK3"}, fkChange2.getNewForeignKey());
    }

    public void testRemoveReferenceFromForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK2' foreign='COLPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK1' foreign='COLPK2'/>\n      <reference local='COLFK2' foreign='COLPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)3, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(1);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(2);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)2, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK1", "ColFK2"}, new String[]{"COLPK2", "COLPK1"}, fkChange2.getNewForeignKey());
    }

    public void testRemoveReferenceFromForeignKeyAndChangeOrder() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK2' foreign='COLPK1'/>\n      <reference local='COLFK1' foreign='COLPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)3, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        PrimaryKeyChange pkChange = (PrimaryKeyChange)changes.get(1);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(2);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)pkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((int)2, (int)pkChange.getNewPrimaryKeyColumns().length);
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)pkChange.getNewPrimaryKeyColumns()[0]);
        TestForeignKeyComparison.assertEquals((String)"COLPK2", (String)pkChange.getNewPrimaryKeyColumns()[1]);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK2", "ColFK1"}, new String[]{"COLPK1", "COLPK2"}, fkChange2.getNewForeignKey());
    }

    public void testDropColumnsFromForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK1' foreign='COLPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <foreign-key name='TESTFK' foreignTable='TABLEB'>\n      <reference local='COLFK1' foreign='COLPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)5, (int)changes.size());
        RemoveForeignKeyChange fkChange1 = (RemoveForeignKeyChange)changes.get(0);
        RemoveColumnChange colChange1 = (RemoveColumnChange)changes.get(1);
        RemoveColumnChange colChange2 = (RemoveColumnChange)changes.get(2);
        RemoveColumnChange colChange3 = (RemoveColumnChange)changes.get(3);
        AddForeignKeyChange fkChange2 = (AddForeignKeyChange)changes.get(4);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange1.findChangedForeignKey(model1, false));
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)colChange1.getChangedTable());
        TestForeignKeyComparison.assertEquals((String)"ColFK3", (String)colChange1.getChangedColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange2.getChangedTable());
        TestForeignKeyComparison.assertEquals((String)"COLPK1", (String)colChange2.getChangedColumn());
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)colChange3.getChangedTable());
        TestForeignKeyComparison.assertEquals((String)"COLPK3", (String)colChange3.getChangedColumn());
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableB", new String[]{"ColFK1"}, new String[]{"COLPK2"}, fkChange2.getNewForeignKey());
    }

    public void testDropSingleReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableA'>\n      <reference local='ColFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableA'>\n      <reference local='ColFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK' type='INTEGER'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)1, (int)changes.size());
        RemoveForeignKeyChange change = (RemoveForeignKeyChange)changes.get(0);
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)change.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableB").getForeignKey(0), (Object)change.findChangedForeignKey(model1, false));
    }

    public void testDropMultiReferenceForeignKey() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='DOUBLE'/>\n    <column name='ColFK3' type='VARCHAR' size='32'/>\n    <foreign-key name='TESTFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='COLPK2'/>\n      <reference local='ColFK2' foreign='COLPK1'/>\n      <reference local='ColFK3' foreign='COLPK3'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TABLEA'>\n    <column name='COLPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLFK1' type='INTEGER'/>\n    <column name='COLFK2' type='DOUBLE'/>\n    <column name='COLFK3' type='VARCHAR' size='32'/>\n  </table>\n  <table name='TABLEB'>\n    <column name='COLPK1' type='DOUBLE' primaryKey='true' required='true'/>\n    <column name='COLPK2' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='COLPK3' type='VARCHAR' size='32' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(false).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)1, (int)changes.size());
        RemoveForeignKeyChange fkChange = (RemoveForeignKeyChange)changes.get(0);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)fkChange.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)fkChange.findChangedForeignKey(model1, false));
    }

    public void testAddAndDropForeignKey1() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableA'>\n      <reference local='ColFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='ColFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableA'>\n      <reference local='ColFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK' type='INTEGER'/>\n    <foreign-key name='TESTFK' foreignTable='TableA'>\n      <reference local='ColFK' foreign='ColPK'/>\n    </foreign-key>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)2, (int)changes.size());
        RemoveForeignKeyChange change1 = (RemoveForeignKeyChange)changes.get(0);
        AddForeignKeyChange change2 = (AddForeignKeyChange)changes.get(1);
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)change1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableB").getForeignKey(0), (Object)change1.findChangedForeignKey(model1, true));
        TestForeignKeyComparison.assertEquals((String)"TableB", (String)change2.getChangedTable());
        this.assertForeignKey("TESTFK", "TableA", new String[]{"ColFK"}, new String[]{"ColPK"}, change2.getNewForeignKey());
    }

    public void testAddAndDropForeignKey2() {
        String MODEL1 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK1'/>\n      <reference local='ColFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        String MODEL2 = "<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK2'/>\n      <reference local='ColFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>";
        Database model1 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK1'/>\n      <reference local='ColFK2' foreign='ColPK2'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        Database model2 = this.parseDatabaseFromString("<?xml version='1.0' encoding='ISO-8859-1'?>\n<database xmlns='http://db.apache.org/ddlutils/schema/1.1' name='test'>\n  <table name='TableA'>\n    <column name='ColPK' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColFK1' type='INTEGER'/>\n    <column name='ColFK2' type='INTEGER'/>\n    <foreign-key name='TestFK' foreignTable='TableB'>\n      <reference local='ColFK1' foreign='ColPK2'/>\n      <reference local='ColFK2' foreign='ColPK1'/>\n    </foreign-key>\n  </table>\n  <table name='TableB'>\n    <column name='ColPK1' type='INTEGER' primaryKey='true' required='true'/>\n    <column name='ColPK2' type='INTEGER' primaryKey='true' required='true'/>\n  </table>\n</database>");
        List changes = this.getPlatform(true).getChanges(model1, model2);
        TestForeignKeyComparison.assertEquals((int)2, (int)changes.size());
        RemoveForeignKeyChange change1 = (RemoveForeignKeyChange)changes.get(0);
        AddForeignKeyChange change2 = (AddForeignKeyChange)changes.get(1);
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)change1.getChangedTable());
        TestForeignKeyComparison.assertEquals((Object)model1.findTable("TableA").getForeignKey(0), (Object)change1.findChangedForeignKey(model1, true));
        TestForeignKeyComparison.assertEquals((String)"TableA", (String)change2.getChangedTable());
        this.assertForeignKey("TestFK", "TableB", new String[]{"ColFK1", "ColFK2"}, new String[]{"ColPK2", "ColPK1"}, change2.getNewForeignKey());
    }
}

